--- MetaMap
--- Written by MetaHawk - aka Urshurak
--- Fan Update (hopefully temporary) by Charroux/Tallspirit
--- Fan Update (not temporary) by mbanks850 and Andymon

-- *** includes a fix for the taintLog bug described by http://us.battle.net/wow/en/forum/topic/6413024501 ***

METAMAP_TITLE = "MetaMap";
METAMAP_VERSION = GetAddOnMetadata("MetaMap", "Version");

METAMAP_NAME = METAMAP_TITLE.."  v"..METAMAP_VERSION;
METAMAPPOI_NAME = "MetaMapPOI";
METAMAP_ICON = "Interface\\WorldMap\\UI-World-Icon";
METAMAP_MAP_PATH = "Interface\\AddOns\\MetaMap\\Maps\\";
METAMAP_ICON_PATH = "Interface\\AddOns\\MetaMap\\Icons\\";
METAMAP_IMAGE_PATH = "Interface\\AddOns\\MetaMap\\Images\\"
METAMAP_SHADER_PATH = "Interface\\AddOns\\MetaMap\\Shaders\\"
METAMAP_MAPCREDITS = "Maps created by Nifl";
METAMAP_TITAN_ID = METAMAP_TITLE;
METAMAP_TITAN_FREQUENCY = 1;

METAMAP_MENUBUTTON_HEIGHT = 16;
METAMAP_LISTBUTTON_HEIGHT = 20;
METAMAP_LISTBUTTON_SHOWN = 30;
METAMAP_SORTBY_NAME = "name";
METAMAP_SORTBY_DESC = "desc";
METAMAP_SORTBY_LEVEL = "level";
METAMAP_SORTBY_LOCATION = "location";
METAMAP_TT_NAME = nil;
METAMAP_POS_UPDATED = nil;

MetaMap_Details = {
	name = METAMAP_TITLE,
	description = METAMAP_DESC,
	version = METAMAP_VERSION,
	releaseDate = "November 21, 2010",
	author = "Mbanks850 (original by MetaHawk)",
	email = "mbanks850@gmail.com (original by admin@metaserve.org.uk)",
	website = "",
	category = MYADDONS_CATEGORY_MAP,
}

MetaMapOptions = {};
MetaMap_Options = {};
MetaMap_Continents = {};
MetaMap_Notes = {};
MetaMap_Lines = {};
MetaMap_MiniNote_Data = {};
MetaMap_NoteFilter = {};
local MetaMap_NoteList = {};
local MetaMap_Relocate = {};
local MetaMap_LastLineClick = {};
local MetaMap_PartyNoteData = {};
local MetaMap_ZoneErrata = nil;

MetaMap_ListOffset = 0;
MetaMap_PingTime = 15;
MetaMap_gPingPOI = nil;
MetaMap_FullScreenMode = false;
MetaMapContainer_CurrentFrame = nil;
MetaMap_MenuParent = "cursor";
MetaMap_sortDone = true;
MetaMap_sortType = METAMAP_SORTBY_NAME;
MetaMap_OptionsInfo = nil;
MetaMap_Qnote = false;
MetaMap_PartyNoteSet = false;
MetaMap_LastLineClick.time = 0;
MetaMap_TempData_Id = "";
MetaMap_TempData_Zone = "";
MetaMap_TempData_Name = "";
MetaMap_TempData_Creator = "";
MetaMap_TempData_xPos = "";
MetaMap_TempData_yPos = "";
MetaMap_TempData_Icon = "";
MetaMap_TempData_TextColor = "";
MetaMap_TempData_Info1Color = "";
MetaMap_TempData_Info2Color = "";
MetaMap_TempData_LootID = nil;
MetaMap_MiniNote_IsInCity = false;
MetaMap_MiniNote_MapzoomInit = false;
MetaMap_SetNextAsMiniNote = 0;
MetaMap_Orphans = 0;
MetaMap_Timer_DelayWKB_AddUnitInfo = nil;

local MetaMap_BaseMapName;
local MetaMap_BaseMapID;
local MetaMap_CurrentMapName;
local MetaMap_CurrentMapID;
local MetaMap_CurrentMapCID;
local MetaMap_CurrentMapZID;
local MetaMap_CurrentMapLevel = 0;
local MetaMap_CurrentMapMicro = false;

local MetaMap_VarsLoaded = false;
local MetaMap_FilterName = "";
local MetaMap_CurrentSaveSet = 1;

local MetaMap_CurrentAction = false;
local MetaMap_LastNote = 0;
local MetaMap_LastLine = 0;
local MetaMap_OrigChatFrame_OnEvent;
local MetaMap_MinDiff = 7
local MetaMap_vnote_xPos = nil;
local MetaMap_vnote_yPos = nil;
local MetaMap_Drawing = nil;
local MetaMap_Timer_DelayLoadModules = 5.0;
local MetaMap_Tracker = false;
local MetaMap_Reshow_BattlefiedMap;

-- *** taintLog fix ***
local MetaMap_taintLog_Set = "0";

MetaMap_Default = {
	["SaveSet"] = 1,
	["MetaMapAlpha1"] = 1.0,
	["MetaMapAlpha2"] = 0.60,
	["BDshader1"] = 0.0,
	["BDshader2"] = 0.0,
	["MetaMapScale1"] = 0.75,
	["MetaMapScale2"] = 0.55,
	["MetaMapTTScale1"] = 1.0,
	["MetaMapTTScale2"] = 0.75,
	["ContainerAlpha"] = 0,
	["ActionMode1"] = false,
	["ActionMode2"] = false,
	["MetaMapButtonPosition"] = 138,
	["MiniColor"] = 4,
	["MenuFont"] = 10,
	["MetaMapZone"] = nil,
	["MetaMapCoords"] = true,
	["MetaMapMiniCoords"] = true,
	["MetaMapButtonShown"] = true,
	["MapChange"] = true,
	["TooltipWrap"] = true,
	["ShowCreator"] = true,
	["MenuMode"] = false,
	["ShowMapList"] = true,
	["LastHighlight"] = true,
	["LastMiniHighlight"] = true,
	["NoteSize"] = 16,
	["AcceptIncoming"] = true,
	["MiniParty"] = true,
	["ListColors"] = true,
	["ZoneHeader"] = false,
	["SortList"] = false,
	["UsePOI"] = false,
	["WKBalwaysOn"] = false,
	["QSTalwaysOn"] = false,
	["FWMalwaysOn"] = false,
	["BWPalwaysOn"] = false,
	["NBKalwaysOn"] = false,
	["TRKalwaysOn"] = false,
}
MetaMapOptions.MenuFont = 10;
MetaMap_MainMenuData = {
	[1]  = {text = METAMAP_MENU_MAPCRD,    opt = "MetaMapCoords",         ksoc = 1, mode = 1},
	[2]  = {text = METAMAP_MENU_MINCRD,    opt = "MetaMapMiniCoords",     ksoc = 1, mode = 1},
	[3]  = {text = METAMAP_MENU_ACTION,    opt = "MetaMap_ActionToggle",  ksoc = 1, mode = 2},
	[4]  = {text = METAMAP_MENU_MAPSET,    opt = "MetaMapSaveSet_Toggle", ksoc = 1, mode = 2},
	[5]  = {text = METAMAP_MENU_FWMMOD,    opt = "MetaMap_LoadFWM",       ksoc = 1, mode = 2},
	[6]  = {text = METAMAP_MENU_TRKSET,    opt = "MetaMap_SetTracker",    ksoc = 1, mode = 2},
	[7]  = {text = "",                                                    ksoc = 1, nc = 1},
	[8]  = {text = METAMAP_MENU_FILTER,    opt = METAMAP_MENU_FILTER,     ksoc = 1, ha = 1},
	[9]  = {text = METAMAP_MENU_TRKFILTER, opt = METAMAP_MENU_TRKFILTER,  ksoc = 1, ha = 1},
	[10] = {text = "",                                                    ksoc = 1, nc = 1},
	[11] = {text = METAMAP_MENU_EXTOPT,    opt = "MetaMapExtOptions_Toggle",        mode = 2},
	[12] = {text = METAMAP_MENU_FLIGHT,    opt = "MetaMap_FlightMapOptions_Toggle",         mode = 2},
	[13] = {text = METAMAP_MENU_TRKMOD,    opt = "MetaMap_LoadTRK",                 mode = 2},
	[14] = {text = METAMAP_MENU_BWPMOD,    opt = "MetaMap_LoadBWP",                 mode = 2},
	[15] = {text = METAMAP_MENU_WKBMOD,    opt = "MetaMap_LoadWKB",                 mode = 2},
	[16] = {text = METAMAP_MENU_QSTMOD,    opt = "MetaMap_LoadQST",                 mode = 2},
	[17] = {text = METAMAP_MENU_NBKMOD,    opt = "MetaMap_LoadNBK",                 mode = 2},
};

function MetaMap_SetWorldMap()
	-- switch in-game world map to full screen mode
	if ( WORLDMAP_SETTINGS.size == WORLDMAP_WINDOWED_SIZE ) then
		SetCVar("miniWorldMap", 0);
		WorldMap_ToggleSizeUp();
	end
	WorldMapFrameSizeUpButton:Show();
	WorldMapFrameSizeDownButton:Hide();

	UIPanelWindows["WorldMapFrame"] = { area = "center", pushable = 0 };
	UIPanelWindows["WorldMapFrame"].allowOtherPanels = true;

	local point = MetaMap_Options.WorldMapPoint;
	local relative = MetaMap_Options.WorldMapRelative;
	local xoffset = MetaMap_Options.WorldMapXoffset;
	local yoffset = MetaMap_Options.WorldMapYoffset;
	WorldMapFrame:ClearAllPoints();
	if (point and relative and xoffset and yoffset) then
		WorldMapFrame:SetPoint(point, "UIParent", relative, xoffset, yoffset);
	else
		WorldMapFrame:SetPoint("CENTER", "UIParent", "CENTER", 0, 0);
	end

	WorldMapFrame:SetParent(UIParent);
	WorldMapFrame:SetMovable(true);

	BlackoutWorld:Hide();
	WorldMapZoomOutButton:Hide();
	WorldMapMagnifyingGlassButton:Hide();
	MiniMapWorldMapButton:Hide();
	WorldMapContinentDropDown:Hide();
	WorldMapZoneDropDown:Hide();

	WorldMapFrameSizeDownButton:SetScript("OnClick", function() MetaMap_FullScreenToggle() end);
	WorldMapFrameSizeUpButton:SetScript("OnClick", function() MetaMap_FullScreenToggle() end);

	--WorldMapFrame:SetFrameStrata("DIALOG");
	MetaMap_SetFrameStrata();

	MetaMap_WorldMapFrame_OnKeyDown_old = WorldMapFrame:GetScript("OnKeyDown");
	WorldMapFrame:SetScript("OnKeyDown", nil);

	MetaMap_GameToolTip_OnShow_old = GameTooltip:GetScript("OnShow");
	if (MetaMap_GameToolTip_OnShow_old) then
		GameTooltip:SetScript("OnShow", function(self) METAMAP_TT_NAME = GameTooltipTextLeft1:GetText(); MetaMap_GameToolTip_OnShow_old(self); end);
	else
		GameTooltip:SetScript("OnShow", function(self) METAMAP_TT_NAME = GameTooltipTextLeft1:GetText(); end);
	end
-- executed to late:
--	hooksecurefunc(GameTooltip,"Show", function(self) METAMAP_TT_NAME = GameTooltipTextLeft1:GetText(); end);

	--WorldMapFrame:HookScript("OnUpdate", function () MetaMapWorldMapFrame_OnUpdate() end);
	hooksecurefunc(WorldMapFrame,"Show",MetaMapTopFrame_OnShow);
	WorldMapQuestShowObjectives:HookScript("OnClick", function () MetaMapQuestShowObjectives_OnClick() end);

	--WORLDMAP_SETTINGS.size=WORLDMAP_QUESTLIST_SIZE;

	MetaMap_SetMapToCurrentZone();
end

function MetaMap_SetFrameStrata()
	local strata;
	if (MetaMapOptions.MetaMapFrameStrata == 2) then
		strata = "DIALOG";
	elseif (MetaMapOptions.MetaMapFrameStrata == 1) then
		strata = "HIGH";
	else
		strata = "MEDIUM";
	end
	WorldMapFrame_ResetFrameLevels();
	WorldMapTooltip:SetFrameStrata("TOOLTIP");
	WorldMapFrame:SetFrameStrata(strata);

	--WorldMapBlobFrame:SetFrameLevel(WorldMapPOIFrame:GetFrameLevel()+1);
	--WorldMapBlobFrame:SetFrameStrata("TOOLTIP");
	--WorldMapQuestScrollFrame:SetFrameLevel(MetaMapTopFrame:GetFrameLevel()+6);
	WorldMapCompareTooltip1:SetFrameStrata("TOOLTIP");
	WorldMapCompareTooltip2:SetFrameStrata("TOOLTIP");
	WorldMapTooltip:SetFrameLevel("300");
end

function MetaMapButton_OnClick()
	MetaMap_Debug_Print("MetaMapButton_OnClick",true);
	MetaMap_ToggleFrame(WorldMapFrame);
end

function MetaMap_OnLoad(self)
	hooksecurefunc("ToggleDropDownMenu", MetaMap_ToggleDropDownMenu);

	hooksecurefunc("WorldMapZoomOutButton_OnClick", MetaMap_WorldMapZoomOutButton_OnClick);

	OutlandButton:HookScript("OnClick", MetaMap_WorldMapAreaButton_OnClick);
	AzerothButton:HookScript("OnClick", MetaMap_WorldMapAreaButton_OnClick);

	TheMaelstromButton:HookScript("OnClick", MetaMap_WorldMapAreaButton_OnClick);
	DeepholmButton:HookScript("OnClick", MetaMap_WorldMapAreaButton_OnClick);
	KezanButton:HookScript("OnClick", MetaMap_WorldMapAreaButton_OnClick);
	LostIslesButton:HookScript("OnClick", MetaMap_WorldMapAreaButton_OnClick);

	WorldMapLevelUpButton:HookScript("OnClick", MetaMap_WorldMapLevelUpDown_OnClick);
	WorldMapLevelDownButton:HookScript("OnClick", MetaMap_WorldMapLevelUpDown_OnClick);
	hooksecurefunc("WorldMapLevelButton_OnClick", MetaMap_WorldMapLevelUpDown_OnClick);
	--hooksecurefunc("WorldMapQuestShowObjectives_OnClick",MetaMap_ShowObjectives_OnClick);

	self:RegisterEvent("ADDON_LOADED");
	self:RegisterEvent("VARIABLES_LOADED");
	self:RegisterEvent("UPDATE_BINDINGS");
	self:RegisterEvent("WORLD_MAP_UPDATE");
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA");
	self:RegisterEvent("ZONE_CHANGED");
	self:RegisterEvent("ZONE_CHANGED_INDOORS");
	self:RegisterEvent("PLAYER_ENTERING_WORLD");
	self:RegisterEvent("MINIMAP_UPDATE_ZOOM");
	self:RegisterEvent("CHAT_MSG_ADDON");
	--self:RegisterEvent("QUEST_LOG_UPDATE");
	--self:RegisterEvent("QUEST_POI_UPDATE");
	self:RegisterEvent("PLAYER_LOGOUT");
	if(IsAddOnLoaded("FuBar")) then	MetaMap_FuBar_OnLoad(); end

	-- *** taintLog fix ***
	MetaMap_UIDropDownMenu_GetSelectedID_Original = UIDropDownMenu_GetSelectedID;
	MetaMap_UIDropDownMenu_ClearAll_Original = UIDropDownMenu_ClearAll;
	if ( GetCVar("taintLog") ~= "0" ) then
		MetaMap_taintLog_Set = GetCVar("taintLog");
		UIDropDownMenu_GetSelectedID = MetaMap_UIDropDownMenu_GetSelectedID;
		UIDropDownMenu_ClearAll = MetaMap_UIDropDownMenu_ClearAll;
	end
end

-- *** taintLog fix *** this is a copy of original function UIDropDownMenu_ClearAll without modifications
function MetaMap_UIDropDownMenu_ClearAll(frame)
	-- Previous code refreshed the menu quite often and was a performance bottleneck
	frame.selectedID = nil;
	frame.selectedName = nil;
	frame.selectedValue = nil;
	UIDropDownMenu_SetText(frame, "");

	local button, checkImage, uncheckImage;
	for i=1, UIDROPDOWNMENU_MAXBUTTONS do
		button = _G["DropDownList"..UIDROPDOWNMENU_MENU_LEVEL.."Button"..i];
		button:UnlockHighlight();

		checkImage = _G["DropDownList"..UIDROPDOWNMENU_MENU_LEVEL.."Button"..i.."Check"];
		checkImage:Hide();
		uncheckImage = _G["DropDownList"..UIDROPDOWNMENU_MENU_LEVEL.."Button"..i.."UnCheck"];
		uncheckImage:Hide();
	end
end

-- *** taintLog fix *** this is a copy of original function UIDropDownMenu_ClearAll without modifications
function MetaMap_UIDropDownMenu_GetSelectedID(frame)
	if ( frame.selectedID ) then
		return frame.selectedID;
	else
		-- If no explicit selectedID then try to send the id of a selected value or name
		local button;
		for i=1, UIDROPDOWNMENU_MAXBUTTONS do
			button = _G["DropDownList"..UIDROPDOWNMENU_MENU_LEVEL.."Button"..i];
			-- See if checked or not
			if ( UIDropDownMenu_GetSelectedName(frame) ) then
				if ( button:GetText() == UIDropDownMenu_GetSelectedName(frame) ) then
					return i;
				end
			elseif ( UIDropDownMenu_GetSelectedValue(frame) ) then
				if ( button.value == UIDropDownMenu_GetSelectedValue(frame) ) then
					return i;
				end
			end
		end
	end
end


function MetaMapContainerFrame_OnLoad(frame)
	frame:SetWidth(WorldMapButton:GetWidth() - MetaMap_MapListFrame:GetWidth()-1);
	frame:SetHeight(WorldMapButton:GetHeight()-41);
	frame:SetFrameLevel(frame:GetParent():GetFrameLevel()+3);
	MetaMapContainer_Header:SetFrameLevel(frame:GetFrameLevel()+2);
	MetaMapContainer_Footer:SetFrameLevel(frame:GetFrameLevel()+2);
	MetaMapContainer_CloseButton:SetFrameLevel(MetaMapContainer_Footer:GetFrameLevel()+2);
end

function MetaMapStartMoving(frame)
	frame:StartMoving();
end

function MetaMapStopMoving(frame)
	frame:StopMovingOrSizing();
	WorldMapFrame_UpdateQuests();
	WorldMapFrame_SetPOIMaxBounds();
	WorldMapQuestShowObjectives_AdjustPosition();
end

function MetaMapQuestShowObjectives_OnClick()
	MetaMap_ShowObjectives_OnClick();
	MetaMap_SetPointerSize();
end

--[[ Unused
function MetaMapWorldMapFrame_OnUpdate(self,elapsed)
	-- MetaMap_Debug_Print("WorldMapFrame_OnUpdate:",true);
	point, relativeTo, relativePoint, xOfs, yOfs = WorldMapPing:GetPoint();
	if (relativeTo ~= nil) then
		DEFAULT_CHAT_FRAME:AddMessage("Ping: "..point..","..relativeTo:GetName()..","..relativePoint..","..xOfs..","..yOfs);
	end

	point, relativeTo, relativePoint, xOfs, yOfs = WorldMapPlayerLower:GetPoint();
	if (relativeTo ~= nil) then
		DEFAULT_CHAT_FRAME:AddMessage("Arrow: "..point..","..relativeTo:GetName()..","..relativePoint..","..xOfs..","..yOfs);
		WorldMapPlayerLower:ClearAllPoints();
		PositionWorldMapArrowFrame("center","WorldMapDetailFrame","topleft",xOfs,yOfs);
		WorldMapPlayerLower:ClearAllPoints();
		WorldMapPlayerLower:SetPoint("center","WorldMapDetailFrame","topleft",500,-308);
		UpdateWorldMapArrow();
		point, relativeTo, relativePoint, xOfs, yOfs = WorldMapPlayerLower:GetPoint();
		DEFAULT_CHAT_FRAME:AddMessage("ArrowAfter: "..point..","..relativeTo:GetName()..","..relativePoint..","..xOfs..","..yOfs);
	end
end
]]--

function MetaMapTopFrame_OnShow(self)
	MetaMap_Debug_Print("MetaMapTopFrame_OnShow",true);

	-- if set, unset the miniWorldMap
	if ( WORLDMAP_SETTINGS.size == WORLDMAP_WINDOWED_SIZE ) then
		-- hide WorldMapFrame
		-- ### problematic with taintLog ###
		ToggleFrame(WorldMapFrame);
		-- switch off miniWorldMap
		SetCVar("miniWorldMap", 0);
		WorldMap_ToggleSizeUp();
		-- show WorldMapFrame again
		WorldMapFrame.blockWorldMapUpdate = true;
		-- ### problematic with taintLog ###
		ToggleFrame(WorldMapFrame);
		WorldMapFrame.blockWorldMapUpdate = nil;
		-- the re-show off the WorldMapFrame triggers MetaMapTopFrame_OnShow, thats return now
		return;
	end

	if (MetaMap_FullScreenMode or InCombatLockdown()) then
		BlackoutWorld:Show();
	else
		BlackoutWorld:Hide();
		if (WorldMapFrame:IsVisible()) then
			ShowUIPanel(WorldMapFrame);
		end
		MetaMap_ToggleDR(self,1);

		WorldMapZoomOutButton:Hide();
		WorldMapMagnifyingGlassButton:Hide();
		MiniMapWorldMapButton:Hide();

		WorldMapFrame:EnableMouse(true);

		WorldMapFrame:SetMovable(true);
		WorldMapFrame:RegisterForDrag("LeftButton");
		WorldMapFrame:SetScript("OnDragStart", MetaMapStartMoving);
		WorldMapFrame:SetScript("OnDragStop", MetaMapStopMoving);

		MetaMapOptions_Init();

		--UpdateWorldMapArrow(WorldMapPlayerUpper);
		--UpdateWorldMapArrow(WorldMapPlayerLower);

		MetaMapTopFrame:SetFrameLevel(WorldMapFrame:GetFrameLevel()+2);	
		MetaMap_InfoLineFrame:SetFrameLevel(MetaMapTopFrame:GetFrameLevel()+1);

		MetaMap_Debug_Print("MetaMapTopFrame_OnShow: Updating Quests",true);
		--WORLDMAP_SETTINGS.size=WORLDMAP_QUESTLIST_SIZE;
		WorldMapFrame_UpdateQuests();
		WorldMapQuestShowObjectives_AdjustPosition();

		if (WorldMapQuestShowObjectives:GetChecked() and WorldMapFrame_UpdateQuests() > 0) then
			WorldMapFrame_SetQuestMapView();
		end
	end

	if (not MetaMap_VarsLoaded) then return; end

	if (BattlefieldMinimap and BattlefieldMinimap:IsVisible()) then
		if (not MetaMap_CombatLockdown_BattlefiedMap) then
			MetaMap_Reshow_BattlefiedMap = time();
		else
			MetaMap_CombatLockdown_BattlefiedMap = nil;
			MetaMap_Reshow_BattlefiedMap = nil;
		end
		BattlefieldMinimap:Hide();
	end

	StaticPopup1:SetFrameStrata("FULLSCREEN");
	if (MetaMap_FullScreenMode or InCombatLockdown()) then
		MetaMapNotesEditFrame:SetParent("WorldMapFrame");
		MetaMap_SendFrame:SetParent("WorldMapFrame");
	end

	MetaMap_SetMapToCurrentZone();
	MetaMap_MainMapUpdate();

	--WorldMapFrame:EnableMouse(false);

	--WorldMapPlayerLower:Hide();
	--WorldMapPlayerUpper:Hide();
end

function MetaMap_ShowObjectives_OnClick()
	MetaMap_Debug_Print("MetaMap_ShowObjectives_OnClick",true);
	local obj = WorldMapQuestShowObjectives:GetChecked(); 
	if (MetaMap_CurrentSaveSet  == 1) then
		MetaMapOptions.ShowObj1 = obj;
		if (obj) then MetaMap_Debug_Print("MetaMapTopFrame_OnHide: saved obj1 = 1",true);
		         else MetaMap_Debug_Print("MetaMapTopFrame_OnHide: saved obj1 = nil",true); end
	else
		MetaMapOptions.ShowObj2 = obj;
	end
end

function MetaMapTopFrame_OnHide(self)
	MetaMap_Debug_Print("MetaMapTopFrame_OnHide: SaveSet:"..MetaMap_CurrentSaveSet,true);

	MetaMap_ShowObjectives_OnClick();

	MetaMapOptions.SaveSet = MetaMap_CurrentSaveSet;
	MetaMap_ClearCurrentMapData();
	MetaMap_HideAll();
	MetaMap_ToggleDR(self,0);
	StaticPopup1:SetFrameStrata("DIALOG");
	MetaMapNotesEditFrame:SetParent("UIParent");
	MetaMapNotesEditFrame:SetFrameStrata("FULLSCREEN");
	MetaMap_SendFrame:SetParent("UIParent");
	MetaMap_SendFrame:SetFrameStrata("FULLSCREEN");
	MetaMap_SetMapToCurrentZone();

	--MetaMapOptions_Init();
	if (BattlefieldMinimap and MetaMap_Reshow_BattlefiedMap) then
		MetaMap_Reshow_BattlefiedMap = nil;
		BattlefieldMinimap:Show();
	end
end

local WORLD_MAP_UPDATE_event_timer = 0;
local WORLD_MAP_UPDATE_event_save = false;
function MetaMap_OnEvent(self, event, ...)
	local arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11 = ...;
	if (event == "ADDON_LOADED" and arg1 == "MetaMap") then
		MetaMapOptions.ShowDNI = false;

		for option, value in pairs(MetaMap_Default) do
			if (MetaMapOptions[option] == nil) then MetaMapOptions[option] = value; end
		end
		MetaMap_Default = nil;
		MetaMap_LoadZones();

		-- ### problematic with taintLog ###
		UIDropDownMenu_Initialize(MetaMap_MainMenu, MetaMap_MainMenu_Initialize, "MENU");
		-- ### problematic with taintLog ###
		UIDropDownMenu_Initialize(MetaMap_InstanceMenu, MetaMap_InstanceMenu_Initialize);
		-- ### problematic with taintLog ###
		UIDropDownMenu_Initialize(MetaMap_ZoneMenu, MetaMap_ZoneMenu_Initialize);
		--- Set the instance menu size
		UIDropDownMenu_SetWidth(MetaMap_InstanceMenu, 120);
		UIDropDownMenu_SetWidth(MetaMap_ZoneMenu, 120);
	elseif (event == "VARIABLES_LOADED") then
		MetaMap_SetWorldMap();

		-- Prevents taint from expanding menus past blizzard's MAXBUTTONS, also fixes an init issue with menus longer than 17.
		if ( UIDROPDOWNMENU_MAXBUTTONS < 29 ) then
			local toggle;
			if ( not WorldMapFrame:IsVisible() ) then
				-- ### problematic with taintLog ###
				ToggleFrame(WorldMapFrame);
				toggle = true;
			end
			SetMapZoom(2);
			if ( toggle ) then
				-- ### problematic with taintLog ###
				ToggleFrame(WorldMapFrame);
			end
		end

		MetaMap_CurrentSaveSet = MetaMapOptions.SaveSet;
		MetaMap_ModeToggleButton:SetText(MetaMapOptions.SaveSet);

		if (myAddOnsFrame_Register) then
			myAddOnsFrame_Register(MetaMap_Details);
		end
		if (MetaMap_MiniNote_Data.icon == "party") then
			MetaMap_ClearMiniNote(true);
		end
		if (MetaMap_MiniNote_Data.icon ~= nil) then
			MetaMap_MiniNoteTexture:SetTexture(METAMAP_ICON_PATH.."Icon"..MetaMap_MiniNote_Data.icon);
		end
		MetaMap_CommandsInit();

		MetaMap_WorldMapButton_OnClick_old = WorldMapButton_OnClick;
		WorldMapButton_OnClick = MetaMap_WorldMapButton_OnClick;

		MetaMap_OrigChatFrame_OnEvent = ChatFrame_MessageEventHandler;
		ChatFrame_MessageEventHandler = MetaMap_ChatFrame_OnEvent;

		MetaMap_MiniNote.TimeSinceLastUpdate = 0;
		for i=0, 9, 1 do
			if (MetaMap_NoteFilter[i] == nil) then MetaMap_NoteFilter[i] = true; end
		end
		if (not MetaMapOptions.MetaMapZone) then
			MetaMapOptions.MetaMapZone = MetaMap_ZoneTable[110][MetaMap_Locale];
		end
		if (not MetaMapOptions.MetaMapLevel) then
			MetaMapOptions.MetaMapLevel = 0;
		end
		MetaMap_ZoneCapture = nil;

		MetaMapOptions_Init();

		-- check if MobMap is installed and using its internal quest tracker
		if ( mobmap_use_questtracker ) then
			MetaMap_Print(METAMAP_MOBMAP_QUESTTRACKER_WARNING, true, 1, 0, 0);
			mobmap_use_questtracker = false;
			MobMap_QuestTracker_Setup();
		end
		MetaMap_VarsLoaded = true;
	elseif (event == "UPDATE_BINDINGS") then
		local key1, key2 = GetBindingKey("TOGGLEWORLDMAPSIZE");
		if (key1) then SetBinding(key1, "METAMAP_FSTOGGLE"); end
		if (key2) then SetBinding(key2, "METAMAP_FSTOGGLE"); end
		if (key1 or key2) then
			SaveBindings(GetCurrentBindingSet());
			MetaMap_Print(METAMAP_MOVE_KEY_BINDING.." "..BINDING_NAME_TOGGLEWORLDMAPSIZE.." -> MetaMap: "..BINDING_NAME_METAMAP_FSTOGGLE,true);
		end
	elseif (event == "INSTANCE_MAP_UPDATE" and MetaMapTopFrame:IsVisible()) then
		if (not MetaMap_VarsLoaded) then return; end
		if (IsAddOnLoaded("MetaMapWKB") and WKB_DisplayFrame:IsVisible()) then
			WKB_OnEvent("INSTANCE_MAP_UPDATE");
		elseif (IsAddOnLoaded("MetaMapQST") and QST_DisplayFrame:IsVisible()) then
			QST_OnEvent("INSTANCE_MAP_UPDATE");
		elseif (IsAddOnLoaded("MetaMapTRK") and TRK_DisplayFrame:IsVisible()) then
			TRK_OnEvent("INSTANCE_MAP_UPDATE");
		else
			MetaMapContainer_ShowFrame();
		end
		if (MetaMap_InfoLineFrame:IsVisible()) then MetaMap_InfoLineUpdate(); end

		MetaMap_MainMapUpdate();
		MetaMap_ZoneSearch();
		MetaMap_HideAll();
		if (MetaMap_gPingPOI) then
			MetaMapPing_OnUpdate(1);
		end
	elseif (event == "WORLD_MAP_UPDATE") then
		if (not MetaMap_VarsLoaded) then return; end
		MetaMap_Debug_Print("WORLD_MAP_UPDATE", true);
		--MetaMap_Debug_Print("WORLD_MAP_UPDATE:"..MetaMap_GetRealZoneText().." : "..MetaMap_GetCurrentMapInfo(), true);

		-- limit the event WORLD_MAP_UPDATE once per 0.5 Sec., because it is triggered very often if the world map is shown
		-- this would executed a routine of the MobMap addon to often, which let MobMap cause a WoW crash
		-- this -> MetaMapOptions_Init -> WorldMapQuestShowObjectives_Toggle -> MobMap_QuestTracker_FullUpdate ->
		-- MobMap_QuestTracker_RefreshQuestStatusFromLog -> GetQuestWorldMapAreaID -> CRASH
		if ( WORLD_MAP_UPDATE_event_timer > time() ) then WORLD_MAP_UPDATE_event_save = true; return; end
		WORLD_MAP_UPDATE_event_timer = time() + 0.3;
		-- save all incoming events, and force an execution if wait time is over in MetaMap_OnUpdate
		WORLD_MAP_UPDATE_event_save = false;

		if (MetaMapOptions.UsePOI) then MetaMapPOI_OnEvent(1); end
		if (not MetaMapTopFrame:IsVisible()) then return; end

		local _, _, zType = MetaMap_GetZoneTableEntry(MetaMap_GetRealZoneText());
		if (zType == "DNI" or zType == "BG" or zType == "SCN" or zType == "RDI")  then
			MetaMapOptions.ShowDNI = true;
			MetaMap_ShowInstance(self, true);
		elseif (UIDropDownMenu_GetSelectedID(MetaMap_ZoneMenu)) then
			MetaMapOptions.ShowDNI = false;
			MetaMapOptions.MetaMapZone = nil;
			MetaMapOptions.MetaMapLevel = 0;
			UIDropDownMenu_ClearAll(MetaMap_InstanceMenu);
		end

		if (IsAddOnLoaded("MetaMapWKB") and WKB_DisplayFrame:IsVisible()) then
			WKB_OnEvent("INSTANCE_MAP_UPDATE");
		elseif (IsAddOnLoaded("MetaMapQST") and QST_DisplayFrame:IsVisible()) then
			QST_OnEvent("INSTANCE_MAP_UPDATE");
		elseif (IsAddOnLoaded("MetaMapTRK") and TRK_DisplayFrame:IsVisible()) then
			--- Maintain the display.
		else
			MetaMapContainer_ShowFrame();
		end

		if (MetaMap_InfoLineFrame:IsVisible()) then
			MetaMap_InfoLineUpdate();
		end
		MetaMap_MainMapUpdate();
		MetaMap_ZoneSearch();
		MetaMapOptions_Init();
		if (MetaMap_gPingPOI) then
			MetaMapPing_OnUpdate(1);
		end
	elseif (event == "ZONE_CHANGED_NEW_AREA" or event == "ZONE_CHANGED" or event == "ZONE_CHANGED_INDOORS") then
		MetaMap_Debug_Print("ZONE_CHANGED", true);
		if (not MetaMap_VarsLoaded) then return; end

		MetaMap_SetMapToCurrentZone(self, true);

		MetaMap_MiniNote_OnUpdate(0);
		if (MetaMapOptions.UsePOI) then
			MetaMapPOI_OnEvent(2);
		end

		if (WorldMapFrame:IsVisible()) then
			MetaMap_MainMapUpdate();
		end

		MetaMap_ZoneDisplay:SetText(METAMAP_CURZONE..MetaMap_GetRealZoneText());
		MetaMap_HideAll();
		MetaMap_Timer_DelayWKB_AddUnitInfo = 5.0;
	elseif (event == "PLAYER_ENTERING_WORLD") then
		if (not MetaMap_VarsLoaded) then return; end
		if (not MetaMap_GetRealZoneText()) then return; end

		MetaMap_SetMapToCurrentZone();

		MetaMap_ZoneDisplay:SetText(METAMAP_CURZONE..MetaMap_GetRealZoneText());
		MetaMap_Timer_DelayWKB_AddUnitInfo = 5.0;
	elseif (event == "MINIMAP_UPDATE_ZOOM") then
		MetaMap_MinimapUpdateZoom();
	elseif (event == "CHAT_MSG_ADDON" and arg1 == "MetaMap:MN") then
		MetaMap_GetNoteFromChat(arg2, arg4);
	elseif ( ( event == "QUEST_LOG_UPDATE" or event == "QUEST_POI_UPDATE" ) and self:IsShown() ) then
		WorldMapFrame_DisplayQuests();
		WorldMapQuestFrame_UpdateMouseOver();
	elseif ( event == "PLAYER_LOGOUT" ) then
		local point, _, relativePoint, xOffset, yOffset = WorldMapFrame:GetPoint(1);
		MetaMap_Options.WorldMapPoint = point;
		MetaMap_Options.WorldMapRelative = relativePoint;
		MetaMap_Options.WorldMapXoffset = xOffset;
		MetaMap_Options.WorldMapYoffset = yOffset;
	end
end

function MetaMap_ChatFrame_OnEvent(self, event, ...)
	local arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13 = ...;
	if (event == "CHAT_MSG_WHISPER" and string.find(arg1, "<MetaMap:MN>")) then
		if (arg2 ~= UnitName("player")) then
			MetaMap_GetNoteFromChat(arg1, arg2);
		end
	elseif (event == "CHAT_MSG_WHISPER_INFORM" and string.find(arg1, "<MetaMap:MN>")) then
		--- Discard the return info
	else
		MetaMap_OrigChatFrame_OnEvent(self, event, ...);
	end
end

local MetaMap_RealZoneText = " ";
local MetaMap_IsInside = true;
local MetaMap_IsMicroDungeon = false;
local MetaMap_RealZoneTimer;
local MetaMap_WaitTimer = 1;
function MetaMap_OnUpdate(self, elapsed)
	if ( not MetaMap_VarsLoaded ) then return; end
	-- *** taintLog fix ***
	if ( GetCVar("taintLog") ~= MetaMap_taintLog_Set ) then
		if ( GetCVar("taintLog") == "0") then
			MetaMap_taintLog_Set = GetCVar("taintLog");
			UIDropDownMenu_ClearAll = MetaMap_UIDropDownMenu_ClearAll_Original;
			UIDropDownMenu_GetSelectedID = MetaMap_UIDropDownMenu_GetSelectedID_Original;
		else
			MetaMap_taintLog_Set = GetCVar("taintLog");
			UIDropDownMenu_GetSelectedID = MetaMap_UIDropDownMenu_GetSelectedID;
			UIDropDownMenu_ClearAll = MetaMap_UIDropDownMenu_ClearAll;
		end
	end

	if ( not MetaMap_MiniNote_MapzoomInit ) then return; end

	-- allow a delay of the WORLD_MAP_UPDATE event without ignoring an event
	if ( WORLD_MAP_UPDATE_event_save and (WORLD_MAP_UPDATE_event_timer < time()) ) then
		MetaMap_OnEvent(self, "WORLD_MAP_UPDATE");
	end

	if (MetaMap_Timer_DelayLoadModules) then
		MetaMap_Timer_DelayLoadModules = MetaMap_Timer_DelayLoadModules - elapsed;
		if (MetaMap_Timer_DelayLoadModules < 0) then
			MetaMap_Timer_DelayLoadModules = nil;
			MetaMap_LoadModules();
		end
	end

	if (MetaMap_Timer_DelayWKB_AddUnitInfo) then
		MetaMap_Timer_DelayWKB_AddUnitInfo = MetaMap_Timer_DelayWKB_AddUnitInfo - elapsed;
		if (MetaMap_Timer_DelayWKB_AddUnitInfo < 0) then
			MetaMap_Timer_DelayWKB_AddUnitInfo = nil;
		end
	end

	-- check for a zone change without event
	local realZone = GetRealZoneText();
	if (MetaMap_RealZoneTimer) then
		MetaMap_RealZoneTimer = MetaMap_RealZoneTimer - elapsed;
	end

	-- execute only every second
	MetaMap_WaitTimer = MetaMap_WaitTimer - elapsed;
	if ( MetaMap_WaitTimer < 0 ) then
		MetaMap_WaitTimer = 1;
	else
		return;
	end

	if (realZone and realZone ~= MetaMap_RealZoneText) then
		MetaMap_RealZoneTimer = 3;
		MetaMap_RealZoneText = realZone;
	elseif ( MetaMap_MiniNote_IsInCity ~= MetaMap_IsInside ) then
		MetaMap_RealZoneTimer = 3;
		MetaMap_IsInside = MetaMap_MiniNote_IsInCity;
	end
	if (MetaMap_RealZoneTimer and MetaMap_RealZoneTimer < 0) then
		MetaMap_RealZoneTimer = nil;
		if (realZone) then
			local _, _, _, isMicroDungeon = GetMapInfo();
			for _, zoneTable in pairs(MetaMap_ZoneTable) do
				if (zoneTable[MetaMap_Locale] == realZone) then
					if ( (zoneTable.ztype == "SZR") and not isMicroDungeon ) then
						realZone = MetaMap_SplitZoneName(zoneTable.Location);
					end
				end
			end
			local baseName = MetaMap_SplitZoneName(MetaMap_BaseMapName);
			if ( (baseName ~= realZone) or (MetaMap_IsMicroDungeon ~= isMicroDungeon) ) then
				MetaMap_IsMicroDungeon = isMicroDungeon;
				MetaMap_OnEvent(self, "ZONE_CHANGED");
				MetaMap_Debug_Print("*** Event ZONE_CHANGED triggered by MetaMap_OnUpdate ***",true);
			end
		end
	end

	if (WorldMapFrame:IsVisible()) then
		if (MetaMapOptions.MetaMapCoords) then MetaMap_MainCoordsUpdate(); end
	else
		if (MetaMapOptions.MetaMapMiniCoords) then MetaMap_MiniCoordsUpdate(); end
	end

	if (MetaMap_MiniNote_Data.xPos) then
		MetaMap_MiniNote_OnUpdate(elapsed);
	end

--	if (MetaMap_gPingPOI) then
--		MetaMapPing_OnUpdate(0);
--	end
end

function MetaMap_LoadZones()
	if(MetaMap_Notes == nil) then MetaMap_Notes = {}; end
	if(MetaMap_Lines == nil) then MetaMap_Lines = {}; end

	for index, zoneTable in pairs(MetaMap_ZoneTable) do
		if (zoneTable.ztype == "RDI" or zoneTable.ztype == "DNI" or zoneTable.ztype == "BG" or zoneTable.ztype == "SCN" or zoneTable.ztype == "MSZ") then
			local name = MetaMap_MergeZoneName(zoneTable);
			if (MetaMap_Notes[name] == nil) then
				MetaMap_Notes[name] = {};
			end
			if (MetaMap_Lines[name] == nil) then
				MetaMap_Lines[name] = {};
			end
		end
	end

	MetaMap_Continents[-1] = "The Cosmos";
	MetaMap_Continents[0] = "Azeroth";
	for cKey, cName in ipairs{GetMapContinents()} do
		MetaMap_Continents[cKey] = cName;
		for zKey, zName in ipairs{GetMapZones(cKey)} do
			local name = zName;
			for _, zoneTable in pairs(MetaMap_ZoneTable) do
				if (zoneTable[MetaMap_Locale] == zName) then
					if (not zoneTable.zoneid or zoneTable.zoneid == zKey) then
						name = MetaMap_MergeZoneName(zoneTable);
					end
				end
			end
			if (MetaMap_Notes[name] == nil) then
				MetaMap_Notes[name] = {};
			end
			if (MetaMap_Lines[name] == nil) then
				MetaMap_Lines[name] = {};
			end
			MetaMap_ZoneTableUpdate(name);
		end
	end
end

-- check if the zoneName is included in MetaMap_ZoneTable else add it
function MetaMap_ZoneTableUpdate(zoneName)
	local index = 0;
	for idx, zoneTable in pairs(MetaMap_ZoneTable) do
		if ( index < idx ) then index = idx; end
		local name = MetaMap_MergeZoneName(zoneTable);
		if (zoneTable.ztype == "SZ" and name == zoneName) then
			return;
		end
	end

	index = index + 1;
	MetaMap_ZoneTable[index] = {ztype = "SZ", en = zoneName, de = zoneName, fr = zoneName, es = zoneName, ru = zoneName, llvl = 0, hlvl = 0, faction = "Unknown", scale = 0, xoffset = 0, yoffset = 0};
end

function MetaMap_NameToZoneID(zoneText)
	local _, idx, zType, mapid = MetaMap_GetZoneTableEntry(zoneText);
	if (zType == "DNI" or zType == "BG" or zType == "SCN" or zType == "RDI") then
		return -1, mapid;
	else
		if(mapid ~= 0 and mapid ~= nil)  then
			MetaMap_Debug_Print("NameToZoneID: "..mapid,true);
			return -1,mapid; 
		end;
		-- check continents first, because "The Maelstrom" is a continent and a zone
		for index, cName in pairs(MetaMap_Continents) do
			if (zoneText == cName) then
				return index, 0;
			end
		end
		-- check all maps
		local zoneid;
		local name = zoneText;
		if (idx) then
			name = MetaMap_ZoneTable[idx][MetaMap_Locale];
			zoneid = MetaMap_ZoneTable[idx].zoneid;
		end
		for cKey, cName in ipairs{GetMapContinents()} do
			for zKey, zName in ipairs{GetMapZones(cKey)} do
				if (name == zName) then
					if (not zoneid or zoneid == zKey) then
						return cKey, zKey;
					end
				end
			end
		end
		return -1, zoneText;
	end
end

function MetaMap_ZoneIDToName(continentKey, zoneKey)
--	for index, zoneTable in pairs(MetaMap_ZoneTable) do
--		if ( (zoneTable.ztype == "BG") or (zoneTable.ztype == "DNI") ) then
--			if (zoneTable[MetaMap_Locale] == MetaMap_GetRealZoneText() and continentKey == -1 and zoneKey == 0) then
--				return zoneTable[MetaMap_Locale];
--			end
--		end
--	end
	if (type(zoneKey) ~= "number") then return zoneKey; end
	if (zoneKey == 0) then
		for index, cName in pairs(MetaMap_Continents) do
			if (continentKey == index) then
				return cName;
			end
		end
	end
	if (continentKey > 0) then
		for zKey, zName in ipairs{GetMapZones(continentKey)} do
			if (zKey == zoneKey) then
				local found;
				for _, zoneTable in pairs(MetaMap_ZoneTable) do
					if (zoneTable[MetaMap_Locale] == zName) then
						found = true;
						if (not zoneTable.zoneid or zoneTable.zoneid == zKey) then
							return MetaMap_MergeZoneName(zoneTable);
						end
					end
				end
				if (not found) then return zName; end
			end
		end
	end
	if (continentKey == -1) then
		for index, zoneTable in pairs(MetaMap_ZoneTable) do
			if ( zoneTable.mapid and (zoneTable.mapid == zoneKey) ) then
				return MetaMap_MergeZoneName(zoneTable);
			end
		end
	end
	return UNKNOWN;
end

function MetaMap_GetCurrentMapInfo()
	local mapName, dataZone;
	local _, _, _, isMicroDungeon = GetMapInfo();
	if ( MetaMapOptions.ShowDNI or isMicroDungeon ) then
		mapName = MetaMapOptions.MetaMapZone;
	else
		mapName = MetaMap_ZoneIDToName(GetCurrentMapContinent(), GetCurrentMapZone());
	end
	local mapLevel = GetCurrentMapDungeonLevel();
	return mapName, mapLevel, MetaMap_Notes[mapName], isMicroDungeon;
end

function MetaMap_SplitZoneName(zoneName0)
	local zoneName = zoneName0;
	local isNameID;

	local IDidx;
	if (zoneName0) then IDidx = string.find(zoneName0,"_"); end
	if (IDidx) then
		zoneName = string.sub(zoneName0, 1, IDidx-1);
		isNameID = tonumber(string.sub(zoneName0, IDidx+1));
	end

	return zoneName, isNameID;
end

function MetaMap_MergeZoneName(zoneTable)
	local nameid;
	if (zoneTable.nameid) then nameid = tostring(zoneTable.nameid); end
	if (nameid) then nameid = "_"..nameid; else nameid = ""; end
	local name = zoneTable[MetaMap_Locale]..nameid;

	return name;
end

function MetaMap_GetZoneTableEntry(zoneName0, mapid0)
	if (not zoneName0) then return; end

	local zoneName, isNameID = MetaMap_SplitZoneName(zoneName0);
	
	
	for index, zoneTable in pairs(MetaMap_ZoneTable) do
		if (zoneTable.en == zoneName or zoneTable.de == zoneName or zoneTable.fr == zoneName or zoneTable.es == zoneName or zoneTable.ru == zoneName) then
			local found;
			if ( not zoneTable.nameid ) then
				found = true;
			else
				if (isNameID) then
					if (isNameID == zoneTable.nameid) then found = true; end
				else
					local currentid = MetaMap_CurrentMapID;
					if (zoneName == MetaMap_GetRealZoneText()) then currentid = MetaMap_BaseMapID; end
					if (mapid0) then currentid = mapid0; end
					if (not currentid) then
						found = true;
					else
						if (currentid == zoneTable.mapid) then found = true; end
					end
				end
			end
			if (found) then
				local name = MetaMap_MergeZoneName(zoneTable);
				local mapid = 0;
				if (zoneTable.mapid ~= nil) then
					mapid = zoneTable.mapid;
				end
				return name, index, zoneTable.ztype, mapid;
			end
		end
	end
end

function MetaMap_CheckValidZone(zoneName)
	local _, idx, zType = MetaMap_GetZoneTableEntry(zoneName);
	if (zType == "BG" or zType == "RDI" or zType == "DNI" or zType == "SCN") then
		return true;
	end
	local zoneid;
	local name = zoneName;
	if (idx) then
		name = MetaMap_ZoneTable[idx][MetaMap_Locale];
		zoneid = MetaMap_ZoneTable[idx].zoneid;
	end
	for cKey, cName in pairs{GetMapContinents()} do
		for zKey, zName in ipairs{GetMapZones(cKey)} do
			if (zName == name) then
				if (not zoneid or zoneid == zKey) then
					return true;
				end
			end
		end
	end
	return false;
end

-- checks if the zone "zoneName" is located in the map "mapName"
function MetaMap_CheckRelatedZone(zoneName, mapName)
	if (zoneName == mapName) then return true; end

	if (mapName == MetaMap_Continents[-1]) then related = true; end --"The Cosmos"

	local _, zIndex, zType = MetaMap_GetZoneTableEntry(zoneName);
	if (zType == "RDI" or zType == "DNI" or zType == "BG" or zType == "SZR" or zType == "MSZ" or zType == "SCN") then
		local locName = MetaMap_ZoneTable[zIndex].Location;
		if (locName == mapName) then return true; end
	end

	local continent = MetaMap_NameToZoneID(zoneName);
	if (zType == "RDI" or zType == "DNI" or zType == "BG" or zType == "SZR" or zType == "MSZ" or zType == "SCN") then
		continent = MetaMap_ZoneTable[zIndex].Continent;
	end
	if (not continent or continent == -1) then return false; end -- The Cosmos do not direct include any maps

	if (mapName == MetaMap_Continents[continent]) then related = true; end
	if (mapName == MetaMap_Continents[0] and continent > 0 and continent ~= 3 ) then related = true; end
	return false;
end

function MetaMap_ZoneCheckButton_OnClick()
	local errata = "";
	if (MetaMap_Orphans == 0) then
		MetaMap_LoadWKB(3);
		MetaMap_LoadTRK(2);
		MetaMap_LoadQST(2);
		errata = MetaMap_CheckZones();
		if (MetaMap_Orphans > 0) then
			MetaMap_ZoneShiftDisplay:Show();
			MetaMap_ZoneCheckButton:SetText(METAMAP_ZONEMOVE_BUTTON);
			MetaMap_OptionsInfo:SetText(METAMAP_ZONE_ERROR..errata);
			for zone, value in pairs(MetaMap_ZoneErrata) do
				MetaMap_OrphanFrameText:SetText(zone);
				MetaMap_OrphanText1:SetText(format(METAMAP_ORPHAN_TEXT1, 1, MetaMap_Orphans));
				break;
			end
		else
			MetaMap_ZoneShiftDisplay:Hide();
			MetaMap_OptionsInfo:SetText(METAMAP_ZONE_NOSHIFT);
			MetaMap_ZoneCheckButton:SetText(METAMAP_ZONECHECK_BUTTON);
		end
	elseif (MetaMap_Orphans > 0) then
		MetaMap_ShiftZones();
		if (MetaMap_Orphans > 0) then
			MetaMap_ZoneShiftDisplay:Show();
			MetaMap_ZoneCheckButton:SetText(METAMAP_ZONEMOVE_BUTTON);
			for zone, value in pairs(MetaMap_ZoneErrata) do
				MetaMap_OrphanFrameText:SetText(zone);
				MetaMap_OrphanText1:SetText(format(METAMAP_ORPHAN_TEXT1, 1, MetaMap_Orphans));
				break;
			end
		else
			MetaMap_ZoneShiftDisplay:Hide();
			MetaMap_OptionsInfo:SetText(METAMAP_ZONE_NOSHIFT);
			MetaMap_ZoneCheckButton:SetText(METAMAP_ZONECHECK_BUTTON);
		end
	end
	MetaMap_ZoneCheckButton:Disable();
end

function MetaMap_CheckZones()
	MetaMap_ZoneErrata = {};
	local errata;
	local found = "|cffff0000\n\n";
	for zone, indexTable in pairs(MetaMap_Notes) do
		if (not MetaMap_CheckValidZone(zone)) then
			if (not MetaMap_ZoneErrata[zone]) then
				MetaMap_ZoneErrata[zone] = true;
			end
			errata = "MetaMap";
		end
	end
	if (errata) then found = found..errata; errata = nil; end
	if (WKB_Data) then
		for zone, indexTable in pairs(WKB_Data) do
			if (not MetaMap_CheckValidZone(zone)) then
				if (not MetaMap_ZoneErrata[zone]) then
					MetaMap_ZoneErrata[zone] = true;
				end
				errata = " - MetaMapWKB";
			end
		end
		if (errata) then found = found..errata; errata = nil; end
	end
	if (TRK_Data) then
		for zone, indexTable in pairs(TRK_Data) do
			if (not MetaMap_CheckValidZone(zone)) then
				if (not MetaMap_ZoneErrata[zone]) then
					MetaMap_ZoneErrata[zone] = true;
				end
				errata = " - MetaMapTRK";
			end
		end
		if (errata) then found = found..errata; errata = nil; end
	end
	if (QST_QuestLog) then
		for index, value in ipairs(QST_QuestLog) do
			if (value.qArea and value.qArea ~= QST_QUEST_UNKNOWN) then
				if (not MetaMap_CheckValidZone(value.qArea)) then
					if (not MetaMap_ZoneErrata[value.qArea]) then
						MetaMap_ZoneErrata[value.qArea] = true;
					end
					errata = " - MetaMapQSTlog";
				end
			end
		end
		if (errata) then found = found..errata; errata = nil; end
		for index, value in ipairs(QST_QuestBase) do
			if (value.qArea) then
				if (value.qArea ~= QST_QUEST_UNKNOWN and not MetaMap_CheckValidZone(value.qArea)) then
					if (not MetaMap_ZoneErrata[value.qArea]) then
						MetaMap_ZoneErrata[value.qArea] = true;
					end
					errata = " - MetaMapQSTbase";
				end
			elseif (value.qZone ~= QST_QUEST_UNKNOWN and not MetaMap_CheckValidZone(value.qZone)) then
				if (not MetaMap_ZoneErrata[value.qZone]) then
					MetaMap_ZoneErrata[value.qZone] = true;
				end
				errata = " - MetaMapQSTbase";
			end
		end
		if (errata) then found = found..errata; errata = nil; end
	end
	for zone, value in pairs(MetaMap_ZoneErrata) do
		MetaMap_Orphans = MetaMap_Orphans + 1;
	end
	return found;
end

function MetaMap_ShiftZones()
	local oldZone = MetaMap_OrphanFrameText:GetText();
	local newZone = UIDropDownMenu_GetText(MetaMap_ZoneCheckMenu);
	if (MetaMap_Notes[oldZone]) then
		if ( newZone ~= METAMAP_ZONE_DELETE ) then
			for index, value in ipairs(MetaMap_Notes[oldZone]) do
				local noteAdded = MetaMap_SetNewNote(newZone, value.xPos, value.yPos, value.name, value.inf1, value.inf2, value.creator, value.icon, value.ncol, value.in1c, value.in2c);
				if (noteAdded and MetaMap_Lines[oldZone]) then
					for i, lines in ipairs(MetaMap_Lines[oldZone]) do
						if (lines.x1 == value.xPos and lines.y1 == value.yPos) then
							MetaMap_ToggleLine(newZone, lines.x1, lines.y1, lines.x2, lines.y2);
						end
					end
				end
			end
		end
		MetaMap_Notes[oldZone] = nil;
		MetaMap_Lines[oldZone] = nil;
	end
	if (WKB_Data and WKB_Data[oldZone]) then
		if ( newZone ~= METAMAP_ZONE_DELETE ) then
			if (not WKB_Data[newZone]) then WKB_Data[newZone] = {}; end
			for unit, value in pairs(WKB_Data[oldZone]) do
				WKB_Data[newZone][unit] = value;
			end
		end
		WKB_Data[oldZone] = nil;
	end
	if (TRK_Data and TRK_Data[oldZone]) then
		if ( newZone ~= METAMAP_ZONE_DELETE ) then
			if (not TRK_Data[newZone]) then TRK_Data[newZone] = {}; end
			for index, value in ipairs(TRK_Data[oldZone]) do
				TRK_Data[newZone][index] = value;
			end
		end
		TRK_Data[oldZone] = nil;
	end
	if (newZone == METAMAP_ZONE_DELETE) then newZone = QST_QUEST_UNKNOWN; end
	if (QST_QuestLog) then
		for index, value in ipairs(QST_QuestLog) do
			if (value.qArea == oldZone) then
				value.qArea = newZone;
			end
			if (value.qNPC[1] and value.qNPC[1].qZone == oldZone) then
				value.qNPC[1].qZone = newZone;
			end
			if (value.qNPC[2] and value.qNPC[2].qZone == oldZone) then
				value.qNPC[2].qZone = newZone;
			end
		end
	end
	if (QST_QuestBase) then
		for index, value in ipairs(QST_QuestBase) do
			if (value.qArea == oldZone) then
				value.qArea = newZone;
			elseif (value.qZone == oldZone) then
				value.qZone = newZone;
			end
			if (value.qNPC[1] and value.qNPC[1].qZone == oldZone) then
				value.qNPC[1].qZone = newZone;
			end
			if (value.qNPC[2] and value.qNPC[2].qZone == oldZone) then
				value.qNPC[2].qZone = newZone;
			end
		end
	end
	MetaMap_ZoneErrata[oldZone] = nil;
	MetaMap_Orphans = MetaMap_Orphans - 1;
	if (MetaMap_Orphans == 0) then MetaMap_ZoneErrata = nil; end
	MetaMap_OptionsInfo:SetText(format(METAMAP_ZONE_SHIFTED, oldZone, newZone));
	UIDropDownMenu_SetText(MetaMap_ZoneCheckMenu, "");
end

local UseBattlefieldMiniMapInCombat = true; --use Battlefield minimap during combat lockdown
local MetaMap_CombatLockdown_BattlefiedMap = nil;

function MetaMap_ToggleFrame(frame)
	if (frame == nil) then
		frame = WorldMapFrame;
	end

	MetaMap_Debug_Print("MetaMap: MetaMap_ToggleFrame("..tostring(frame)..")");
	if (UseBattlefieldMiniMapInCombat and InCombatLockdown() and frame == WorldMapFrame) then --combat lockdown
		if (not BattlefieldMinimap) then BattlefieldMinimap_LoadUI(); end
		if (BattlefieldMinimap and BattlefieldMinimap:IsVisible()) then
			if (MetaMap_CombatLockdown_BattlefiedMap) then --wasn't on before combat
				BattlefieldMinimap:Hide();
				--MetaMap_Reshow_BattlefiedMap = true;
			end
			MetaMap_CombatLockdown_BattlefiedMap = nil;
		elseif (BattlefieldMinimap) then
			MetaMap_CombatLockdown_BattlefiedMap = true;
			BattlefieldMinimap:Show();
		end
	elseif (MetaMap_CombatLockdown_BattlefiedMap and frame == WorldMapFrame) then
		MetaMap_CombatLockdown_BattlefiedMap = nil;
		BattlefieldMinimap:Hide();
	end
	if (frame:IsVisible()) then
		HideUIPanel(frame);
	else
		ShowUIPanel(frame);
	end
end

function MetaMapContainer_ShowFrame(frame, header, footer, info)
	if (not frame) then
		if (MetaMapContainer_CurrentFrame) then
			MetaMapContainer_CurrentFrame:Hide();
		end
		MetaMapContainerFrame:Hide();
		return;
	end
	if (MetaMapContainer_CurrentFrame) then
		MetaMapContainer_CurrentFrame:Hide();
	end
	if (header ~= nil) then
		MetaMapContainer_HeaderText:SetText(header);
		MetaMapContainer_HeaderText:Show();
	else
		MetaMapContainer_HeaderText:Hide();
	end
	if (footer ~= nil) then
		MetaMapContainer_FooterText:SetText(footer);
		MetaMapContainer_FooterText:Show();
	else
		MetaMapContainer_FooterText:Hide();
	end
	if (info ~= nil) then
		MetaMapContainer_InfoText:SetText(info);
		MetaMapContainer_InfoText:Show();
	else
		MetaMapContainer_InfoText:Hide();
	end
	MetaMapContainer_CurrentFrame = frame;
	MetaMapContainer_CurrentFrame:Show();
	MetaMapContainerFrame:Show();
	frame:SetAlpha(MetaMapContainerFrame:GetAlpha());
end

function MetaMap_LoadModules()
	if (MetaMapOptions.NBKalwaysOn) then MetaMap_LoadNBK(1); end
	if (MetaMapOptions.WKBalwaysOn) then MetaMap_LoadWKB(3); end
	if (MetaMapOptions.BWPalwaysOn) then MetaMap_LoadBWP(0, 3); end
	if (MetaMapOptions.FWMalwaysOn) then MetaMap_LoadFWM(); end
	if (MetaMapOptions.QSTalwaysOn) then MetaMap_LoadQST(2); end
	if (MetaMapOptions.TRKalwaysOn) then MetaMap_LoadTRK(2); end
end

function MetaMap_LoadHLP()
	if (not IsAddOnLoaded("MetaMapHLP")) then
		LoadAddOn("MetaMapHLP");
	end
	if (IsAddOnLoaded("MetaMapHLP")) then
		MetaMap_LoadHLPButton:Hide();
		return true;
	else
		MetaMap_OptionsInfo:SetText("MetaMapHLP "..METAMAP_NOMODULE);
	end
end

function MetaMap_LoadCVT()
	if (not IsAddOnLoaded("MetaMapCVT")) then
		LoadAddOn("MetaMapCVT");
	end
	if (IsAddOnLoaded("MetaMapCVT")) then
		MetaMapCVT_CheckData();
	else
		MetaMap_OptionsInfo:SetText("MetaMapCVT "..METAMAP_NOMODULE);
	end
end

function MetaMap_LoadEXP()
	if (not IsAddOnLoaded("MetaMapEXP")) then
		LoadAddOn("MetaMapEXP");
	end
	if (IsAddOnLoaded("MetaMapEXP")) then
		EXP_CheckData();
	else
		MetaMap_OptionsInfo:SetText("MetaMapEXP "..METAMAP_NOMODULE);
	end
end

function MetaMap_LoadBKP()
	if (not IsAddOnLoaded("MetaMapBKP")) then
		LoadAddOn("MetaMapBKP");
	end
	if (IsAddOnLoaded("MetaMapBKP")) then
		BKP_BackUpFrame:Show();
	else
		if (MetaMap_LoadBKP) then MetaMap_LoadBKP:Disable(); end
		if (MetaMap_GeneralDialog:IsVisible()) then
			MetaMap_OptionsInfo:SetText("MetaMapBKP "..METAMAP_NOMODULE);
		else
			MetaMap_Print("MetaMapBKP "..METAMAP_NOMODULE, true);
		end
	end
end

	
function MetaMap_LoadBWP(id, mode)
	if (not IsAddOnLoaded("MetaMapBWP")) then
		LoadAddOn("MetaMapBWP");
	end
	if (IsAddOnLoaded("MetaMapBWP")) then
		if (mode == nil) then
			MetaMapBWPMenu_Init();
		elseif (mode == 1) then
			MetaMap_KBMenu_RBSelect(id);
		elseif (mode == 2) then
			MetaMapNotes_RBSelect(id);
		end
	else
		MetaMap_Print("MetaMapBWP "..METAMAP_NOMODULE, true);
	end
end

function MetaMap_LoadWKB(mode)
	if (not IsAddOnLoaded("MetaMapWKB")) then
		LoadAddOn("MetaMapWKB");
	end
	if (IsAddOnLoaded("MetaMapWKB")) then
		if (mode == nil or mode == 1) then
			WKB_ToggleFrame(mode);
		elseif (mode == 2) then
			WKB_UpdateKeySelectedUnit();
		end
	else
		MetaMap_Print("MetaMapWKB "..METAMAP_NOMODULE, true);
	end
end

function MetaMap_LoadQST(mode)
	if (not IsAddOnLoaded("MetaMapQST")) then
		LoadAddOn("MetaMapQST");
	end
	if (IsAddOnLoaded("MetaMapQST")) then
		QST_ToggleFrame(mode);
	else
		MetaMap_Print("MetaMapQST "..METAMAP_NOMODULE, true);
	end
end

function MetaMap_LoadNBK(mode)
	if (not IsAddOnLoaded("MetaMapNBK")) then
		LoadAddOn("MetaMapNBK");
	end
	if (IsAddOnLoaded("MetaMapNBK")) then
		if (not mode) then
			MetaMap_ToggleFrame(NBK_NoteBookFrame);
		end
		return true;
	else
		MetaMap_Print("MetaMapNBK "..METAMAP_NOMODULE, true);
		return false;
	end
end

function MetaMap_LoadTRK(mode)
	if (not IsAddOnLoaded("MetaMapTRK")) then
		LoadAddOn("MetaMapTRK");
	end
	if (IsAddOnLoaded("MetaMapTRK")) then
		TRK_ToggleFrame(mode);
		MetaMap_Tracker = true;
		return true;
	else
		MetaMap_Print("MetaMapTRK "..METAMAP_NOMODULE, true);
		MetaMap_Tracker = false;
		return false;
	end
end

function MetaMap_LoadFWM(mode)
	if (not IsAddOnLoaded("MetaMapFWM")) then
		LoadAddOn("MetaMapFWM");
	end
	if (IsAddOnLoaded("MetaMapFWM")) then
		if (mode == nil) then
			FWM_ShowUnexplored = not FWM_ShowUnexplored;
		else
			FWM_ShowUnexplored = true;
		end 
		WorldMapFrame_Update();
	else
		if (MetaMap_ModulesDialog:IsVisible()) then
			MetaMap_OptionsInfo:SetText("MetaMapFWM "..METAMAP_NOMODULE);
		else
			MetaMap_Print("MetaMapFWM "..METAMAP_NOMODULE, true);
		end
	end
end

--- Init the tracker activation
function MetaMap_SetTracker()
	MetaMap_LoadTRK(2);
end

--[[ unused function
function MetaMap_GetSpell(name)
	local index = 1;
	local spellName = "";
	while (spellName) do
		spellName = GetSpellBookItemName(index, BOOKTYPE_SPELL);
		if (name == spellName) then return index; end
		index = index + 1;
	end
end
]]

function MetaMap_CommandsInit()
	SlashCmdList["MAPNOTE"] = MetaMap_GetNoteBySlashCommand;
	for i = 1, #(METAMAP_ENABLE_COMMANDS) do
		setglobal("SLASH_MAPNOTE"..i, METAMAP_ENABLE_COMMANDS[i]);
	end
	SlashCmdList["MININOTE"] = MetaMap_NextMiniNote;
	for i = 1, #(METAMAP_MININOTE_COMMANDS) do
		setglobal("SLASH_MININOTE"..i, METAMAP_MININOTE_COMMANDS[i]);
	end
	SlashCmdList["MININOTEONLY"] = MetaMap_NextMiniNoteOnly;
	for i = 1, #(METAMAP_MININOTEONLY_COMMANDS) do
		setglobal("SLASH_MININOTEONLY"..i, METAMAP_MININOTEONLY_COMMANDS[i]);
	end
	SlashCmdList["MININOTEOFF"] = MetaMap_ClearMiniNote;
	for i = 1, #(METAMAP_MININOTEOFF_COMMANDS) do
		setglobal("SLASH_MININOTEOFF"..i, METAMAP_MININOTEOFF_COMMANDS[i]);
	end
	SlashCmdList["QUICKNOTE"] = MetaMap_Quicknote;
	for i = 1, #(METAMAP_QUICKNOTE_COMMANDS) do
		setglobal("SLASH_QUICKNOTE"..i, METAMAP_QUICKNOTE_COMMANDS[i]);
	end
end

function MetaMap_FullScreenToggle(self)
	MetaMap_Debug_Print("FullScreenToggle:", true);
	if ( InCombatLockdown() ) then return; end

	local mapid = GetCurrentMapAreaID();
	local level = GetCurrentMapDungeonLevel();

	if (MetaMap_FullScreenMode) then
		WorldMapFrame:SetScript("OnKeyDown", nil);
		WorldMapFrame:SetScript("OnKeyUp", nil);
		UIPanelWindows["WorldMapFrame"] = { area = "center", pushable = 9 };
		BlackoutWorld:Hide();
		MetaMap_FullScreenMode = false;
		if (WorldMapFrame:IsVisible()) then
			CloseAllWindows();
			ShowUIPanel(WorldMapFrame);
		end
		MetaMapOptions_Init();
		WorldMapFrameSizeDownButton:Hide();
		WorldMapFrameSizeUpButton:Show();
	else
		WorldMapFrame:SetScale(1.0);
		WorldMapFrame:SetScript("OnKeyDown", MetaMap_WorldMapFrame_OnKeyDown_old);
		WorldMapFrame:SetScript("OnKeyUp", function(self, key)
			local binding = GetBindingFromClick(key);
			if (binding == "METAMAP_FSTOGGLE" or binding == "METAMAP_SAVESET") then
				RunBinding("METAMAP_FSTOGGLE");
			end
		end);
		UIPanelWindows["WorldMapFrame"] = { area = "full", pushable = 0 };
		BlackoutWorld:Show();
		MetaMap_FullScreenMode = true;
		if (WorldMapFrame:IsVisible()) then
			CloseAllWindows();
			ShowUIPanel(WorldMapFrame);
		end
		WorldMapFrameSizeDownButton:Show();
		WorldMapFrameSizeUpButton:Hide();
	end

	local _, _, _, isMicroDungeon = GetMapInfo();
	if ( not isMicroDungeon ) then SetMapByID(mapid); end
	if (MetaMapShown) then MetaMap_ShowInstance(self, true); end
	if ( (level ~= 0) and not isMicroDungeon ) then SetDungeonMapLevel(level); end
end

function MetaMap_ShowInstance(self, show, basemap)
	MetaMap_Debug_Print("MetaMap_ShowInstance", true);
	--MetaMap_Debug_Print("ShowInstance-start:"..MetaMapOptions.MetaMapZone.." "..tostring(MetaMapOptions.MetaMapLevel), true);
	local _, _, zType = MetaMap_GetZoneTableEntry(MetaMapOptions.MetaMapZone);

	MetaMapOptions.ShowDNI = show;

	local _, _, _, isMicroDungeon = GetMapInfo();
	if (basemap or not WorldMapFrame:IsVisible()) then
		if (show and (zType == "RDI" or zType == "DNI" or zType == "BG" or zType == "SCN")) then
			UIDropDownMenu_ClearAll(MetaMap_ZoneMenu);
			UIDropDownMenu_SetText(MetaMap_InstanceMenu, MetaMapOptions.MetaMapZone);
		else
			UIDropDownMenu_ClearAll(MetaMap_InstanceMenu);
			if (MetaMapOptions.MetaMapZone) then
				UIDropDownMenu_SetText(MetaMap_ZoneMenu, MetaMapOptions.MetaMapZone);
			end
			if ( isMicroDungeon ) then
				MetaMapOptions.MetaMapLevel = GetCurrentMapDungeonLevel();
			else
				MetaMapOptions.MetaMapZone = nil;
				MetaMapOptions.MetaMapLevel = 0;
			end
		end
		return;
	end

	if (show and (zType == "DNI" or zType == "BG" or zType == "SCN" or zType == "RDI")) then

		ShowUIPanel(WorldMapDetailFrame);
		ShowUIPanel(WorldMapButton);
		WorldMapPlayerLower:Show()
		WorldMapPlayerUpper:Show()

		-- set the map only if different to the shown map to prevent endless loop
		local _, instance = MetaMap_NameToZoneID(MetaMapOptions.MetaMapZone);
		local location = GetCurrentMapAreaID();
		if (instance ~= location) then SetMapByID(instance); end
		local level = MetaMapOptions.MetaMapLevel;
		location = GetCurrentMapDungeonLevel();
		if (level ~= 0 and level ~= location) then SetDungeonMapLevel(MetaMapOptions.MetaMapLevel); end

		--MetaMap_Debug_Print("ResetingShowObj",true);
 		--WorldMapFrame_AdjustMapAndQuestList();

		if (WorldMapQuestShowObjectives:GetChecked() and WorldMapFrame_UpdateQuests() > 0) then
			WorldMapFrame_SetQuestMapView();
		end
		WorldMapQuestShowObjectives:Show();

		UIDropDownMenu_ClearAll(MetaMap_ZoneMenu);
		UIDropDownMenu_SetText(MetaMap_InstanceMenu, MetaMapOptions.MetaMapZone);
		--UIDropDownMenu_ClearAll(WorldMapContinentDropDown);
		--UIDropDownMenu_ClearAll(WorldMapZoneDropDown);
	else
		if (not show) then

			ShowUIPanel(WorldMapDetailFrame);
			ShowUIPanel(WorldMapButton);
			WorldMapPlayerLower:Show();
			WorldMapPlayerUpper:Show();

			WorldMapQuestShowObjectives_Toggle();
			if (WorldMapQuestShowObjectives:GetChecked() and WorldMapFrame_UpdateQuests() > 0) then
				WorldMapFrame_SetQuestMapView();
			end
			WorldMapQuestShowObjectives:Show();

			UIDropDownMenu_ClearAll(MetaMap_InstanceMenu);
			if (MetaMapOptions.MetaMapZone) then
				UIDropDownMenu_SetText(MetaMap_ZoneMenu, MetaMapOptions.MetaMapZone);
			end
			if ( isMicroDungeon ) then
				MetaMapOptions.MetaMapLevel = GetCurrentMapDungeonLevel();
			else
				MetaMapOptions.MetaMapZone = nil;
				MetaMapOptions.MetaMapLevel = 0;
			end
		end
		if (self) then MetaMap_OnEvent(self, "INSTANCE_MAP_UPDATE"); end
	end
end

function MetaMap_MiniCoordsUpdate()
	if (WorldMapFrame:IsVisible()) then return; end

	local px, py = GetPlayerMapPosition("player");
	if (px == 0 and py == 0) then
		local _, _, zType = MetaMap_GetZoneTableEntry(MetaMap_GetRealZoneText());
		if (zType == "DN") then
			MetaMapMiniCoords:SetText(METAMAP_INSTANCE);
		else
			MetaMapMiniCoords:SetText("Dead Zone");
		end
	else
		MetaMapMiniCoords:SetText(format("%d, %d", px * 100, py * 100));
	end
end

-- Sets coords at the bottom of the map
function MetaMap_MainCoordsUpdate()
	--local OFFSET_X = 0.0022;
	--local OFFSET_Y = -0.0262;
	--local centerX, centerY = WorldMapFrame:GetCenter();
	--local width = WorldMapButton:GetWidth();
	--local height = WorldMapButton:GetHeight();
	--local x, y = GetCursorPosition();
	--x = x / WorldMapFrame:GetEffectiveScale();
	--y = y / WorldMapFrame:GetEffectiveScale();

	local OFFSET_X = 0;
	local OFFSET_Y = 0;
	local centerX, centerY = WorldMapButton:GetCenter()
	local width = WorldMapButton:GetWidth()
	local height = WorldMapButton:GetHeight()
	local x, y = GetCursorPosition()
	x = x / WorldMapButton:GetEffectiveScale()
	y = y / WorldMapButton:GetEffectiveScale()

	if (centerX == nil) then
		centerX = 0;
	end
	if (centerY == nil) then
		centerY = 0;
	end

	local adjustedX = (x - (centerX - width/2)) / width
	local adjustedY = (centerY + height/2 - y) / height
	x = 100 * (adjustedX + OFFSET_X);
	y = 100 * (adjustedY + OFFSET_Y);

	--MetaMap_Debug_Print("MainCoordsUpdate"..format("%d, %d", x, y),true);

	if (x < 0 or y < 0 or x > 100 or y > 100) then
		MetaMapCoordsCursor:SetText("");
	else
		MetaMapCoordsCursor:SetText("|cffffffff"..format("%d, %d", x, y));
	end

	local px, py = GetPlayerMapPosition("player");
	if (px == 0 and py == 0) then
		local _, _, zType = MetaMap_GetZoneTableEntry(MetaMap_GetRealZoneText());
		local continent, zone = MetaMap_NameToZoneID(MetaMap_GetRealZoneText());
		if (zType == "DN") then
			MetaMapCoordsPlayer:SetText(METAMAP_INSTANCE_1);
		elseif (GetCurrentMapContinent() ~= continent or GetCurrentMapZone() ~= zone) then
			MetaMapCoordsPlayer:SetText("");
		else
			MetaMapCoordsPlayer:SetText("|cff00ff00Dead Zone");
		end
	else
		MetaMapCoordsPlayer:SetText("|cff00ff00"..format("%d, %d", px * 100, py * 100));
	end
	MetaMapCoordsPlayer:Show();
	MetaMapCoordsCursor:Show();
end

function MetaMap_UpdateAlpha()
	if (MetaMapOptions.SaveSet == 1) then
		MetaMapOptions.MetaMapAlpha1 = MetaMapAlphaSlider:GetValue();
		WorldMapFrame:SetAlpha(MetaMapOptions.MetaMapAlpha1);
	else
		MetaMapOptions.MetaMapAlpha2 = MetaMapAlphaSlider:GetValue();
		WorldMapFrame:SetAlpha(MetaMapOptions.MetaMapAlpha2);
	end
	MetaMap_MainCoords:SetAlpha(MetaMapAlphaSlider:GetValue() + 0.2);
	WorldMapButton:SetAlpha(MetaMapAlphaSlider:GetValue() + 0.2);
end

function MetaMap_UpdateScale()
	MetaMap_Debug_Print("MetaMap_UpdateScale", true);
	if ( InCombatLockdown() ) then return; end
	if (not MetaMap_FullScreenMode) then
		MetaMap_Debug_Print("MetaMap_UpdateScale-NoFullScreen", true);
		if (MetaMapOptions.SaveSet == 1) then
			MetaMapOptions.MetaMapScale1 = MetaMapScaleSlider:GetValue();
			if (MetaMapOptions.MetaMapScale1 == 0) then MetaMapOptions.MetaMapScale1 = 0.5; end
			MetaMap_SetEffectiveScale(WorldMapFrame, MetaMapOptions.MetaMapScale1);
		else
			MetaMapOptions.MetaMapScale2 = MetaMapScaleSlider:GetValue();
			if (MetaMapOptions.MetaMapScale2 == 0) then MetaMapOptions.MetaMapScale2 = 0.5; end
			MetaMap_SetEffectiveScale(WorldMapFrame, MetaMapOptions.MetaMapScale2);
		end

		WorldMapFrame:SetWidth(WorldMapPositioningGuide:GetWidth());
		WorldMapFrame:SetHeight(WorldMapPositioningGuide:GetHeight());

		MetaMapTopFrame:SetWidth(WorldMapButton:GetWidth());
		MetaMapTopFrame:SetHeight(WorldMapButton:GetHeight());

		WorldMapFrame_UpdateQuests();
		--WorldMapFrame_SetPOIMaxBounds();
		WorldMapQuestShowObjectives_AdjustPosition();

		MetaMap_SetPointerSize();
	end
end

function MetaMap_SetPointerSize()
	if (WorldMapQuestScrollFrame:IsVisible()) then
		--WorldMapPlayerLower:SetModelScale(.75);
		--WorldMapPlayerUpperWorldMapPlayerUpper:SetModelScale(.75);
	else
		--WorldMapPlayerLower:SetModelScale(1.0);
		--WorldMapPlayerUpper:SetModelScale(1.0);
	end
end

function MetaMap_UpdateTTScale()
	if (MetaMapOptions.SaveSet == 1) then
		MetaMapOptions.MetaMapTTScale1 = MetaMapTTScaleSlider:GetValue();
		WorldMapTooltip:SetScale(MetaMapOptions.MetaMapTTScale1);
	else
		MetaMapOptions.MetaMapTTScale2 = MetaMapTTScaleSlider:GetValue();
		WorldMapTooltip:SetScale(MetaMapOptions.MetaMapTTScale2);
	end
end

function MetaMap_InstanceMenu_Initialize(self)
	MetaMap_Debug_Print("MetaMap_InstanceMenu_Initialize:"..UIDROPDOWNMENU_MENU_LEVEL,true);

	if (UIDROPDOWNMENU_MENU_LEVEL == 1) then
		MetaMap_InstanceMenu_level1(700, METAMAP_INSTANCE_MENU_DUNGEONS);
		MetaMap_InstanceMenu_level1(600, METAMAP_INSTANCE_MENU_RAIDS);
		MetaMap_InstanceMenu_level1(800, METAMAP_INSTANCE_MENU_SCENARIOS);
		MetaMap_InstanceMenu_level1(999, METAMAP_BATTLEGROUNDS);

	elseif (UIDROPDOWNMENU_MENU_LEVEL == 2) then
		local menuVal = MetaMap_SubMenuFix(self);
		if (menuVal ~= nil) then
			MetaMap_Debug_Print("MetaMap_SubMenuFix:"..UIDROPDOWNMENU_MENU_LEVEL.."="..menuVal,true);
		else
			MetaMap_Debug_Print("MetaMap_SubMenuFix menuVal was nil", true);
		end

		if ( menuVal == 600 or menuVal == 700 or menuVal == 800 or menuVal == 999 ) then
			MetaMap_InstanceMenu_level2(menuVal);
		end

	elseif (UIDROPDOWNMENU_MENU_LEVEL == 3) then
		local menuVal = MetaMap_SubMenuFix(self);
		if (menuVal ~= nil) then
			MetaMap_Debug_Print("MetaMap_SubMenuFix:"..UIDROPDOWNMENU_MENU_LEVEL.."="..menuVal,true);
		else
			MetaMap_Debug_Print("MetaMap_SubMenuFix menuVal was nil", true);
		end

		if (menuVal >= 800 and menuVal <= 810) then
			MetaMap_InstanceMenu_level3("SCN", 800, menuVal);
		elseif (menuVal >= 700 and menuVal <= 710) then
			MetaMap_InstanceMenu_level3("DNI", 700, menuVal);
		elseif (menuVal >= 600 and menuVal <= 610) then
			MetaMap_InstanceMenu_level3("RDI", 600, menuVal);
		end 
	end
end

function MetaMap_InstanceMenu_level1(menuVal, text)
	local info = {};
	info.text = text;
	info.textHeight = MetaMapOptions.MenuFont;
	info.hasArrow = 1;
	info.notCheckable = 1;
	info.value = menuVal;
	info.notClickable = false;
	UIDropDownMenu_AddButton(info);
end

function MetaMap_InstanceMenu_level2(menuVal)
	if (menuVal == 999) then
		MetaMap_InstanceMenu_level3("BG", 900, menuVal);
		return;
	end 

	for index, cName in pairs(MetaMap_Continents) do
		if (index > 0) then
			local info = {};
			info.text = cName;
			info.textHeight = MetaMapOptions.MenuFont;
			info.hasArrow = 1;
			info.notCheckable = 1;
			info.value = menuVal + index;
			info.disabled = false;
			info.notClickable = false;
			info.isTitle = false;
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
		end
	end
end

function MetaMap_InstanceMenu_level3(ztype, basemenuval, menuVal)
	local menuList = {};
	for index, zoneTable in pairs(MetaMap_ZoneTable) do
		if ( zoneTable.ztype == ztype ) then
			if ( (zoneTable.Continent == (menuVal - basemenuval)) or (menuVal == 999) ) then
				local name = MetaMap_MergeZoneName(zoneTable);
				table.insert(menuList, {location = name});
			end
		end
	end

	local sort = MetaMap_sortType;
	MetaMap_sortType = METAMAP_SORTBY_LOCATION;
	table.sort(menuList, MetaMap_SortCriteria);
	MetaMap_sortType = sort;
	for zKey, zName in pairs(menuList) do
		local info = {};
		info.text = zName.location;
		info.textHeight = MetaMapOptions.MenuFont;
		info.checked = nil;
		info.notCheckable = 1;
		info.value = zName.location;
		info.func = MetaMap_InstanceMenu_OnClick;
		info.disabled = false;
		info.notClickable = false;
		info.isTitle = false;
		UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
	end
end

function MetaMap_InstanceMenu_OnClick(self)
	MetaMapOptions.MetaMapZone = self.value;
	MetaMapOptions.MetaMapLevel = 0;
	MetaMap_ShowInstance(self, true);

	MetaMap_SaveCurrentMapData();
end

function MetaMap_MainMenuSelect(parent, level)
	local x, y = 0, 0;
	if (parent) then
		MetaMap_MenuParent = parent;
		if (parent == "FuBarPluginMetaMapFrame") then y = -10; end
	else
		MetaMap_MenuParent = "cursor";
	end
	-- ### problematic with taintLog ###
	ToggleDropDownMenu(nil, nil, MetaMap_MainMenu, MetaMap_MenuParent, x, y);
end

function MetaMap_MainMenu_Initialize(self)
	if (UIDROPDOWNMENU_MENU_LEVEL == 2) then
		local _, menuText = MetaMap_SubMenuFix(self);
		
		if (menuText == METAMAP_MENU_FILTER) then
			local menuFrame = _G["DropDownList"..2];
			local menuName = menuFrame:GetName();
			local cText;
			for i = 0, 9, 1 do
				if (MetaMap_NoteFilter[i]) then
					cText = METAMAP_MAP_ICON_ON;
				else
					cText = METAMAP_MAP_ICON_OFF;
				end
				local info = {
					checked = nil,
					notCheckable = 1,
					keepShownOnClick = 1,
					text = cText,
					textHeight = MetaMapOptions.MenuFont,
					icon = METAMAP_ICON_PATH.."Icon"..i,
					value = {mode = 2, func = "MetaMap_FilterNotes", cText = cText, args = i},
					func = MetaMap_MainMenu_OnClick;
				};
				UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			end
			local info = {
				checked = nil,
				notCheckable = 1,
				keepShownOnClick = 1,
				text = METAMAP_MENU_FILTER1,
				textHeight = MetaMapOptions.MenuFont,
				value = {mode = 2, func = "MetaMap_FilterNotes", args = 11},
				func = MetaMap_MainMenu_OnClick;
			};
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			local info = {
				checked = nil,
				notCheckable = 1,
				keepShownOnClick = 1,
				text = METAMAP_MENU_FILTER2,
				textHeight = MetaMapOptions.MenuFont,
				value = {mode = 2, func = "MetaMap_FilterNotes", args = 12},
				func = MetaMap_MainMenu_OnClick;
			};
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
		elseif (menuText == METAMAP_MENU_TRKFILTER) then
			local cText = METAMAP_MENU_OFF.."   ";
			if (TRK_Options.FilterHerb) then cText = METAMAP_MENU_ON.."   "; end
			local info = {
				checked = nil,
				notCheckable = 1,
				keepShownOnClick = 1,
				text = cText..TRK_FILTER_HERB,
				textHeight = MetaMapOptions.MenuFont,
				value = "FilterHerb",
				func = TRK_MetaMapMenuOnClick;
			};
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			cText = METAMAP_MENU_OFF.."   ";
			if (TRK_Options.FilterOre) then cText = METAMAP_MENU_ON.."   "; end
			local info = {
				checked = nil,
				notCheckable = 1,
				keepShownOnClick = 1,
				text = cText..TRK_FILTER_ORE,
				textHeight = MetaMapOptions.MenuFont,
				value = "FilterOre",
				func = TRK_MetaMapMenuOnClick;
			};
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			cText = METAMAP_MENU_OFF.."   ";
			if (TRK_Options.FilterTreasure) then cText = METAMAP_MENU_ON.."   "; end
			local info = {
				checked = nil,
				notCheckable = 1,
				keepShownOnClick = 1,
				text = cText..TRK_FILTER_TREASURE,
				textHeight = MetaMapOptions.MenuFont,
				value = "FilterTreasure",
				func = TRK_MetaMapMenuOnClick;
			};
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			cText = METAMAP_MENU_OFF.."   ";
			if (TRK_Options.FilterMisc) then cText = METAMAP_MENU_ON.."   "; end
			local info = {
				checked = nil,
				notCheckable = 1,
				keepShownOnClick = 1,
				text = cText..TRK_FILTER_MISC,
				textHeight = MetaMapOptions.MenuFont,
				value = "FilterMisc",
				func = TRK_MetaMapMenuOnClick;
			};
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
		end
	else
		local info = {
			notCheckable = 1,
			isTitle = 1,
			text = METAMAP_NAME.."\n\n",
			textHeight = MetaMapOptions.MenuFont + 1;
		}
		UIDropDownMenu_AddButton(info);
		for index, value in ipairs(MetaMap_MainMenuData) do
			local toggle = "";
			local showitem = true;
			local cText = value.text;
			if (cText == METAMAP_MENU_TRKFILTER and not IsAddOnLoaded("MetaMapTRK")) then showitem = false; end
			if (cText == METAMAP_MENU_FLIGHT and not IsAddOnLoaded("FlightMap")) then showitem = false; end
			if (cText == METAMAP_MENU_ACTION and MetaMap_CurrentAction) then
				cText = METAMAP_MENU_ON.."    "..value.text;
			elseif (cText == METAMAP_MENU_ACTION and not MetaMap_CurrentAction) then
				cText = METAMAP_MENU_OFF.."    "..value.text;
			elseif (cText == METAMAP_MENU_FWMMOD and FWM_ShowUnexplored) then
				cText = METAMAP_MENU_ON.."    "..value.text;
			elseif (cText == METAMAP_MENU_FWMMOD and not FWM_ShowUnexplored) then
				cText = METAMAP_MENU_OFF.."    "..value.text;
			elseif (cText == METAMAP_MENU_TRKSET) then
				if ( MetaMap_Tracker ) then
					cText = METAMAP_MENU_ON.."    "..value.text;
				else
					cText = METAMAP_MENU_OFF.."    "..value.text;
				end
			elseif (cText == METAMAP_MENU_MAPSET) then
				cText = "|cff00FFFF  "..MetaMap_CurrentSaveSet.."|r     "..value.text;
			elseif (value.mode == 1 and MetaMapOptions[value.opt]) then
				cText = METAMAP_MENU_ON.."    "..value.text;
			elseif (value.mode == 1 and not MetaMapOptions[value.opt]) then
				cText = METAMAP_MENU_OFF.."   "..value.text;
			end
			if (showitem) then
				local info = {
					keepShownOnClick = value.ksoc,
					checked = nil,
					notCheckable = 1,
					hasArrow = value.ha,
					notClickable = value.nc,
					text = cText,
					textHeight = MetaMapOptions.MenuFont,
					value = {mode = value.mode, func = value.opt, args = ""},
					func = MetaMap_MainMenu_OnClick;
				}
				UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			end
		end
	end
end

function MetaMap_MainMenu_OnClick(self)
	if (not self.value.mode) then return; end
	local button;
	if (self.value.mode == 1) then
		MetaMap_ToggleOptions(self.value.func);
	else
		RunScript(self.value.func.."("..self.value.args..")");
	end
	local txt = self:GetText();
	if (string.find(txt, METAMAP_MENU_ON)) then
		txt = string.gsub(txt, METAMAP_MENU_ON, METAMAP_MENU_OFF);
	elseif (string.find(txt, METAMAP_MENU_OFF)) then
		txt = string.gsub(txt, METAMAP_MENU_OFF, METAMAP_MENU_ON);
	elseif (string.find(txt, "1")) then
		txt = string.gsub(txt, "1", "2");
		button = _G[self:GetParent():GetName().."Button"..self:GetID() - 1];
	elseif (string.find(txt, "2")) then
		txt = string.gsub(txt, "2", "1");
		button = _G[self:GetParent():GetName().."Button"..self:GetID() - 1];
	end
	if (button and MetaMap_CurrentAction) then
		button:SetText(METAMAP_MENU_ON.."    "..METAMAP_MENU_ACTION);
	elseif (button and not MetaMap_CurrentAction) then
		button:SetText(METAMAP_MENU_OFF.."    "..METAMAP_MENU_ACTION);
	end
	self:SetText(txt);
	self.checked = not self.checked;
end

function MetaMap_FilterNotes(args)
	if (args == 11) then
		for i = 0, 9, 1 do
			local index = i +1;
			local button = _G["DropDownList2Button"..index];
			button:SetText(string.gsub(button:GetText(), METAMAP_MENU_OFF, METAMAP_MENU_ON));
			MetaMap_NoteFilter[i] = true;
		end
	elseif (args == 12) then
		for i = 0, 9, 1 do
			local index = i +1;
			local button = _G["DropDownList2Button"..index];
			button:SetText(string.gsub(button:GetText(), METAMAP_MENU_ON, METAMAP_MENU_OFF));
			MetaMap_NoteFilter[i] = false;
		end
	else
		MetaMap_NoteFilter[args] = not MetaMap_NoteFilter[args];
	end
	MetaMap_MainMapUpdate();
end

function MetaMap_ZoneCheckMenu_Initialize(self)
	if (UIDROPDOWNMENU_MENU_LEVEL == 1) then
		for index, cName in pairs(MetaMap_Continents) do
			if (index > 0) then
				local info = {
					text = cName,
					textHeight = MetaMapOptions.MenuFont,
					value = index,
					hasArrow = 1,
					checked = nil,
					notCheckable = 1;
				}
				UIDropDownMenu_AddButton(info);
			end
		end
		local info = {
			text = METAMAP_BATTLEGROUNDS,
			textHeight = MetaMapOptions.MenuFont,
			value = "BG",
			hasArrow = 1,
			checked = nil,
			notCheckable = 1;
		}
		UIDropDownMenu_AddButton(info);
		local info = {
			text = METAMAP_INSTANCE_MENU_DUNGEONS,
			textHeight = MetaMapOptions.MenuFont,
			value = "DNI",
			hasArrow = 1,
			checked = nil,
			notCheckable = 1;
		}
		UIDropDownMenu_AddButton(info);
		local info = {
			text = METAMAP_INSTANCE_MENU_RAIDS,
			textHeight = MetaMapOptions.MenuFont,
			value = "RDI",
			hasArrow = 1,
			checked = nil,
			notCheckable = 1;
		}
		UIDropDownMenu_AddButton(info);
		local info = {
			text = METAMAP_INSTANCE_MENU_SCENARIOS,
			textHeight = MetaMapOptions.MenuFont,
			value = "SCN",
			hasArrow = 1,
			checked = nil,
			notCheckable = 1;
		}
		UIDropDownMenu_AddButton(info);
		local info = {
			checked = nil,
			notCheckable = 1,
			text = METAMAP_ZONE_DELETE,
			textHeight = MetaMapOptions.MenuFont,
			value = METAMAP_ZONE_DELETE,
			func = MetaMap_ZoneCheckMenu_OnClick;
		}
		UIDropDownMenu_AddButton(info);
	end
	if (UIDROPDOWNMENU_MENU_LEVEL == 2) then
		local menuVal = MetaMap_SubMenuFix(self);
		if (menuVal == "BG") then
			for index, value in pairs(MetaMap_ZoneTable) do
				if (value.ztype == "BG") then
					local info = {
						checked = nil,
						notCheckable = 1,
						text = value[MetaMap_Locale],
						textHeight = MetaMapOptions.MenuFont,
						value = value[MetaMap_Locale],
						func = MetaMap_ZoneCheckMenu_OnClick;
					};
					UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
				end
			end
		elseif (menuVal == "DNI" or menuVal == "RDI" or menuVal == "SCN") then
			local idx;
			if ( menuVal == "RDI" ) then idx = 600; end
			if ( menuVal == "DNI" ) then idx = 700; end
			if ( menuVal == "SCN" ) then idx = 800; end
			for index, cName in pairs(MetaMap_Continents) do
				if (index > 0) then
					local info = {
						text = cName,
						textHeight = MetaMapOptions.MenuFont,
						value = idx + index,
						hasArrow = 1,
						checked = nil,
						notCheckable = 1,
					}
					UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
				end
			end
		else
			for zKey, zName in ipairs{GetMapZones(menuVal)} do
				local name = MetaMap_ZoneIDToName(menuVal, zKey);
				local info = {
					checked = nil,
					notCheckable = 1,
					text = name,
					textHeight = MetaMapOptions.MenuFont,
					value = name,
					func = MetaMap_ZoneCheckMenu_OnClick;
				};
				UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			end
		end
	end
	if (UIDROPDOWNMENU_MENU_LEVEL == 3) then
		local menuVal = MetaMap_SubMenuFix(self);
		local ztype;
		if     ( menuVal > 800 ) then ztype = "SCN"; menuVal = menuVal - 800;
		elseif ( menuVal > 700 ) then ztype = "DNI"; menuVal = menuVal - 700;
		elseif ( menuVal > 600 ) then ztype = "RDI"; menuVal = menuVal - 600; end
		local menuList = {};
		for index, zoneTable in pairs(MetaMap_ZoneTable) do
			if ( (zoneTable.ztype == ztype) and (zoneTable.Continent == menuVal) ) then
				local name = MetaMap_MergeZoneName(zoneTable);
				table.insert(menuList, {location = name});
			end
		end
		local sort = MetaMap_sortType;
		MetaMap_sortType = METAMAP_SORTBY_LOCATION;
		table.sort(menuList, MetaMap_SortCriteria);
		MetaMap_sortType = sort;
		for zKey, zName in pairs(menuList) do
			local info = {
				checked = nil,
				notCheckable = 1,
				text = zName.location,
				textHeight = MetaMapOptions.MenuFont,
				value = zName.location,
				func = MetaMap_ZoneCheckMenu_OnClick;
			};
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
		end
		menuList = nil;
	end
end

function MetaMap_ZoneCheckMenu_OnClick(self)
	UIDropDownMenu_SetText(MetaMap_ZoneCheckMenu, self.value);
	MetaMap_ZoneCheckButton:Enable();
end

function MetaMap_ToggleDialog(tab)
	local subFrame = _G[tab];
	MetaMap_OptionsInfo:SetText("");
	MetaMap_GeneralDialog:Hide();
	MetaMap_NotesDialog:Hide();
	MetaMap_ModulesDialog:Hide();
	MetaMap_ImportDialog:Hide();
	MetaMap_ZoneShiftDialog:Hide();
	MetaMap_HelpDialog:Hide();
	if (BKP_BackUpFrame) then BKP_BackUpFrame:Hide(); end
	if (EXP_ExportFrame) then EXP_ExportFrame:Hide(); end
	if (CVT_ImportFrame) then CVT_ImportFrame:Hide(); end
	if (subFrame) then
		if (MetaMap_DialogFrame:IsVisible()) then
			PlaySound("igCharacterInfoTab");
			_G[tab]:Show();
		else
			ShowUIPanel(MetaMap_DialogFrame);
			_G[tab]:Show();
		end
	end
end

function MetaMap_OptionsTab_OnClick(self)
	if (self:GetName() == "MetaMap_DialogFrameTab1") then
		MetaMap_ToggleDialog("MetaMap_GeneralDialog");
	elseif (self:GetName() == "MetaMap_DialogFrameTab2") then
		MetaMap_ToggleDialog("MetaMap_NotesDialog");
	elseif (self:GetName() == "MetaMap_DialogFrameTab3") then
		MetaMap_ToggleDialog("MetaMap_ModulesDialog");
	elseif (self:GetName() == "MetaMap_DialogFrameTab4") then
		MetaMap_ToggleDialog("MetaMap_ImportDialog");
	elseif (self:GetName() == "MetaMap_DialogFrameTab5") then
		MetaMap_ToggleDialog("MetaMap_ZoneShiftDialog");
	elseif (self:GetName() == "MetaMap_DialogFrameTab6") then
		MetaMap_ToggleDialog("MetaMap_HelpDialog");
	end
	PlaySound("igCharacterInfoTab");
end

function MetaMapExtOptions_Toggle()
	if (MetaMap_DialogFrame:IsVisible()) then
		HideUIPanel(MetaMap_DialogFrame);
	else
		if (MetaMap_FullScreenMode) then
			MetaMap_DialogFrame:SetParent("WorldMapFrame");
		else
			MetaMap_DialogFrame:SetParent("UIParent");
			MetaMap_DialogFrame:SetFrameStrata("FULLSCREEN");
		end
		ShowUIPanel(MetaMap_DialogFrame);
	end
end

function MetaMapSaveSet_Toggle()
	MetaMap_ShowObjectives_OnClick();

	if (MetaMapOptions.SaveSet == 1) then
		MetaMapOptions.SaveSet = 2;
	else
		MetaMapOptions.SaveSet = 1;
	end

	MetaMap_ModeToggleButton:SetText(MetaMapOptions.SaveSet);

	MetaMapOptions_Init();
end

function MetaMap_MapModeToggle(mode)
	MetaMapOptions.SaveSet = mode;
	MetaMap_ToggleFrame(WorldMapFrame);
end

function MetaMap_ActionToggle()
	MetaMap_ToggleOptions("ActionMode"..MetaMapOptions.SaveSet);
end

function MetaMapOptions_Init()
	MetaMap_Debug_Print("MetaMapOptions_Init",true);
	if (MetaMapOptions.SaveSet == 1) then
		if (MetaMapOptions.MetaMapAlpha1 < 0.15) then MetaMapOptions.MetaMapAlpha1 = 0.15; end
		MetaMapScaleSlider:SetValue(MetaMapOptions.MetaMapScale1);
		
		MetaMapAlphaSlider:SetValue(MetaMapOptions.MetaMapAlpha1);
		MetaMapTTScaleSlider:SetValue(MetaMapOptions.MetaMapTTScale1);
		MetaMap_CurrentAction = MetaMapOptions.ActionMode1;
		--MetaMap_Debug_Print("MetaMapOptions_Init:"..MetaMapOptions.ShowObj1,true);
		WorldMapQuestShowObjectives:SetChecked(MetaMapOptions.ShowObj1); 
		
	else
		if (MetaMapOptions.MetaMapAlpha2 < 0.15) then MetaMapOptions.MetaMapAlpha2 = 0.15; end
		MetaMapScaleSlider:SetValue(MetaMapOptions.MetaMapScale2);
	
		MetaMapAlphaSlider:SetValue(MetaMapOptions.MetaMapAlpha2);
		MetaMapTTScaleSlider:SetValue(MetaMapOptions.MetaMapTTScale2);
		MetaMap_CurrentAction = MetaMapOptions.ActionMode2;
		WorldMapQuestShowObjectives:SetChecked(MetaMapOptions.ShowObj2); 
	end

	SetCVar("questPOI", WorldMapQuestShowObjectives:GetChecked());
	-- ### problematic with taintLog ###
	WorldMapQuestShowObjectives_Toggle();
	-- * this should not be the case ********************************
	if ( WORLDMAP_SETTINGS.size == WORLDMAP_WINDOWED_SIZE ) then -- *
		WatchFrame_GetCurrentMapQuests();                    -- *
		WatchFrame_Update();                                 -- *
	end                                                          -- *
	-- **************************************************************
	WorldMapFrame_DisplayQuests();

	if (MetaMap_CurrentAction) then
		WorldMapButton:EnableMouse(false);
		MetaMapTopFrame:EnableMouse(false);
		
	else
		WorldMapButton:EnableMouse(true);
		MetaMapTopFrame:EnableMouse(true);
		
	end
	if (MetaMapOptions.MetaMapButtonShown) then
		MetaMapButton_UpdatePosition();
		MetaMapButton:Show();
	else
		MetaMapButton:Hide();
	end
	if (MetaMapOptions.MetaMapCoords) then
		MetaMap_MainCoords:Show();
	else
		MetaMap_MainCoords:Hide();
	end
	if (MetaMapOptions.MetaMapMiniCoords) then
		MetaMap_MiniCoords:Show();
	else
		MetaMap_MiniCoords:Hide();
	end
	if (MetaMapOptions.ShowMapList) then
		MetaMapList_Init();
	else
		MetaMap_MapListFrame:Hide();
	end
	MetaMap_UpdateAlpha();
	MetaMap_UpdateScale();
	MetaMap_UpdateTTScale();

	MetaMapContainerFrame:SetBackdropColor(0,0,0,MetaMapOptions.ContainerAlpha);
	MetaMap_MapListFrame:SetBackdropColor(0,0,0,MetaMapOptions.ContainerAlpha);
	MetaMap_CurrentSaveSet = MetaMapOptions.SaveSet;
	MetaMapButtonSlider:SetValue(MetaMapOptions.MetaMapButtonPosition);
	MetaMapMiniCoords:SetTextColor(MetaMap_Colors[MetaMapOptions.MiniColor].r, MetaMap_Colors[MetaMapOptions.MiniColor].g, MetaMap_Colors[MetaMapOptions.MiniColor].b);

	MetaMap_MapModeText:SetText(METAMAP_MENU_MAPSET.." "..MetaMapOptions.SaveSet);
end

function MetaMapButton_UpdatePosition()
	if (MetaMapOptions.MetaMapButtonPosition_Old ~= MetaMapOptions.MetaMapButtonPosition or not MetaMapOptions.MetaMapButtonPositionXY) then
		MetaMapButton:ClearAllPoints();
		MetaMapButton:SetPoint("TOPLEFT", "Minimap", "TOPLEFT",
			52 - (80 * cos(MetaMapOptions.MetaMapButtonPosition)),
			(80 * sin(MetaMapOptions.MetaMapButtonPosition)) - 52
		);
		MetaMapOptions.MetaMapButtonPositionXY = nil;
		MetaMapOptions.MetaMapButtonPosition_Old = MetaMapOptions.MetaMapButtonPosition;
	end
end

--function MMTest()
--	local cx, cy = GetCursorPosition();
--	local cz = UIParent:GetEffectiveScale();
--	MetaMapOptions.MetaMapButtonPositionX = cx;
--	MetaMapOptions.MetaMapButtonPositionY = cy;
--	MetaMapButton_UpdatePosition();
--end

function MetaMap_ButtonTooltip()
	GameTooltip_SetDefaultAnchor(GameTooltip, UIParent);
	GameTooltip:SetText(METAMAP_TITLE, 0, 1, 0);
	GameTooltip:AddLine(METAMAP_BUTTON_TOOLTIP1, 1, 1, 1);
	if (MetaMapOptions.MenuMode) then
		GameTooltip:AddLine(METAMAP_BUTTON_TOOLTIP2, 1, 1, 1);
	end
	GameTooltip:Show();
end

function MetaMap_round(num, idp)
	local mult = 10^(idp or 0);
	return (math.floor(num * mult + 0.5) / mult);
end

function MetaMap_SetEffectiveScale(frame, scale)
	local parent = frame:GetParent();
	if (parent) then
		scale = scale / parent:GetEffectiveScale();
	end
	frame:SetScale(scale);
	return scale;
end

function MetaMap_MiniMapCoords_OnClick(button)
	if (IsShiftKeyDown()) then
		if (not ChatEdit_GetActiveWindow()) then ChatFrame_OpenChat(""); end
		local ChatFrameEditBox = ChatEdit_GetActiveWindow();
		if (not ChatFrameEditBox:IsVisible()) then ChatFrameEditBox:Show(); end
		local msg = METAMAP_MYLOCATION..MetaMap_GetRealZoneText().." ("..MetaMapMiniCoords:GetText()..")";
		ChatFrameEditBox:Insert(msg);
	elseif (IsControlKeyDown()) then
		if (MetaMapOptions.MiniColor == 9) then
			MetaMapOptions.MiniColor = 0;
		else
			MetaMapOptions.MiniColor = MetaMapOptions.MiniColor + 1;
		end
		local color = MetaMap_Colors[MetaMapOptions.MiniColor];
		MetaMapMiniCoords:SetTextColor(color.r, color.g, color.b);
	end
end

function MetaMap_MiniMapCoords_OnEnter(self)
	MetaMap_SetTTInfoLine(MetaMap_GetRealZoneText(), self, GameTooltip);
	GameTooltip:AddLine(METAMAP_INFOLINE_HINT5, 0.75, 0, 0.75, false);
	GameTooltip:AddLine(METAMAP_INFOLINE_HINT6, 0.75, 0, 0.75, false);
	GameTooltip:Show();
end

function MetaMap_ShowLocation(self, zoneName, zoneLevel, noteName, noteID)
	if (not zoneName) then return; end

	local _, _, zType = MetaMap_GetZoneTableEntry(zoneName);
	if ( zType == "MSZ" ) then return; end
	MetaMapContainer_ShowFrame();
	ShowUIPanel(WorldMapFrame);

	MetaMapOptions.MetaMapZone = zoneName;
	if (zoneLevel and type(zoneLevel) == "number") then
		MetaMapOptions.MetaMapLevel = zoneLevel;
	else
		MetaMapOptions.MetaMapLevel = 0;
	end
	if (zType == "RDI" or zType == "DNI" or zType == "BG" or zType == "SCN") then
		MetaMap_ShowInstance(self, true);
	else
		MetaMap_ShowInstance(self, false);
		SetMapZoom(MetaMap_NameToZoneID(zoneName));
	end

	MetaMap_SaveCurrentMapData();

	if (not noteName) then return; end

	local dataZone = MetaMap_Notes[zoneName];
	if (not noteID) then
		for index, value in ipairs(dataZone) do
			if (dataZone[index].name == noteName) then
				noteID = index;
				break;
			end
		end
	end
	if (noteID) then
		MetaMapPing_SetPing(dataZone, noteID);
	end
end

function MetaMapList_Init()
	if (not MetaMapOptions.ShowMapList) then return; end

	if (MetaMapOptions.SortList) then
		MetaMapList_Header:SetText(METAMAPLIST_UNSORTED);
	else
		MetaMapList_Header:SetText(METAMAPLIST_SORTED);
	end
	MetaMap_MapListFrame:Show();
	FauxScrollFrame_SetOffset(MetaMapList_ScrollFrame, MetaMap_ListOffset);
	MetaMapList_BuildList();
	if (not MetaMap_NoteList[1]) then
		MetaMap_MapListFrame:Hide();
		return;
	end
	MetaMapList_UpdateScroll();
end

-- This gets called from WorldMapFrame.lua when user left clicks on the map.
local MetaMap_ProcessMapClick_old = ProcessMapClick;
function ProcessMapClick(...)
	--MetaMap_Debug_Print("ProcessMapClick", true);

	local mapName, mapLevel, dataZone, isMicroDungeon = MetaMap_GetCurrentMapInfo();

	if (not MetaMap_FramesHidden()) then return; end

	if (BattlefieldMinimap and BattlefieldMinimap:IsVisible() ) then
		if (not MetaMap_CombatLockdown_BattlefiedMap) then
			MetaMap_Reshow_BattlefiedMap = time();
		end
		MetaMap_CombatLockdown_BattlefiedMap = nil;
		BattlefieldMinimap:Hide(); --BattlefieldMinimap screws up the map selection
	end

	if (mapName and MetaMap_Relocate.id) then
		if (not IsControlKeyDown() and not IsShiftKeyDown()) then
			MetaMap_MoveNote(MetaMap_Relocate.mapName, MetaMap_Relocate.id);
			MetaMap_Relocate = {};
			return;
		end
	end

	if (mapName) then 
		local _, _, ztype = MetaMap_GetZoneTableEntry(mapName);
		if (not ztype == "SZ") then
			MetaMap_Debug_Print("mapName: " .. tostring(mapName) , true);
			MetaMap_Debug_Print("dataZone: " .. tostring(dataZone) , true);
			MetaMap_Debug_Print("realZoneText: " .. tostring(MetaMap_GetRealZoneText()) , true);
			MetaMap_Debug_Print("MetaMapOptions.MetaMapZone:"..tostring(MetaMapOptions.MetaMapZone), true);
		end
	else
		MetaMap_Debug_Print("realZoneText: " .. tostring(MetaMap_GetRealZoneText()) , true);
	end

	if ( (IsControlKeyDown() or IsShiftKeyDown() or IsAltKeyDown()) and mapName and dataZone ) then
		if (mapName or MetaMapOptions.ShowDNI) then
			local centerX, centerY = WorldMapButton:GetCenter();
			local width = WorldMapButton:GetWidth();
			local height = WorldMapButton:GetHeight();
			local x, y = GetCursorPosition();
			x = x / WorldMapButton:GetEffectiveScale();
			y = y / WorldMapButton:GetEffectiveScale();

			if (centerX == nil) then
				centerX = 0;
			end
			if (centerY == nil) then
				centerY = 0;
			end

			local adjustedY = (centerY + height/2 - y) / height;
			local adjustedX = (x - (centerX - width/2)) / width;

			if (IsShiftKeyDown()) then
				MetaMap_SetPartyNote(adjustedX, adjustedY);
			elseif (IsControlKeyDown()) then
				local _, _, dataZone = MetaMap_GetCurrentMapInfo();
				if (dataZone) then MetaMap_EditNewNote(adjustedX, adjustedY); end
			elseif (IsAltKeyDown() and MetaMap_GetCurrentMapInfo() == MetaMap_GetRealZoneText()) then
				MetaMap_LoadBWP(0, 3);
				if (IsAddOnLoaded("MetaMapBWP")) then
					BWP_LocCommand(format("%d, %d", 100 * adjustedX, 100 * adjustedY));
				end
			end
		end
	else
		MetaMap_Debug_Print("--------click mark-------",true);
		MetaMap_ProcessMapClick_old(...);

		MetaMap_SaveCurrentMapData();

		-- set drop down menu text of zone menu to current map
		mapName = MetaMap_GetCurrentMapInfo();
		if (mapName) then
			local cKey, zKey = MetaMap_NameToZoneID(mapName);
			if ( (cKey == -1) and (type(zKey) == "number") and (zKey > 0) ) then
				UIDropDownMenu_ClearAll(MetaMap_ZoneMenu);
				UIDropDownMenu_SetText(MetaMap_InstanceMenu, MetaMapOptions.MetaMapZone);
			elseif ( cKey ~= -1 or (type(zKey) == "number" and zKey == 0) or isMicroDungeon ) then
				UIDropDownMenu_ClearAll(MetaMap_InstanceMenu);
				UIDropDownMenu_SetText(MetaMap_ZoneMenu, mapName);
			end
		end
	end
end

-- *** Allow zoom out from all dungeons and BGs ***
-- This gets called from WorldMapFrame.lua when user right clicks on the map or
--      gets called from WorldMapFrame.xml if the "WorldMapZoomOutButton" is clicked
function MetaMap_WorldMapZoomOutButton_OnClick()
	if (MetaMapOptions.MetaMapZone) then
		local _, zIndex = MetaMap_GetZoneTableEntry(MetaMapOptions.MetaMapZone);
		local mapName;
		if (zIndex) then mapName = MetaMap_ZoneTable[zIndex].Location; end
		if (mapName) then
			local _, _, _, mapid = MetaMap_GetZoneTableEntry(mapName);
			if (mapid ~= 0) then
				SetMapByID(mapid);
			else
				SetMapZoom(MetaMap_NameToZoneID(mapName));
			end
			MetaMapOptions.MetaMapZone = mapName;
		else
			-- zoom out from BGs
			local continent;
			if (zIndex) then continent = MetaMap_ZoneTable[zIndex].Continent; end
			if (not continent) then continent = -1; end
			SetMapZoom(continent, 0);
			MetaMapOptions.MetaMapZone = MetaMap_ZoneIDToName(continent, 0);
		end
		MetaMap_ShowInstance(frame, false);
		MetaMap_MainMapUpdate();
	end

	MetaMap_SaveCurrentMapData();

	-- set drop down menu text of zone menu to current map
	local mapName = MetaMap_GetCurrentMapInfo();
	if (mapName) then
		local cKey, zKey = MetaMap_NameToZoneID(mapName);
		if (cKey ~= -1 or (type(zKey) == "number" and zKey == 0)) then
			UIDropDownMenu_SetText(MetaMap_ZoneMenu, mapName);
		end
	end
end

-- left click handler for maps with special buttons, like "The Cosmos" map
function MetaMap_WorldMapAreaButton_OnClick()
	MetaMap_SaveCurrentMapData();

	-- set drop down menu text of zone menu to current map
	local mapName = MetaMap_GetCurrentMapInfo();
	if (mapName) then
		local cKey, zKey = MetaMap_NameToZoneID(mapName);
		if (cKey ~= -1 or (type(zKey) == "number" and zKey == 0)) then
			UIDropDownMenu_SetText(MetaMap_ZoneMenu, mapName);
		end
	end
end

-- The function WorldMapLevelUpDown_OnClick registers changes of the map level
function MetaMap_WorldMapLevelUpDown_OnClick()
	MetaMap_SaveCurrentMapData();
end

function MetaMapList_Highlight_Note(self)
	for i = 1, MetaMap_NoteList.lastEntry, 1 do
		_G["MetaMapNotesPOI"..i.."Highlight"]:Hide();
	end

	local lastNote = MetaMap_NoteList[self:GetID() + MetaMap_ListOffset].id;
	if (_G["MetaMapNotesPOI"..lastNote]:IsVisible()) then
		_G["MetaMapNotesPOI"..lastNote.."Highlight"]:SetTexture(METAMAP_ICON_PATH.."IconGlowRed");
		_G["MetaMapNotesPOI"..lastNote.."Highlight"]:Show();
	end
end

function MetaMapList_OnClick(self, button, id)
	MetaMap_Debug_Print("MetaMapList_OnClick", true);
	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	--MetaMapList_Highlight_Note(self);
	if (button == "LeftButton") then
		if (IsShiftKeyDown()) then
			if (not dataZone) then return; end
			if (not ChatEdit_GetActiveWindow()) then ChatFrame_OpenChat(""); end
			local ChatFrameEditBox = ChatEdit_GetActiveWindow();
			if (not ChatFrameEditBox:IsVisible()) then ChatFrameEditBox:Show(); end
			local tinf1 = dataZone[id].inf1;
			local coords = format("%d, %d", dataZone[id].xPos *100, dataZone[id].yPos *100);
			if (strlen(tinf1) > 0) then tinf1 = " ["..tinf1.."] "; end
			local msg = dataZone[id].name.." "..tinf1.." ("..mapName.." - "..coords..")";
			ChatFrameEditBox:Insert(msg);
		elseif (id == 0) then
			MetaMapPing_SetPing(dataZone, id);
		else
			MetaMapPing_SetPing(dataZone, MetaMap_NoteList[self:GetID() + MetaMap_ListOffset].id);
		end
	elseif (button == "RightButton") then
		if (IsControlKeyDown()) then
			MetaMap_LoadBWP(id, 2);
		elseif (IsShiftKeyDown() and MetaMap_LoadNBK(1)) then
			NBK_SetTargetNote(dataZone[id].name);
		else
			MetaMap_MapNote_OnClick(self,"LeftButton", id);
		end
	end
end

function MetaMapList_BuildList()
	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	MetaMap_NoteList = {};
	MetaMapList_InfoText:Hide();
	MetaMapList_PlayerButton:Hide();
	if (mapName == MetaMap_GetRealZoneText() ) then
		_G["MetaMapList_PlayerButton".."Name"]:SetText(UnitName("Player"));
		MetaMapList_PlayerButton:Show();
	end
	if (not dataZone) then
		MetaMap_MapListFrame:Hide();
	else
		local index = 1;
		for i, value in ipairs(dataZone) do
			if (MetaMap_NoteFilter[dataZone[i].icon]) then
	 			MetaMap_NoteList[index] = {};
				MetaMap_NoteList[index]["name"] = dataZone[i]["name"];
				MetaMap_NoteList[index]["xPos"] = dataZone[i]["xPos"];
				MetaMap_NoteList[index]["yPos"] = dataZone[i]["yPos"];
				MetaMap_NoteList[index]["ncol"] = dataZone[i]["ncol"];
				MetaMap_NoteList[index]["icon"] = dataZone[i]["icon"];
				MetaMap_NoteList[index]["id"] = i;
				MetaMap_NoteList.lastEntry = index;
				index = index + 1;
			end
		end
		if (MetaMapOptions.SortList) then
			local sort = MetaMap_sortType;
			MetaMap_sortType = METAMAP_SORTBY_NAME;
			table.sort(MetaMap_NoteList, MetaMap_SortCriteria);
			MetaMap_sortType = sort;
		end
	end
end

function MetaMapList_UpdateScroll()
	for i = 1, METAMAP_LISTBUTTON_SHOWN, 1 do
		local buttonIndex = i + FauxScrollFrame_GetOffset(MetaMapList_ScrollFrame);
		local scrollFrameButton = _G["MetaMapList_ScrollFrameButton"..i];
		local NameButton = _G["MetaMapList_ScrollFrameButton"..i.."Name"];
		if (buttonIndex < MetaMap_NoteList.lastEntry + 1) then
			MetaMap_ListOffset = buttonIndex - i;
			NameButton:SetText(MetaMap_NoteList[buttonIndex]["name"]);
			_G["MetaMapList_ScrollFrameButton"..i.."NoteID"]:SetText(MetaMap_NoteList[buttonIndex]["id"]);
			if (MetaMapOptions.ListColors) then
				local cNr = MetaMap_NoteList[buttonIndex]["ncol"];
				NameButton:SetTextColor(MetaMap_Colors[cNr].r, MetaMap_Colors[cNr].g, MetaMap_Colors[cNr].b);
			else
				NameButton:SetTextColor(MetaMap_Colors[0].r, MetaMap_Colors[0].g, MetaMap_Colors[0].b);
			end
			scrollFrameButton:Show();
		else
			scrollFrameButton:Hide();
		end
	end
	FauxScrollFrame_Update(MetaMapList_ScrollFrame, MetaMap_NoteList.lastEntry, METAMAP_LISTBUTTON_SHOWN, METAMAP_LISTBUTTON_HEIGHT);
end

function MetaMapPing_SetPing(dataZone, id)
	if (id == 0) then
		if (WorldMapPing:IsShown()) then
			WorldMapPing:Hide();
		else
			WorldMapPing:Show();
		end
		return;
	end
	if (MetaMap_gPingPOI and MetaMap_gPingPOI:IsShown()) then
		MetaMapPing_OnUpdate(1);
	end
	MetaMap_Debug_Print("MetaMapPing_SetPing: "..id, true);

	MetaMap_gPingPOI = _G["MetaMapNotesPOI"..id.."Ping"];
	if ( MetaMap_gPingPOI ) then
		MetaMap_gPingPOI:SetTexture(METAMAP_ICON_PATH.."IconPing");
		UIFrameFlash(MetaMap_gPingPOI, 0.25, 0.25, 20, false, 0.15, 0.15);
		PlaySound("MapPing");
	end
end

function MetaMapPing_OnUpdate(rem)
	MetaMap_Debug_Print("MetaMapPing_OnUpdate: "..rem, true);
	if (rem) then
		-- or not UIFrameIsFading(MetaMap_PingPOI)
		UIFrameFlashStop(MetaMap_gPingPOI);
		MetaMap_gPingPOI:Hide();
		MetaMap_gPingPOI = nil;
	end
end

function MetaMap_ZoneSearch()
	if (MetaMap_NotesDialog:IsVisible()) then
		local mapName = MetaMap_GetCurrentMapInfo();
		MetaMap_ZoneSearchResult:SetText(format(METAMAP_ZONESEARCH_TEXT, mapName));
	end
end

function MetaMap_HelpOnEnter(self, header, args)
	local myArgs = {args};
	GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
	GameTooltip:SetText(header, 0.2, 0.5, 1, true);
	for i, string in pairs(myArgs) do
		GameTooltip:AddLine(string, 1, 1, 1, true);
	end
	GameTooltip:Show();
end

function MetaMap_Print(msg, display, r, g, b)
	if (not display) then return; end
	if (msg == nil) then msg = "Nil Value"; end
	if (type(msg) == "table") then msg = "Table Value"; end
	msg = "<"..METAMAP_TITLE..">: "..msg;
	if (DEFAULT_CHAT_FRAME) then
		if (r == nil or g == nil or b == nil) then
			r = 0.60; g = 0.80; b = 1.00;
		end
		DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b);
	end
end

function MetaMap_Debug_Print(msg, display, r, g, b)
	if (not MetaMapOptions["Debug"]) then return; end
	if (not display) then return; end
	if (msg == nil) then msg = "Nil Value"; end
	if (type(msg) == "table") then msg = "Table Value"; end
	msg = "["..date("%m/%d/%y %H:%M:%S").."]".."<"..METAMAP_TITLE..">: "..msg;
	if (DEFAULT_CHAT_FRAME) then
		if(r == nil or g == nil or b == nil) then
			r = 0.60; g = 0.80; b = 1.00;
		end
		DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b);
	end
end

function MetaMap_ToggleDR(self, mode)
	if (mode == 1) then
		DressUpFrame:SetMovable(true);
		DressUpFrame:SetFrameStrata("FULLSCREEN_DIALOG");
		DressUpFrame:SetScript("OnMouseDown", function() if (arg1 == "LeftButton") then self:StartMoving(); self.isMoving = true; end end);
		DressUpFrame:SetScript("OnMouseUp", function() if (self.isMoving) then self:StopMovingOrSizing(); self.isMoving	= false; end end);
	else
		DressUpFrame:SetMovable(false);
		DressUpFrame:SetFrameStrata("HIGH");
		DressUpFrame:SetScript("OnMouseDown", nil);
		DressUpFrame:SetScript("OnMouseUp", nil);
	end
end

local function MetaMap_CreateNoteObject(noteNumber)
	local button;
	if (_G["MetaMapNotesPOI"..noteNumber]) then
		button = _G["MetaMapNotesPOI"..noteNumber];
	else
		button = CreateFrame("Button" ,"MetaMapNotesPOI"..noteNumber, WorldMapButton, "MetaMapNotes_NoteTemplate");
		MetaMap_LastNote = MetaMap_LastNote + 1;
	end
	button:SetWidth(MetaMapOptions.NoteSize);
	button:SetHeight(MetaMapOptions.NoteSize);
	button:SetID(noteNumber);
	return button;
end

local function MetaMap_CreateLineObject(lineNumber)
	local line;
	if (_G["MetaMapNotesLines_"..lineNumber]) then
		line = _G["MetaMapNotesLines_"..lineNumber];
	else
		MetaMapNotesLinesFrame:CreateTexture("MetaMapNotesLines_"..lineNumber, "ARTWORK");
		line = _G["MetaMapNotesLines_"..lineNumber];
		MetaMap_LastLine = MetaMap_LastLine + 1;
	end
	return line;
end

local function MetaMap_AddMiniNote(id, mapName, xPos, yPos, name, inf1, inf2, creator, icon, ncol, in1c, in2c)
	local dataZone = MetaMap_Notes[mapName][id];
	MetaMap_MiniNote_Data.id = id;
	MetaMap_MiniNote_Data.zonetext = mapName;
	MetaMap_MiniNote_Data.inf1 = "";
	MetaMap_MiniNote_Data.inf2 = "";
	MetaMap_MiniNote_Data.in1c = 1;
	MetaMap_MiniNote_Data.in2c = 1;
	MetaMap_MiniNote_Data.color = 0;
	MetaMap_MiniNote_Data.creator = creator;
	if (id == 0) then
		MetaMap_MiniNote_Data.xPos = xPos;
		MetaMap_MiniNote_Data.yPos = yPos;
		MetaMap_MiniNote_Data.name = name;
		MetaMap_MiniNote_Data.inf1 = inf1;
		MetaMap_MiniNote_Data.inf2 = inf2;
		MetaMap_MiniNote_Data.in1c = in1c;
		MetaMap_MiniNote_Data.in2c = in2c;
		MetaMap_MiniNote_Data.color = ncol;
		MetaMap_MiniNote_Data.icon = icon;
	elseif (id == -1) then
		MetaMap_MiniNote_Data.xPos = MetaMap_PartyNoteData.xPos;
		MetaMap_MiniNote_Data.yPos = MetaMap_PartyNoteData.yPos;
		MetaMap_MiniNote_Data.name = METAMAP_PARTYNOTE;
		MetaMap_MiniNote_Data.icon = "party";
	elseif (id > 0) then
		MetaMap_MiniNote_Data.xPos = dataZone.xPos;
		MetaMap_MiniNote_Data.yPos = dataZone.yPos;
		MetaMap_MiniNote_Data.name = dataZone.name;
		MetaMap_MiniNote_Data.inf1 = dataZone.inf1;
		MetaMap_MiniNote_Data.inf2 = dataZone.inf2;
		MetaMap_MiniNote_Data.in1c = dataZone.in1c;
		MetaMap_MiniNote_Data.in2c = dataZone.in2c;
		MetaMap_MiniNote_Data.color = dataZone.ncol;
		MetaMap_MiniNote_Data.icon = dataZone.icon;
		MetaMap_MiniNote_Data.creator = dataZone.creator;
	end
	MetaMap_MiniNoteTexture:SetTexture(METAMAP_ICON_PATH.."Icon"..MetaMap_MiniNote_Data.icon);
	MetaMap_MiniNote:Show();
	MetaMap_SetNextAsMiniNote = 0;
	MetaMapNotesButtonMiniNoteOff:Enable();
	MetaMap_MainMapUpdate();
end

local function MetaMap_CheckNearNotes(mapName, xPos, yPos)
	local dataZone = MetaMap_Notes[mapName];
	if (dataZone == nil) then return; end
	for i, value in pairs(dataZone) do
		local deltax = abs(dataZone[i].xPos - xPos);
		local deltay = abs(dataZone[i].yPos - yPos);
		if (deltax <= 0.0009765625 * MetaMap_MinDiff and deltay <= 0.0013020833 * MetaMap_MinDiff) then
			return i;
		end
	end
	return false;
end

local function MetaMap_AddNewNote(mapName, xPos, yPos, name, inf1, inf2, creator, icon, ncol, in1c, in2c, mininote, mLevel)
	if (xPos == 0 and yPos == 0) then
		MetaMap_Print(METAMAP_INVALIDZONE, true);
		return;
	end
	if (not MetaMap_Notes[mapName] or name == nil) then return false; end
	if (inf1 == nil) then inf1 = ""; end
	if (inf2 == nil) then inf2 = ""; end
	if (icon == nil) then icon = 0; end
	if (ncol == nil) then ncol = 0; end
	if (in1c == nil) then in1c = 0; end
	if (in2c == nil) then in2c = 0; end
	if (creator == nil) then creator = UnitName("player"); end
	local id = 0;
	local checkNote;
	local returnValue = true;
	local dataZone = MetaMap_Notes[mapName];
	local index = #(dataZone);
	if (mininote == 0 or mininote == nil) then
		MetaMap_SetNextAsMiniNote = 0;
	elseif (mininote == 1) then
		MetaMap_SetNextAsMiniNote = 1;
	elseif (mininote == 2) then
		MetaMap_SetNextAsMiniNote = 2;
	end		

	if (MetaMap_SetNextAsMiniNote ~= 2) then
		checkNote = MetaMap_CheckNearNotes(mapName, xPos, yPos);
		if (checkNote) then
			returnValue = false;
		else
			MetaMap_TempData_Id = index + 1
			dataZone[MetaMap_TempData_Id] = {};
			dataZone[MetaMap_TempData_Id].name = name;
			dataZone[MetaMap_TempData_Id].ncol = ncol;
			dataZone[MetaMap_TempData_Id].inf1 = inf1;
			dataZone[MetaMap_TempData_Id].in1c = in1c;
			dataZone[MetaMap_TempData_Id].inf2 = inf2;
			dataZone[MetaMap_TempData_Id].in2c = in2c;
			dataZone[MetaMap_TempData_Id].creator = creator;
			dataZone[MetaMap_TempData_Id].icon = icon;
			dataZone[MetaMap_TempData_Id].xPos = xPos;
			dataZone[MetaMap_TempData_Id].yPos = yPos;
			dataZone[MetaMap_TempData_Id].mLevel = mLevel;
			id = MetaMap_TempData_Id;
			if (MetaMap_MiniNote_Data ~= nil and MetaMap_MiniNote_Data.name == name) then
				MetaMap_MiniNote_Data.id = id;
			end
			returnValue = true;
			checkNote = id;
		end
	end
	if (MetaMap_SetNextAsMiniNote ~= 0) then
		for i = 0, index, 1 do
			if (dataZone[i] ~= nil) then
				if (dataZone[i].name == name and dataZone[i].xPos == xPos and dataZone[i].yPos == yPos) then
					id = i;
					break;
				end
			end
		end
		MetaMap_AddMiniNote(id, mapName, xPos, yPos, name, inf1, inf2, creator, icon, ncol, in1c, in2c);
		returnValue = returnValue;
	end
	MetaMap_MainMapUpdate();
	return returnValue, checkNote;
end

local function MetaMap_DeleteMapNote(id, mapName)
	MetaMap_HideAll();
	if id == 0 then
		MetaMap_vnote_xPos = nil;
		MetaMap_vnote_yPos = nil;
		MetaMap_MainMapUpdate();
		return;
	elseif (id == -1) then
		MetaMap_PartyNoteData.xPos = nil;
		MetaMap_PartyNoteData.yPos = nil;
		MetaMap_PartyNoteData.mapName = nil;
		if(MetaMap_MiniNote_Data.id == -1) then
			MetaMap_MiniNote_Data = {};
		end
		MetaMap_MainMapUpdate();
		return;
	end

	local TempData = {};
	TempData[mapName] = {};
	local dataZone = MetaMap_Notes[mapName][id];
	local lastEntry = #(MetaMap_Notes[mapName]);
	if (dataZone) then
		MetaMap_DeleteLines(mapName, dataZone.xPos, dataZone.yPos);
	end
	if (lastEntry ~= 0 and id <= lastEntry) then
		TempData[mapName] = MetaMap_Notes[mapName];
		MetaMap_Notes[mapName] = {};
		local newZone = TempData[mapName];
		for index, indexTable in ipairs(newZone) do
			if (index ~= id) then
				local oldData = newZone[index];
				MetaMap_AddNewNote(mapName, oldData.xPos, oldData.yPos, oldData.name, oldData.inf1, oldData.inf2, oldData.creator, oldData.icon, oldData.ncol, oldData.in1c, oldData.in2c, nil, oldData.mLevel);
			end
		end
	end
	if (MetaMap_MiniNote_Data.id == id) then
		MetaMap_ClearMiniNote(true);
	end
	MetaMap_MainMapUpdate();
end

function MetaMap_GenerateSendString(version)
	-- <MetaMap:MN> z<1> x<0.123123> y<0.123123> t<> i1<> i2<> cr<> i<8> tf<3> i1f<5> i2f<6>
	local text = "";
	local pName = UnitName("player");
	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	if (not dataZone) then return; end
	if (version == 1) then text = "<MetaMap:MN>"; end
	text = text.." z<"..mapName..">";

	if (MetaMap_PartyNoteSet) then
		local xPos = floor(MetaMap_PartyNoteData.xPos * 1000000)/1000000;
		local yPos = floor(MetaMap_PartyNoteData.yPos * 1000000)/1000000;
		text = text.." x<"..xPos.."> y<"..yPos..">";
		text = text.." t<"..METAMAP_PARTYNOTE..">";
		text = text.." i1<>";
		text = text.." i2<>";
		text = text.." cr<"..pName..">";
		text = text.." i<0>";
		text = text.." tf<0>";
		text = text.." i1f<0>";
		text = text.." i2f<0>";
		text = text.." p<1>";
	elseif (MetaMap_MiniNote_Data.id == 0) then
		local xPos = floor(MetaMap_MiniNote_Data.xPos * 1000000)/1000000;
		local yPos = floor(MetaMap_MiniNote_Data.yPos * 1000000)/1000000;
		text = text.." x<"..xPos.."> y<"..yPos..">";
		text = text.." t<"..MetaMap_EliminateUsedChars(MetaMap_MiniNote_Data.name)..">";
		text = text.." i1<"..MetaMap_EliminateUsedChars(MetaMap_MiniNote_Data.inf1)..">";
		text = text.." i2<"..MetaMap_EliminateUsedChars(MetaMap_MiniNote_Data.inf2)..">";
		text = text.." cr<"..MetaMap_MiniNote_Data.creator..">";
		text = text.." i<"..MetaMap_MiniNote_Data.icon..">";
		text = text.." tf<"..MetaMap_MiniNote_Data.color..">";
		text = text.." i1f<"..MetaMap_MiniNote_Data.in1c..">";
		text = text.." i2f<"..MetaMap_MiniNote_Data.in2c..">";
	else
		if (not dataZone[MetaMap_TempData_Id].creator) then
			dataZone[MetaMap_TempData_Id].creator = pName;
		end
		local xPos = floor(dataZone[MetaMap_TempData_Id].xPos * 1000000)/1000000; --cut to six digits behind the 0
		local yPos = floor(dataZone[MetaMap_TempData_Id].yPos * 1000000)/1000000;
		text = text.." x<"..xPos.."> y<"..yPos..">";
		text = text.." t<"..MetaMap_EliminateUsedChars(dataZone[MetaMap_TempData_Id].name)..">";
		text = text.." i1<"..MetaMap_EliminateUsedChars(dataZone[MetaMap_TempData_Id].inf1)..">";
		text = text.." i2<"..MetaMap_EliminateUsedChars(dataZone[MetaMap_TempData_Id].inf2)..">";
		text = text.." cr<"..dataZone[MetaMap_TempData_Id].creator..">";
		text = text.." i<"..dataZone[MetaMap_TempData_Id].icon..">";
		text = text.." tf<"..dataZone[MetaMap_TempData_Id].ncol..">";
		text = text.." i1f<"..dataZone[MetaMap_TempData_Id].in1c..">";
		text = text.." i2f<"..dataZone[MetaMap_TempData_Id].in2c..">";
	end
	MetaMap_PartyNoteSet = false;
	return text;
end

function MetaMap_EliminateUsedChars(text)
	text = string.gsub(text, "<", "");
	text = string.gsub(text, ">", "");
	return text;
end

function MetaMap_GetSendString(msg, who)
	local zone = gsub(msg,".*<MetaMap:MN> z<([^>]*)>.*","%1",1);
	local xPos = gsub(msg,".*<MetaMap:MN>%s+%w+.*x<([^>]*)>.*","%1",1)+0;
	local yPos = gsub(msg,".*<MetaMap:MN>%s+%w+.*y<([^>]*)>.*","%1",1)+0;
	local name = gsub(msg,".*<MetaMap:MN>%s+%w+.*t<([^>]*)>.*","%1",1);
	local inf1 = gsub(msg,".*<MetaMap:MN>%s+%w+.*i1<([^>]*)>.*","%1",1);
	local inf2 = gsub(msg,".*<MetaMap:MN>%s+%w+.*i2<([^>]*)>.*","%1",1);
	local creator = gsub(msg,".*<MetaMap:MN>%s+%w+.*cr<([^>]*)>.*","%1",1);
	local icon = gsub(msg,".*<MetaMap:MN>%s+%w+.*i<([^>]*)>.*","%1",1)+0;
	local ncol = gsub(msg,".*<MetaMap:MN>%s+%w+.*tf<([^>]*)>.*","%1",1)+0;
	local in1c = gsub(msg,".*<MetaMap:MN>%s+%w+.*i1f<([^>]*)>.*","%1",1)+0;
	local in2c = gsub(msg,".*<MetaMap:MN>%s+%w+.*i2f<([^>]*)>.*","%1",1)+0;
	local mLevel = gsub(msg,".*<MetaMap:MN>%s+%w+.*m<([^>]*)>.*","%1",1)+0;

	local mapName = MetaMap_GetZoneTableEntry(zone);
	local noteAdded, noteID = MetaMap_AddNewNote(mapName, xPos, yPos, name, inf1, inf2, creator, icon, ncol, in1c, in2c, MetaMap_SetNextAsMiniNote, mLevel);
	if (who == nil) then
		if (noteAdded) then
			MetaMap_Print(format(METAMAP_ACCEPT_NOTE, mapName), true);
		else
			MetaMap_Print(format(METAMAP_DECLINE_NOTE, MetaMap_Notes[mapName][noteID].name, mapName), true);
		end
	else
		if (noteAdded) then
			MetaMap_Print(format(METAMAP_ACCEPT_GET, who, mapName), true);
		else
			MetaMap_Print(format(METAMAP_DECLINE_GET, who, mapName, MetaMap_Notes[mapName][noteID].name), true);
		end
	end
	return noteAdded;
end

function MetaMap_Quicknote(msg)
	MetaMap_SetMapToCurrentZone();

	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	local px, py = GetPlayerMapPosition("player");
	if (not dataZone or px == 0 or px == nil) then
		MetaMap_Print(METAMAP_INVALIDZONE, true);
		return;
	end
	local name = METAMAP_QUICKNOTE_DEFAULTNAME;
	if (msg ~= "" and msg ~= nil) then
		if (strlen(msg) == 1) then
			mode = tonumber(strsub(msg, 1, 1));
			msg = "";
		else
			local mCheck = strsub(msg, 1, 2);
			if (mCheck == "1 " or mCheck == "2 " or mCheck == "3 ") then
				mode = tonumber(strsub(msg, 1, 1));
				msg = strsub(msg, 3);
			else
				mode = MetaMap_SetNextAsMiniNote;
			end
		end
	else
		mode = MetaMap_SetNextAsMiniNote;
	end
	local i, j, x, y, tmp = string.find(msg,"%s*(%d+)%s*[,.]%s*(%d+)%s*([^%c]*)");
	if (x ~= nil and y ~= nil) then
		px = x / 100;
		py = y / 100;
		msg = tmp;
	end
	if (mode == 3) then
		MetaMap_vnote_xPos = px;
		MetaMap_vnote_yPos = py;
		MetaMap_Print(METAMAP_VNOTE_SET, true);
		return;
	end
	if (msg ~= "" and msg ~= nil) then
		name = string.sub(msg,string.find(msg,"%s*([^%c]*)"));
	end
	local noteAdded, noteID = MetaMap_AddNewNote(mapName, px, py, name, "", "", UnitName("player"), 0, 0, 0, 0, mode, GetCurrentMapDungeonLevel());
	if (noteAdded) then
		if (mode ~= 2) then
			MetaMap_Print(format(METAMAP_ACCEPT_NOTE, MetaMap_GetRealZoneText()), true);
		end
	else
		MetaMap_Print(format(METAMAP_DECLINE_NOTE, dataZone[noteID].name, MetaMap_GetRealZoneText()), true);
	end
	if (mode > 0) then
		MetaMap_Print(format(METAMAP_ACCEPT_MININOTE, MetaMap_GetRealZoneText()), true);
	end
	MetaMap_Qnote = false;
end

function MetaMap_QuickNoteShow()
	local x, y = GetPlayerMapPosition("player");
	local coords = format("%d, %d", x * 100, y * 100);
	Coords_EditBox:SetText(coords);
	MiniNote_CheckButton:SetChecked(false);
	MetaMap_Qnote = true;
end

function MetaMap_SetQuickNote(mode)
	local msg;
	if (mode == 1) then
		msg = Coords_EditBox:GetText().." "..Note_EditBox:GetText();
	else
		msg = "3 "..Coords_EditBox:GetText();
	end
	MetaMap_Quicknote(msg);
end

function MetaMap_GetNoteFromChat(msg, who)
	if (not MetaMapOptions.AcceptIncoming) then
		MetaMap_Print(format(METAMAP_DISABLED_GET, who), true);
		return;
	end
	if (gsub(msg,".*<MetaMap:MN>%s+%w+.*p<([^>]*)>.*","%1",1) == "1") then -- Party Note
		local id = -1;
		local zone = gsub(msg,".*<MetaMap:MN>%s+%w+.*z<([^>]*)>.*","%1",1);
		local xPos = gsub(msg,".*<MetaMap:MN>%s+%w+.*x<([^>]*)>.*","%1",1)+0;
		local yPos = gsub(msg,".*<MetaMap:MN>%s+%w+.*y<([^>]*)>.*","%1",1)+0;
		local icon = "party";
		local mapName = MetaMap_GetZoneTableEntry(zone);
		MetaMap_PartyNoteData.zone = mapName;
		MetaMap_PartyNoteData.xPos = xPos;
		MetaMap_PartyNoteData.yPos = yPos;
		if (MetaMapOptions.MiniParty) then
			MetaMap_AddMiniNote(id, mapName, xPos, yPos, name, inf1, inf2, creator, icon, ncol, in1c, in2c);
			MetaMap_Print(format(METAMAP_PARTY_GET, who, mapName), true);
		end
	else
		MetaMap_GetSendString(msg, who);
	end
end

function MetaMap_GetNoteBySlashCommand(msg)
	if (msg and msg ~= "") then
		msg = "<MetaMap:MN> "..msg;
		return MetaMap_GetSendString(msg);
	else
		MetaMap_Print(METAMAP_MAPNOTEHELP, true);
		return false;
	end
end

function MetaMap_Misc_OnClick(self, button)
	if (not MetaMap_FramesHidden()) then return; end
	if (button == "LeftButton") then
		if (self:GetID() == 0) then
			MetaMap_TempData_Id = 0;
			MetaMap_EditExistingNote(MetaMap_TempData_Id);
		elseif (self:GetID() == 1) then
			MetaMap_PartyNoteSet = true;
			MetaMap_TempData_Id = -1;
			MetaMap_ShowSendFrame(0);
		end
	end
end

function MetaMap_NextMiniNote(msg)
	msg = string.lower(msg);
	if (msg == "on") then
		MetaMap_SetNextAsMiniNote = 1;
	elseif (msg == "off") then
		MetaMap_SetNextAsMiniNote = 0;
	elseif (MetaMap_SetNextAsMiniNote == 1) then
		MetaMap_SetNextAsMiniNote = 0;
	else
		MetaMap_SetNextAsMiniNote = 1;
	end
end

function MetaMap_NextMiniNoteOnly(msg)
	msg = string.lower(msg);
	if (msg == "on") then
		MetaMap_SetNextAsMiniNote = 2;
	elseif (msg == "off") then
		MetaMap_SetNextAsMiniNote = 0;
	elseif (MetaMap_SetNextAsMiniNote == 2) then
		MetaMap_SetNextAsMiniNote = 0;
	else
		MetaMap_SetNextAsMiniNote = 2;
	end
end

function MetaMap_MinimapUpdateZoom()
	if (MetaMap_MiniNote_MapzoomInit) then
		if (MetaMap_MiniNote_IsInCity) then
			MetaMap_MiniNote_IsInCity = false;
		else
			MetaMap_MiniNote_IsInCity = true;
		end
	else
		local tempzoom = 0;
		if (GetCVar("minimapZoom") == GetCVar("minimapInsideZoom")) then
			if (GetCVar("minimapInsideZoom") + 0 >= 3) then
				Minimap:SetZoom(Minimap:GetZoom() - 1);
				tempzoom = 1;
			else
				Minimap:SetZoom(Minimap:GetZoom() + 1);
				tempzoom = - 1;
			end
		end

		if (GetCVar("minimapInsideZoom") + 0 == Minimap:GetZoom()) then
			MetaMap_MiniNote_IsInCity = true;
		else
			MetaMap_MiniNote_IsInCity = false;
		end

		Minimap:SetZoom(Minimap:GetZoom() + tempzoom);
		MetaMap_IsInside = MetaMap_MiniNote_IsInCity;
		local _, _, _, isMicroDungeon = GetMapInfo();
		MetaMap_IsMicroDungeon = isMicroDungeon;
		MetaMap_MiniNote_MapzoomInit = true;
	end
end

function MetaMap_MiniNote_OnUpdate(elapsed)
	if (MetaMap_GetRealZoneText() ~= MetaMap_MiniNote_Data.zonetext) then
		MetaMap_MiniNote:Hide();
		return;
	end
	local zName, zIndex = MetaMap_GetZoneTableEntry(MetaMap_GetRealZoneText());
	local continent, zone = MetaMap_NameToZoneID(MetaMap_GetRealZoneText());
	if (not zIndex or continent ~= GetCurrentMapContinent() or zone ~= GetCurrentMapZone()) then return; end
	local x, y = GetPlayerMapPosition("player");
	if (x == 0 and y == 0) then return; end
	local currentSet = MetaMap_ZoneTable[zIndex];
	local currentZoom = Minimap:GetZoom();
	local xscale, yscale;
	if (zone >= 0) then
		xscale = MetaMap_MapScale[continent][currentZoom].xscale;
		yscale = MetaMap_MapScale[continent][currentZoom].yscale;
	else
		xscale = currentSet.xscale;
		yscale = currentSet.yscale;
	end
	if (MetaMap_MiniNote_IsInCity) then
		xscale = xscale * MetaMap_MapScale.cityscale[currentZoom];
		yscale = yscale * MetaMap_MapScale.cityscale[currentZoom];
	end
	local xpos = MetaMap_MiniNote_Data.xPos * currentSet.scale + currentSet.xoffset;
	local ypos = MetaMap_MiniNote_Data.yPos * currentSet.scale + currentSet.yoffset;
	x = x * currentSet.scale + currentSet.xoffset;
	y = y * currentSet.scale + currentSet.yoffset;
	local deltax = (xpos - x) * xscale;
	local deltay = (ypos - y) * yscale;
	if (sqrt( (deltax * deltax) + (deltay * deltay) ) > 56.5) then
		local adjust = 1;
		if (deltax == 0) then
			deltax = deltax + 0.0000000001;
		elseif (deltax < 0) then
			adjust = - 1;
		end
		local m = math.atan(deltay / deltax);
		deltax = math.cos(m) * 57 * adjust;
		deltay = math.sin(m) * 57 * adjust;
	end
	MetaMap_MiniNote:SetPoint("CENTER", "MinimapCluster", "TOPLEFT", 105 + deltax, -93 - deltay);
	MetaMap_MiniNote:Show();
end

function MetaMap_MiniNote_OnClick(self, arg1)
	if (arg1 == "LeftButton" and IsShiftKeyDown()) then
		if (not ChatEdit_GetActiveWindow()) then ChatFrame_OpenChat(""); end
		local ChatFrameEditBox = ChatEdit_GetActiveWindow();
		if (not ChatFrameEditBox:IsVisible()) then ChatFrameEditBox:Show(); end
		local coords = format("%d, %d", MetaMap_MiniNote_Data.xPos *100, MetaMap_MiniNote_Data.yPos *100);
		local msg = MetaMap_MiniNote_Data.name.." ("..MetaMap_GetRealZoneText().." - "..coords..")";
		ChatFrameEditBox:Insert(msg);
	else
		if (MetaMap_MiniNote_Data.id > 0) then
			MetaMap_SetMapToCurrentZone();
			if (not WorldMapFrame:IsVisible()) then
				MetaMapNotesEditFrame:SetParent("UIParent");
			end
			MetaMap_EditExistingNote(MetaMap_MiniNote_Data.id);
		elseif (MetaMap_MiniNote_Data.id == 0) then
			MetaMap_TempData_Id = 0;
			MetaMap_ShowSendFrame(0);
		else
			MetaMap_PartyNoteSet = true;
			MetaMap_TempData_Id = -1;
			MetaMap_ShowSendFrame(0);
		end
	end
end

function MetaMap_EditNewNote(ax, ay)
	if (not MetaMap_FramesHidden()) then return; end
	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	local width = WorldMapButton:GetWidth();
	local height = WorldMapButton:GetHeight();
	local xOffset,yOffset;
	MetaMap_TempData_xPos = ax;
	MetaMap_TempData_yPos = ay;
	MetaMap_TempData_Id = nil;
	if (ax*1002 >= (1002 - 195)) then
		xOffset = ax * width - 176;
	else
		xOffset = ax * width;
	end
	if (ay*668 <= (668 - 156)) then
		yOffset = -(ay * height) - 75;
	else
		yOffset = -(ay * height) + 87;
	end
	if (MetaMap_TempData_Id == 0) then
		MetaMap_vnote_xPos = nil;
		MetaMap_vnote_yPos = nil;
	end
	MetaMap_TempData_Id = #(dataZone) + 1;
	MetaMap_TempData_Creator = UnitName("player");
	MetaMap_Edit_SetIcon(0);
	MetaMap_Edit_SetTextColor(0);
	MetaMap_Edit_SetInfo1Color(0);
	MetaMap_Edit_SetInfo2Color(0);
	TitleWideEditBox:SetText("");
	Info1WideEditBox:SetText("");
	Info2WideEditBox:SetText("");
	if(MetaMapOptions["AutoFillCoords"]) then
		TitleWideEditBox:SetText(format("%d, %d", ax*100, ay *100));
	else
		TitleWideEditBox:SetText("");
	end

	CreatorWideEditBox:SetText(MetaMap_TempData_Creator);
	MetaMap_HideAll();
	MetaMapNotesButtonMiniNoteOff:Disable();
	MetaMapNotesButtonMiniNoteOn:Disable();
	MetaMapNotesButtonDeleteNote:Disable();
	MetaMapNotesButtonToggleLine:Disable();
	MetaMap_SendNoteButton:Disable();
	MetaMapNotesButtonMoveNote:Disable();
	MetaMapNotesEditFrameTitle:SetText(METAMAP_NEW_NOTE);
	MetaMapNotesEditFrame:Show();
end

function MetaMap_EditExistingNote(id)
	MetaMap_HideAll();
	MetaMapNotesEditFrameTitle:SetText(METAMAP_EDIT_NOTE);
	if (MetaMap_MiniNote_Data.xPos == nil) then
		MetaMapNotesButtonMiniNoteOff:Disable();
	else
		MetaMapNotesButtonMiniNoteOff:Enable();
	end
	MetaMapNotesButtonMiniNoteOn:Enable();
	MetaMapNotesButtonDeleteNote:Enable();
	MetaMapNotesButtonToggleLine:Enable();
	MetaMapNotesButtonMoveNote:Enable();

	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	MetaMap_TempData_Id = id;

	if (id == 0) then
		WorldMapPOIFrame.allowBlobTooltip = true;
		WorldMapTooltip:Hide();
		MetaMap_EditNewNote(MetaMap_vnote_xPos, MetaMap_vnote_yPos);
		return;
	elseif (id == -1) then
		WorldMapPOIFrame.allowBlobTooltip = true;
		WorldMapTooltip:Hide();
		MetaMap_EditNewNote(MetaMap_PartyNoteData.xPos, MetaMap_PartyNoteData.yPos);
		return;
	end
	MetaMap_TempData_LootID = nil;
	if (dataZone[MetaMap_TempData_Id].lootid ~= nil) then
		MetaMap_TempData_LootID = dataZone[MetaMap_TempData_Id].lootid;
	end
	MetaMap_TempData_Zone = mapName;
	MetaMap_TempData_Name = dataZone[MetaMap_TempData_Id].name;
	MetaMap_TempData_Creator = dataZone[MetaMap_TempData_Id].creator;
	MetaMap_TempData_xPos = dataZone[MetaMap_TempData_Id].xPos;
	MetaMap_TempData_yPos = dataZone[MetaMap_TempData_Id].yPos;
	MetaMap_Edit_SetIcon(dataZone[MetaMap_TempData_Id].icon);
	MetaMap_Edit_SetTextColor(dataZone[MetaMap_TempData_Id].ncol);
	MetaMap_Edit_SetInfo1Color(dataZone[MetaMap_TempData_Id].in1c);
	MetaMap_Edit_SetInfo2Color(dataZone[MetaMap_TempData_Id].in2c);
	TitleWideEditBox:SetText(dataZone[MetaMap_TempData_Id].name);
	Info1WideEditBox:SetText(dataZone[MetaMap_TempData_Id].inf1);
	Info2WideEditBox:SetText(dataZone[MetaMap_TempData_Id].inf2);
	CreatorWideEditBox:SetText(dataZone[MetaMap_TempData_Id].creator);
	MetaMapNotesEditFrame:Show();
end

function MetaMap_NoteEditorSave()
	MetaMap_HideAll();
	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	if (not dataZone) then return; end
	dataZone[MetaMap_TempData_Id] = {};
	dataZone[MetaMap_TempData_Id].name = TitleWideEditBox:GetText();
	dataZone[MetaMap_TempData_Id].ncol = MetaMap_TempData_TextColor;
	dataZone[MetaMap_TempData_Id].inf1 = Info1WideEditBox:GetText();
	dataZone[MetaMap_TempData_Id].in1c = MetaMap_TempData_Info1Color;
	dataZone[MetaMap_TempData_Id].inf2 = Info2WideEditBox:GetText();
	dataZone[MetaMap_TempData_Id].in2c = MetaMap_TempData_Info2Color;
	dataZone[MetaMap_TempData_Id].creator = CreatorWideEditBox:GetText();
	dataZone[MetaMap_TempData_Id].icon = MetaMap_TempData_Icon;
	dataZone[MetaMap_TempData_Id].xPos = MetaMap_TempData_xPos;
	dataZone[MetaMap_TempData_Id].yPos = MetaMap_TempData_yPos;
	dataZone[MetaMap_TempData_Id].mLevel = GetCurrentMapDungeonLevel();

	if (MetaMap_TempData_LootID ~= nil) then
		dataZone[MetaMap_TempData_Id].lootid = MetaMap_TempData_LootID;
		MetaMap_TempData_LootID = nil;
	end
	if (mapName == MetaMap_MiniNote_Data.zonetext and MetaMap_MiniNote_Data.id == MetaMap_TempData_Id) then
		MetaMap_MiniNote_Data.zonetext = mapName;
		MetaMap_MiniNote_Data.name = TitleWideEditBox:GetText();
		MetaMap_MiniNote_Data.icon = MetaMap_TempData_Icon;
		MetaMap_MiniNoteTexture:SetTexture(METAMAP_ICON_PATH.."Icon"..MetaMap_MiniNote_Data.icon);
		MetaMap_MiniNote_Data.inf1 = Info1WideEditBox:GetText();
		MetaMap_MiniNote_Data.inf2 = Info2WideEditBox:GetText();
		MetaMap_MiniNote_Data.in1c = MetaMap_TempData_Info1Color;
		MetaMap_MiniNote_Data.in2c = MetaMap_TempData_Info2Color;
		MetaMap_MiniNote_Data.color = MetaMap_TempData_TextColor;
		MetaMap_MiniNote_Data.creator = CreatorWideEditBox:GetText();
	end
	if (MetaMap_vnote_xPos == MetaMap_TempData_xPos and MetaMap_vnote_yPos == MetaMap_TempData_yPos) then
		MetaMap_vnote_xPos = nil;
		MetaMap_vnote_yPos = nil;
	end
	MetaMap_MainMapUpdate();
end

function MetaMap_ShowSendFrame(mode)
	MetaMap_SendPlayer:Disable();
	MetaMap_SendParty:Disable();
	MetaMap_SendGuild:Disable();
	MetaMap_ChangeSendFrame:Enable();
	SendWideEditBox:Show();
	MetaMap_SendFramePlayer:Show();
	MetaMap_DeletePartyNote:Hide();
	if (mode == 0) then
		if (GetNumSubgroupMembers() > 0 or IsInRaid()) then MetaMap_SendParty:Enable(); end
		if (IsInGuild()) then MetaMap_SendGuild:Enable(); end
		MetaMap_DeletePartyNote:Show();
		MetaMap_ChangeSendFrame:Disable();
		MetaMap_SendFramePlayer:Hide();
		SendWideEditBox:Hide();
	elseif (mode == 1) then
		MetaMap_ToggleSendValue = 2;
		if (GetNumSubgroupMembers() > 0 or IsInRaid()) then MetaMap_SendParty:Enable(); end
		if (IsInGuild()) then MetaMap_SendGuild:Enable(); end
		SendWideEditBox:SetText("");
		MetaMap_SendFrameTitle:SetText(METAMAP_SEND_NOTE);
		MetaMap_SendFrameTip:SetText(METAMAP_SEND_TIP);
		MetaMap_SendFramePlayer:SetText(METAMAP_SEND_PLAYER);
		MetaMap_ChangeSendFrame:SetText(METAMAP_SLASHCOMMAND);
	elseif (mode == 2) then
		MetaMap_ToggleSendValue = 1;
		MetaMap_SendFrameTitle:SetText(METAMAP_SEND_SLASHTITLE);
		MetaMap_SendFrameTip:SetText(METAMAP_SEND_SLASHTIP);
		MetaMap_SendFramePlayer:SetText(METAMAP_SEND_SLASHCOMMAND);
		MetaMap_ChangeSendFrame:SetText(METAMAP_SHOWSEND);
		SendWideEditBox:SetText("/mapnote"..MetaMap_GenerateSendString(2));
	end
	if (not MetaMap_SendFrame:IsVisible()) then
		MetaMap_HideAll();
		MetaMap_SendFrame:Show();
	end
end

function MetaMap_Edit_SetIcon(icon)
	MetaMap_TempData_Icon = icon;
	IconOverlay:SetPoint("TOPLEFT", "EditIcon"..icon, "TOPLEFT", -3, 3);
end

function MetaMap_Edit_SetTextColor(color)
	MetaMap_TempData_TextColor = color;
	TextColorOverlay:SetPoint("TOPLEFT", "TextColor"..color, "TOPLEFT", -3, 3);
end

function MetaMap_Edit_SetInfo1Color(color)
	MetaMap_TempData_Info1Color = color;
	Info1ColorOverlay:SetPoint("TOPLEFT", "Info1Color"..color, "TOPLEFT", -3, 3);
end

function MetaMap_Edit_SetInfo2Color(color)
	MetaMap_TempData_Info2Color = color;
	Info2ColorOverlay:SetPoint("TOPLEFT", "Info2Color"..color, "TOPLEFT", -3, 3);
end

function MetaMap_SendNote(self,mode)
	if (mode == 1) then
		if (strlen(SendWideEditBox:GetText()) > 1) then
			SendChatMessage(MetaMap_GenerateSendString(1), "WHISPER", self.language, SendWideEditBox:GetText());
			MetaMap_Print(format(METAMAP_NOTE_SENT, SendWideEditBox:GetText()), true);
		else
			MetaMap_Print(METAMAP_NOPLAYER, true);
		end
	elseif (mode == 2) then
		if (IsInRaid()) then
			SendAddonMessage("MetaMap:MN", MetaMap_GenerateSendString(1), "RAID");
			MetaMap_Print(METAMAP_RAIDSENT, true);
		elseif (GetNumSubgroupMembers() > 0) then
			SendAddonMessage("MetaMap:MN", MetaMap_GenerateSendString(1), "PARTY");
			MetaMap_Print(METAMAP_PARTYSENT, true);
		else
			MetaMap_Print(METAMAP_NOPARTY, true);
		end
	elseif (mode == 3) then
		if (IsInGuild()) then
			SendAddonMessage("MetaMap:MN", MetaMap_GenerateSendString(1), "GUILD");
			MetaMap_Print(METAMAP_GUILDSENT, true);
		else
			MetaMap_Print(METAMAP_NOGUILD, true);
		end
	end
	MetaMap_HideAll();
end

function MetaMap_ClearMiniNote(skipMapUpdate)
	MetaMap_MiniNote_Data = {};
	if (MetaMap_PartyNoteData ~= nil) then
		MetaMap_DeleteMapNote(-1);
	end
	MetaMap_MiniNote:Hide();
	MetaMapNotesButtonMiniNoteOff:Disable();
	if not skipMapUpdate then
		MetaMap_MainMapUpdate();
	end
end

function MetaMap_MainMapUpdate()
	MetaMap_Debug_Print("MetaMap_MainMapUpdate", true);
	if (WorldMapButton:IsVisible()) then
		MetaMap_WorldMapButton_OnUpdate();
	end
	if (Minimap:IsVisible() and MinimapPing_OnUpdate ~= nil) then
		MinimapPing_OnUpdate(Minimap, 0); --3.0.2
	end
end

function MetaMap_HideAll()
	MetaMapNotesEditFrame:Hide();
	MetaMap_SendFrame:Hide();
	MetaMap_QuickNoteFrame:Hide();
	MetaMap_ClearGUI();
end

function MetaMap_FramesHidden()
	if (MetaMapNotesEditFrame:IsVisible()) then return false; end
	if (MetaMap_SendFrame:IsVisible()) then return false; end
	if (MetaMap_QuickNoteFrame:IsVisible()) then return false; end
	return true;
end

function MetaMap_MapNoteOnEnter(self,id)
	--MetaMap_Debug_Print("MapNoteOnEnter", true);
	if (MetaMap_FramesHidden()) then
		--MetaMap_Debug_Print("MapNoteOnEnter:Showing", true);
		local x, y = self:GetCenter();
		local x2, y2 = WorldMapButton:GetCenter();
		local anchor = "";
		if (x > x2) then
			anchor = "ANCHOR_LEFT";
		else
			anchor = "ANCHOR_RIGHT";
		end
		WorldMapTooltip:SetOwner(self, anchor);
		if (id	== 0) then
			WorldMapTooltip:SetText(METAMAP_VNOTE_DEFAULTNAME);
		elseif (id == -1) then
			WorldMapTooltip:SetText(METAMAP_PARTYNOTE);
		else
			local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
			if (not dataZone or not dataZone[id]) then return; end
			local blt = "";
			local cNr = dataZone[id].ncol;
			WorldMapTooltip:AddDoubleLine(dataZone[id].name, blt, MetaMap_Colors[cNr].r, MetaMap_Colors[cNr].g, MetaMap_Colors[cNr].b, MetaMapOptions.TooltipWrap);
			if (dataZone[id].inf1 ~= nil and dataZone[id].inf1 ~= "") then
				cNr = dataZone[id].in1c;
				WorldMapTooltip:AddLine(dataZone[id].inf1, MetaMap_Colors[cNr].r, MetaMap_Colors[cNr].g, MetaMap_Colors[cNr].b, MetaMapOptions.TooltipWrap);
			end
			if (dataZone[id].inf2 ~= nil and dataZone[id].inf2 ~= "") then
				cNr = dataZone[id].in2c;
				WorldMapTooltip:AddLine(dataZone[id].inf2, MetaMap_Colors[cNr].r, MetaMap_Colors[cNr].g, MetaMap_Colors[cNr].b, MetaMapOptions.TooltipWrap);
			end
			if (dataZone[id].creator ~= nil and dataZone[id].creator ~= "" and MetaMapOptions.ShowCreator) then
				WorldMapTooltip:AddDoubleLine(METAMAP_CREATEDBY, dataZone[id].creator, 0, 0.75, 0.85, 0, 0.75, 0.85);
			end
		end
		WorldMapPOIFrame.allowBlobTooltip = false;
		WorldMapTooltip:Show();
	else
		WorldMapPOIFrame.allowBlobTooltip = true;
		WorldMapTooltip:Hide();
	end
end

function MetaMap_MiniNote_OnEnter(self)
	GameTooltip:SetOwner(self, "ANCHOR_CURSOR");
	if(MetaMap_MiniNote_Data.id == -1) then
		GameTooltip:SetText(METAMAP_PARTYNOTE);
	else
		local color = MetaMap_Colors[MetaMap_MiniNote_Data.color];
		GameTooltip:SetText(MetaMap_MiniNote_Data.name, color.r, color.g, color.b, MetaMapOptions.TooltipWrap);
		local in1c = MetaMap_Colors[MetaMap_MiniNote_Data.in1c];
		GameTooltip:AddLine(MetaMap_MiniNote_Data.inf1, in1c.r, in1c.g, in1c.b, MetaMapOptions.TooltipWrap);
		local in2c = MetaMap_Colors[MetaMap_MiniNote_Data.in2c];
		GameTooltip:AddLine(MetaMap_MiniNote_Data.inf2, in2c.r, in2c.g, in2c.b, MetaMapOptions.TooltipWrap);
		if (MetaMap_MiniNote_Data.creator ~= nil and MetaMap_MiniNote_Data.creator ~= "" and MetaMapOptions.ShowCreator) then
			GameTooltip:AddDoubleLine(METAMAP_CREATEDBY, MetaMap_MiniNote_Data.creator, 0, 0.75, 0.85, 0, 0.75, 0.85);
		end
	end
	GameTooltip:Show();
end

function MetaMap_MapNote_OnClick(self, button, id)
	if (not MetaMap_FramesHidden()) then return; end
	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	if (not dataZone) then return; end

	if (MetaMap_LastLineClick.GUIactive) then
		id = id + 0;
		local ax = dataZone[id].xPos;
		local ay = dataZone[id].yPos;
		if ( (MetaMap_LastLineClick.x ~= ax or MetaMap_LastLineClick.y ~= ay) and MetaMap_LastLineClick.mapName == mapName) then
			MetaMap_ToggleLine(mapName, ax, ay, MetaMap_LastLineClick.x, MetaMap_LastLineClick.y);
		end
		MetaMap_ClearGUI();
	elseif (button == "LeftButton") then
		if (IsShiftKeyDown()) then
			if (not ChatEdit_GetActiveWindow()) then ChatFrame_OpenChat(""); end
			local ChatFrameEditBox = ChatEdit_GetActiveWindow();
			if (not ChatFrameEditBox:IsVisible()) then ChatFrameEditBox:Show(); end
			local mode = 1;
			local tinf1 = dataZone[id].inf1;
			local coords = format("%d, %d", dataZone[id].xPos *100, dataZone[id].yPos *100);
			if (strlen(tinf1) > 0) then tinf1 = " ["..tinf1.."] "; end
			local msg = dataZone[id].name.." "..tinf1.." ("..mapName.." - "..coords..")";
			ChatFrameEditBox:Insert(msg);
		elseif (dataZone[id].icon ~= 10) then
			local width = WorldMapButton:GetWidth();
			local height = WorldMapButton:GetHeight();
			id = id + 0;
			MetaMap_TempData_Id = id;
			local ax = dataZone[id].xPos;
			local ay = dataZone[id].yPos;
			if (ax*1002 >= (1002 - 195)) then
				xOffset = ax * width - 176;
			else
				xOffset = ax * width;
			end
			if (ay*668 <= (668 - 156)) then
				yOffset = -(ay * height) - 75;
			else
				yOffset = -(ay * height) + 113;
			end
			MetaMap_SendNoteButton:Enable();
			WorldMapPOIFrame.allowBlobTooltip = true;			
			WorldMapTooltip:Hide();
			MetaMap_EditExistingNote(MetaMap_TempData_Id);
		end
	elseif (button == "RightButton") then
		if (IsControlKeyDown()) then
			MetaMapNotes_CRBSelect(id);
		elseif (IsShiftKeyDown() and MetaMap_LoadNBK(1)) then
			NBK_SetTargetNote(dataZone[id].name);
		else
			MetaMap_LoadBWP(self:GetID(), 2);
		end
	end
end

function MetaMap_StartGUIToggleLine()
	MetaMap_HideAll();
	MetaMapText_NoteTotals:SetText("|cffffffff"..METAMAP_CLICK_ON_SECOND_NOTE);
	MetaMap_LastLineClick.GUIactive = true;
	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	MetaMap_LastLineClick.x = dataZone[MetaMap_TempData_Id].xPos;
	MetaMap_LastLineClick.y = dataZone[MetaMap_TempData_Id].yPos;
	MetaMap_LastLineClick.mapName = mapName;
end

function MetaMap_StartMoveNote(ID)
	MetaMap_HideAll();
	MetaMapText_NoteTotals:SetText("|cffffffff"..METAMAP_CLICK_ON_LOCATION);
	local mapName = MetaMap_GetCurrentMapInfo();
	MetaMap_Relocate.mapName = mapName;
	MetaMap_Relocate.id = ID;
end

function MetaMap_MoveNote(mapName, id)
	local zoneTable = MetaMap_Lines[mapName];
	local lineCount = #(zoneTable);
	local currentX = MetaMap_Notes[mapName][id].xPos;
	local currentY = MetaMap_Notes[mapName][id].yPos;
	local centerX, centerY = WorldMapButton:GetCenter();
	local width = WorldMapButton:GetWidth();
	local height = WorldMapButton:GetHeight();
	local x, y = GetCursorPosition();
	x = x / WorldMapButton:GetEffectiveScale();
	y = y / WorldMapButton:GetEffectiveScale();

	if (centerX == nil) then
		centerX = 0;
	end
	if (centerY == nil) then
		centerY = 0;
	end

	local adjustedY = (centerY + height/2 - y) / height;
	local adjustedX = (x - (centerX - width/2)) / width;
	MetaMap_Notes[mapName][id].xPos = adjustedX;
	MetaMap_Notes[mapName][id].yPos = adjustedY;
	if (MetaMap_MiniNote_Data.id == id) then
		MetaMap_MiniNote_Data.xPos = adjustedX;
		MetaMap_MiniNote_Data.yPos = adjustedY;
	end
	for i = 1, lineCount, 1 do
		if (i <= lineCount) then
			if (zoneTable[i].x1 == currentX and zoneTable[i].y1 == currentY) then
				zoneTable[i].x1 = adjustedX;
				zoneTable[i].y1 = adjustedY;
			elseif (zoneTable[i].x2 == currentX and zoneTable[i].y2 == currentY) then
				zoneTable[i].x2 = adjustedX;
				zoneTable[i].y2 = adjustedY;
			end
		end
	end
	MetaMap_MainMapUpdate();
end

function MetaMap_ClearGUI()
	MetaMap_LastLineClick.GUIactive = false;
	MetaMap_Relocate = {};
end

function MetaMap_DrawLine(id, x1, y1, x2, y2)
	assert(x1 and y1 and x2 and y2);
	local MetaMapNotesLine = MetaMap_CreateLineObject(id);
	local positiveSlopeTexture = METAMAP_IMAGE_PATH.."LineTemplatePositive256";
	local negativeSlopeTexture = METAMAP_IMAGE_PATH.."LineTemplateNegative256";
	local width = WorldMapDetailFrame:GetWidth();
	local height = WorldMapDetailFrame:GetHeight();
	local deltax = math.abs((x1 - x2) * width);
	local deltay = math.abs((y1 - y2) * height);
	local xOffset = math.min(x1,x2) * width;
	local yOffset = -(math.min(y1,y2) * height);
	local lowerpixel = math.min(deltax, deltay);
	lowerpixel = lowerpixel / 256;
	if (lowerpixel > 1) then
		lowerpixel = 1;
	end
	if (deltax == 0) then
		deltax = 2;
		MetaMapNotesLine:SetTexture(0, 0, 0);
		MetaMapNotesLine:SetTexCoord(0, 1, 0, 1);
	elseif (deltay == 0) then
		deltay = 2;
		MetaMapNotesLine:SetTexture(0, 0, 0);
		MetaMapNotesLine:SetTexCoord(0, 1, 0, 1);
	elseif (x1 - x2 < 0) then
		if (y1 - y2 < 0) then
			MetaMapNotesLine:SetTexture(negativeSlopeTexture);
			MetaMapNotesLine:SetTexCoord(0, lowerpixel, 0, lowerpixel);
		else
			MetaMapNotesLine:SetTexture(positiveSlopeTexture);
			MetaMapNotesLine:SetTexCoord(0, lowerpixel, 1-lowerpixel, 1);
		end
	else
		if (y1 - y2 < 0) then
			MetaMapNotesLine:SetTexture(positiveSlopeTexture);
			MetaMapNotesLine:SetTexCoord(0, lowerpixel, 1-lowerpixel, 1);
		else
			MetaMapNotesLine:SetTexture(negativeSlopeTexture);
			MetaMapNotesLine:SetTexCoord(0, lowerpixel, 0, lowerpixel);
		end
	end


	MetaMapNotesLine:SetPoint("TOPLEFT", "WorldMapDetailFrame", "TOPLEFT", xOffset, yOffset);

	MetaMapNotesLine:SetWidth(deltax);
	MetaMapNotesLine:SetHeight(deltay);
	MetaMapNotesLine:Show();
end

function MetaMap_ToggleLine(mapName, x1, y1, x2, y2)
	local newline = true;
	local lineTable = MetaMap_Lines[mapName];
	local lineCount = #(lineTable);

	for i = 1, lineCount, 1 do
		if (i <= lineCount) then
			if ( (lineTable[i].x1 == x1 and lineTable[i].y1 == y1 and
					lineTable[i].x2 == x2 and lineTable[i].y2 == y2) or
					(lineTable[i].x1 == x2 and lineTable[i].y1 == y2 and
					lineTable[i].x2 == x1 and lineTable[i].y2 == y1) ) then
				for j = i, lineCount-1, 1 do
					lineTable[j].x1 = lineTable[j+1].x1;
					lineTable[j].x2 = lineTable[j+1].x2;
					lineTable[j].y1 = lineTable[j+1].y1;
					lineTable[j].y2 = lineTable[j+1].y2;
				end
				lineTable[lineCount] = nil;
				PlaySound("igMainMenuOption");
				newline = false;
				lineCount = lineCount - 1;
			end
		end
	end
	if (newline) then
		lineTable[lineCount+1] = {};
		lineTable[lineCount+1].x1 = x1;
		lineTable[lineCount+1].x2 = x2;
		lineTable[lineCount+1].y1 = y1;
		lineTable[lineCount+1].y2 = y2;
	end
	MetaMap_LastLineClick.zone = 0;
	MetaMap_MainMapUpdate();
end

function MetaMap_SetPartyNote(xPos, yPos)
	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	xPos = floor(xPos * 1000000) / 1000000;
	yPos = floor(yPos * 1000000) / 1000000;
	MetaMap_PartyNoteData.mapName = mapName;
	MetaMap_PartyNoteData.xPos = xPos;
	MetaMap_PartyNoteData.yPos = yPos;
	if (MetaMap_MiniNote_Data.icon == "party" or MetaMapOptions.MiniParty) then
		MetaMap_MiniNote_Data.zonetext = mapName;
		MetaMap_MiniNote_Data.id = -1;
		MetaMap_MiniNote_Data.xPos = xPos;
		MetaMap_MiniNote_Data.yPos = yPos;
		MetaMap_MiniNote_Data.name = METAMAP_PARTYNOTE;
		MetaMap_MiniNote_Data.color = 0;
		MetaMap_MiniNote_Data.icon = "party"
		MetaMap_MiniNoteTexture:SetTexture(METAMAP_ICON_PATH.."Icon"..MetaMap_MiniNote_Data.icon);
		MetaMap_MiniNote:Show();
	end
	MetaMap_MainMapUpdate();
end

function MetaMap_WorldMapButton_OnClick(frame, button)
	MetaMap_Debug_Print("MetaMap_WorldMapButton_OnClick", true);
	if (not MetaMap_FramesHidden()) then return; end

	if (BattlefieldMinimap and BattlefieldMinimap:IsVisible() ) then
		if (not MetaMap_CombatLockdown_BattlefiedMap) then
			MetaMap_Reshow_BattlefiedMap = time();
		end
		MetaMap_CombatLockdown_BattlefiedMap = nil;
		BattlefieldMinimap:Hide(); --BattlefieldMinimap screws up the map selection
	end

	local mapName = MetaMap_GetCurrentMapInfo();
	if (mapName and MetaMap_Relocate.id) then
		if (button == "LeftButton" and not IsControlKeyDown() and not IsShiftKeyDown()) then
			MetaMap_MoveNote(MetaMap_Relocate.mapName, MetaMap_Relocate.id);
			MetaMap_Relocate = {};
			return;
		end
	end

	if (button == "LeftButton" and (IsControlKeyDown() or IsShiftKeyDown() or IsAltKeyDown())) then
		if (mapName  or MetaMapOptions.ShowDNI) then
			local centerX, centerY = WorldMapButton:GetCenter();
			local width = WorldMapButton:GetWidth();
			local height = WorldMapButton:GetHeight();
			local x, y = GetCursorPosition();
			x = x / WorldMapButton:GetEffectiveScale();
			y = y / WorldMapButton:GetEffectiveScale();

			if (centerX == nil) then
				centerX = 0;
			end
			if (centerY == nil) then
				centerY = 0;
			end

			local adjustedY = (centerY + height/2 - y) / height;
			local adjustedX = (x - (centerX - width/2)) / width;

			if (IsShiftKeyDown()) then
				MetaMap_SetPartyNote(adjustedX, adjustedY);
			elseif (IsControlKeyDown()) then
				local _, _, dataZone = MetaMap_GetCurrentMapInfo();
				if (dataZone) then MetaMap_EditNewNote(adjustedX, adjustedY); end
			elseif (IsAltKeyDown() and MetaMap_GetCurrentMapInfo() == MetaMap_GetRealZoneText()) then
				MetaMap_LoadBWP(0, 3);
				if (IsAddOnLoaded("MetaMapBWP")) then
					BWP_LocCommand(format("%d, %d", 100 * adjustedX, 100 * adjustedY));
				end
			end
		end
--	elseif (button == "RightButton" and MetaMapFrame:IsVisible()) then
--		local _, zIndex = MetaMap_GetZoneTableEntry(MetaMapOptions.MetaMapZone);
--		local mapName = MetaMap_ZoneTable[zIndex].Location;
--		MetaMapOptions.MetaMapZone = mapName;
--		MetaMap_ShowInstance(frame, false);
--		SetMapZoom(MetaMap_NameToZoneID(mapName)); 
--
--		MetaMap_SaveCurrentMapData();
	else
		MetaMap_WorldMapButton_OnClick_old(frame, button);
	end
end

function MetaMap_WorldMapButton_OnUpdate(self, elapsed)
	if (not MetaMap_VarsLoaded or MetaMap_Drawing) then return; end
	local lastNote = 0;
	local lastLine = 0;
	local showLine = true;
	local xOffset,yOffset = 0;
	local currentLineZone;
	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	MetaMap_Drawing = true;
	if (dataZone) then
		currentLineZone = MetaMap_Lines[mapName];
		if (currentLineZone) then
			for i, line in ipairs(currentLineZone) do
				MetaMap_DrawLine(i, line.x1, line.y1, line.x2, line.y2);
				lastLine = i;
			end
		end
		for i, value in ipairs(dataZone) do
			local temp = MetaMap_CreateNoteObject(i);
			local xPos = dataZone[i].xPos;
			local yPos = dataZone[i].yPos;
			local xOffset = xPos * WorldMapButton:GetWidth();
			local yOffset = -yPos * WorldMapButton:GetHeight();
	
			temp:SetParent("WorldMapButton");
			temp:SetPoint("CENTER", "WorldMapButton", "TOPLEFT", xOffset, yOffset);
		
			_G["MetaMapNotesPOI"..i.."Texture"]:SetTexture(METAMAP_ICON_PATH.."Icon"..dataZone[i].icon);
			_G["MetaMapNotesPOI"..i.."Highlight"]:Hide();
			for landmarkIndex = 1, GetNumMapLandmarks(), 1 do
				local worldMapPOI = _G["WorldMapFramePOI"..landmarkIndex];
				if (worldMapPOI == nil) then break; end
				local metaMapPOI = _G["MetaMapNotesPOI"..i];
				local name, unknown, textureIndex, x, y = GetMapLandmarkInfo(landmarkIndex);
				local xPosmin = xPos - 2; local xPosmax = xPos + 2;
				local yPosmin = yPos - 2; local yPosmax = yPos + 2;
				if((x > xPosmin and x < xPosmax) and (y > yPosmin and y < yPosmax)) then
					metaMapPOI:SetFrameLevel(worldMapPOI:GetFrameLevel() + 1);
				end
			end

			if (dataZone[i].icon == 10) then
				if (dataZone[i].name == MetaMap_FilterName) then
					temp:Hide();
					showLine = false;
				else
					temp:Show();
				end
			elseif (MetaMap_NoteFilter[dataZone[i].icon] and (dataZone[i].mLevel == nil or dataZone[i].mLevel == GetCurrentMapDungeonLevel())) then
				temp:Show();
			else
				MetaMap_FilterName = dataZone[i].name;
				temp:Hide();
				showLine = false;
			end
			if (not showLine) then
				for line = 1, lastLine, 1 do
					if (currentLineZone[line].x1 == xPos and currentLineZone[line].y1 == yPos) then
						_G["MetaMapNotesLines_"..line]:Hide();
					elseif (currentLineZone[line].x2 == xPos and currentLineZone[line].y2 == yPos) then
						_G["MetaMapNotesLines_"..line]:Hide();
					end
				end
			end

			lastNote = i;
		end
		if (MetaMapOptions.LastHighlight and lastNote ~= 0 and dataZone[lastNote].icon ~= 10) then
			if (_G["MetaMapNotesPOI"..lastNote]:IsVisible()) then
				_G["MetaMapNotesPOI"..lastNote.."Highlight"]:SetTexture(METAMAP_ICON_PATH.."IconGlowRed");
				_G["MetaMapNotesPOI"..lastNote.."Highlight"]:Show();
			end
		end
		if (MetaMapOptions.LastMiniHighlight and MetaMap_MiniNote_Data.zonetext == mapName and MetaMap_MiniNote_Data.id > 0) then
			_G["MetaMapNotesPOI"..MetaMap_MiniNote_Data.id.."Highlight"]:SetTexture(METAMAP_ICON_PATH.."IconGlowBlue");
			_G["MetaMapNotesPOI"..MetaMap_MiniNote_Data.id.."Highlight"]:Show();
		end
		for i = lastNote + 1, MetaMap_LastNote, 1 do
			_G["MetaMapNotesPOI"..i]:Hide();
		end
		for i = lastLine + 1, MetaMap_LastLine, 1 do
			_G["MetaMapNotesLines_"..i]:Hide();
		end
	else
		for i = 1, MetaMap_LastNote, 1 do
			_G["MetaMapNotesPOI"..i]:Hide();
		end

		for i = 1, MetaMap_LastLine, 1 do
			_G["MetaMapNotesLines_"..i]:Hide();
		end
	end

	if (dataZone) then
		-- vNote button
		if (mapName and MetaMap_vnote_xPos ~= nil) then
			xOffset = MetaMap_vnote_xPos * WorldMapButton:GetWidth();
			yOffset = -MetaMap_vnote_yPos * WorldMapButton:GetHeight();
			MetaMapNotesPOIvNote:SetPoint("CENTER", "WorldMapButton", "TOPLEFT", xOffset, yOffset);
			
			MetaMapNotesPOIvNote:Show();
		else
			MetaMapNotesPOIvNote:Hide();
		end

		-- party note
		if (MetaMap_PartyNoteData.xPos ~= nil and mapName == MetaMap_PartyNoteData.mapName) then
			if (MetaMapOptions.LastMiniHighlight and MetaMap_MiniNote_Data.icon == "party") then
				MetaMapNotesPOIpartyTexture:SetTexture(METAMAP_ICON_PATH.."Iconpartyblue");
			else
				MetaMapNotesPOIpartyTexture:SetTexture(METAMAP_ICON_PATH.."Iconparty");
			end
			xOffset = MetaMap_PartyNoteData.xPos * WorldMapButton:GetWidth();
			yOffset = -MetaMap_PartyNoteData.yPos * WorldMapButton:GetHeight();
			MetaMapNotesPOIparty:SetParent("WorldMapButton");
			MetaMapNotesPOIparty:SetPoint("CENTER", "WorldMapButton", "TOPLEFT", xOffset, yOffset);
			
			MetaMapNotesPOIparty:Show();
		else
			MetaMapNotesPOIparty:Hide();
		end
	end
	MetaMap_Drawing = nil;
	MetaMapText_NoteTotals:SetText("|cff00ff00"..METAMAP_NOTES_SHOWN..": ".."|cffffffff"..(lastNote).."  ".."|cff00ff00"..METAMAP_LINES_SHOWN..": ".."|cffffffff"..(lastLine));
	MetaMapText_NoteTotals:Show();
	MetaMapList_Init();
	MetaMap_FilterName = "";
	if (IsAddOnLoaded("MetaMapTRK")) then
		TRK_DisplayNodes(mapName, GetCurrentMapDungeonLevel());
	end
end

function MetaMap_NotesListInit()
	local Temp_List = {};
	for mapName, indexTable in pairs(MetaMap_Notes) do
		for index, value in pairs(indexTable) do
			if (Temp_List[value.creator] == nil) then
				Temp_List[value.creator] = value.creator;
			end
		end
	end
	for index, creators in pairs(Temp_List) do
		local uText;
		if (Temp_List[index] == "") then
			uText = "Unsigned";
		else
			uText = Temp_List[index];
		end
		local info = {};
		info.checked = nil;
		info.notCheckable = 1;
		info.text = uText;
		info.value = uText;
		info.func = MetaMap_NotesList_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function MetaMap_NotesList_OnClick(self)
	local creator = self.value;
	local button = UIDROPDOWNMENU_MENU_VALUE;
	button:SetText(creator);
	if (creator == "Unsigned") then
		cFlag = "";
	else
		cFlag = creator;
	end	
	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	StaticPopupDialogs["Delete_Notes"] = {
		text = TEXT(format(METAMAP_BATCHDELETE, mapName, creator)),
		button1 = TEXT(ACCEPT),
		button2 = TEXT(DECLINE),
		OnAccept = function()
			MetaMap_DeleteNotes(cFlag, nil, mapName);
			button:SetText(METAMAP_OPTIONS_CCREATOR);
		end,
		OnCancel = function()
			button:SetText(METAMAP_OPTIONS_CCREATOR);
		end,
		timeout = 60,
		showAlert = 1,
	};
	StaticPopup_Show("Delete_Notes");
end

function MetaMap_DeleteNotes(creator, name, mapName)
	if (not creator) then return; end
	local continent;
	if (mapName) then
		for key, value in pairs(MetaMap_Continents) do
			if (mapName == value) then continent = key; end
		end
	end
	if (continent ~= nil or mapName == nil) then
		for zone, indexTable in pairs(MetaMap_Notes) do
			local cKey = MetaMap_NameToZoneID(zone);
			if (continent == cKey or continent == 0 or continent == -1 or continent == nil) then
				for id = #(indexTable), 1, -1 do
					if (creator == indexTable[id].creator and (name == indexTable[id].name or name == nil)) then
						MetaMap_DeleteMapNote(id, zone);
					end
				end
			end
		end
	else
		for id = #(MetaMap_Notes[mapName]), 1, -1 do
			if (creator == MetaMap_Notes[mapName][id].creator) then
				MetaMap_DeleteMapNote(id, mapName);
			end
		end
	end
	if (creator == "") then creator = "Unsigned"; end
	if (mapName ~= nil) then
		if (MetaMap_NotesDialog:IsVisible()) then
			MetaMap_OptionsInfo:SetText(format(METAMAP_DELETED_BY_ZONE, mapName, creator), true);
		else
			MetaMap_Print(format(METAMAP_DELETED_BY_ZONE, mapName, creator), true);
		end
	elseif (name ~= nil) then
		MetaMap_Print(format(METAMAP_DELETED_BY_NAME, creator, name), true);
	else
		MetaMap_Print(format(METAMAP_DELETED_BY_CREATOR, creator), true);
	end
end

function MetaMap_CheckLinks(id)
	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	local name = dataZone[id].name;
	local count = 0;
	for i = 1, 4, 1 do
		if (dataZone[id+i] ~= nil and dataZone[id+i].name == name and dataZone[id+i].icon == 10) then
			count = count +1;
		end
	end
	for i = 1, count + 1, 1 do
		MetaMap_DeleteMapNote(id, mapName);
	end
end

function MetaMap_DeleteLines(mapName, x, y)
	if (not x or not y) then return; end
	local lineTable = MetaMap_Lines[mapName];
	local lineCount = #(lineTable);
	local offset = 0;
	for i = 1, lineCount, 1 do
		if ( (lineTable[i-offset].x1 == x and lineTable[i-offset].y1 == y) or (lineTable[i-offset].x2 == x and lineTable[i-offset].y2 == y) ) then
			for j = i, lineCount-1, 1 do
				lineTable[j-offset].x1 = lineTable[j+1-offset].x1;
				lineTable[j-offset].x2 = lineTable[j+1-offset].x2;
				lineTable[j-offset].y1 = lineTable[j+1-offset].y1;
				lineTable[j-offset].y2 = lineTable[j+1-offset].y2;
			end
			lineTable[lineCount-offset] = nil;
			offset = offset + 1;
		end
	end
	MetaMap_LastLineClick.zone = 0;
end

function MetaMapPOI_OnEvent(mode)
	if (GetCurrentMapZone() == 0) then return; end
	local mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
	local noteAdded1, noteAdded2;
	local name, unknown, textureIndex, x, y;
	local icon = 7; --was 8
	for landmarkIndex = 1, GetNumMapLandmarks(), 1 do
		name, unknown, textureIndex, x, y = GetMapLandmarkInfo(landmarkIndex);
		if (textureIndex == 15) then
			icon = 7; --was 5
		elseif (textureIndex == 6) then
			icon = 6;
		end
		if (mode == 1) then
			if (textureIndex==6) then
				noteAdded1 = MetaMap_AddNewNote(mapName, x, y, name, "", "", METAMAPPOI_NAME, icon, 6, 0, 0,nil,GetCurrentMapDungeonLevel());
			end
		else
			noteAdded2 = MetaMap_AddNewNote(mapName, x, y, name, "", "", METAMAPPOI_NAME, icon, 6, 0, 0,nil,GetCurrentMapDungeonLevel());
		end
	end
	if (noteAdded1 and noteAdded2) then
		MetaMap_Print("MetaMapPOI updated map notes for "..MetaMap_GetRealZoneText(), true);
	else
		if (noteAdded2) then
			MetaMap_Print("MetaMapPOI updated map notes for "..MetaMap_GetRealZoneText(), true);
		end
		if (noteAdded1) then
			MetaMap_Print("MetaMapPOI set Guard note for "..name, true);
		end
	end
end

function MetaMap_SortCriteria(a, b)
	if (MetaMap_sortType == METAMAP_SORTBY_NAME) then
		if (a.name < b.name) then
			return true;
		elseif (a.name > b.name) then
			return false;
		end
	elseif (MetaMap_sortType == METAMAP_SORTBY_DESC) then
		if (a.desc < b.desc) then
			return true;
		elseif (a.desc > b.desc) then
			return false;
		end
	elseif (MetaMap_sortType == METAMAP_SORTBY_LEVEL) then
		if (a.level < b.level) then
			return true;
		elseif (a.level > b.level) then
			return false;
		end
	elseif (MetaMap_sortType == METAMAP_SORTBY_LOCATION) then
		if (a.location < b.location) then
			return true;
		elseif (a.location > b.location) then
			return false;
		end
	else
		if (a < b) then
			return true;
		elseif (a > b) then
			return false;
		end
		if (a == nil) then
			if (b == nil) then
				return false;
			else
				return true;
			end
		elseif (b == nil) then
			return false;
		end
	end
end

function MetaMap_InvertList(list)
	local newlist = {};
	local count = #(list);
	for i = 1, count do
		table.insert(newlist, list[(count + 1) - i]);
	end
	return newlist;
end

function MetaMap_InfoLine(button)
	MetaMap_Debug_Print("MetaMap_InfoLine"..button,true);
	if (button == "RightButton") then
		MetaMapOptions.ShowMapList = not MetaMapOptions.ShowMapList;
		MetaMapOptions_Init();
		return;
	end

	if (MetaMap_InfoLineFrame:IsVisible()) then
		MetaMapContainer_ShowFrame();
		return;
	end
	MetaMap_InfoLineUpdate();
end

function MetaMap_InfoLineUpdate()
	local header = "";
	local zName, zIndex, zType = MetaMap_GetZoneTableEntry(MetaMap_GetCurrentMapInfo());
	if (zType == "RDI" or zType == "DNI" or zType == "SCN") then
		local zoneTable = MetaMap_ZoneTable[zIndex];
		header = METAMAP_STRING_LOCATION..": ".."|cffffffff"..zoneTable.Location.."|r";
		header = header.."   "..METAMAP_STRING_LEVELRANGE..": ".."|cffffffff"..zoneTable.LevelRange.."|r";
		header = header.."   "..METAMAP_STRING_PLAYERLIMIT..": ".."|cffffffff"..zoneTable.PlayerLimit.."|r";
		MetaMap_InfoLineFrameText:SetText(zoneTable.infoline);
	else
		header = "|cffffffff"..MetaMap_GetCurrentMapInfo().."|r";
		MetaMap_InfoLineFrameText:SetText(METAMAP_FURINF);
	end
	MetaMapContainer_ShowFrame(MetaMap_InfoLineFrame, header);
end

function MetaMap_InfoLineOnEnter(self)
	MetaMap_SetTTInfoLine(MetaMap_GetCurrentMapInfo(), self, WorldMapTooltip);
	WorldMapTooltip:AddLine(METAMAP_INFOLINE_HINT1, 0.75, 0, 0.75, false);
	WorldMapTooltip:AddLine(METAMAP_INFOLINE_HINT2, 0.75, 0, 0.75, false);
	WorldMapTooltip:AddLine(" ");
	WorldMapTooltip:AddLine(METAMAP_INFOLINE_HINT3, 0.40, 0.40, 0.40, false);
	WorldMapTooltip:AddLine(METAMAP_INFOLINE_HINT4, 0.40, 0.40, 0.40, false);

	WorldMapPOIFrame.allowBlobTooltip = false;
	WorldMapTooltip:Show();
	--WorldMapTooltip:SetFrameLevel(WorldMapFrame:GetFrameLevel() + 20);
end

function MetaMap_SetTTInfoLine(zoneName, Button, Tooltip)
	local zName, zIndex, zType = MetaMap_GetZoneTableEntry(zoneName);
	Tooltip:SetOwner(Button, "ANCHOR_BOTTOMLEFT");
	if (zType == "RDI" or zType == "DNI" or zType == "SCN") then
		local zoneTable = MetaMap_ZoneTable[zIndex];
		Tooltip:SetText(zName, 1, 1, 0, false);
		Tooltip:AddLine(METAMAP_STRING_LOCATION..": ".."|cffffffff"..zoneTable.Location, 1, 1, 0, false);
		Tooltip:AddLine(METAMAP_STRING_LEVELRANGE..": ".."|cffffffff"..zoneTable.LevelRange, 1, 1, 0, false);
		Tooltip:AddLine(METAMAP_STRING_PLAYERLIMIT..": ".."|cffffffff"..zoneTable.PlayerLimit, 1, 1, 0, false);
		Tooltip:AddLine(" ");
		Tooltip:AddDoubleLine(METAMAP_SEVEDINSTANCES, "ID:");
		if (GetNumSavedInstances() > 0) then
			for i = 1, GetNumSavedInstances() do
				local name, ID, remaining = GetSavedInstanceInfo(i);
				remaining = SecondsToTime(remaining);
				Tooltip:AddDoubleLine(name, "|cffffffff"..ID, 0, 1, 0, false);
				Tooltip:AddLine("|cffffffff"..remaining);
			end
		else
			Tooltip:AddLine(METAMAP_NO_SAVED_INSTANCES);
		end
	elseif (zType == "SZ" or zType == "MSZ" or zType == "SZR" or zType == "BG") then
		local zoneTable = MetaMap_ZoneTable[zIndex];
		local fColor = {}; local lColor = {};
		local Neutral = { r = 0.9, g = 0.8, b = 0.2 };
		local Friendly = { r = 0.2, g = 0.9, b = 0.2 };
		local Hostile = { r = 0.9, g = 0.2, b = 0.2 };
		local Contested = { r = 0.8, g = 0.6, b = 0.4 };
		local player_faction = UnitFactionGroup("player");
		local faction = zoneTable.faction;
		if (faction == "Contested") then
			fColor = Contested;				
		elseif (faction == "Neutral") then
			fColor = Neutral;
		elseif (faction == player_faction) then
			fColor = Friendly;
		else
			fColor = Hostile;
		end
		if (UnitLevel("player") > zoneTable.hlvl) then
			lColor = { r = 0.5, g = 0.5, b = 0.5 };				
		elseif (UnitLevel("player") < zoneTable.llvl) then
			lColor = Hostile;
		else
			lColor = Friendly;
		end
		local faction_lc;
		if (faction == "Contested") then faction_lc = METAMAP_FACTION_CONTESTED; end
		if (faction == "Neutral") then faction_lc = METAMAP_FACTION_NEUTRAL; end
		if (faction == "Alliance") then faction_lc = FACTION_ALLIANCE; end
		if (faction == "Horde") then faction_lc = FACTION_HORDE; end
		Tooltip:AddDoubleLine(zName, faction_lc, fColor.r, fColor.g, fColor.b, fColor.r, fColor.g, fColor.b, false);
		Tooltip:AddDoubleLine(METAMAP_STRING_LEVELRANGE, zoneTable.llvl.." - "..zoneTable.hlvl, 1, 1, 0, lColor.r, lColor.g, lColor.b, false);
	else
		Tooltip:SetText(zoneName, 1, 1, 1, false);
	end
	Tooltip:AddLine(" ");

	Tooltip:Show();
end

function MetaMap_ToggleOptions(key, value)
	if (value) then
		MetaMapOptions[key] = value;
	else
		MetaMapOptions[key] = not MetaMapOptions[key];
	end

	MetaMapOptions_Init();

	return MetaMapOptions[key];
end

function MetaMap_SubMenuFix(self)
	local value, text;
	MetaMap_Debug_Print("MetaMap_SubMenuFix:Self="..self:GetName(),true);
	value = UIDROPDOWNMENU_MENU_VALUE;
	if (type(value) == "table") then
		text = value["func"];
	end
	return value, text;
end

function MetaMap_ColorSelect(self)
	local R, G, B = unpack(self.color);
	ColorPickerFrame.func = MetaMap_SetColor;
	ColorPickerFrame.cancelFunc = MetaMap_CancelColor;
	ColorPickerFrame.func2 = self.func;
	ColorPickerFrame.option = self.option;
	ColorPickerFrame.previousValues = {R, G, B};
	ColorPickerFrame:SetFrameStrata("FULLSCREEN");
	ColorPickerFrame:Show();
	ColorPickerFrame:SetColorRGB(R, G, B);
end

function MetaMap_SetColor()
	local R, G, B = ColorPickerFrame:GetColorRGB();
	ColorPickerFrame.func2(ColorPickerFrame.option, R, G, B);
end

function MetaMap_CancelColor(prevColors)
	local R, G, B = unpack(prevColors);
	ColorPickerFrame.func2(ColorPickerFrame.option, R, G, B);
end

function MetaMap_ContextHelp(title)
	if (not MetaMap_DialogFrame:IsVisible()) then
		MetaMapExtOptions_Toggle();
	end
	PanelTemplates_SetTab(MetaMap_DialogFrame, 6);
	if (MetaMap_LoadHLP()) then
		MetaMap_ToggleDialog("MetaMap_HelpDialog");
		HLP_DisplayOption(HLP_HelpData.Modules[title], 2, title);
		UIDropDownMenu_SetText(HLP_MenuSelect, title);
	end
end

--[[ -- not used
function MetaMap_CaptureZones()
	MetaMap_ZoneCapture = {};
	for continentKey, continentName in ipairs{GetMapContinents()} do
		MetaMap_ZoneCapture[continentKey] = {};
		for zoneKey, zoneName in ipairs{GetMapZones(continentKey)} do
			if (MetaMap_ZoneCapture[continentKey][zoneKey] == nil) then
				MetaMap_ZoneCapture[continentKey][zoneKey] = {};
			end
			MetaMap_ZoneCapture[continentKey][zoneKey] = zoneName;
		end
	end
	MetaMap_Print("New Zones captured to SavedVariables\\MetaMap.lua", true);
end
]]

--[[ -- commented out in MetaMap.xml
function MetaMap_DevTools()
	if (not IsAddOnLoaded("MetaMapXTM")) then
		LoadAddOn("MetaMapXTM");
	end
	if (IsAddOnLoaded("MetaMapXTM")) then
		XTM_MenuSelect();
	end
end
]]

----------------
-- FuBar Support
----------------
function MetaMap_FuBar_OnLoad()
	if (AceLibrary("AceAddon-2.0") == nil) then return; end
	MetaMapFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0");
	MetaMapFu.hasIcon = METAMAP_ICON;
	MetaMapFu.name = METAMAP_TITLE;
	MetaMapFu.version = METAMAP_VERSION;
	MetaMapFu.description = METAMAP_DESC;
	MetaMapFu.category = "Map";
	MetaMapFu.hasNoText = true;
	MetaMapFu.description = METAMAP_DESC;

	function MetaMapFu:OnInitialize()
		if (FuBar2DB.profiles.Default.detached.MetaMap) then
			MetaMapFu.hideWithoutStandby = true;
		end
	end

	function MetaMapFu:OnClick()
		if (IsControlKeyDown()) then
			MetaMap_DevTools();
		else
			MetaMap_ToggleFrame(WorldMapFrame);
		end
	end

	function MetaMapFu:OnTooltipUpdate()
		GameTooltip:Hide();
		MetaMap_MainMenuSelect("FuBarPluginMetaMapFrame");
	end
end

----------------
-- Titan Support
----------------
function MetaMap_TitanPanelButton_OnLoad(self)
	self.registry = { 
		id = METAMAP_TITAN_ID,
		version = METAMAP_VERSION,
		menuText = METAMAP_TITLE,
		category = METAMAP_CATEGORY,
		tooltipTitle = METAMAP_TITLE ,
		tooltipTextFunction = "MetaMap_TitanPanelButton_GetTooltipText",
		frequency = METAMAP_TITAN_FREQUENCY, 
		icon = METAMAP_ICON,
		iconWidth = 16,
		savedVariables = {
		ShowIcon = 1,
		}
	};
end

function MetaMap_TitanPanelButton_GetTooltipText()
	if (MetaMapOptions.MenuMode) then
		retText = METAMAP_BUTTON_TOOLTIP1.."\n"..METAMAP_BUTTON_TOOLTIP2;
		return retText;
	end
end

function MetaMap_TitanPanelButton_OnClick(button)
	if ( button == "LeftButton" ) then
		MetaMap_ToggleFrame(WorldMapFrame);
	end
end

-----------
-- FlightMap
-----------
function MetaMap_FlightMapOptions_Toggle()
	FlightMapOptionsFrame:SetFrameStrata("FULLSCREEN");
	MetaMap_ToggleFrame(FlightMapOptionsFrame);
end

------------------------------------------------------------
--- The following functions are available for external calls
--- It is global so, simply CALL the function.
--- No need for hooking, unless stated otherwise. :)
------------------------------------------------------------
function MetaMap_SetNewNote(mapName, xPos, yPos, name, inf1, inf2, creator, icon, ncol, in1c, in2c, mininote, mLevel)
	local noteAdded, noteID = MetaMap_AddNewNote(mapName, xPos, yPos, name, inf1, inf2, creator, icon, ncol, in1c, in2c, mininote, mLevel);
	return noteAdded, noteID;
--Note accepted: noteAdded is returned as true, noteID  returns the NEW note index number.
--		Note rejected: noteAdded is returned as false, noteID returns the NEAR note index number.
--		The optional [mininote] parameter sets a Mininote as follows:
--		0 - Sets Mapnote only
--		1 - Sets Mapnote + Mininote
--		2 - Sets Mininote only
--		Nil or any other value defaults to value 0
end

function MetaMap_SetMiniNote(id, mapName, xPos, yPos, name, inf1, inf2, creator, icon, ncol, in1c, in2c)
	MetaMap_AddMiniNote(id, mapName, xPos, yPos, name, inf1, inf2, creator, icon, ncol, in1c, in2c);
end

function MetaMap_RemoveMapNote(id, mapName)
	MetaMap_DeleteMapNote(id, mapName);
end

function MetaMap_KBMenu_RBSelect(id)
	-- Initiated when RightClicking on KB display item.
	-- Slot assigned to MetaMapBWP.
end

function MetaMap_KBMenu_CRBSelect(id)
	-- Available for other mods to run their own routine.
	-- Initiated when CTRL+RightClicking on KB display item.
	-- Usage: MetaMap_KBMenu_CRBSelect = MyFunction
end

function MetaMap_KBMenu_SRBSelect(id)
	-- Available for other mods to run their own routine.
	-- Initiated when Shift+RightClicking on KB display item.
	-- Usage: MetaMap_KBMenu_SRBSelect = MyFunction
end

function MetaMapNotes_RBSelect(id)
	-- Initiated when RightClicking on a map note.
	-- Slot assigned to MetaMapBWP.
end

function MetaMapNotes_CRBSelect(id)
	-- Available for other mods to run their own routine.
	-- Initiated when CTRL+RightClicking on a map note.
	-- Usage: MetaMapNotes_CRBSelect = MyFunction
end

function MetaMapNotes_SRBSelect(id)
	-- Available for other mods to run their own routine.
	-- Initiated when Shift+RightClicking on a map note.
	-- Usage: MetaMapNotes_SRBSelect = MyFunction
end

-- manual fix for re-positioning of Stormwind City notes
-- ONLY EXECUTE THE FOLLOWING SLASH COMMAND IF YOU NEED -ALL- OF YOUR STORMWIND CITY NOTES ADJUSTING
-- Your Stormwind City note positions will be scaled and shifted to account for the new city map
-- This function for Stormwind map adjustments was borrowed from MapNotes
function MetaMapStormwindFix(again)
	if (again and again ~= "again") then again = nil; end
	if (not again and MetaMap_Notes and MetaMap_Notes.StormwindFixed) then
		MetaMap_Print(" The Stormwind City map notes were previously adjusted.", 1);
		MetaMap_Print(" If you are absolutely sure of what you are doing, you can force the adjustment again by typing"..
			" \'/script MetaMapStormwindFix(\"again\")\'", 1);	
		return;
	end
	local x, y;
	local moved = 0;
	if (MetaMap_Notes == nil) then MetaMap_Notes = {}; end
	for i, n in pairs(MetaMap_Notes["Stormwind City"]) do
		x = n.xPos * 0.76 + 0.203;
		if ( x > 0.9999 ) then x = 0.9999; end
		y = n.yPos * 0.76 + 0.253;
		if ( y > 0.9999 ) then y = 0.9999; end
		n.xPos = x;
		n.yPos = y;
		moved = moved + 1;
	end
	MetaMap_Print(moved.." Stormwind City map notes were adjusted.", 1); -- msg, display, r, g, b
	MetaMap_Notes.StormwindFixed = nil; --removed due to it causeing MetaMapEXP errors
end

function MetaMapStormwindUnfix(again)
	if (again and again ~= "again") then again = nil; end
	if (not again and MetaMap_Notes and MetaMap_Notes.StormwindFixed) then
		MetaMap_Print(" The Stormwind City map notes were previously un-adjusted.", 1);
		MetaMap_Print(" If you are absolutely sure of what you are doing, you can force the un-adjustment again by typing"..
			" \'/script MetaMapStormwindunfix(\"again\")\'", 1);	
		return;
	end
	local x, y;
	local moved = 0;
	if (MetaMap_Notes == nil) then MetaMap_Notes = {}; end
	for i, n in pairs(MetaMap_Notes["Stormwind City"]) do
		x = (n.xPos - 0.203 ) / 0.76;
		if ( x > 0.9999 ) then x = 0.9999; end
		y = (n.yPos - 0.253) / 0.76;
		if ( y > 0.9999 ) then y = 0.9999; end
		n.xPos = x;	n.yPos = y;
		moved = moved + 1;
	end
	MetaMap_Print(moved.." Stormwind City map notes were un-adjusted.", 1); -- msg, display, r, g, b
	MetaMap_Notes.StormwindFixed = nil; --removed due to it causeing MetaMapEXP errors
end

function MetaMap_ZoneMenu_Initialize(self)
	MetaMap_Debug_Print("MetaMap_ZoneMenu_Initialize:"..UIDROPDOWNMENU_MENU_LEVEL, true);
	if (UIDROPDOWNMENU_MENU_LEVEL == 2) then
		local menuVal = MetaMap_SubMenuFix(self);
		
		if (menuVal ~= nil) then
				MetaMap_Debug_Print("MetaMap_SubMenuFix:"..UIDROPDOWNMENU_MENU_LEVEL.."="..menuVal, true);
		else
				MetaMap_Debug_Print("MetaMap_SubMenuFix menuVal was nil", true);
		end

		local menuList = {};
		for index, zoneTable in pairs(MetaMap_ZoneTable) do
--			if (zoneTable.ztype == "SZ") then
--				local c = zoneTable.Continent;
--				if (c == nil) then c = 0; end
--				MetaMap_Debug_Print(c..zoneTable[MetaMap_Locale],true);
--			end 
			if (zoneTable.ztype == "SZ" and zoneTable.Continent == menuVal) then
				local name = MetaMap_MergeZoneName(zoneTable);
				table.insert(menuList, {location = name});
			end
		end
		local sort = MetaMap_sortType;
		MetaMap_sortType = METAMAP_SORTBY_LOCATION;
		table.sort(menuList, MetaMap_SortCriteria);
		MetaMap_sortType = sort;
		for zKey, zName in pairs(menuList) do
			local info = {};
			info.checked = nil;
			info.notCheckable = 1;
			info.text = zName.location;
			info.textHeight = MetaMapOptions.MenuFont;
			info.value = zName.location;
			info.disabled = false;
			info.notClickable = false;
			info.isTitle = false;
			info.func = MetaMap_ZoneMenu_OnClick;
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
		end
	else
		for index, cName in pairs(MetaMap_Continents) do
			if (index > 0) then
				local info = {};
				info.text = cName;
				info.hasArrow = 1;
				info.value = index;
				info.notCheckable = 1;
				info.notClickable = false;
				info.textHeight = MetaMapOptions.MenuFont;
				info.func = MetaMap_ZoneMenu_Continent_OnClick;
				UIDropDownMenu_AddButton(info);
			end
		end
	end
end

-- move list frame to stay inside the screen
function MetaMap_ToggleDropDownMenu()
	local listFrame2 = _G["DropDownList2"];
	local listFrame3 = _G["DropDownList3"];
	local shown2 = listFrame2:IsShown();
	local shown3 = false;
	if (listFrame3 and listFrame3:IsShown()) then shown3 = true; end
	if ( WorldMapFrame:IsVisible() and shown2 and not shown3 ) then
		local top = listFrame2:GetTop();
		local shift = top - GetScreenHeight();
		if (shift > 0) then
			local point, relativeTo, relativePoint, xOffset, yOffset = listFrame2:GetPoint(1);
			listFrame2:ClearAllPoints();
			listFrame2:SetPoint(point, relativeTo, relativePoint, xOffset, yOffset - shift);
		end
	end
end

function MetaMap_ZoneMenu_Continent_OnClick(self)
	MetaMap_Debug_Print("MetaMap_ZoneMenu_Continent_OnClick: "..self.value, true);

	MetaMapOptions.MetaMapZone = MetaMap_Continents[self.value];
	MetaMap_ShowInstance(frame, false);
	SetMapZoom(MetaMap_NameToZoneID(MetaMap_Continents[self.value]));

	MetaMap_SaveCurrentMapData();
end

function MetaMap_ZoneMenu_OnClick(self)
	MetaMap_Debug_Print("MetaMap_ZoneMenu_OnClick: "..self.value, true);

	MetaMapOptions.MetaMapZone = self.value;
	MetaMap_ShowInstance(frame, false);
	
	local zone, mapid = MetaMap_NameToZoneID(self.value);
	if ( (mapid ~= 0) and (zone == -1) ) then
		MetaMap_Debug_Print("MetaMap_ZoneMenu_OnClick: mapid:"..mapid,true);
		SetMapByID(mapid);
	else
		MetaMap_Debug_Print("MetaMap_ZoneMenu_OnClick: zone:"..zone..", mapid:"..mapid,true);
		SetMapZoom(zone, mapid);
	end;

	MetaMap_SaveCurrentMapData();
end

-- correction of the in-game RealZoneText
function MetaMap_GetRealZoneText()
	if (MetaMap_BaseMapName) then
		return MetaMap_BaseMapName;
	else
		return GetRealZoneText();
	end
end

-- link pre-instances (like BlackRock, Maraudon) to maps (normally the continent map is shown)
function MetaMap_SetMapToCurrentZone(self, mapReset)
	MetaMap_Debug_Print("MetaMap_SetMapToCurrentZone", true);
	SetMapToCurrentZone();
	local realID = GetCurrentMapAreaID();

	local realZone = GetRealZoneText();
	local _, _, _, isMicroDungeon = GetMapInfo();
	if (realZone) then
		local _, index, type = MetaMap_GetZoneTableEntry(realZone, realID);
		if ( index and (type == "SZR") and not isMicroDungeon ) then
			local mapName = MetaMap_ZoneTable[index]["Location"];
			if (mapName) then
				if (MetaMapOptions.MetaMapZone) then MetaMapOptions.MetaMapZone = mapName; end
				local _, _, _, mapid = MetaMap_GetZoneTableEntry(mapName);
				if ( mapid ~= 0 ) then
					MetaMap_Debug_Print("SetMapByID",true);
					SetMapByID(mapid);
					--SetDungeonMapLevel(0);
				else
					MetaMap_Debug_Print("SetMapZoom",true);
					SetMapZoom(MetaMap_NameToZoneID(mapName));
				end
			end
		end
	end

	if (realZone) then
		for _, zoneTable in pairs(MetaMap_ZoneTable) do
			if (zoneTable[MetaMap_Locale] == realZone) then
				if ( not zoneTable.mapid or (zoneTable.mapid == GetCurrentMapAreaID() and not isMicroDungeon) ) then
					if (zoneTable.ztype == "SZR") then
						realZone = zoneTable.Location;
					else
						realZone = MetaMap_MergeZoneName(zoneTable);
					end
				end
			end
		end
		MetaMap_BaseMapName = realZone;
		MetaMap_BaseMapLevel = GetCurrentMapDungeonLevel();
	else
		MetaMap_BaseMapName = nil;
		MetaMapOptions.MetaMapLevel = 0;
	end

	MetaMap_BaseMapID = GetCurrentMapAreaID();

	if ( not MetaMapOptions.MapChange and WorldMapFrame:IsVisible() and mapReset and self and not MetaMap_CurrentMapMicro ) then
		MetaMap_SetMapAfterRefresh(self);
	else
		if ( isMicroDungeon ) then
			MetaMapOptions.MetaMapZone = GetRealZoneText();
			MetaMapOptions.MetaMapLevel = GetCurrentMapDungeonLevel();
		else
			MetaMapOptions.MetaMapZone = MetaMap_GetRealZoneText();
			MetaMapOptions.MetaMapLevel = 0;
		end
		MetaMapOptions.ShowDNI = true;
		MetaMap_SaveCurrentMapData();

		local _, _, zType = MetaMap_GetZoneTableEntry(MetaMap_GetRealZoneText());
		if (zType == "RDI" or zType == "DNI" or zType == "BG" or zType == "SCN") then
			MetaMap_ShowInstance(self, true, true);
		else
			MetaMap_ShowInstance(self, false, true);
		end
	end
end

function MetaMap_SaveCurrentMapData()
	if (not WorldMapFrame:IsVisible()) then return; end

	local mapName = MetaMap_GetCurrentMapInfo();
	if (mapName) then
		MetaMap_CurrentMapName = mapName;
		MetaMap_CurrentMapID = GetCurrentMapAreaID();
		MetaMap_CurrentMapCID = GetCurrentMapContinent();
		MetaMap_CurrentMapZID = GetCurrentMapZone();
		MetaMap_CurrentMapLevel = GetCurrentMapDungeonLevel();
		local _, _, _, isMicroDungeon = GetMapInfo();
		MetaMap_CurrentMapMicro = isMicroDungeon;
		MetaMap_Debug_Print("CurrentMap = "..mapName.." (mapid "..MetaMap_CurrentMapID..") level "..MetaMap_CurrentMapLevel, true);
	end
end

-- re-show map displayed before a map refresh
function MetaMap_SetMapAfterRefresh(self)
	MetaMap_Debug_Print("MetaMap_SetMapAfterRefresh", true);
	if (MetaMapOptions.MapChange) then return; end
	if (not WorldMapFrame:IsVisible()) then return; end
	if (not MetaMap_CurrentMapName or not MetaMap_CurrentMapID) then return; end
	local mapID = GetCurrentMapAreaID();
	local mapLevel = GetCurrentMapDungeonLevel();
	if (mapID == MetaMap_CurrentMapID and mapLevel == MetaMap_CurrentMapLevel) then return; end

	local _, _, zType = MetaMap_GetZoneTableEntry(MetaMap_CurrentMapName);
	local mapName = MetaMap_GetCurrentMapInfo();
	if (zType == "DN" and mapName and mapName == MetaMap_CurrentMapName) then return; end

	if ( mapName ) then MetaMap_Debug_Print("Set map to: "..mapName.." (mapid "..MetaMap_CurrentMapID..") level "..MetaMap_CurrentMapLevel, true); end
	local cKey, zKey = MetaMap_NameToZoneID(MetaMap_CurrentMapName);
	if (cKey == -1 and (type(zKey) ~= "number" or zKey ~= 0)) then
		local valid = true;
		if (type(zKey) ~= "number") then
			-- check that instance name is valid
			valid = MetaMap_CheckValidZone(MetaMap_CurrentMapName);
		end
		if (valid) then
			MetaMapOptions.MetaMapZone = MetaMap_CurrentMapName;
			MetaMapOptions.MetaMapLevel = MetaMap_CurrentMapLevel;
			MetaMap_ShowInstance(self, true);
		else
			MetaMap_SaveCurrentMapData();
		end
	else
		if (MetaMap_CurrentMapZID == 0) then
			-- continent maps need to set with SetMapZoom, else (with SetMapByID) area buttons don't work
			SetMapZoom(MetaMap_CurrentMapCID, 0);
		else
			SetMapByID(MetaMap_CurrentMapID);
		end
		UIDropDownMenu_SetText(MetaMap_ZoneMenu, MetaMap_CurrentMapName);
		if (MetaMap_CurrentMapLevel ~= 0) then SetDungeonMapLevel(MetaMap_CurrentMapLevel); end
	end
end

function MetaMap_ClearCurrentMapData()
	MetaMap_CurrentMapName = nil;
	MetaMap_CurrentMapID = nil;
	MetaMap_CurrentMapZID = nil;
	MetaMap_CurrentMapCID = nil;
	MetaMap_CurrentMapLevel = 0;
	MetaMap_CurrentMapMicro = nil;
end

--[[ note
continent, zone = MetaMap_NameToZoneID(zoneText)
Returns continent and zone IDs.

mapName, mapLevel, dataZone = MetaMap_GetCurrentMapInfo();
mapName returns currently displayed map.
dataZone returns 'MetaMap_Notes[mapNameIndex]'

There is also a 'Container' frame available for displaying data etc, within the WorldMap,
in the same format as the MetaMapWKB, and MetaMapQST displays.
Referenced and parented as 'MetaMapContainerFrame'.
]]
