﻿
local cLocale = strsub(GetLocale(), 1, 2);
if (cLocale == "de" or cLocale == "fr" or cLocale == "es" or cLocale == "ru") then
	MetaMap_Locale = cLocale;
else
	MetaMap_Locale = "en";
end

METAMAP_WLK_INFO = "Northrend Dungeon"; -- WotLK Dungeon info: needs localization
METAMAP_CTA_INFO = "Cataclysm Dungeon"; -- Cata Dungeon info: needs localization
METAMAP_MOP_INFO = "Mists of Pandaria Dungeon"; -- Mists Dungeon info: needs localization
METAMAP_MOP_SCN_INFO = "Mists of Pandaria Scenario"; -- Mists Scenario info: needs localization

MetaMap_Colors = {}
MetaMap_Colors[0] = {r = 1.0, g = 0.82, b = 0.0}
MetaMap_Colors[1] = {r = 0.55, g = 0.46, b = 0.04}
MetaMap_Colors[2] = {r = 1.0, g = 0.0, b = 0.0}
MetaMap_Colors[3] = {r = 0.56, g = 0.0, b = 0.0}
MetaMap_Colors[4] = {r = 0.0, g = 1.0, b = 0.0}
MetaMap_Colors[5] = {r = 0.0, g = 0.39, b = 0.05}
MetaMap_Colors[6] = {r = 0.42, g = 0.47, b = 0.87}
MetaMap_Colors[7] = {r = 0.25, g = 0.35, b = 0.66}
MetaMap_Colors[8] = {r = 1.0, g = 1.0, b = 1.0}
MetaMap_Colors[9] = {r = 0.65, g = 0.65, b = 0.65}

MetaMap_MapScale = {};
MetaMap_MapScale.cityscale    = {};
MetaMap_MapScale.cityscale[0] = 1.565;
MetaMap_MapScale.cityscale[1] = 1.687;
MetaMap_MapScale.cityscale[2] = 1.882;
MetaMap_MapScale.cityscale[3] = 2.210;
MetaMap_MapScale.cityscale[4] = 2.575;
MetaMap_MapScale.cityscale[5] = 2.651;
MetaMap_MapScale[1]    = {};
MetaMap_MapScale[1][0] = {xscale = 11016.6, yscale = 7399.9};
MetaMap_MapScale[1][1] = {xscale = 12897.3, yscale = 8638.1};
MetaMap_MapScale[1][2] = {xscale = 15478.8, yscale = 10368.0};
MetaMap_MapScale[1][3] = {xscale = 19321.8, yscale = 12992.7};
MetaMap_MapScale[1][4] = {xscale = 25650.4, yscale = 17253.2};
MetaMap_MapScale[1][5] = {xscale = 38787.7, yscale = 26032.1};
MetaMap_MapScale[2]    = {};
MetaMap_MapScale[2][0] = {xscale = 10448.3, yscale = 7072.7};
MetaMap_MapScale[2][1] = {xscale = 12160.5, yscale = 8197.8};
MetaMap_MapScale[2][2] = {xscale = 14703.1, yscale = 9825.0};
MetaMap_MapScale[2][3] = {xscale = 18568.7, yscale = 12472.2};
MetaMap_MapScale[2][4] = {xscale = 24390.3, yscale = 15628.5};
MetaMap_MapScale[2][5] = {xscale = 37012.2, yscale = 25130.6};
--Outlands scaling
MetaMap_MapScale[3]    = {};
MetaMap_MapScale[3][0] = {xscale = 10448.3, yscale = 7072.7};
MetaMap_MapScale[3][1] = {xscale = 12160.5, yscale = 8197.8};
MetaMap_MapScale[3][2] = {xscale = 14703.1, yscale = 9825.0};
MetaMap_MapScale[3][3] = {xscale = 18568.7, yscale = 12472.2};
MetaMap_MapScale[3][4] = {xscale = 24390.3, yscale = 15628.5};
MetaMap_MapScale[3][5] = {xscale = 37012.2, yscale = 25130.6};
--Northrend scaling (just copied from Outland values, so it may be wrong)
MetaMap_MapScale[4]    = {};
MetaMap_MapScale[4][0] = {xscale = 10448.3, yscale = 7072.7};
MetaMap_MapScale[4][1] = {xscale = 12160.5, yscale = 8197.8};
MetaMap_MapScale[4][2] = {xscale = 14703.1, yscale = 9825.0};
MetaMap_MapScale[4][3] = {xscale = 18568.7, yscale = 12472.2};
MetaMap_MapScale[4][4] = {xscale = 24390.3, yscale = 15628.5};
MetaMap_MapScale[4][5] = {xscale = 37012.2, yscale = 25130.6};
MetaMap_MapScale[5]    = {};
MetaMap_MapScale[5][0] = {xscale = 10448.3, yscale = 7072.7};
MetaMap_MapScale[5][1] = {xscale = 12160.5, yscale = 8197.8};
MetaMap_MapScale[5][2] = {xscale = 14703.1, yscale = 9825.0};
MetaMap_MapScale[5][3] = {xscale = 18568.7, yscale = 12472.2};
MetaMap_MapScale[5][4] = {xscale = 24390.3, yscale = 15628.5};
MetaMap_MapScale[5][5] = {xscale = 37012.2, yscale = 25130.6};
MetaMap_MapScale[6]    = {};
MetaMap_MapScale[6][0] = {xscale = 10448.3, yscale = 7072.7};
MetaMap_MapScale[6][1] = {xscale = 12160.5, yscale = 8197.8};
MetaMap_MapScale[6][2] = {xscale = 14703.1, yscale = 9825.0};
MetaMap_MapScale[6][3] = {xscale = 18568.7, yscale = 12472.2};
MetaMap_MapScale[6][4] = {xscale = 24390.3, yscale = 15628.5};
MetaMap_MapScale[6][5] = {xscale = 37012.2, yscale = 25130.6};

--- ZoneName matrix for English/German/French/Spanish/Russian, extracted from v5.0.4
--- The dungeon levels are the LFG levels and taken from locale-enUS.MPQ/DBFilesClient/LfgDungeons.dbc
--- The mapid's can be found in the file misc.mpq/DBFilesClient/WorldMapArea.dbc
--- Important: the locale entries identify the location of the player, and have to fit to the shown location in the first line if mouse over the location string above the minimap.
---            This location strings are found in the in-game database in the file locale-enUS.MPQ/DBFilesClient/AreaTable.dbc
--- Important: There must not be a mapid set for ztype = "SZ"
MetaMap_ZoneTable = {
--- Kalimdor (continent 1)
	[1]   = {ztype = "SZ",  en = "Ashenvale",                        de = "Eschental",                             fr = "Orneval",                            es = "Vallefresno",                               ru = "Ясеневый лес",                                  Continent = 1,                                           llvl = 20, hlvl = 25, faction = "Contested", scale = 0.15670371525706, xoffset = 0.41757282062541, yoffset = 0.33126468682991},
	[2]   = {ztype = "SZ",  en = "Azshara",                          de = "Azshara",                               fr = "Azshara",                            es = "Azshara",                                   ru = "Азшара",                                        Continent = 1,                                           llvl = 10, hlvl = 20, faction = "Contested", scale = 0.13779501505279, xoffset = 0.55282036918049, yoffset = 0.30400571307545},
	[3]   = {ztype = "SZ",  en = "Darkshore",                        de = "Dunkelküste",                           fr = "Sombrivage",                         es = "Costa Oscura",                              ru = "Темные берега",                                 Continent = 1,                                           llvl = 10, hlvl = 20, faction = "Alliance",  scale = 0.17799008894522, xoffset = 0.38383175154516, yoffset = 0.18206216123156},
	[4]   = {ztype = "SZ",  en = "Darnassus",                        de = "Darnassus",                             fr = "Darnassus",                          es = "Darnassus",                                 ru = "Дарнас",                                        Continent = 1,                           Location =  16, llvl =  0, hlvl =  0, faction = "Alliance",  scale = 0.02876626176374, xoffset = 0.38392150175204, yoffset = 0.10441296545475},
	[5]   = {ztype = "SZ",  en = "Desolace",                         de = "Desolace",                              fr = "Désolace",                           es = "Desolace",                                  ru = "Пустоши",                                       Continent = 1,                                           llvl = 30, hlvl = 35, faction = "Contested", scale = 0.12219839120669, xoffset = 0.34873187115693, yoffset = 0.50331046935371},
	[6]   = {ztype = "SZ",  en = "Durotar",                          de = "Durotar",                               fr = "Durotar",                            es = "Durotar",                                   ru = "Дуротар",                                       Continent = 1,                                           llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.14368294970080, xoffset = 0.51709782709100, yoffset = 0.44802818134926},
	[7]   = {ztype = "SZ",  en = "Dustwallow Marsh",                 de = "Düstermarschen",                        fr = "Marécage d’Âprefange",               es = "Marjal Revolcafango",                       ru = "Пылевые топи",                                  Continent = 1,                                           llvl = 35, hlvl = 40, faction = "Contested", scale = 0.14266384095509, xoffset = 0.49026338351379, yoffset = 0.60461876174686},
	[8]   = {ztype = "SZ",  en = "Felwood",                          de = "Teufelswald",                           fr = "Gangrebois",                         es = "Frondavil",                                 ru = "Оскверненный лес",                              Continent = 1,                                           llvl = 45, hlvl = 50, faction = "Contested", scale = 0.15625084006464, xoffset = 0.41995800144849, yoffset = 0.23097545880609},
	[9]   = {ztype = "SZ",  en = "Feralas",                          de = "Feralas",                               fr = "Féralas",                            es = "Feralas",                                   ru = "Фералас",                                       Continent = 1,                                           llvl = 35, hlvl = 40, faction = "Contested", scale = 0.18885970960818, xoffset = 0.31589651244686, yoffset = 0.61820581746798},
	[10]  = {ztype = "SZ",  en = "Moonglade",                        de = "Mondlichtung",                          fr = "Reflet-de-Lune",                     es = "Claro de la Luna",                          ru = "Лунная поляна",                                 Continent = 1,                                           llvl =  1, hlvl = 60, faction = "Contested", scale = 0.06292695969921, xoffset = 0.50130287793373, yoffset = 0.17560823085517},
	[11]  = {ztype = "SZ",  en = "Mulgore",                          de = "Mulgore",                               fr = "Mulgore",                            es = "Mulgore",                                   ru = "Мулгор",                                        Continent = 1,                                           llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.13960673216274, xoffset = 0.40811854919226, yoffset = 0.53286226907346},
	[12]  = {ztype = "SZ",  en = "Orgrimmar",                        de = "Orgrimmar",                             fr = "Orgrimmar",                          es = "Orgrimmar",                                 ru = "Оргриммар",                                     Continent = 1,                           Location =   6, llvl =  0, hlvl =  0, faction = "Horde",     scale = 0.03811449638057, xoffset = 0.56378554142668, yoffset = 0.42905218646258},
	[13]  = {ztype = "SZ",  en = "Silithus",                         de = "Silithus",                              fr = "Silithus",                           es = "Silithus",                                  ru = "Силитус",                                       Continent = 1,                                           llvl = 55, hlvl = 60, faction = "Contested", scale = 0.09468465888932, xoffset = 0.39731975488374, yoffset = 0.76460608512626},
	[14]  = {ztype = "SZ",  en = "Stonetalon Mountains",             de = "Steinkrallengebirge",                   fr = "Les Serres-Rocheuses",               es = "Sierra Espolón",                            ru = "Когтистые горы",                                Continent = 1,                                           llvl = 25, hlvl = 30, faction = "Contested", scale = 0.13272833611061, xoffset = 0.37556627748617, yoffset = 0.40285135292988},
	[15]  = {ztype = "SZ",  en = "Tanaris",                          de = "Tanaris",                               fr = "Tanaris",                            es = "Tanaris",                                   ru = "Танарис",                                       Continent = 1,                                           llvl = 45, hlvl = 50, faction = "Contested", scale = 0.18750104661175, xoffset = 0.46971301480866, yoffset = 0.76120931364891},
	[16]  = {ztype = "SZ",  en = "Teldrassil",                       de = "Teldrassil",                            fr = "Teldrassil",                         es = "Teldrassil",                                ru = "Тельдрассил",                                   Continent = 1,                                           llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.13836131003639, xoffset = 0.36011098024729, yoffset = 0.03948322979210},
--old	[17]  = {ztype = "SZ",  en = "The Barrens",                      de = "Brachland",                             fr = "Les Tarides",                        es = "The Barrens",                               ru = "Степи",                                         Continent = 1,                                           llvl = 10, hlvl = 25, faction = "Horde",     scale = 0.27539211944292, xoffset = 0.39249347333450, yoffset = 0.45601063260257},
	[18]  = {ztype = "SZ",  en = "Thousand Needles",                 de = "Tausend Nadeln",                        fr = "Mille pointes",                      es = "Las Mil Agujas",                            ru = "Тысяча Игл",                                    Continent = 1,                                           llvl = 40, hlvl = 45, faction = "Contested", scale = 0.11956582877920, xoffset = 0.47554411191734, yoffset = 0.68342356389650},
	[19]  = {ztype = "SZ",  en = "Thunder Bluff",                    de = "Donnerfels",                            fr = "Les Pitons-du-Tonnerre",             es = "Cima del Trueno",                           ru = "Громовой Утес",                                 Continent = 1,                           Location =  11, llvl =  0, hlvl =  0, faction = "Horde",     scale = 0.02836291430658, xoffset = 0.44972878210917, yoffset = 0.55638479002362},
	[20]  = {ztype = "SZ",  en = "Un'Goro Crater",                   de = "Krater von Un'Goro",                    fr = "Cratère d’Un’Goro",                  es = "Cráter de Un'Goro",                         ru = "Кратер Ун'Горо",                                Continent = 1,                                           llvl = 50, hlvl = 55, faction = "Contested", scale = 0.10054401185671, xoffset = 0.44927594451520, yoffset = 0.76494573629405},
	[21]  = {ztype = "SZ",  en = "Winterspring",                     de = "Winterquell",                           fr = "Berceau-de-l’Hiver",                 es = "Cuna del Invierno",                         ru = "Зимние Ключи",                                  Continent = 1,                                           llvl = 50, hlvl = 55, faction = "Contested", scale = 0.19293573573141, xoffset = 0.47237382938446, yoffset = 0.17390990272233},
--- Eastern Kingdoms (continent 2)
	[22]  = {ztype = "SZ",  en = "Eversong Woods",                   de = "Immersangwald",                         fr = "Bois des Chants éternels",           es = "Bosque Canción Eterna",                     ru = "Леса Вечной Песни",                             Continent = 2,                                           llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.09517074521836, xoffset = 0.48982154167011, yoffset = 0.76846519986510},
	[23]  = {ztype = "SZ",  en = "Ghostlands",                       de = "Geisterlande",                          fr = "Les terres Fantômes",                es = "Tierras Fantasma",                          ru = "Призрачные земли",                              Continent = 2,                                           llvl = 10, hlvl = 20, faction = "Horde",     scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[24]  = {ztype = "SZ",  en = "Silvermoon City",                  de = "Silbermond",                            fr = "Lune-d’argent",                      es = "Ciudad de Lunargenta",                      ru = "Луносвет",                                      Continent = 2,                           Location =  22, llvl =  0, hlvl =  0, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
--- Eastern Kingdoms related map parts
	[25]  = {ztype = "SZR", en = "Blackrock Mountain",               de = "Der Schwarzfels",                       fr = "Mont Rochenoire",                    es = "Montaña Roca Negra",                        ru = "Черная гора",                                   Continent = 2,                           Location =  34, llvl = 50, hlvl = 52, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[26]  = {ztype = "SZR", en = "The Steam Pools",                  de = "Die Dampfteiche",                       fr = "Les bassins de Vapeur",              es = "Las Charcas Vaporosas",                     ru = "Дымящиеся озера",                               Continent = 1,                           Location =   9, llvl = 85, hlvl = 85, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
--- Eastern Kingdoms (continent 2)
--old	[30]  = {ztype = "SZ",  en = "Alterac Mountains",                de = "Alteracgebirge",                        fr = "Montagnes d’Alterac",                es = "Montañas de Alterac",                       ru = "Альтеракские горы",                             Continent = 2,                                           llvl = 30, hlvl = 40, faction = "Contested", scale = 0.07954563533736, xoffset = 0.43229874660542, yoffset = 0.25425926375262},
	[31]  = {ztype = "SZ",  en = "Arathi Highlands",                 de = "Arathihochland",                        fr = "Hautes-terres Arathies",             es = "Tierras Altas de Arathi",                   ru = "Нагорье Арати",                                 Continent = 2,                                           llvl = 25, hlvl = 30, faction = "Contested", scale = 0.10227310921644, xoffset = 0.47916793249546, yoffset = 0.32386170078419},
	[32]  = {ztype = "SZ",  en = "Badlands",                         de = "Ödland",                                fr = "Terres Ingrates",                    es = "Tierras Inhóspitas",                        ru = "Бесплодные земли",                              Continent = 2,                                           llvl = 45, hlvl = 48, faction = "Contested", scale = 0.07066771883566, xoffset = 0.51361415033147, yoffset = 0.56915717993261},
	[33]  = {ztype = "SZ",  en = "Blasted Lands",                    de = "Verwüstete Lande",                      fr = "Terres Foudroyées",                  es = "Las Tierras Devastadas",                    ru = "Выжженные земли",                               Continent = 2,                                           llvl = 54, hlvl = 60, faction = "Contested", scale = 0.09517074521836, xoffset = 0.48982154167011, yoffset = 0.76846519986510},
	[34]  = {ztype = "SZ",  en = "Burning Steppes",                  de = "Brennende Steppe",                      fr = "Steppes Ardentes",                   es = "Las Estepas Ardientes",                     ru = "Пылающие степи",                                Continent = 2,                                           llvl = 50, hlvl = 52, faction = "Contested", scale = 0.08321525646393, xoffset = 0.04621224670174, yoffset = 0.61780780524905},
	[35]  = {ztype = "SZ",  en = "Deadwind Pass",                    de = "Gebirgspass der Totenwinde",            fr = "Défilé de Deuillevent",              es = "Paso de la Muerte",                         ru = "Перевал Мертвого Ветра",                        Continent = 2,                                           llvl = 55, hlvl = 60, faction = "Contested", scale = 0.07102298961531, xoffset = 0.47822105868635, yoffset = 0.73863555048516},
	[36]  = {ztype = "SZ",  en = "Dun Morogh",                       de = "Dun Morogh",                            fr = "Dun Morogh",                         es = "Dun Morogh",                                ru = "Дун Морог",                                     Continent = 2,                                           llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.13991525534426, xoffset = 0.40335096278072, yoffset = 0.48339696712179},
	[37]  = {ztype = "SZ",  en = "Duskwood",                         de = "Dämmerwald",                            fr = "Bois de la Pénombre",                es = "Bosque del Ocaso",                          ru = "Сумеречный лес",                                Continent = 2,                                           llvl = 20, hlvl = 25, faction = "Contested", scale = 0.07670475476181, xoffset = 0.43087243362495, yoffset = 0.73224350550454},
	[38]  = {ztype = "SZ",  en = "Eastern Plaguelands",              de = "Östliche Pestländer",                   fr = "Maleterres de l’Est",                es = "Tierras de la Peste del Este",              ru = "Восточные Чумные земли",                        Continent = 2,                                           llvl = 40, hlvl = 45, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[39]  = {ztype = "SZ",  en = "Elwynn Forest",                    de = "Wald von Elwynn",                       fr = "Forêt d’Elwynn",                     es = "Bosque de Elwynn",                          ru = "Элвиннский лес",                                Continent = 2,                                           llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.09860350595046, xoffset = 0.41092682316676, yoffset = 0.65651531970162},
	[40]  = {ztype = "SZ",  en = "Hillsbrad Foothills",              de = "Vorgebirge des Hügellands",             fr = "Contreforts de Hautebrande",         es = "Laderas de Trabalomas",                     ru = "Предгорья Хилсбрада",                           Continent = 2,                                           llvl = 20, hlvl = 25, faction = "Contested", scale = 0.09090931690055, xoffset = 0.42424361247460, yoffset = 0.30113436864162},
	[41]  = {ztype = "SZ",  en = "Ironforge",                        de = "Eisenschmiede",                         fr = "Forgefer",                           es = "Forjaz",                                    ru = "Стальгорн",                                     Continent = 2,                           Location =  36, llvl =  0, hlvl =  0, faction = "Alliance",  scale = 0.02248317426784, xoffset = 0.47481923366335, yoffset = 0.51289242617182},
	[42]  = {ztype = "SZ",  en = "Loch Modan",                       de = "Loch Modan",                            fr = "Loch Modan",                         es = "Loch Modan",                                ru = "Лок Модан",                                     Continent = 2,                                           llvl = 10, hlvl = 20, faction = "Alliance",  scale = 0.07839152145224, xoffset = 0.51118749188138, yoffset = 0.50940913489577},
	[43]  = {ztype = "SZ",  en = "Redridge Mountains",               de = "Rotkammgebirge",                        fr = "Les Carmines",                       es = "Montañas Crestagrana",                      ru = "Красногорье",                                   Continent = 2,                                           llvl = 15, hlvl = 20, faction = "Contested", scale = 0.06170112311456, xoffset = 0.49917278340928, yoffset = 0.68359285304999},
	[44]  = {ztype = "SZ",  en = "Searing Gorge",                    de = "Sengende Schlucht",                     fr = "Gorge des Vents brûlants",           es = "La Garganta de Fuego",                      ru = "Тлеющее ущелье",                                Continent = 2,                                           llvl = 48, hlvl = 50, faction = "Contested", scale = 0.06338794005823, xoffset = 0.46372051266487, yoffset = 0.57812379382509},
	[45]  = {ztype = "SZ",  en = "Silverpine Forest",                de = "Silberwald",                            fr = "Forêt des Pins-Argentés",            es = "Bosque de Argénteos",                       ru = "Серебряный бор",                                Continent = 2,                                           llvl = 10, hlvl = 20, faction = "Horde",     scale = 0.11931848806212, xoffset = 0.35653502290090, yoffset = 0.24715695496522},
	[46]  = {ztype = "SZ",  en = "Stormwind City",                   de = "Sturmwind",                             fr = "Hurlevent",                          es = "Ciudad de Ventormenta",                     ru = "Штормград",                                     Continent = 2,                           Location =  39, llvl =  0, hlvl =  0, faction = "Alliance",  scale = 0.13819701270887, xoffset = 0.41531450060561, yoffset = 0.67097280492581},
	[47]  = {ztype = "SZ",  en = "Stranglethorn Vale",               de = "Schlingendorntal",                      fr = "Vallée de Strangleronce",            es = "Vega de Tuercespina",                       ru = "Тернистая долина",                              Continent = 2,                                           llvl = 30, hlvl = 45, faction = "Contested", scale = 0.18128603034401, xoffset = 0.39145470225916, yoffset = 0.79412224886668},
	[48]  = {ztype = "SZ",  en = "Swamp of Sorrows",                 de = "Sümpfe des Elends",                     fr = "Marais des Chagrins",                es = "Pantano de las Penas",                      ru = "Болото Печали",                                 Continent = 2,                                           llvl = 52, hlvl = 54, faction = "Contested", scale = 0.06516347991404, xoffset = 0.51769795272070, yoffset = 0.72815974701615},
	[49]  = {ztype = "SZ",  en = "The Hinterlands",                  de = "Hinterland",                            fr = "Les Hinterlands",                    es = "Tierras del Interior",                      ru = "Внутренние земли",                              Continent = 2,                                           llvl = 30, hlvl = 35, faction = "Contested", scale = 0.10937523495111, xoffset = 0.49929119700867, yoffset = 0.25567971676068},
	[50]  = {ztype = "SZ",  en = "Tirisfal Glades",                  de = "Tirisfal",                              fr = "Clairières de Tirisfal",             es = "Claros de Tirisfal",                        ru = "Тирисфальские леса",                            Continent = 2,                                           llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.12837403412087, xoffset = 0.36837217317549, yoffset = 0.15464954319582},
	[51]  = {ztype = "SZ",  en = "Undercity",                        de = "Unterstadt",                            fr = "Fossoyeuse",                         es = "Entrañas",                                  ru = "Подгород",                                      Continent = 2,                           Location =  50, llvl =  0, hlvl =  0, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[52]  = {ztype = "SZ",  en = "Western Plaguelands",              de = "Westliche Pestländer",                  fr = "Maleterres de l’Ouest",              es = "Tierras de la Peste del Oeste",             ru = "Западные Чумные земли",                         Continent = 2,                                           llvl = 35, hlvl = 40, faction = "Contested", scale = 0.12215946583965, xoffset = 0.44270955019641, yoffset = 0.17471356786018},
	[53]  = {ztype = "SZ",  en = "Westfall",                         de = "Westfall",                              fr = "Marche de l’Ouest",                  es = "Páramos de Poniente",                       ru = "Западный Край",                                 Continent = 2,                                           llvl = 10, hlvl = 15, faction = "Alliance",  scale = 0.09943208435841, xoffset = 0.36884571674582, yoffset = 0.71874918595783},
	[54]  = {ztype = "SZ",  en = "Wetlands",                         de = "Sumpfland",                             fr = "Les Paluns",                         es = "Los Humedales",                             ru = "Болотина",                                      Continent = 2,                                           llvl = 20, hlvl = 25, faction = "Contested", scale = 0.11745423014662, xoffset = 0.46561438951659, yoffset = 0.40971063365152},
--- Kalimdor (continent 1)
	[55]  = {ztype = "SZ",  en = "Azuremyst Isle",                   de = "Azurmythosinsel",                       fr = "Île de Brume-Azur",                  es = "Isla Bruma Azur",                           ru = "Остров Лазурной Дымки",                         Continent = 1,                                           llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.09860350595046, xoffset = 0.41092682316676, yoffset = 0.65651531970162},
	[56]  = {ztype = "SZ",  en = "Bloodmyst Isle",                   de = "Blutmythosinsel",                       fr = "Île de Brume-Sang",                  es = "Isla Bruma de Sangre",                      ru = "Остров Кровавой Дымки",                         Continent = 1,                                           llvl = 10, hlvl = 20, faction = "Alliance",  scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[57]  = {ztype = "SZ",  en = "The Exodar",                       de = "Die Exodar",                            fr = "L’Exodar",                           es = "El Exodar",                                 ru = "Экзодар",                                       Continent = 1,                           Location =  55, llvl =  0, hlvl =  0, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
--- Eastern Kingdoms (continent 2)
	[58]  = {ztype = "DNI", en = "Plaguelands: The Scarlet Enclave", de = "Pestländer: Die Scharlachrote Enklave", fr = "Maleterres : l’enclave Écarlate",    es = "Tierras de la Peste: El Enclave Escarlata", ru = "Чумные земли: Анклав Алого ордена",             Continent = 2,              mapid = 502, Location =  38, LevelRange = "55-58",        PlayerLimit = "Deathknight Starting Area"},
--- Outlands (continent 3)
	[60]  = {ztype = "SZ",  en = "Hellfire Peninsula",               de = "Höllenfeuerhalbinsel",                  fr = "Péninsule des Flammes infernales",   es = "Península del Fuego Infernal",              ru = "Полуостров Адского Пламени",                    Continent = 3,                                           llvl = 58, hlvl = 62, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[61]  = {ztype = "SZ",  en = "Blade's Edge Mountains",           de = "Schergrat",                             fr = "Les Tranchantes",                    es = "Montañas Filospada",                        ru = "Острогорье",                                    Continent = 3,                                           llvl = 64, hlvl = 66, faction = "Contested", scale = 0.09517074521836, xoffset = 0.48982154167011, yoffset = 0.76846519986510},
	[62]  = {ztype = "SZ",  en = "Nagrand",                          de = "Nagrand",                               fr = "Nagrand",                            es = "Nagrand",                                   ru = "Награнд",                                       Continent = 3,                                           llvl = 64, hlvl = 66, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[63]  = {ztype = "SZ",  en = "Netherstorm",                      de = "Nethersturm",                           fr = "Raz-de-Néant",                       es = "Tormenta Abisal",                           ru = "Пустоверть",                                    Continent = 3,                                           llvl = 66, hlvl = 70, faction = "Neutral",   scale = 0.09468465888932, xoffset = 0.39731975488374, yoffset = 0.76460608512626},
	[64]  = {ztype = "SZ",  en = "Shadowmoon Valley",                de = "Schattenmondtal",                       fr = "Vallée d’Ombrelune",                 es = "Valle Sombraluna",                          ru = "Долина Призрачной Луны",                        Continent = 3,                                           llvl = 67, hlvl = 70, faction = "Contested", scale = 0.13779501505279, xoffset = 0.55282036918049, yoffset = 0.30400571307545},
	[65]  = {ztype = "SZ",  en = "Shattrath City",                   de = "Shattrath",                             fr = "Shattrath",                          es = "Ciudad de Shattrath",                       ru = "Шаттрат",                                       Continent = 3,                                           llvl =  0, hlvl =  0, faction = "Neutral",   scale = 0.02836291430658, xoffset = 0.44972878210917, yoffset = 0.55638479002362},
	[66]  = {ztype = "SZ",  en = "Terokkar Forest",                  de = "Wälder von Terokkar",                   fr = "Forêt de Terokkar",                  es = "Bosque de Terokkar",                        ru = "Лес Тероккар",                                  Continent = 3,                                           llvl = 62, hlvl = 64, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[67]  = {ztype = "SZ",  en = "Zangarmarsh",                      de = "Zangarmarschen",                        fr = "Marécage de Zangar",                 es = "Marisma de Zangar",                         ru = "Зангартопь",                                    Continent = 3,                                           llvl = 60, hlvl = 62, faction = "Contested", scale = 0.15670371525706, xoffset = 0.41757282062541, yoffset = 0.33126468682991},
--- BattleGrounds
	[70]  = {ztype = "BG",  en = "Warsong Gulch",                    de = "Kriegshymnenschlucht",                  fr = "Goulet des Chanteguerres",           es = "Garganta Grito de Guerra",                  ru = "Ущелье Песни Войны",                            Continent = 1,              mapid = 443, Location = 240, llvl = 10, hlvl = 85, faction = "Contested", scale = 0.035,            xoffset = 0.41757282062541, yoffset = 0.33126468682991, xscale = 12897.3, yscale = 8638.1},
	[71]  = {ztype = "BG",  en = "Alterac Valley",                   de = "Alteractal",                            fr = "Vallée d’Alterac",                   es = "Valle de Alterac",                          ru = "Альтеракская долина",                           Continent = 2,              mapid = 401, Location =  40, llvl = 45, hlvl = 85, faction = "Contested", scale = 0.13,             xoffset = 0.41757282062541, yoffset = 0.33126468682991, xscale = 12897.3, yscale = 8638.1},
	[72]  = {ztype = "BG",  en = "Arathi Basin",                     de = "Arathibecken",                          fr = "Bassin Arathi",                      es = "Cuenca de Arathi",                          ru = "Низина Арати",                                  Continent = 2,              mapid = 461, Location =  31, llvl = 10, hlvl = 85, faction = "Contested", scale = 0.045,            xoffset = 0.41757282062541, yoffset = 0.33126468682991, xscale = 12897.3, yscale = 8638.1},
	[73]  = {ztype = "BG",  en = "Eye of the Storm",                 de = "Auge des Sturms",                       fr = "L’Œil du cyclone",                   es = "Ojo de la Tormenta",                        ru = "Око Бури",                                      Continent = 3,              mapid = 482, Location =  63, llvl = 35, hlvl = 85, faction = "Contested", scale = 0.1,              xoffset = 0.41757282062541, yoffset = 0.33126468682991, xscale = 12897.3, yscale = 8638.1},
	[74]  = {ztype = "BG",  en = "Strand of the Ancients",           de = "Strand der Uralten",                    fr = "Rivage des Anciens",                 es = "Playa de los Ancestros",                    ru = "Берег Древних",                                 Continent = 4,              mapid = 512, Location = 201, llvl = 65, hlvl = 85, faction = "Contested", scale = 0.1,              xoffset = 0.41757282062541, yoffset = 0.33126468682991, xscale = 12897.3, yscale = 8638.1},
	[75]  = {ztype = "BG",  en = "Isle of Conquest",                 de = "Insel der Eroberung",                   fr = "Île des Conquérants",                es = "Isla de la Conquista",                      ru = "Остров Завоеваний",                             Continent = 4,              mapid = 540, Location = 208, llvl = 75, hlvl = 85, faction = "Contested", scale = 0.1,              xoffset = 0.41757282062541, yoffset = 0.33126468682991, xscale = 12897.3, yscale = 8638.1},
	[76]  = {ztype = "BG",  en = "The Battle for Gilneas",           de = "Die Schlacht um Gilneas",               fr = "La bataille de Gilnéas",             es = "La Batalla por Gilneas",                    ru = "Битва за Гилнеас",                              Continent = 2,              mapid = 736, Location = 232, llvl = 85, hlvl = 85, faction = "Contested", scale = 0.1,              xoffset = 0.41757282062541, yoffset = 0.33126468682991, xscale = 12897.3, yscale = 8638.1},
	[77]  = {ztype = "BG",  en = "Twin Peaks",                       de = "Zwillingsgipfel",                       fr = "Pics-Jumeaux",                       es = "Cumbres Gemelas",                           ru = "Два Пика",                                      Continent = 1,              mapid = 626, Location = 227, llvl = 85, hlvl = 85, faction = "Contested", scale = 0.1,              xoffset = 0.41757282062541, yoffset = 0.33126468682991, xscale = 12897.3, yscale = 8638.1},
--- Instances (Kalimdor)
	[80]  = {ztype = "DNI", en = "Blackfathom Deeps",                de = "Tiefschwarze Grotte",                   fr = "Profondeurs de Brassenoire",         es = "Cavernas de Brazanegra",                    ru = "Непроглядная Пучина",                           Continent = 1,              mapid = 688, Location =   1, LevelRange = "20-30",        PlayerLimit =  "5", infoline = METAMAP_BFD_INFO},
	[81]  = {ztype = "DNI", en = "Dire Maul",                        de = "Düsterbruch",                           fr = "Hache-Tripes",                       es = "La Masacre",                                ru = "Забытый Город",                                 Continent = 1,              mapid = 699, Location =   9, LevelRange = "36-52",        PlayerLimit =  "5", infoline = METAMAP_DMC_INFO},
--old	[82]  = {ztype = "DN",  en = "Dire Maul East",                   de = "Düsterbruch Ost",                       fr = "Hache-Tripes Est",                   es = "La Masacre Este",                           ru = "Забытый Город -восток",                         Continent = 1,                           Location =   9, LevelRange = "56-60",        PlayerLimit =  "5", infoline = METAMAP_DMC_INFO, texture = "DireMaulEast"},
--old	[83]  = {ztype = "DN",  en = "Dire Maul North",                  de = "Düsterbruch Nord",                      fr = "Hache-Tripes Nord",                  es = "La Masacre Norte",                          ru = "Забытый Город -север",                          Continent = 1,                           Location =   9, LevelRange = "56-60",        PlayerLimit =  "5", infoline = METAMAP_DMC_INFO, texture = "DireMaulNorth"},
--old	[84]  = {ztype = "DN",  en = "Dire Maul West",                   de = "Düsterbruch West",                      fr = "Hache-Tripes Ouest",                 es = "La Masacre Oeste",                          ru = "Забытый Город - запад",                         Continent = 1,                           Location =   9, LevelRange = "56-60",        PlayerLimit =  "5", infoline = METAMAP_DMC_INFO, texture = "DireMaulWest"},
	[85]  = {ztype = "DNI", en = "Maraudon",                         de = "Maraudon",                              fr = "Maraudon",                           es = "Maraudon",                                  ru = "Мародон",                                       Continent = 1,              mapid = 750, Location =   5, LevelRange = "30-44",        PlayerLimit =  "5", infoline = METAMAP_MDN_INFO},
	[86]  = {ztype = "RDI", en = "Onyxia's Lair",                    de = "Onyxias Hort",                          fr = "Repaire d’Onyxia",                   es = "Guarida de Onyxia",                         ru = "Логово Ониксии",                                Continent = 1,              mapid = 718, Location =   7, LevelRange = "80-83",        PlayerLimit = "25", infoline = METAMAP_ONL_INFO},
	[87]  = {ztype = "DNI", en = "Ragefire Chasm",                   de = "Der Flammenschlund",                    fr = "Gouffre de Ragefeu",                 es = "Sima Ígnea",                                ru = "Огненная пропасть",                             Continent = 1,              mapid = 680, Location =  12, LevelRange = "15-21",        PlayerLimit =  "5", infoline = METAMAP_RFC_INFO},
	[88]  = {ztype = "DNI", en = "Razorfen Downs",                   de = "Hügel der Klingenhauer",                fr = "Souilles de Tranchebauge",           es = "Zahúrda Rajacieno",                         ru = "Курганы Иглошкурых",                            Continent = 1,              mapid = 760, Location =  18, LevelRange = "40-50",        PlayerLimit =  "5", infoline = METAMAP_RFD_INFO},
	[89]  = {ztype = "DNI", en = "Razorfen Kraul",                   de = "Kral der Klingenhauer",                 fr = "Kraal de Tranchebauge",              es = "Horado Rajacieno",                          ru = "Лабиринты Иглошкурых",                          Continent = 1,              mapid = 761, Location = 241, LevelRange = "30-40",        PlayerLimit =  "5", infoline = METAMAP_RFK_INFO},
	[90]  = {ztype = "DNI", en = "Wailing Caverns",                  de = "Die Höhlen des Wehklagens",             fr = "Cavernes des Lamentations",          es = "Cuevas de los Lamentos",                    ru = "Пещеры Стенаний",                               Continent = 1,              mapid = 749, Location = 240, LevelRange = "15-25",        PlayerLimit =  "5", infoline = METAMAP_TWC_INFO},
	[91]  = {ztype = "DNI", en = "Zul'Farrak",                       de = "Zul'Farrak",                            fr = "Zul’Farrak",                         es = "Zul'Farrak",                                ru = "Зул'Фаррак",                                    Continent = 1,              mapid = 686, Location =  15, LevelRange = "44-54",        PlayerLimit =  "5", infoline = METAMAP_ZFK_INFO},
	[92]  = {ztype = "RDI", en = "Ahn'Qiraj",                        de = "Ahn'Qiraj",                             fr = "Ahn’Qiraj",                          es = "Ahn'Qiraj",                                 ru = "Ан'Кираж",                                      Continent = 1,              mapid = 766, Location =  13, LevelRange = "60+",          PlayerLimit = "40", infoline = METAMAP_TAQ_INFO},
	[93]  = {ztype = "RDI", en = "Ruins of Ahn'Qiraj",               de = "Ruinen von Ahn'Qiraj",                  fr = "Ruines d’Ahn’Qiraj",                 es = "Ruinas de Ahn'Qiraj",                       ru = "Руины Ан'Киража",                               Continent = 1,              mapid = 717, Location =  13, LevelRange = "60+",          PlayerLimit = "20", infoline = METAMAP_RAQ_INFO},
--- Instances (Eastern Kingdoms)
	[94]  = {ztype = "DNI", en = "Blackrock Depths",                 de = "Schwarzfelstiefen",                     fr = "Profondeurs de Rochenoire",          es = "Profundidades de Roca Negra",               ru = "Глубины Черной горы",                           Continent = 2,              mapid = 704, Location =  44, LevelRange = "47-61",        PlayerLimit =  "5", infoline = METAMAP_BRD_INFO},
	[95]  = {ztype = "DNI", en = "Blackrock Spire",                  de = "Schwarzfelsspitze",                     fr = "Pic Rochenoire",                     es = "Cumbre de Roca Negra",                      ru = "Пик Черной горы",                               Continent = 2,              mapid = 721, Location =  44, LevelRange = "55-65",        PlayerLimit =  "5", infoline = METAMAP_BRS_INFO},
	[97]  = {ztype = "RDI", en = "Blackwing Lair",                   de = "Pechschwingenhort",                     fr = "Repaire de l’Aile noire",            es = "Guarida de Alanegra",                       ru = "Логово Крыла Тьмы",                             Continent = 2,              mapid = 755, Location =  44, LevelRange = "60+",          PlayerLimit = "40", infoline = METAMAP_BWL_INFO},
	[98]  = {ztype = "DNI", en = "Gnomeregan",                       de = "Gnomeregan",                            fr = "Gnomeregan",                         es = "Gnomeregan",                                ru = "Гномреган",                                     Continent = 2,              mapid = 691, Location =  36, LevelRange = "24-34",        PlayerLimit =  "5", infoline = METAMAP_GNM_INFO},
	[99]  = {ztype = "RDI", en = "Molten Core",                      de = "Geschmolzener Kern",                    fr = "Cœur du Magma",                      es = "Núcleo de Magma",                           ru = "Огненные Недра",                                Continent = 2,              mapid = 696, Location =  44, LevelRange = "60+",          PlayerLimit = "40", infoline = METAMAP_TMC_INFO},
--old	[100] = {ztype = "DNI", en = "Scarlet Monastery",                de = "Das Scharlachrote Kloster",             fr = "Monastère Écarlate",                 es = "Monasterio Escarlata",                      ru = "Монастырь Алого ордена",                        Continent = 2,              mapid = 762, Location =  50, LevelRange = "31-34",        PlayerLimit =  "5", infoline = METAMAP_TSM_INFO},
--old	[101] = {ztype = "DNI", en = "Scholomance",                      de = "Scholomance",                           fr = "Scholomance",                        es = "Scholomance",                               ru = "Некроситет",                                    Continent = 2,              mapid = 763, Location =  52, LevelRange = "40-43",        PlayerLimit =  "5", infoline = METAMAP_SLM_INFO},
	[102] = {ztype = "DNI", en = "Shadowfang Keep",                  de = "Burg Schattenfang",                     fr = "Donjon d’Ombrecroc",                 es = "Castillo de Colmillo Oscuro",               ru = "Крепость Темного Клыка",                        Continent = 2,              mapid = 764, Location =  45, LevelRange = "16-26, 85-87", PlayerLimit =  "5", infoline = METAMAP_SFK_INFO},
	[103] = {ztype = "DNI", en = "Stratholme",                       de = "Stratholme",                            fr = "Stratholme",                         es = "Stratholme",                                ru = "Стратхольм",                                    Continent = 2,              mapid = 765, Location =  38, LevelRange = "42-56",        PlayerLimit =  "5", infoline = METAMAP_STR_INFO},
	[104] = {ztype = "DNI", en = "The Deadmines",                    de = "Die Todesminen",                        fr = "Les Mortemines",                     es = "Las Minas de la Muerte",                    ru = "Мертвые копи",                                  Continent = 2,              mapid = 756, Location =  53, LevelRange = "15-21, 85-87", PlayerLimit =  "5", infoline = METAMAP_TDM_INFO},
	[105] = {ztype = "DNI", en = "The Stockade",                     de = "Das Verlies",                           fr = "La Prison",                          es = "Las Mazmorras",                             ru = "Тюрьма",                                        Continent = 2,              mapid = 690, Location =  46, LevelRange = "20-30",        PlayerLimit =  "5", infoline = METAMAP_TSK_INFO},
	[106] = {ztype = "DNI", en = "Sunken Temple",                    de = "Versunkener Tempel",                    fr = "Temple englouti",                    es = "Templo Sumergido",                          ru = "Затонувший храм",                               Continent = 2,              mapid = 687, Location =  48, LevelRange = "50-60",        PlayerLimit =  "5", infoline = METAMAP_TST_INFO},
	[107] = {ztype = "DNI", en = "Uldaman",                          de = "Uldaman",                               fr = "Uldaman",                            es = "Uldaman",                                   ru = "Ульдаман",                                      Continent = 2,              mapid = 692, Location =  32, LevelRange = "35-45",        PlayerLimit =  "5", infoline = METAMAP_ULD_INFO},
--- BC Dungeons
	[109] = {ztype = "RDI", en = "Black Temple",                     de = "Der Schwarze Tempel",                   fr = "Temple Noir",                        es = "Templo Oscuro",                             ru = "Черный храм",                                   Continent = 3,              mapid = 796, Location =  64, LevelRange = "70+",          PlayerLimit = "25", infoline = METAMAP_TBD_INFO},
	[110] = {ztype = "DNI", en = "The Blood Furnace",                de = "Der Blutkessel",                        fr = "La Fournaise du sang",               es = "El Horno de Sangre",                        ru = "Кузня Крови",                                   Continent = 3,              mapid = 725, Location =  60, LevelRange = "59-68, 70-75", PlayerLimit =  "5", infoline = METAMAP_HFC_INFO},
	[111] = {ztype = "DNI", en = "The Shattered Halls",              de = "Die Zerschmetterten Hallen",            fr = "Les salles Brisées",                 es = "Las Salas Arrasadas",                       ru = "Разрушенные залы",                              Continent = 3,              mapid = 710, Location =  60, LevelRange = "67-75, 70-75", PlayerLimit =  "5", infoline = METAMAP_HFC_INFO},
	[112] = {ztype = "DNI", en = "The Underbog",                     de = "Der Tiefensumpf",                       fr = "La Basse-tourbière",                 es = "La Sotiénaga",                              ru = "Нижетопь",                                      Continent = 3,              mapid = 726, Location =  67, LevelRange = "61-70, 70-75", PlayerLimit =  "5", infoline = METAMAP_CFR_INFO},
	[113] = {ztype = "DNI", en = "The Steamvault",                   de = "Die Dampfkammer",                       fr = "Le caveau de la Vapeur",             es = "La Cámara de Vapor",                        ru = "Паровое подземелье",                            Continent = 3,              mapid = 727, Location =  67, LevelRange = "67-75, 70-75", PlayerLimit =  "5", infoline = METAMAP_CFR_INFO},
	[114] = {ztype = "DNI", en = "The Slave Pens",                   de = "Die Sklavenunterkünfte",                fr = "Les enclos aux esclaves",            es = "Recinto de los Esclavos",                   ru = "Узилище",                                       Continent = 3,              mapid = 728, Location =  67, LevelRange = "60-69, 70-75", PlayerLimit =  "5", infoline = METAMAP_CFR_INFO},
	[115] = {ztype = "RDI", en = "Magtheridon's Lair",               de = "Magtheridons Kammer",                   fr = "Le repaire de Magtheridon",          es = "Guarida de Magtheridon",                    ru = "Логово Магтеридона",                            Continent = 3,              mapid = 779, Location =  60, LevelRange = "70+",          PlayerLimit = "25", infoline = METAMAP_MAG_INFO},
	[116] = {ztype = "DNI", en = "Hellfire Ramparts",                de = "Höllenfeuerbollwerk",                   fr = "Remparts des Flammes infernales",    es = "Murallas del Fuego Infernal",               ru = "Бастионы Адского Пламени",                      Continent = 3,              mapid = 797, Location =  60, LevelRange = "57-67, 70-75", PlayerLimit =  "5", infoline = METAMAP_HFC_INFO},
	[117] = {ztype = "DNI", en = "Mana-Tombs",                       de = "Managruft",                             fr = "Tombes-mana",                        es = "Tumbas de Maná",                            ru = "Гробницы Маны",                                 Continent = 3,              mapid = 732, Location =  66, LevelRange = "62-71, 70-75", PlayerLimit =  "5", infoline = METAMAP_AUC_INFO},
	[118] = {ztype = "DNI", en = "Auchenai Crypts",                  de = "Auchenaikrypta",                        fr = "Cryptes Auchenaï",                   es = "Criptas Auchenai",                          ru = "Аукенайские гробницы",                          Continent = 3,              mapid = 722, Location =  66, LevelRange = "63-72, 70-75", PlayerLimit =  "5", infoline = METAMAP_AUC_INFO},
	[119] = {ztype = "DNI", en = "Sethekk Halls",                    de = "Sethekkhallen",                         fr = "Les salles des Sethekk",             es = "Salas Sethekk",                             ru = "Сетеккские залы",                               Continent = 3,              mapid = 723, Location =  66, LevelRange = "65-73, 70-75", PlayerLimit =  "5", infoline = METAMAP_AUC_INFO},
	[120] = {ztype = "DNI", en = "Shadow Labyrinth",                 de = "Schattenlabyrinth",                     fr = "Labyrinthe des Ombres",              es = "Laberinto de las Sombras",                  ru = "Темный лабиринт",                               Continent = 3,              mapid = 724, Location =  66, LevelRange = "67-75, 70-75", PlayerLimit =  "5", infoline = METAMAP_AUC_INFO},
	[121] = {ztype = "DNI", en = "The Arcatraz",                     de = "Die Arkatraz",                          fr = "L’Arcatraz",                         es = "El Arcatraz",                               ru = "Аркатрац",                                      Continent = 3,              mapid = 731, Location =  63, LevelRange = "68-75, 70-75", PlayerLimit =  "5", infoline = METAMAP_TTK_INFO},
	[122] = {ztype = "DNI", en = "The Botanica",                     de = "Die Botanika",                          fr = "La Botanica",                        es = "El Invernáculo",                            ru = "Ботаника",                                      Continent = 3,              mapid = 729, Location =  63, LevelRange = "67-75, 70-75", PlayerLimit =  "5", infoline = METAMAP_TTK_INFO},
	[123] = {ztype = "DNI", en = "The Mechanar",                     de = "Die Mechanar",                          fr = "Le Méchanar",                        es = "El Mechanar",                               ru = "Механар",                                       Continent = 3,              mapid = 730, Location =  63, LevelRange = "67-75, 70-75", PlayerLimit =  "5", infoline = METAMAP_TTK_INFO},
	[124] = {ztype = "DNI", en = "The Black Morass",                 de = "Der Schwarze Morast",                   fr = "Le Noir marécage",                   es = "La Ciénaga Negra",                          ru = "Черные топи",                                   Continent = 1,              mapid = 733, Location =  15, LevelRange = "68-75, 70-75", PlayerLimit =  "5", infoline = METAMAP_COT_INFO},
	[125] = {ztype = "DNI", en = "Old Hillsbrad Foothills",          de = "Vorgebirge des Alten Hügellands",       fr = "Contreforts de Hautebrande d’antan", es = "Antiguas Laderas de Trabalomas",            ru = "Старые предгорья Хилсбрада",                    Continent = 1,              mapid = 734, Location =  15, LevelRange = "64-73, 70-75", PlayerLimit =  "5", infoline = METAMAP_COT_INFO},
	[126] = {ztype = "RDI", en = "Hyjal Summit",                     de = "Hyjalgipfel",                           fr = "Sommet d’Hyjal",                     es = "La Cima Hyjal",                             ru = "Вершина Хиджала",                               Continent = 1,              mapid = 775, Location =  15, LevelRange = "70+",          PlayerLimit = "25", infoline = METAMAP_COT_INFO},
	[127] = {ztype = "RDI", en = "Karazhan",                         de = "Karazhan",                              fr = "Karazhan",                           es = "Karazhan",                                  ru = "Каражан",                                       Continent = 2,              mapid = 799, Location =  35, LevelRange = "70+",          PlayerLimit = "10", infoline = METAMAP_KZN_INFO},
	[128] = {ztype = "RDI", en = "Gruul's Lair",                     de = "Gruuls Unterschlupf",                   fr = "Repaire de Gruul",                   es = "Guarida de Gruul",                          ru = "Логово Груула",                                 Continent = 3,              mapid = 776, Location =  61, LevelRange = "70+",          PlayerLimit = "25", infoline = METAMAP_GRL_INFO},
	[129] = {ztype = "RDI", en = "Serpentshrine Cavern",             de = "Höhle des Schlangenschreins",           fr = "Caverne du sanctuaire du Serpent",   es = "Caverna Santuario Serpiente",               ru = "Змеиное святилище",                             Continent = 3,              mapid = 780, Location =  67, LevelRange = "70+",          PlayerLimit = "25", infoline = METAMAP_CFR_INFO},
	[130] = {ztype = "RDI", en = "Tempest Keep",                     de = "Festung der Stürme",                    fr = "Donjon de la Tempête",               es = "El Castillo de la Tempestad",               ru = "Крепость Бурь",                                 Continent = 3,              mapid = 782, Location =  63, LevelRange = "70+",          PlayerLimit = "25", infoline = METAMAP_TTK_INFO},
-- WotLK Dungeons
	[131] = {ztype = "DNI", en = "Utgarde Keep",                     de = "Burg Utgarde",                          fr = "Donjon d’Utgarde",                   es = "Fortaleza de Utgarde",                      ru = "Крепость Утгард",                               Continent = 4,              mapid = 523, Location = 204, LevelRange = "68-78, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[132] = {ztype = "DNI", en = "Azjol-Nerub",                      de = "Azjol-Nerub",                           fr = "Azjol-Nérub",                        es = "Azjol-Nerub",                               ru = "Азжол-Неруб",                                   Continent = 4,              mapid = 533, Location = 201, LevelRange = "70-80, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[133] = {ztype = "DNI", en = "Ahn'kahet: The Old Kingdom",       de = "Ahn'kahet: Das Alte Königreich",        fr = "Ahn’kahet : l’Ancien royaume",       es = "Ahn'kahet: El Antiguo Reino",               ru = "Ан'кахет: Старое Королевство",                  Continent = 4,              mapid = 522, Location = 201, LevelRange = "71-80, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[134] = {ztype = "RDI", en = "Ulduar",                           de = "Ulduar",                                fr = "Ulduar",                             es = "Ulduar",                                    ru = "Ульдуар",                                       Continent = 4,              mapid = 529, Location = 200, LevelRange = "80-83",        PlayerLimit = "25", infoline = METAMAP_WLK_INFO},
	[135] = {ztype = "RDI", en = "Naxxramas",                        de = "Naxxramas",                             fr = "Naxxramas",                          es = "Naxxramas",                                 ru = "Наксрамас",                                     Continent = 4,              mapid = 535, Location = 200, LevelRange = "80-83",        PlayerLimit = "25", infoline = METAMAP_WLK_INFO},
--2x	[136] = {ztype = "DNI", en = "The Nexus",                        de = "Der Nexus",                             fr = "Le Nexus",                           es = "El Nexo",                                   ru = "Нексус",                                        Continent = 4,              mapid = 520, Location = 200, LevelRange = "70-73",        PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[137] = {ztype = "RDI", en = "Icecrown Citadel",                 de = "Eiskronenzitadelle",                    fr = "Citadelle de la Couronne de glace",  es = "Ciudadela de la Corona de Hielo",           ru = "Цитадель Ледяной Короны",                       Continent = 4,              mapid = 604, Location = 200, LevelRange = "80-83",        PlayerLimit = "25", infoline = METAMAP_WLK_INFO},
	[138] = {ztype = "DNI", en = "Drak'Tharon Keep",                 de = "Feste Drak'Tharon",                     fr = "Donjon de Drak’Tharon",              es = "Fortaleza de Drak'Tharon",                  ru = "Крепость Драк'Тарон",                           Continent = 4,              mapid = 534, Location = 203, LevelRange = "72-80, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[139] = {ztype = "RDI", en = "The Obsidian Sanctum",             de = "Das Obsidiansanktum",                   fr = "Le sanctum Obsidien",                es = "El Sagrario Obsidiana",                     ru = "Обсидиановое святилище",                        Continent = 4,              mapid = 531, Location = 201, LevelRange = "80-83",        PlayerLimit = "25", infoline = METAMAP_WLK_INFO},
	[140] = {ztype = "DNI", en = "The Violet Hold",                  de = "Die Violette Festung",                  fr = "Le fort Pourpre",                    es = "El Bastión Violeta",                        ru = "Аметистовая крепость",                          Continent = 4,              mapid = 536, Location = 210, LevelRange = "73-80, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[141] = {ztype = "DNI", en = "Utgarde Pinnacle",                 de = "Turm Utgarde",                          fr = "Cime d’Utgarde",                     es = "Pináculo de Utgarde",                       ru = "Вершина Утгард",                                Continent = 4,              mapid = 524, Location = 204, LevelRange = "77-80, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[142] = {ztype = "DNI", en = "The Nexus",                        de = "Der Nexus",                             fr = "Le Nexus",                           es = "El Nexo",                                   ru = "Нексус",                                        Continent = 4,              mapid = 520, Location = 202, LevelRange = "69-79, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[143] = {ztype = "DNI", en = "The Oculus",                       de = "Das Oculus",                            fr = "L’Oculus",                           es = "El Oculus",                                 ru = "Окулус",                                        Continent = 4,              mapid = 528, Location = 202, LevelRange = "77-80, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[144] = {ztype = "RDI", en = "The Eye of Eternity",              de = "Das Auge der Ewigkeit",                 fr = "L’Œil de l’éternité",                es = "El Ojo de la Eternidad",                    ru = "Око Вечности",                                  Continent = 4,              mapid = 527, Location = 202, LevelRange = "80-83",        PlayerLimit = "25", infoline = METAMAP_WLK_INFO},
	[145] = {ztype = "DNI", en = "Gundrak",                          de = "Gundrak",                               fr = "Gundrak",                            es = "Gundrak",                                   ru = "Гундрак",                                       Continent = 4,              mapid = 530, Location = 207, LevelRange = "74-80, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[146] = {ztype = "DNI", en = "Halls of Stone",                   de = "Hallen des Steins",                     fr = "Les salles de Pierre",               es = "Cámaras de Piedra",                         ru = "Чертоги Камня",                                 Continent = 4,              mapid = 526, Location = 200, LevelRange = "75-80, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[147] = {ztype = "DNI", en = "Halls of Lightning",               de = "Hallen der Blitze",                     fr = "Les salles de Foudre",               es = "Cámaras de Relámpagos",                     ru = "Чертоги Молний",                                Continent = 4,              mapid = 525, Location = 200, LevelRange = "77-80, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[148] = {ztype = "DNI", en = "Trial of the Champion",            de = "Prüfung des Champions",                 fr = "L’épreuve du champion",              es = "Prueba del Campeón",                        ru = "Испытание чемпиона",                            Continent = 4,              mapid = 542, Location = 208, LevelRange = "78-80, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[149] = {ztype = "RDI", en = "Trial of the Crusader",            de = "Prüfung des Kreuzfahrers",              fr = "L’épreuve du croisé",                es = "Prueba del Cruzado",                        ru = "Испытание крестоносца",                         Continent = 4,              mapid = 543, Location = 208, LevelRange = "80-83",        PlayerLimit = "25", infoline = METAMAP_WLK_INFO},
	[150] = {ztype = "DNI", en = "Pit of Saron",                     de = "Grube von Saron",                       fr = "Fosse de Saron",                     es = "Foso de Saron",                             ru = "Яма Сарона",                                    Continent = 4,              mapid = 602, Location = 208, LevelRange = "80, 80-82",    PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[151] = {ztype = "DNI", en = "Halls of Reflection",              de = "Hallen der Reflexion",                  fr = "Salles des Reflets",                 es = "Cámaras de Reflexión",                      ru = "Залы Отражений",                                Continent = 4,              mapid = 603, Location = 208, LevelRange = "80, 80-82",    PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[152] = {ztype = "DNI", en = "The Forge of Souls",               de = "Die Seelenschmiede",                    fr = "La Forge des Âmes",                  es = "La Forja de Almas",                         ru = "Кузня Душ",                                     Continent = 4,              mapid = 601, Location = 208, LevelRange = "80, 80-82",    PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[153] = {ztype = "DNI", en = "The Culling of Stratholme",        de = "Das Ausmerzen von Stratholme",          fr = "L’Épuration de Stratholme",          es = "La Matanza de Stratholme",                  ru = "Очищение Стратхольма",                          Continent = 4,              mapid = 521, Location = 200, LevelRange = "77-80, 80-82", PlayerLimit =  "5", infoline = METAMAP_WLK_INFO},
	[154] = {ztype = "RDI", en = "Vault of Archavon",                de = "Archavons Kammer",                      fr = "Caveau d’Archavon",                  es = "La Cámara de Archavon",                     ru = "Склеп Аркавона",                                Continent = 4,              mapid = 532, Location = 209, LevelRange = "80-83",        PlayerLimit = "25", infoline = METAMAP_WLK_INFO},
--- BC Dungeons
	[155] = {ztype = "RDI", en = "Sunwell Plateau",                  de = "Sonnenbrunnenplateau",                  fr = "Plateau du Puits de soleil",         es = "Meseta de La Fuente del Sol",               ru = "Плато Солнечного Колодца",                      Continent = 2,              mapid = 789, Location = 157, LevelRange = "70+",          PlayerLimit = "25", infoline = METAMAP_WLK_INFO}, 
	[156] = {ztype = "DNI", en = "Magisters' Terrace",               de = "Terrasse der Magister",                 fr = "Terrasse des Magistères",            es = "Bancal del Magister",                       ru = "Терраса Магистров",                             Continent = 2,              mapid = 798, Location = 157, LevelRange = "68-75, 70-75", PlayerLimit = "25", infoline = METAMAP_WLK_INFO}, 
--- Eastern Kingdoms (continent 2)
	[157] = {ztype = "SZ",  en = "Isle of Quel'Danas",               de = "Insel von Quel'Danas",                  fr = "Île de Quel’Danas",                  es = "Isla de Quel'Danas",                        ru = "Остров Кель'Данас",                             Continent = 2,                                           llvl = 70, hlvl = 70, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
-- WotLK Dungeons
	[158] = {ztype = "RDI", en = "The Ruby Sanctum",                 de = "Das Rubinsanktum",                      fr = "Le sanctum Rubis",                   es = "El Sagrario Rubí",                          ru = "Рубиновое святилище",                           Continent = 4,              mapid = 609, Location = 201, LevelRange = "80-83",        PlayerLimit = "25",  infoline = METAMAP_WLK_INFO},
--- Northrend (continent 4)
	[200] = {ztype = "SZ",  en = "The Storm Peaks",                  de = "Die Sturmgipfel",                       fr = "Les pics Foudroyés",                 es = "Las Cumbres Tormentosas",                   ru = "Грозовая Гряда",                                Continent = 4,                                           llvl = 77, hlvl = 80, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[201] = {ztype = "SZ",  en = "Dragonblight",                     de = "Drachenöde",                            fr = "Désolation des dragons",             es = "Cementerio de Dragones",                    ru = "Драконий Погост",                               Continent = 4,                                           llvl = 71, hlvl = 73, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[202] = {ztype = "SZ",  en = "Borean Tundra",                    de = "Boreanische Tundra",                    fr = "Toundra Boréenne",                   es = "Tundra Boreal",                             ru = "Борейская тундра",                              Continent = 4,                                           llvl = 70, hlvl = 72, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[203] = {ztype = "SZ",  en = "Grizzly Hills",                    de = "Grizzlyhügel",                          fr = "Les Grisonnes",                      es = "Colinas Pardas",                            ru = "Седые холмы",                                   Continent = 4,                                           llvl = 73, hlvl = 75, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[204] = {ztype = "SZ",  en = "Howling Fjord",                    de = "Der Heulende Fjord",                    fr = "Fjord Hurlant",                      es = "Fiordo Aquilonal",                          ru = "Ревущий фьорд",                                 Continent = 4,                                           llvl = 68, hlvl = 72, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[205] = {ztype = "SZ",  en = "Crystalsong Forest",               de = "Kristallsangwald",                      fr = "Forêt du Chant de cristal",          es = "Bosque Canto de Cristal",                   ru = "Лес Хрустальной Песни",                         Continent = 4,                                           llvl = 80, hlvl = 80, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[206] = {ztype = "SZ",  en = "Sholazar Basin",                   de = "Sholazzarbecken",                       fr = "Bassin de Sholazar",                 es = "Cuenca de Sholazar",                        ru = "Низина Шолазар",                                Continent = 4,                                           llvl = 75, hlvl = 77, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[207] = {ztype = "SZ",  en = "Zul'Drak",                         de = "Zul'Drak",                              fr = "Zul’Drak",                           es = "Zul'Drak",                                  ru = "Зул'Драк",                                      Continent = 4,                                           llvl = 73, hlvl = 77, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[208] = {ztype = "SZ",  en = "Icecrown",                         de = "Eiskrone",                              fr = "La Couronne de glace",               es = "Corona de Hielo",                           ru = "Ледяная Корона",                                Continent = 4,                                           llvl = 77, hlvl = 80, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[209] = {ztype = "SZ",  en = "Wintergrasp",                      de = "Tausendwintersee",                      fr = "Joug-d’Hiver",                       es = "Conquista del Invierno",                    ru = "Озеро Ледяных Оков",                            Continent = 4,                                           llvl = 80, hlvl = 80, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[210] = {ztype = "SZ",  en = "Dalaran",                          de = "Dalaran",                               fr = "Dalaran",                            es = "Dalaran",                                   ru = "Даларан",                                       Continent = 4,                           Location = 205, llvl =  0, hlvl =  0, faction = "Neutral",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[211] = {ztype = "SZ",  en = "Hrothgar's Landing",               de = "Hrothgars Landestelle",                 fr = "Accostage de Hrothgar",              es = "Desembarco de Hrothgar",                    ru = "Лагерь Хротгара",                               Continent = 4,                                           llvl = 77, hlvl = 80, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
--- Cataclysm
	[225] = {ztype = "SZ",  en = "Uldum",                            de = "Uldum",                                 fr = "Uldum",                              es = "Uldum",                                     ru = "Ульдум",                                        Continent = 1,                                           llvl = 83, hlvl = 84, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[226] = {ztype = "SZ",  en = "Tol Barad",                        de = "Tol Barad",                             fr = "Tol Barad",                          es = "Tol Barad",                                 ru = "Тол Барад",                                     Continent = 2,                                           llvl = 85, hlvl = 85, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[227] = {ztype = "SZ",  en = "Twilight Highlands",               de = "Schattenhochland",                      fr = "Hautes-terres du Crépuscule",        es = "Tierras Altas Crepusculares",               ru = "Сумеречное нагорье",                            Continent = 2,                                           llvl = 84, hlvl = 85, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[228] = {ztype = "SZ",  en = "Vashj'ir",                         de = "Vashj'ir",                              fr = "Vashj’ir",                           es = "Vashj'ir",                                  ru = "Вайш'ир",                                       Continent = 2,                                           llvl = 80, hlvl = 82, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[229] = {ztype = "SZ",  en = "Deepholm",                         de = "Tiefenheim",                            fr = "Le Tréfonds",                        es = "Infralar",                                  ru = "Подземье",                                      Continent = 5,                                           llvl = 82, hlvl = 83, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
--- Eastern Kingdoms (continent 2)
	[230] = {ztype = "SZ",  en = "Northern Stranglethorn",           de = "Nördliches Schlingendorntal",           fr = "Strangleronce septentrionale",       es = "Norte de la Vega de Tuercespina",           ru = "Северная Тернистая долина",                     Continent = 2,                           Location =  47, llvl = 25, hlvl = 30, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[231] = {ztype = "SZ",  en = "The Cape of Stranglethorn",        de = "Das Schlingendornkap",                  fr = "Cap Strangleronce",                  es = "El Cabo de Tuercespina",                    ru = "Мыс Тернистой долины",                          Continent = 2,                           Location =  47, llvl = 30, hlvl = 35, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
--- Cataclysm
	-- give mapid and zoneid there, because two different maps have the same name (at least for German)
	[232] = {ztype = "SZ",  en = "Ruins of Gilneas",                 de = "Ruinen von Gilneas",                    fr = "Ruines de Gilnéas",                  es = "Ruinas de Gilneas",                         ru = "руины Гилнеаса",                    nameid = 1, Continent = 2, zoneid = 20, mapid = 684,                 llvl =  1, hlvl = 12, faction = "Alliance",  scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[233] = {ztype = "SZ",  en = "Tol Barad Peninsula",              de = "Halbinsel von Tol Barad",               fr = "Péninsule de Tol Barad",             es = "Península de Tol Barad",                    ru = "Полуостров Тол Барад",                          Continent = 2,                                           llvl = 85, hlvl = 85, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[234] = {ztype = "SZ",  en = "Abyssal Depths",                   de = "Abyssische Tiefen",                     fr = "Profondeurs Abyssales",              es = "Profundidades Abisales",                    ru = "Бездонные глубины",                             Continent = 2,                           Location = 228, llvl = 80, hlvl = 82, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[235] = {ztype = "SZ",  en = "Shimmering Expanse",               de = "Schimmernde Weiten",                    fr = "Étendues Chatoyantes",               es = "Extensión Bruñida",                         ru = "Мерцающий простор",                             Continent = 2,                           Location = 228, llvl = 80, hlvl = 82, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[236] = {ztype = "SZ",  en = "Kelp'thar Forest",                 de = "Tang'tharwald",                         fr = "Forêt de Varech’thar",               es = "Bosque Kelp'thar",                          ru = "Лес Келп’тар",                                  Continent = 2,                           Location = 228, llvl = 80, hlvl = 82, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[237] = {ztype = "SZ",  en = "Kezan",                            de = "Kezan",                                 fr = "Kezan",                              es = "Kezan",                                     ru = "Кезан",                                         Continent = 5,                                           llvl =  1, hlvl =  5, faction = "Horde",     scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[238] = {ztype = "SZ",  en = "The Lost Isles",                   de = "Die Verlorenen Inseln",                 fr = "Les îles Perdues",                   es = "Las Islas Perdidas",                        ru = "Затерянные острова",                            Continent = 5,                                           llvl =  5, hlvl = 12, faction = "Horde",     scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[239] = {ztype = "SZ",  en = "Mount Hyjal",                      de = "Hyjal",                                 fr = "Mont Hyjal",                         es = "Monte Hyjal",                               ru = "Хиджал",                                        Continent = 1,                                           llvl = 80, hlvl = 82, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
--- Kalimdor (continent 1)
	[240] = {ztype = "SZ",  en = "Northern Barrens",                 de = "Nördliches Brachland",                  fr = "Tarides du Nord",                    es = "Los Baldíos del Norte",                     ru = "Северные Степи",                                Continent = 1,                                           llvl = 10, hlvl = 20, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[241] = {ztype = "SZ",  en = "Southern Barrens",                 de = "Südliches Brachland",                   fr = "Tarides du Sud",                     es = "Los Baldíos del Sur",                       ru = "Южные Степи",                                   Continent = 1,                                           llvl = 30, hlvl = 35, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[242] = {ztype = "SZ",  en = "Ahn'Qiraj: The Fallen Kingdom",    de = "Ahn'Qiraj: Das Gefallene Königreich",   fr = "Ahn’Qiraj : le royaume Déchu",       es = "Ahn'Qiraj: El Reino Caído",                 ru = "Ан'Кираж: Павшее Королевство",                  Continent = 1,                                           llvl = 55, hlvl = 60, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
--- Cataclysm  related map parts
	[250] = {ztype = "SZR", en = "Gilneas City",                     de = "Gilneas",                               fr = "Gilnéas",                            es = "Ciudad de Gilneas",                         ru = "Гилнеас",                                       Continent = 2,                           Location = 232, llvl =  1, hlvl = 12, faction = "Alliance",  scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	-- a given nameid require also a mapid
	[251] = {ztype = "DNI", en = "Gilneas",                          de = "Gilneas",                               fr = "Gilnéas",                            es = "Gilneas",                                   ru = "Гилнеас",                           nameid = 1, Continent = 2,              mapid = 545,                 LevelRange = "1-12",         PlayerLimit = "Worgen Starting Area"},
	[252] = {ztype = "SZR", en = "Military District",                de = "Militärviertel",                        fr = "Secteur Militaire",                  es = "Distrito Militar",                          ru = "Военный квартал",                               Continent = 2,                           Location = 253, llvl =  1, hlvl = 12, faction = "Alliance",  scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	-- a given nameid require also a mapid
	[253] = {ztype = "DNI", en = "Gilneas City",                     de = "Gilneas",                               fr = "Gilnéas",                            es = "Ciudad de Gilneas",                         ru = "Гилнеас",                           nameid = 2, Continent = 2,              mapid = 611, Location = 251, LevelRange = "1-12",         PlayerLimit = "Worgen Starting Area"},
--- Cataclysm
	-- a given nameid require also a mapid, and give zoneid there, because two different maps have the same name (at least for German)
	[260] = {ztype = "SZ",  en = "Ruins of Gilneas City",            de = "Ruinen von Gilneas",                    fr = "Ruines de Gilnéas (ville)",          es = "Ruinas de la Ciudad de Gilneas",            ru = "Гилнеас",                           nameid = 2, Continent = 2, zoneid = 19, mapid = 685, Location = 232, llvl =  1, hlvl = 12, faction = "Alliance",  scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	-- give zoneid there, because two different maps have the same name
	[261] = {ztype = "SZ",  en = "The Maelstrom",                    de = "Der Mahlstrom",                         fr = "Le Maelström",                       es = "La Vorágine",                               ru = "Водоворот",                                     Continent = 5, zoneid = 1,                               llvl = 80, hlvl = 85, faction = "Neutral",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
--- Cataclysm Dungeons
	[275] = {ztype = "DNI", en = "Lost city of the Tol'vir",         de = "Die Verlorene Stadt der Tol'vir",       fr = "Cité perdue des Tol’vir",            es = "Ciudad Perdida de los Tol'vir",             ru = "Затерянный город Тол'вир",                      Continent = 5,              mapid = 747, Location = 225, LevelRange = "84-85, 85-87", PlayerLimit =  "5", infoline = METAMAP_CTA_INFO},
	[276] = {ztype = "RDI", en = "Baradin Hold",                     de = "Baradinfestung",                        fr = "Bastion de Baradin",                 es = "Bastión de Baradin",                        ru = "Крепость Барадин",                              Continent = 5,              mapid = 752, Location = 226, LevelRange = "85+",          PlayerLimit = "25", infoline = METAMAP_CTA_INFO},
	[277] = {ztype = "DNI", en = "Blackrock Caverns",                de = "Schwarzfelshöhlen",                     fr = "Cavernes de Rochenoire",             es = "Cavernas Roca Negra",                       ru = "Пещеры Черной горы",                            Continent = 5,              mapid = 753, Location =  44, LevelRange = "80-85, 85-87", PlayerLimit =  "5", infoline = METAMAP_CTA_INFO},
	[278] = {ztype = "RDI", en = "Blackwing Descent",                de = "Pechschwingenabstieg",                  fr = "Descente de l’Aile noire",           es = "Descenso de Alanegra",                      ru = "Твердыня Крыла Тьмы",                           Continent = 5,              mapid = 754, Location =  44, LevelRange = "85+",          PlayerLimit = "25", infoline = METAMAP_CTA_INFO},
	[279] = {ztype = "DNI", en = "Grim Batol",                       de = "Grim Batol",                            fr = "Grim Batol",                         es = "Grim Batol",                                ru = "Грим Батол",                                    Continent = 5,              mapid = 757, Location = 226, LevelRange = "84-85, 85-87", PlayerLimit =  "5", infoline = METAMAP_CTA_INFO},
	[280] = {ztype = "RDI", en = "The Bastion of Twilight",          de = "Die Bastion des Zwielichts",            fr = "Le bastion du Crépuscule",           es = "El Bastión del Crepúsculo",                 ru = "Сумеречный бастион",                            Continent = 5,              mapid = 758, Location = 226, LevelRange = "85+",          PlayerLimit = "25", infoline = METAMAP_CTA_INFO},
	[281] = {ztype = "DNI", en = "Halls of Origination",             de = "Hallen des Ursprungs",                  fr = "Salles de l’Origine",                es = "Cámaras de los Orígenes",                   ru = "Чертоги Созидания",                             Continent = 5,              mapid = 759, Location = 225, LevelRange = "84-85, 85-87", PlayerLimit =  "5", infoline = METAMAP_CTA_INFO},
	[282] = {ztype = "DNI", en = "Throne of the Tides",              de = "Thron der Gezeiten",                    fr = "Trône des marées",                   es = "Trono de las Mareas",                       ru = "Трон Приливов",                                 Continent = 5,              mapid = 767, Location = 228, LevelRange = "80-85, 85-87", PlayerLimit =  "5", infoline = METAMAP_CTA_INFO},
	[283] = {ztype = "DNI", en = "The Stonecore",                    de = "Der Steinerne Kern",                    fr = "Le Cœur-de-pierre",                  es = "El Núcleo Pétreo",                          ru = "Каменные Недра",                                Continent = 5,              mapid = 768, Location = 229, LevelRange = "81-85, 85",    PlayerLimit =  "5", infoline = METAMAP_CTA_INFO},
	[284] = {ztype = "DNI", en = "The Vortex Pinnacle",              de = "Der Vortexgipfel",                      fr = "La cime du Vortex",                  es = "La Cumbre del Vórtice",                     ru = "Вершина смерча",                                Continent = 5,              mapid = 769, Location = 225, LevelRange = "81-85, 85-87", PlayerLimit =  "5", infoline = METAMAP_CTA_INFO},
	[285] = {ztype = "RDI", en = "Throne of the Four Winds",         de = "Thron der Vier Winde",                  fr = "Trône des quatre vents",             es = "Trono de los Cuatro Vientos",               ru = "Трон Четырех Ветров",                           Continent = 5,              mapid = 773, Location = 225, LevelRange = "85+",          PlayerLimit = "25", infoline = METAMAP_CTA_INFO},
	[286] = {ztype = "DNI", en = "Zul'Aman",                         de = "Zul'Aman",                              fr = "Zul’Aman",                           es = "Zul'Aman",                                  ru = "Зул'Аман",                                      Continent = 5,              mapid = 781, Location =  23, LevelRange = "85-87",        PlayerLimit =  "5", infoline = METAMAP_CTA_INFO},
	[287] = {ztype = "DNI", en = "Zul'Gurub",                        de = "Zul'Gurub",                             fr = "Zul’Gurub",                          es = "Zul'Gurub",                                 ru = "Зул'Гуруб",                                     Continent = 5,              mapid = 793, Location = 230, LevelRange = "85-87",        PlayerLimit =  "5", infoline = METAMAP_CTA_INFO},
	[288] = {ztype = "RDI", en = "Firelands",                        de = "Feuerlande",                            fr = "Terres de Feu",                      es = "Tierras de Fuego",                          ru = "Огненные Просторы",                             Continent = 5,              mapid = 800, Location = 239, LevelRange = "85+",          PlayerLimit = "25", infoline = METAMAP_CTA_INFO},
	[289] = {ztype = "DNI", en = "Well of Eternity",                 de = "Brunnen der Ewigkeit",                  fr = "Puits d’éternité",                   es = "Pozo de la Eternidad",                      ru = "Источник Вечности",                             Continent = 5,              mapid = 816, Location =  15, LevelRange = "85",           PlayerLimit =  "5", infoline = METAMAP_CTA_INFO},
	[290] = {ztype = "DNI", en = "Hour of Twilight",                 de = "Stunde des Zwielichts",                 fr = "L’Heure du Crépuscule",              es = "Hora del Crepúsculo",                       ru = "Время Сумерек",                                 Continent = 5,              mapid = 819, Location =  15, LevelRange = "85",           PlayerLimit =  "5", infoline = METAMAP_CTA_INFO},
	[291] = {ztype = "DNI", en = "End Time",                         de = "Die Endzeit",                           fr = "La Fin des temps",                   es = "Fin de los Días",                           ru = "Конец Времен",                                  Continent = 5,              mapid = 820, Location =  15, LevelRange = "85-87",        PlayerLimit =  "5", infoline = METAMAP_CTA_INFO},
	[292] = {ztype = "RDI", en = "Dragon Soul",                      de = "Drachenseele",                          fr = "L’Âme des dragons",                  es = "Alma de Dragón",                            ru = "Душа Дракона",                                  Continent = 5,              mapid = 824, Location = 201, LevelRange = "85+",          PlayerLimit = "25", infoline = METAMAP_CTA_INFO},
	[293] = {ztype = "DNI", en = "Darkmoon Island",                  de = "Dunkelmond-Insel",                      fr = "Île de Sombrelune",                  es = "Isla Luna Negra",                           ru = "Остров Новолуния",                              Continent = 5,              mapid = 823, Location = 261, LevelRange = "1-90",         PlayerLimit =  "0", infoline = METAMAP_CTA_INFO},
-- Pandaria
	[294] = {ztype = "SZ",  en = "Townlong Steppes",                 de = "Tonlongsteppe",                         fr = "Steppes de Tanglong",                es = "Estepas de Tong Long",                      ru = "Танлунские степи",                              Continent = 6,                                           llvl = 88, hlvl = 89, faction = "Contested",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[295] = {ztype = "SZ",  en = "Kun-Lai Summit",                   de = "Kun-Lai-Gipfel",                        fr = "Sommet de Kun-Lai",                  es = "Cima Kun-Lai",                              ru = "Вершина Кунь-Лай",                              Continent = 6,                                           llvl = 87, hlvl = 88, faction = "Contested",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[296] = {ztype = "SZ",  en = "The Jade Forest",                  de = "Der Jadewald",                          fr = "La forêt de Jade",                   es = "El Bosque de Jade",                         ru = "Нефритовый лес",                                Continent = 6,                                           llvl = 85, hlvl = 86, faction = "Contested",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[297] = {ztype = "SZ",  en = "Valley of the Four Winds",         de = "Tal der Vier Winde",                    fr = "Vallée des Quatre vents",            es = "Valle de los Cuatro Vientos",               ru = "Долина Четырех Ветров",                         Continent = 6,                                           llvl = 86, hlvl = 87, faction = "Contested",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[298] = {ztype = "SZ",  en = "Vale of Eternal Blossoms",         de = "Tal der Ewigen Blüten",                 fr = "Val de l’Éternel printemps",         es = "Valle de la Flor Eterna",                   ru = "Вечноцветущий дол",                             Continent = 6,                                           llvl = 87, hlvl = 90, faction = "Contested",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[299] = {ztype = "SZ",  en = "Dread Wastes",                     de = "Schreckensöde",                         fr = "Terres de l’Angoisse",               es = "Desierto del Pavor",                        ru = "Жуткие пустоши",                                Continent = 6,                                           llvl = 89, hlvl = 90, faction = "Contested",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[300] = {ztype = "SZ",  en = "Krasarang Wilds",                  de = "Krasarangwildnis",                      fr = "Étendues sauvages de Krasarang",     es = "Espesura Krasarang",                        ru = "Красарангские джунгли",                         Continent = 6,                                           llvl = 86, hlvl = 87, faction = "Contested",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
--	[301] = {ztype = "SZ",  en = "Shrine of Seven Stars",            de = "Schrein der Sieben Sterne",             fr = "Sanctuaire des Sept-Étoiles",        es = "Santuario de las Siete Estrellas",          ru = "Святилище Семи Звезд",                          Continent = 6,                                           llvl = 85, hlvl = 85, faction = "Neutral",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
--	[302] = {ztype = "SZ",  en = "Shrine of Two Moons",              de = "Schrein der Zwei Monde",                fr = "Sanctuaire des Deux-Lunes",          es = "Santuario de las Dos Lunas",                ru = "Святилище Двух Лун",                            Continent = 6,                                           llvl = 85, hlvl = 85, faction = "Neutral",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[303] = {ztype = "SZ",  en = "The Veiled Stair",                 de = "Die Verhüllte Treppe",                  fr = "L’escalier Dérobé",                  es = "La Escalera Velada",                        ru = "Сокрытая лестница",                             Continent = 6,                                           llvl = 87, hlvl = 88, faction = "Contested",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[304] = {ztype = "DNI", en = "The Wandering Isle",               de = "Die Wandernde Insel",                   fr = "L’île Vagabonde",                    es = "La Isla Errante",                           ru = "Скитающийся остров",                            Continent = 6,              mapid = 808,                 LevelRange = "1-10",         PlayerLimit =  "0", infoline = METAMAP_MOP_INFO},
-- New starting areas
	[305] = {ztype = "SZ",  en = "Northshire",                       de = "Nordhain",                              fr = "Comté-du-Nord",                      es = "Villanorte",                                ru = "Североземье",                                   Continent = 2,                           Location =  39, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[306] = {ztype = "SZ",  en = "Coldridge Valley",                 de = "Das Eisklammtal",                       fr = "Vallée des Frigères",                es = "Valle de Crestanevada",                     ru = "Холодная долина",                               Continent = 2,                           Location =  36, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[307] = {ztype = "SZ",  en = "New Tinkertown",                   de = "Neu-Tüftlerstadt",                      fr = "La Nouvelle-Brikabrok",              es = "Nueva Ciudad Manitas",                      ru = "Новый Город Механиков",                         Continent = 2,                           Location =  36, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[308] = {ztype = "SZ",  en = "Deathknell",                       de = "Todesend",                              fr = "Le Glas",                            es = "Camposanto",                                ru = "Похоронный Звон",                               Continent = 2,                           Location =  50, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[309] = {ztype = "SZ",  en = "Sunstrider Isle",                  de = "Insel der Sonnenwanderer",              fr = "Île de Haut-Soleil",                 es = "Isla del Caminante del Sol",                ru = "Остров Солнечного Скитальца",                   Continent = 2,                           Location =  22, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[310] = {ztype = "SZ",  en = "Valley of Trials",                 de = "Tal der Prüfungen",                     fr = "Vallée des Épreuves",                es = "Valle de los Retos",                        ru = "Долина Испытаний",                              Continent = 1,                           Location =   6, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[311] = {ztype = "SZ",  en = "Camp Narache",                     de = "Camp Narache",                          fr = "Camp Narache",                       es = "Campamento Narache",                        ru = "Лагерь Нараче",                                 Continent = 1,                           Location =  11, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[312] = {ztype = "SZ",  en = "Echo Isles",                       de = "Die Echoinseln",                        fr = "Îles de l’Écho",                     es = "Islas del Eco",                             ru = "Острова Эха",                                   Continent = 1,                           Location =   6, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[313] = {ztype = "SZ",  en = "Ammen Vale",                       de = "Am'mental",                             fr = "Val d’Ammen",                        es = "Valle Ammen",                               ru = "Долина Аммен",                                  Continent = 1,                           Location =  55, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[314] = {ztype = "SZ",  en = "Shadowglen",                       de = "Laubschattental",                       fr = "Sombrevallon",                       es = "Cañada Umbría",                             ru = "Тенистая долина",                               Continent = 1,                           Location =  16, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
-- MoP BGs
	[315] = {ztype = "BG",  en = "Silvershard Mines",                de = "Silberbruchmine",                       fr = "Mines d’Éclargent",                  es = "Minas Lonjaplata",                          ru = "Сверкающие копи",                               Continent = 2,              mapid = 860, Location =  47, llvl = 85, hlvl = 85, faction = "Contested", scale = 0.1,              xoffset = 0.41757282062541, yoffset = 0.33126468682991, xscale = 12897.3, yscale = 8638.1},
	[316] = {ztype = "BG",  en = "Temple of Kotmogu",                de = "Tempel von Katmogu",                    fr = "Temple de Kotmogu",                  es = "Templo de Kotmogu",                         ru = "Храм Котмогу",                                  Continent = 6,              mapid = 856, Location = 298, llvl = 85, hlvl = 85, faction = "Contested", scale = 0.1,              xoffset = 0.41757282062541, yoffset = 0.33126468682991, xscale = 12897.3, yscale = 8638.1},
-- Pandaria dungeons
	[317] = {ztype = "DNI", en = "Temple of the Jade Serpent",       de = "Tempel der Jadeschlange",               fr = "Temple du Serpent de jade",          es = "Templo del Dragón de Jade",                 ru = "Храм Нефритовой Змеи",                          Continent = 6,              mapid = 867, Location = 296, LevelRange = "85-90, 90",    PlayerLimit =  "5", infoline = METAMAP_MOP_INFO},
	[318] = {ztype = "DNI", en = "Gate of the Setting Sun",          de = "Das Tor der Untergehenden Sonne",       fr = "Porte du Soleil couchant",           es = "Puerta del Sol Poniente",                   ru = "Врата Заходящего Солнца",                       Continent = 6,              mapid = 875, Location = 299, LevelRange = "90",           PlayerLimit =  "5", infoline = METAMAP_MOP_INFO},
	[319] = {ztype = "DNI", en = "Stormstout Brewery",               de = "Brauerei Sturmbräu",                    fr = "Brasserie Brune d’Orage",            es = "Cervecería del Trueno",                     ru = "Хмелеварня Буйных Портеров",                    Continent = 6,              mapid = 876, Location = 297, LevelRange = "85-90, 90",    PlayerLimit =  "5", infoline = METAMAP_MOP_INFO},
	[320] = {ztype = "DNI", en = "Shado-Pan Monastery",              de = "Shado-Pan-Kloster",                     fr = "Monastère des Pandashan",            es = "Monasterio del Shadopan",                   ru = "Монастырь Шадо-Пан",                            Continent = 6,              mapid = 877, Location = 295, LevelRange = "87-90, 90",    PlayerLimit =  "5", infoline = METAMAP_MOP_INFO},
	[321] = {ztype = "DNI", en = "Mogu'shan Palace",                 de = "Mogu'shanpalast",                       fr = "Palais Mogu’shan",                   es = "Palacio Mogu'shan",                         ru = "Дворец Могу'шан",                               Continent = 6,              mapid = 885, Location = 298, LevelRange = "87-90, 90",    PlayerLimit =  "5", infoline = METAMAP_MOP_INFO},
	[322] = {ztype = "DNI", en = "Siege of Niuzao Temple",           de = "Die Belagerung des Niuzaotempels",      fr = "Siège du temple de Niuzao",          es = "Asedio del Templo de Niuzao",               ru = "Осада храма Нюцзао",                            Continent = 6,              mapid = 887, Location = 294, LevelRange = "90",           PlayerLimit =  "5", infoline = METAMAP_MOP_INFO},
	[323] = {ztype = "DNI", en = "Scholomance",                      de = "Scholomance",                           fr = "Scholomance",                        es = "Scholomance",                               ru = "Некроситет",                                    Continent = 2,              mapid = 898, Location =  52, LevelRange = "38-48, 90",    PlayerLimit =  "5", infoline = METAMAP_MOP_INFO},
	[324] = {ztype = "DNI", en = "Scarlet Halls",                    de = "Scharlachrote Hallen",                  fr = "Salles Écarlates",                   es = "Cámaras Escarlata",                         ru = "Залы Алого ордена",                             Continent = 2,              mapid = 871, Location =  45, LevelRange = "26-36, 90",    PlayerLimit =  "5", infoline = METAMAP_MOP_INFO},
	[325] = {ztype = "DNI", en = "Scarlet Monastery",                de = "Das Scharlachrote Kloster",             fr = "Monastère Écarlate",                 es = "Monasterio Escarlata",                      ru = "Монастырь Алого ордена",                        Continent = 2,              mapid = 874, Location =  45, LevelRange = "28-38, 90",    PlayerLimit =  "5", infoline = METAMAP_MOP_INFO},
	[326] = {ztype = "RDI", en = "Terrace of Endless Spring",        de = "Terrasse des Endlosen Frühlings",       fr = "Terrasse Printanière",               es = "Veranda de la Primavera Eterna",            ru = "Терраса Вечной Весны",                          Continent = 6,              mapid = 886, Location = 303, LevelRange = "90",           PlayerLimit = "25", infoline = METAMAP_MOP_INFO},
	[327] = {ztype = "RDI", en = "Mogu'shan Vaults",                 de = "Mogu'shangewölbe",                      fr = "Caveaux Mogu’shan",                  es = "Cámaras Mogu'shan",                         ru = "Подземелья Могу'шан",                           Continent = 6,              mapid = 896, Location = 295, LevelRange = "90",           PlayerLimit = "25", infoline = METAMAP_MOP_INFO},
	[328] = {ztype = "RDI", en = "Heart of Fear",                    de = "Das Herz der Angst",                    fr = "Cœur de la Peur",                    es = "Corazón del Miedo",                         ru = "Сердце Страха",                                 Continent = 6,              mapid = 897, Location = 299, LevelRange = "90",           PlayerLimit = "25", infoline = METAMAP_MOP_INFO},
-- Scenarios
	[329] = {ztype = "SCN", en = "A Brewing Storm",                  de = "Ein Sturm braut sich zusammen",         fr = "Une bière foudroyante",              es = "Cervezas y Truenos",                        ru = "Хмельная буря",                                 Continent = 6,              mapid = 878, Location = 296, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	[330] = {ztype = "SCN", en = "Peak of Serenity",                 de = "Gipfel der Ruhe",                       fr = "Pic de la Sérénité",                 es = "Pico de la Serenidad",                      ru = "Пик Безмятежности",                             Continent = 6,              mapid = 879, Location = 295, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	[331] = {ztype = "SCN", en = "Greenstone Village",               de = "Grünstein",                             fr = "Pierre-Verte",                       es = "Aldea Verdemar",                            ru = "Деревня Зеленой Скалы",                         Continent = 6,              mapid = 880, Location = 296, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	[332] = {ztype = "SCN", en = "Unga Ingoo",                       de = "Unga Ingu",                             fr = "Unga Ingou",                         es = "Unga Ingoo",                                ru = "Унга-Ингу",                                     Continent = 6,              mapid = 882, Location = 300, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	[333] = {ztype = "SCN", en = "Zan'vess",                         de = "Zan'vess",                              fr = "Zan’Vess",                           es = "Zan'vess",                                  ru = "Зан'весс",                                      Continent = 6,              mapid = 883, Location = 299, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	[334] = {ztype = "SCN", en = "Brewmoon Festival",                de = "Das Braumondfest",                      fr = "Festival de Brasse-Lune",            es = "Festival de la Cerveza Lunar",              ru = "Фестиваль Хмельнолуния",                        Continent = 6,              mapid = 884, Location = 295, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	[335] = {ztype = "SCN", en = "Proving Grounds",                  de = "Feuerprobe",                            fr = "Ordalie",                            es = "Terreno de Pruebas",                        ru = "Арена испытаний",                               Continent = 6,              mapid = 899, Location = 295, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	[336] = {ztype = "SCN", en = "Crypt of Forgotten Kings",         de = "Krypta der Vergessenen Könige",         fr = "Crypte des Rois oubliés",            es = "Cripta de los Reyes Olvidados",             ru = "Гробница Забытых Королей",                      Continent = 6,              mapid = 900, Location = 298, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
-- this is for Horde
	[337] = {ztype = "SCN", en = "Dustwallow Marsh",                 de = "Düstermarschen",                        fr = "Marécage d'Âprefange",               es = "Marjal Revolcafango",                       ru = "Пылевые топи",                     nameid = 1 , Continent = 1,              mapid = 851, Location =   7, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
-- this is for Allince
	[338] = {ztype = "SCN", en = "Dustwallow Marsh",                 de = "Düstermarschen",                        fr = "Marécage d'Âprefange",               es = "Marjal Revolcafango",                       ru = "Пылевые топи",                     nameid = 2 , Continent = 1,              mapid = 906, Location =   7, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},

	[339] = {ztype = "SCN", en = "Lion's Landing",                   de = "Die Löwenlandung",                      fr = "Le territoire du Lion",              es = "Desembarco del León",                       ru = "Львиный лагерь",                                Continent = 6,              mapid = 911, Location = 300, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	[340] = {ztype = "SCN", en = "A Little Patience",                de = "Ein wenig Geduld",                      fr = "Un peu de patience",                 es = "Templanza",                                 ru = "Немного терпения",                              Continent = 6,              mapid = 912, Location = 300, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	[341] = {ztype = "SCN", en = "Dagger in the Dark",               de = "Ein Dolch im Dunkel",                   fr = "Une dague dans la nuit",             es = "Una Daga en la Oscuridad",                  ru = "Кинжал во тьме",                                Continent = 6,              mapid = 914, Location = 300, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	[342] = {ztype = "SCN", en = "Domination Point",                 de = "Die Herrschaftsfeste",                  fr = "Halte de la Domination",             es = "Punto de Dominio",                          ru = "Крепость Покорителей",                          Continent = 6,              mapid = 920, Location = 300, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},

	[343] = {ztype = "SCR", en = "Deeprun Tram / Brawlpub",          de = "Deeprun Tram",                          fr = "Deeprun Tram",                       es = "Deeprun Tram",                              ru = "Deeprun Tram",                                  Continent = 2,              mapid = 922,                 LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	[344] = {ztype = "SCN", en = "Brawl'gar Arena",                  de = "Brawl'gar Arena",                       fr = "Brawl'gar Arena",                    es = "Brawl'gar Arena",                           ru = "Brawl'gar Arena",                               Continent = 2,              mapid = 925, Location =  46, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	[345] = {ztype = "SCN", en = "Brawl'gar Arena",                  de = "Brawl'gar Arena",                       fr = "Brawl'gar Arena",                    es = "Brawl'gar Arena",                           ru = "Brawl'gar Arena",                               Continent = 1,              mapid = 925, Location =  12, LevelRange = "90",           PlayerLimit =  "3", infoline = METAMAP_MOP_SCN_INFO},
	
	[346] = {ztype = "RDI", en = "Throne of Thunder",                    de = "Throne of Thunder",                    fr = "Throne of Thunder",                    es = "Throne of Thunder",                         ru = "Throne of Thunder",                                 Continent = 6,              mapid = 930, Location = 347, LevelRange = "90",           PlayerLimit = "25", infoline = METAMAP_MOP_INFO},
	[347] = {ztype = "SZ",  en = "Isle of Thunder",                 de = "Isle of Thunder",                  fr = "Isle of Thunder",                  es = "Isle of Thunder",                        ru = "Isle of Thunder",                             Continent = 6,                                           llvl = 90, hlvl = 90, faction = "Contested",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[348] = {ztype = "SZ",  en = "Isle of Giants",                 de = "Isle of Giants",                  fr = "Isle of Giants",                  es = "Isle of Giants",                        ru = "Isle of Giants",                             Continent = 6,                                           llvl = 90, hlvl = 90, faction = "Contested",   scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	
-- micro maps
	[355] = {ztype = "MSZ", en = "Blackrock Mountain",               de = "Der Schwarzfels",                       fr = "Mont Rochenoire",                    es = "Montaña Roca Negra",                        ru = "Черная гора",                                   Continent = 2,                           Location =  34, llvl = 50, hlvl = 52, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[356] = {ztype = "MSZ", en = "StillpineHold",                    de = "Tannenruhfeste",                        fr = "Repaire des Calmepins",              es = "Bastión Semprepino",                        ru = "Логово племени Тихвой",                         Continent = 1,                           Location =  55, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[357] = {ztype = "MSZ", en = "Tides' Hollow",                    de = "Gezeitenhöhle",                         fr = "Creux de la marée",                  es = "Hoya de la Marea",                          ru = "Пещера Приливов",                               Continent = 1,                           Location =  55, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[358] = {ztype = "MSZ", en = "Uldaman Entrance",                 de = "Eingang nach Uldaman",                  fr = "Entrée d’Uldaman",                   es = "Entrada de Uldaman",                        ru = "Ульдаман",                                      Continent = 2,                           Location =  32, llvl = 45, hlvl = 48, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[359] = {ztype = "MSZ", en = "Wailing Caverns",                  de = "Die Höhlen des Wehklagens",             fr = "Cavernes des Lamentations",          es = "Cuevas de los Lamentos",                    ru = "Пещеры Стенаний",                               Continent = 1,                           Location = 240, llvl = 10, hlvl = 20, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[360] = {ztype = "MSZ", en = "Frostmane Hovel",                  de = "Frostmähnenbau",                        fr = "Taudis des Crins-de-Givre",          es = "Cobertizo Peloescarcha",                    ru = "Пещера Мерзлогривов",                           Continent = 2,                           Location = 306, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[361] = {ztype = "MSZ", en = "Night Web's Hollow",               de = "Nachtwebergrund",                       fr = "Grottes des Tisse-nuit",             es = "Hoya Nocturácnidas",                        ru = "Паучья низина",                                 Continent = 2,                           Location = 308, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[362] = {ztype = "MSZ", en = "Maraudon",                         de = "Maraudon",                              fr = "Maraudon",                           es = "Maraudon",                                  ru = "Мародон",                                       Continent = 1,                           Location =   5, llvl = 30, hlvl = 35, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[363] = {ztype = "MSZ", en = "Coldridge Pass",                   de = "Eisklamm",                              fr = "Passe des Frigères",                 es = "Desfiladero de Crestanevada",               ru = "Туннель Холодной долины",                       Continent = 2,                           Location =  36, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[364] = {ztype = "MSZ", en = "Frostmane Hold",                   de = "Höhle der Frostmähnen",                 fr = "Repaire des Crins-de-Givre",         es = "Poblado Peloescarcha",                      ru = "Форт Мерзлогривов",                             Continent = 2,                           Location =  36, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[365] = {ztype = "MSZ", en = "New Tinkertown",                   de = "Neu-Tüftlerstadt",                      fr = "La Nouvelle-Brikabrok",              es = "Nueva Ciudad Manitas",                      ru = "Новый Город Механиков",                         Continent = 2,                           Location =  36, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[366] = {ztype = "MSZ", en = "Gol'Bolar Quarry",                 de = "Steinbruch Gol'Bolar",                  fr = "Carrière de Gol’Bolar",              es = "Cantera de Gol'Bolar",                      ru = "Карьер Гол'Болар",                              Continent = 2,                           Location =  36, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[367] = {ztype = "MSZ", en = "The Grizzled Den",                 de = "Der Graufelsbau",                       fr = "L’antre Gris",                       es = "El Cubil Pardo",                            ru = "Серая берлога",                                 Continent = 2,                           Location =  36, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[368] = {ztype = "MSZ", en = "Burning Blade Coven",              de = "Koven der Brennenden Klinge",           fr = "Convent de la Lame ardente",         es = "Aquelarre del Filo Ardiente",               ru = "Грот Пылающего Клинка",                         Continent = 1,                           Location =   6, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[369] = {ztype = "MSZ", en = "Dustwind Cave",                    de = "Staubwindhöhle",                        fr = "Caverne des Terrevent",              es = "Cueva Viento Seco",                         ru = "Пещера Пыльного Ветра",                         Continent = 1,                           Location =   6, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[370] = {ztype = "MSZ", en = "Skull Rock",                       de = "Knochenhöhle",                          fr = "Rocher du Crâne",                    es = "Roca del Cráneo",                           ru = "Скала Черепа",                                  Continent = 1,                           Location =   6, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[371] = {ztype = "MSZ", en = "Spitescale Cavern",                de = "Gallschuppenhöhle",                     fr = "Caverne des Vexécailles",            es = "Caverna Escama Maliciosa",                  ru = "Пещера Злобной Чешуи",                          Continent = 1,                           Location =   6, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[372] = {ztype = "MSZ", en = "Tiragarde Keep",                   de = "Burg Tiragarde",                        fr = "Donjon de Tiragarde",                es = "Fuerte de Tiragarde",                       ru = "Крепость Тирагард",                             Continent = 1,                           Location =   6, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[373] = {ztype = "MSZ", en = "Spitescale Cavern",                de = "Gallschuppenhöhle",                     fr = "Caverne des Vexécailles",            es = "Caverna Escama Maliciosa",                  ru = "Пещера Злобной Чешуи",                          Continent = 1,                           Location = 312, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[374] = {ztype = "MSZ", en = "Fargodeep Mine",                   de = "Tiefenschachtmine",                     fr = "Mine de Fondugouffre",               es = "Mina Abisal",                               ru = "Рудник Подземных Глубин",                       Continent = 2,                           Location =  39, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[375] = {ztype = "MSZ", en = "Jasperlode Mine",                  de = "Jaspismine",                            fr = "Mine Veine-de-Jaspe",                es = "Cantera de Jaspe",                          ru = "Яшмовая шахта",                                 Continent = 2,                           Location =  39, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[376] = {ztype = "MSZ", en = "Amani Catacombs",                  de = "Amanikatakomben",                       fr = "Catacombes des Amani",               es = "Catacumbas Amani",                          ru = "Катакомбы Амани",                               Continent = 2,                           Location =  23, llvl = 10, hlvl = 20, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[377] = {ztype = "MSZ", en = "Emberstone Mine",                  de = "Glutsteinmine",                         fr = "Mine de Pierrebraise",               es = "Mina Piedra Ígnea",                         ru = "Шахта Тлеющего Угля",                           Continent = 2,                           Location = 251, llvl =  1, hlvl = 12, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[378] = {ztype = "MSZ", en = "Greymane Manor",                   de = "Graumähnenanwesen",                     fr = "Manoir de Grisetête",                es = "Mansión de Cringris",                       ru = "Поместье Седогрива",                            Continent = 2,                           Location = 251, llvl =  1, hlvl = 12, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[379] = {ztype = "MSZ", en = "Kaja'mine",                        de = "Kaja'mine",                             fr = "Kaja’mine",                          es = "Kaja'mina",                                 ru = "Каджа'митовая шахта",                           Continent = 5,                           Location = 237, llvl =  1, hlvl =  5, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[380] = {ztype = "MSZ", en = "The Ruins of Ogudei",              de = "Die Ruinen von Ogudei",                 fr = "Les ruines d’Ogudei",                es = "Las Ruinas de Ogudei",                      ru = "Руины Огудея",                                  Continent = 6,                           Location = 300, llvl = 86, hlvl = 87, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[381] = {ztype = "MSZ", en = "Howlingwind Cavern",               de = "Heulwindhöhle",                         fr = "Caverne du Vent hurlant",            es = "Caverna Viento Aullante",                   ru = "Пещера Ревущего Ветра",                         Continent = 6,                           Location = 295, llvl = 87, hlvl = 88, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[382] = {ztype = "MSZ", en = "Knucklethump Hole",                de = "Faustklopploch",                        fr = "Trou des Coups-de-poing",            es = "Agujero Machakadedo",                       ru = "Логово Тяжелого Когтя",                         Continent = 6,                           Location = 295, llvl = 87, hlvl = 88, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[383] = {ztype = "MSZ", en = "Pranksters' Hollow",               de = "Witzboldwinkel",                        fr = "Creux des Farceurs",                 es = "Escondrijo de los Bribones",                ru = "Пещера шаловливых духов",                       Continent = 6,                           Location = 295, llvl = 87, hlvl = 88, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[384] = {ztype = "MSZ", en = "The Ruins of Korune",              de = "Die Ruinen von Korun",                  fr = "Les ruines de Korune",               es = "Las Ruinas de Korune",                      ru = "Руины клана Корун",                             Continent = 6,                           Location = 295, llvl = 87, hlvl = 88, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[385] = {ztype = "MSZ", en = "The Deeper",                       de = "Die Tiefere",                           fr = "La Fosse",                           es = "La Zanja",                                  ru = "Глубокая пещера",                               Continent = 6,                           Location = 295, llvl = 87, hlvl = 88, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[386] = {ztype = "MSZ", en = "Tomb of Conquerors",               de = "Das Grab der Eroberer",                 fr = "Tombe des Conquérants",              es = "Tumba de los Conquistadores",               ru = "Гробница Завоевателей",                         Continent = 6,                           Location = 295, llvl = 87, hlvl = 88, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[387] = {ztype = "MSZ", en = "Palemane Rock",                    de = "Bleichmähnenfels",                      fr = "Rocher des Crins-Pâles",             es = "Roca Crines Pálidas",                       ru = "Утес Бледногривов",                             Continent = 1,                           Location =  11, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[388] = {ztype = "MSZ", en = "The Venture Co. Mine",             de = "Die Mine der Venture Co.",              fr = "Mine de la KapitalRisk",             es = "Mina Ventura y Cía.",                       ru = "Рудник Торговой Компании",                      Continent = 1,                           Location =  11, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[389] = {ztype = "MSZ", en = "Frostmane Hold",                   de = "Höhle der Frostmähnen",                 fr = "Repaire des Crins-de-Givre",         es = "Poblado Peloescarcha",                      ru = "Форт Мерзлогривов",                             Continent = 2,                           Location = 307, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[390] = {ztype = "MSZ", en = "Echo Ridge Mine",                  de = "Echokammmine",                          fr = "Mine de la crête aux Échos",         es = "Mina del Eco",                              ru = "Рудник Горного Эха",                            Continent = 2,                           Location = 305, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[391] = {ztype = "MSZ", en = "Twilight's Run",                   de = "Kavernen des Schattenhammers",          fr = "Défilé du Crépuscule",               es = "Paseo Crepúsculo",                          ru = "Сумеречная пещера",                             Continent = 1,                           Location =  13, llvl = 55, hlvl = 60, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[392] = {ztype = "MSZ", en = "Caverns of Time",                  de = "Höhlen der Zeit",                       fr = "Grottes du Temps",                   es = "Cavernas del Tiempo",                       ru = "Пещеры Времени",                                Continent = 1,                           Location =  15, llvl = 45, hlvl = 50, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[393] = {ztype = "MSZ", en = "The Gaping Chasm",                 de = "Die Klaffende Schlucht",                fr = "Le gouffre Béant",                   es = "Sima Abierta",                              ru = "Зияющая бездна",                                Continent = 1,                           Location =  15, llvl = 45, hlvl = 50, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[394] = {ztype = "MSZ", en = "The Noxious Lair",                 de = "Der Giftige Unterschlupf",              fr = "Le repaire Nuisible",                es = "La Guarida Ponzoñosa",                      ru = "Ядовитый улей",                                 Continent = 1,                           Location =  15, llvl = 45, hlvl = 50, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[395] = {ztype = "MSZ", en = "Ban'ethil Barrow Den",             de = "Grabhügel von Ban'ethil",               fr = "Refuge des saisons de Ban’ethil",    es = "Túmulo de Ban'ethil",                       ru = "Обитель Бен'этиль",                             Continent = 1,                           Location =  16, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[396] = {ztype = "MSZ", en = "Fel Rock",                         de = "Teufelsfels",                           fr = "Gangreroche",                        es = "Roca Mácula",                               ru = "Пещера Бесов",                                  Continent = 1,                           Location =  16, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[397] = {ztype = "MSZ", en = "Shadowthread Cave",                de = "Schattenweberhöhle",                    fr = "Grotte de Sombrefil",                es = "Gruta Narácnida",                           ru = "Паучье логово",                                 Continent = 1,                           Location =  16, llvl =  1, hlvl = 10, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[398] = {ztype = "MSZ", en = "The Ancient Passage",              de = "Die Uralte Passage",                    fr = "L’ancien Passage",                   es = "El Pasaje Antiguo",                         ru = "Древний проход",                                Continent = 6,                           Location = 303, llvl = 87, hlvl = 88, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[399] = {ztype = "MSZ", en = "Greenstone Quarry",                de = "Grünsteinbruch",                        fr = "Carrière de Pierre-Verte",           es = "Cantera Verdemar",                          ru = "Каменоломня Зеленой Скалы",                     Continent = 6,                           Location = 296, llvl = 85, hlvl = 86, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[400] = {ztype = "MSZ", en = "Oona Kagu",                        de = "Uuna Kagu",                             fr = "Ouna Kagu",                          es = "Oona Kagu",                                 ru = "Уна Кагу",                                      Continent = 6,                           Location = 296, llvl = 85, hlvl = 86, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[401] = {ztype = "MSZ", en = "The Widow's Wail",                 de = "Das Klagen der Witwe",                  fr = "Les Sanglots de la veuve",           es = "El Lamento de la Viuda",                    ru = "Плач Вдовы",                                    Continent = 6,                           Location = 296, llvl = 85, hlvl = 86, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[402] = {ztype = "MSZ", en = "Gallywix Labor Mine",              de = "Gallywix' Fronmine",                    fr = "Mine de travail de Gallywix",        es = "Mina de Trabajos Forzados de Gallywix",     ru = "Исправительная шахта Галливикса",               Continent = 5,                           Location = 238, llvl =  5, hlvl = 12, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[403] = {ztype = "MSZ", en = "Kaja'mite Cavern",                 de = "Kaja'mithöhle",                         fr = "Caverne de Kaja’mite",               es = "Caverna de Kaja'mita",                      ru = "Каджа'митовая пещера",                          Continent = 5,                           Location = 238, llvl =  5, hlvl = 12, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[404] = {ztype = "MSZ", en = "Volcanoth's Lair",                 de = "Volcanoths Hort",                       fr = "Repaire de Volcanoth",               es = "Guarida de Volcanoth",                      ru = "Пещера Вулканота",                              Continent = 5,                           Location = 238, llvl =  5, hlvl = 12, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[405] = {ztype = "MSZ", en = "Scarlet Monastery Entrance",       de = "Eingang zum Scharlachroten Kloster",    fr = "Entrée du Monastère Écarlate",       es = "Entrada del Monasterio Escarlata",          ru = "Монастырь Алого ордена",                        Continent = 2,                           Location =  50, llvl =  1, hlvl = 10, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[406] = {ztype = "MSZ", en = "Niuzao Catacombs",                 de = "Niuzaokatakomben",                      fr = "Catacombes de Niuzao",               es = "Catacumbas de Niuzao",                      ru = "Катакомбы Нюцзао",                              Continent = 6,                           Location = 294, llvl = 88, hlvl = 89, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[407] = {ztype = "MSZ", en = "The Slithering Scar",              de = "Die Wuchernde Narbe",                   fr = "La Balafre sinueuse",                es = "La Cicatriz Serpenteante",                  ru = "Скользкий овраг",                               Continent = 1,                           Location =  20, llvl = 50, hlvl = 55, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[408] = {ztype = "MSZ", en = "Guo-Lai Halls",                    de = "Guo-Lai-Hallen",                        fr = "Salles de Guo-Lai",                  es = "Salas de Guo-Lai",                          ru = "Залы Го-Лай",                                   Continent = 6,                           Location = 298, llvl = 87, hlvl = 90, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[409] = {ztype = "MSZ", en = "Shrine of Seven Stars",            de = "Schrein der Sieben Sterne",             fr = "Sanctuaire des Sept-Étoiles",        es = "Santuario de las Siete Estrellas",          ru = "Святилище Семи Звезд",                          Continent = 6,                           Location = 298, llvl = 87, hlvl = 90, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[410] = {ztype = "MSZ", en = "Shrine of Two Moons",              de = "Schrein der Zwei Monde",                fr = "Sanctuaire des Deux-Lunes",          es = "Santuario de las Dos Lunas",                ru = "Святилище Двух Лун",                            Continent = 6,                           Location = 298, llvl = 87, hlvl = 90, faction = "Horde",     scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[411] = {ztype = "MSZ", en = "Cavern of Endless Echoes",         de = "Die Höhle Endloser Echos",              fr = "Caverne des Échos sans fin",         es = "Cueva del Eco Infinito",                    ru = "Пещера Бесконечного Эха",                       Continent = 6,                           Location = 297, llvl = 86, hlvl = 87, faction = "Contested", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[412] = {ztype = "MSZ", en = "The Deadmines",                    de = "Die Todesminen",                        fr = "Les Mortemines",                     es = "Las Minas de la Muerte",                    ru = "Мертвые копи",                                  Continent = 2,                           Location =  53, llvl = 10, hlvl = 15, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[413] = {ztype = "MSZ", en = "Gold Coast Quarry",                de = "Der Goldküstensteinbruch",              fr = "Carrière de la Côte de l’or",        es = "Mina de la Costa del Oro",                  ru = "Прииск на Золотом Берегу",                      Continent = 2,                           Location =  53, llvl = 10, hlvl = 15, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[414] = {ztype = "MSZ", en = "Jangolode Mine",                   de = "Der Jangoschacht",                      fr = "Mine Veine-de-Jango",                es = "Mina de Jango",                             ru = "Рудник Янго",                                   Continent = 2,                           Location =  53, llvl = 10, hlvl = 15, faction = "Alliance",  scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
}

for index, zoneTable in pairs(MetaMap_ZoneTable) do
	if ((zoneTable.ztype == "RDI") or (zoneTable.ztype == "DNI") or (zoneTable.ztype == "SZR") or (zoneTable.ztype == "MSZ") or (zoneTable.ztype == "BG") or (zoneTable.ztype == "SCN")) then
-- for debug only
--		if (zoneTable.Location == nil) then
--			msg = "Contants loc:"..index.." name: "..zoneTable.en;
--			msg = "["..date("%m/%d/%y %H:%M:%S").."]".."<METAMAP>: "..msg;
--			r = 0.60; g = 0.80; b = 1.00;
--			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b);
--		end
		if (zoneTable.Location) then
			local nameid;
			local nameid0 = MetaMap_ZoneTable[zoneTable.Location].nameid;
			if (nameid0) then nameid = tostring(nameid0); end
			if (nameid) then nameid = "_"..nameid; else nameid = ""; end
			zoneTable.Location = MetaMap_ZoneTable[zoneTable.Location][MetaMap_Locale]..nameid;
		end
	end
end
