--[[--------------------------------------------------------------------------------------------
  
Uses a hardcoded list of overlay data which duplicates data available in the client.  Since it
also queries the client to find out which overlays should be 100%, it will detect discrepancies
in the client data and record any mismatched or not-present data in a saved Errata table.

--]]--------------------------------------------------------------------------------------------
local FWM_OverlayInfo = {
		["Teldrassil"] = {
 			"TheCleft:144:226:432:109",
			"PoolsofArlithrien:140:210:345:243",
			"GalardellValley:178:186:466:237",
			"RutheranVillage:317:220:329:448",
			"WellspringLake:165:249:382:83",
			"BanethilHollow:175:235:374:221",
			"TheOracleGlade:194:244:276:90",
			"Shadowglen:241:217:481:104",
			"Darnassus:298:337:149:181",
			"LakeAlameth:289:202:422:310",
			"StarbreezeVillage:187:196:544:217",
			"GnarlpineHold:198:181:347:355",
		},
		["Sunwell"] = {
			"SunsReachHarbor:512:416:252:252",
			"SunsReachSanctum:512:512:251:4",
		},
		["DunMorogh"] = {
			"Kharanos:184:188:449:220",
			"IceFlowLake:236:358:263:0",
			"AmberstillRanch:249:183:595:225",
			"TheGrizzledDen:211:160:374:287",
			"IronforgeAirfield:308:335:630:0",
			"Ironforge:376:347:398:0",
			"ShimmerRidge:171:234:397:132",
			"HelmsBedLake:218:234:760:268",
			"Gnomeregan:409:318:0:27",
			"FrostmaneHold:437:249:50:227",
			"ColdridgeValley:398:302:100:366",
			"TheShimmeringDeep:171:234:397:132",
			"ColdridgePass:225:276:360:340",
			"FrostmaneFront:226:335:469:256",
			"NorthGateOutpost:237:366:765:43",
			"TheTundridHills:174:249:579:306",
			"GolBolarQuarry:198:251:663:288",
		},
		["Elwynn"] = {
			"FargodeepMine:269:248:240:420",
			"TowerofAzora:270:241:529:287",
			"StonecairnLake:340:272:552:186",
			"CrystalLake:220:207:417:327",
			"EastvaleLoggingCamp:294:243:703:292",
			"WestbrookGarrison:269:313:116:355",
			"NorthshireValley:295:296:355:138",
			"RidgepointTower:285:194:708:442",
			"Stromwind:512:422:0:0",
			"Goldshire:276:231:247:294",
			"JerodsLanding:230:206:396:430",
			"BrackwellPumpkinPatch:287:216:532:424",
		},
		["Mulgore"] = {
			"BloodhoofVillage:302:223:319:273",
			"WindfuryRidge:222:202:400:0",
			"ThunderBluff:373:259:208:62",
			"RedCloudMesa:446:264:286:401",
			"WinterhoofWaterWell:174:185:449:340",
			"ThunderhornWaterWell:201:167:333:202",
			"WildmaneWaterWell:190:172:331:0",
			"RavagedCaravan:187:165:435:224",
			"BaeldunDigsite:218:192:226:220",
			"StonetalonPass:237:184:201:0",
			"TheGoldenPlains:186:216:448:101",
			"PalemaneRock:172:205:248:321",
			"TheRollingPlains:260:243:527:291",
			"TheVentureCoMine:208:300:530:138",
			"RedRocks:186:185:514:43",
		},
		["Kezan"] = {
			"SwindleStreet:168:213:317:232",
			"Drudgetown:351:301:180:367",
			"GallywixsVilla:303:452:0:41",
			"FirstbankofKezan:376:343:98:325",
			"TheSlick:592:202:219:108",
			"Kajamine:354:360:586:308",
			"BilgewaterPort:694:290:163:148",
			"KTCHeadquarters:321:401:433:267",
			"KajaroField:250:307:383:260",
		},
		["Tirisfal"] = {
			"ColdHearthManor:212:177:418:317",
			"BalnirFarmstead:242:179:594:324",
			"TheBulwark:293:338:709:330",
			"AgamandMills:285:260:324:90",
			"ScarletMonastery:262:262:740:47",
			"RuinsofLorderon:390:267:423:359",
			"BrightwaterLake:210:292:573:122",
			"CalstonEstate:179:169:389:255",
			"Deathknell:431:407:9:207",
			"SollidenFarmstead:286:225:201:192",
			"Brill:199:182:480:252",
			"NightmareVale:225:281:347:325",
			"CrusaderOutpost:175:210:686:232",
			"ScarletWatchPost:161:234:692:99",
			"GarrensHaunt:190:214:477:129",
			"VenomwebVale:250:279:752:150",
		},
		["Durotar"] = {
			"Orgrimmar:259:165:309:0",
			"TiragardeKeep:210:200:462:298",
			"SenjinVillage:192:184:457:406",
			"SkullRock:208:157:438:0",
			"ValleyOfTrials:254:258:304:312",
			"NorthwatchFoothold:162:157:399:440",
			"RazormaneGrounds:248:158:302:264",
			"SouthfuryWatershed:244:222:282:174",
			"DrygulchRavine:236:196:415:60",
			"ThunderRidge:220:218:295:48",
			"EchoIsles:330:255:429:413",
			"RazorHill:224:227:431:157",
		},
		["Westfall"] = {
			"Moonbrook:232:213:308:325",
			"TheGapingChasm:184:217:294:168",
			"TheDeadAcre:193:273:531:200",
			"GoldCoastQuarry:235:306:199:79",
			"JangoloadMine:196:229:311:0",
			"TheDaggerHills:292:273:303:395",
			"TheDustPlains:317:261:480:378",
			"AlexstonFarmstead:346:222:167:263",
			"WestfallLighthouse:211:167:221:477",
			"TheMolsenFarm:202:224:348:118",
			"DemontsPlace:201:195:203:376",
			"FurlbrowsPumpkinFarm:197:213:394:0",
			"TheJansenStead:202:179:474:0",
			"SentinelHill:229:265:404:226",
			"SaldeansFarm:244:237:451:81",
		},
		["Silverpine"] = {
			"NorthTidesRun:281:345:147:0",
			"DeepElemMine:217:198:483:212",
			"FenrisIsle:352:302:581:15",
			"ValgansField:162:172:461:77",
			"ShadowfangKeep:179:165:337:337",
			"OlsensFarthing:251:167:312:249",
			"TheForsakenFront:152:189:433:327",
			"BerensPeril:318:263:505:405",
			"TheDecrepitFields:176:152:471:156",
			"TheGreymaneWall:409:162:318:506",
			"TheBattlefront:255:180:349:429",
			"TheSkitteringDark:227:172:236:0",
			"ForsakenRearGuard:186:238:369:0",
			"NorthTidesBeachhead:174:199:323:68",
			"Ambermill:283:243:509:250",
			"TheSepulcher:218:200:341:157",
			"ForsakenHighCommand:361:175:445:0",
		},
		["LochModan"] = {
			"TheLoch:330:474:340:81",
			"NorthgatePass:319:289:16:0",
			"StonesplinterValley:273:294:177:345",
			"SilverStreamMine:225:252:221:0",
			"MogroshStronghold:294:249:549:52",
			"GrizzlepawRidge:273:230:245:324",
			"Thelsamar:455:295:0:146",
			"ValleyofKings:310:345:0:311",
			"StronewroughtDam:333:200:339:0",
			"TheFarstriderLodge:349:292:570:209",
			"IronbandsExcavationSite:397:291:481:296",
		},
		["Darkshore"] = {
			"WitheringThicket:328:250:305:118",
			"RuinsofMathystra:200:263:517:28",
			"TheMastersGlaive:303:185:277:483",
			"ShatterspearWarcamp:245:147:565:0",
			"EyeoftheVortex:330:192:300:239",
			"WildbendRiver:314:193:280:378",
			"Lordanel:277:281:391:54",
			"RuinsofAuberdine:203:194:280:182",
			"ShatterspearVale:250:241:596:16",
			"Nazjvel:244:201:207:467",
			"AmethAran:326:145:294:330",
		},
		["Redridge"] = {
			"RendersCamp:357:246:214:0",
			"GalardellValley:428:463:574:0",
			"LakeEverstill:464:250:81:214",
			"AlthersMill:228:247:350:139",
			"StonewatchKeep:228:420:480:0",
			"ShalewindCanyon:306:324:688:283",
			"CampEverstill:189:193:445:286",
			"Lakeshire:410:256:0:110",
			"ThreeCorners:323:406:0:256",
			"LakeridgeHighway:392:352:148:316",
			"StonewatchFalls:316:182:525:302",
			"RendersValley:427:291:451:377",
			"RedridgeCanyons:413:292:37:0",
		},
		["Wetlands"] = {
			"WhelgarsExcavationSite:298:447:185:195",
			"DireforgeHills:329:228:506:34",
			"SlabchiselsSurvey:300:316:532:352",
			"DunModr:257:185:356:7",
			"MosshideFen:369:235:506:232",
			"GreenwardensGrove:250:269:460:102",
			"SundownMarsh:276:243:121:63",
			"RaptorRidge:256:245:599:123",
			"ThelganRock:258:207:371:335",
			"DunAlgaz:298:215:346:419",
			"MenethilHarbor:325:363:0:297",
			"Satlspray:250:282:218:0",
			"BlackChannelMarsh:301:232:37:240",
			"BluegillMarsh:321:248:31:102",
			"IronbeardsTomb:185:224:372:76",
			"AngerfangEncampment:236:256:359:201",
		},
		["VashjirDepths"] = {
			"AbyssalBreach:491:470:497:0",
			"Seabrush:225:250:415:183",
			"ColdlightChasm:267:374:266:280",
			"AbandonedReef:371:394:50:263",
			"KorthunsEnd:370:385:412:283",
			"DeepfinRidge:363:262:275:32",
			"FireplumeTrench:298:251:315:110",
			"LGhorek:306:293:162:210",
		},
		["HillsbradFoothills"] = {
			"SlaughterHollow:148:120:413:55",
			"PurgationIsle:144:139:200:505",
			"CrushridgeHold:134:124:463:101",
			"DurnholdeKeep:437:451:565:217",
			"GallowsCorner:155:147:451:140",
			"LordamereInternmentCamp:250:167:194:216",
			"DunGarok:269:258:542:410",
			"MistyShore:158:169:321:42",
			"HillsbradFields:302:175:191:302",
			"TheHeadland:105:148:390:255",
			"CorrahnsDagger:135:160:426:224",
			"DalaranCrater:316:238:102:137",
			"GrowlessCave:171:136:359:191",
			"ChillwindPoint:447:263:555:68",
			"GavinsNaze:116:129:344:254",
			"RuinsOfAlterac:189:181:347:85",
			"NethanderSteed:204:244:502:373",
			"DarrowHill:147:160:425:279",
			"TheUplands:212:160:441:0",
			"Southshore:229:219:383:352",
			"DandredsFold:258:113:341:0",
			"Strahnbrad:275:193:505:44",
			"TarrenMill:165:203:494:226",
			"SouthpointTower:312:254:59:310",
			"SoferasNaze:148:146:484:166",
			"AzurelodeMine:180:182:287:399",
		},
		["Duskwood"] = {
			"RacenHill:205:157:96:292",
			"RavenHillCemetary:323:309:91:132",
			"TheYorgenFarmstead:233:248:401:396",
			"TheHushedBank:189:307:0:152",
			"VulGolOgreMound:268:282:228:355",
			"TheTwilightGrove:320:388:314:101",
			"TheTranquilGardensCemetary:291:244:627:344",
			"TheDarkenedBank:931:235:71:26",
			"TheRottingOrchard:291:263:539:368",
			"Darkshire:329:314:640:128",
			"ManorMistmantle:219:182:661:122",
			"AddlesStead:299:296:32:348",
			"BrightwoodGrove:279:399:497:112",
		},
		["RuinsofGilneas"] = {
			"GilneasPuzzle:1002:668:0:0",
		},
		["Barrens"] = {
			"MorshanRampart:261:216:258:6",
			"TheStagnantOasis:336:289:344:379",
			"Ratchet:219:175:547:379",
			"BoulderLodeMine:278:209:511:7",
			"TheWailingCaverns:377:325:152:318",
			"FarWatchPost:207:332:555:129",
			"TheForgottenPools:446:256:100:208",
			"ThornHill:239:231:481:254",
			"TheMerchantCoast:315:212:556:456",
			"TheCrossroads:233:193:362:275",
			"GroldomFarm:243:217:448:127",
			"DreadmistPeak:241:195:290:104",
			"TheDryHills:283:270:116:57",
			"TheSludgeFen:257:249:403:6",
		},
		["TheCapeOfStranglethorn"] = {
			"BootyBay:225:255:289:341",
			"CrystalveinMine:271:204:528:73",
			"GurubashiArena:238:260:345:0",
			"MistvaleValley:253:242:408:248",
			"RuinsofAboraz:184:176:533:181",
			"NekmaniWellspring:246:221:292:213",
			"JagueroIsle:240:264:471:404",
			"WildShore:236:276:340:392",
			"TheSundering:244:209:452:0",
			"HardwrenchHideaway:356:221:208:116",
			"RuinsofJubuwal:155:221:468:119",
		},
		["StranglethornJungle"] = {
			"BaliaMahRuins:239:205:397:243",
			"GromGolBaseCamp:167:179:298:228",
			"LakeNazferiti:240:228:413:95",
			"Bambala:190:176:566:164",
			"MizjahRuins:157:173:387:246",
			"BalAlRuins:159:137:267:168",
			"NesingwarysExpedition:227:190:306:63",
			"KurzensCompound:244:238:499:0",
			"ZuuldalaRuins:324:263:9:22",
			"RuinsOfZulKunda:228:265:158:0",
			"Mazthoril:350:259:488:364",
			"TheVileReef:236:224:140:208",
			"MoshOggOgreMound:234:206:543:253",
			"RebelCamp:302:166:306:0",
			"FortLivingston:230:170:398:375",
			"ZulGurub:376:560:626:0",
			"KalAiRuins:139:150:354:184",
		},
		["SwampOfSorrows"] = {
			"Stagalbog:347:303:540:360",
			"Bogpaddle:262:193:600:0",
			"TheHarborage:266:284:161:79",
			"Sorrowmurk:229:418:703:80",
			"SplinterspearJunction:238:343:194:236",
			"MarshtideWatch:330:342:478:0",
			"TheShiftingMire:292:360:331:24",
			"PoolOfTears:257:229:575:238",
			"Stonard:357:308:297:258",
			"MistyreedStrand:402:668:600:0",
			"IthariusCave:268:316:7:242",
			"MistyValley:268:285:0:80",
		},
		["Arathi"] = {
			"Hammerfall:270:271:581:118",
			"GalensFall:212:305:0:144",
			"CirecleofOuterBinding:215:188:332:273",
			"DabyriesFarmstead:210:227:404:144",
			"NorthfoldManor:227:268:132:105",
			"ThandolSpan:237:252:261:416",
			"RefugePoint:196:270:293:145",
			"CircleofWestBinding:220:287:85:24",
			"FaldirsCove:273:268:77:400",
			"Bouldergor:249:278:171:123",
			"WitherbarkVillage:260:220:476:359",
			"GoShekFarm:306:248:430:249",
			"CircleofEastBinding:183:238:506:126",
			"CircleofInnerBinding:228:227:201:312",
			"StromgardeKeep:284:306:21:269",
			"BoulderfistHall:252:258:327:367",
		},
		["Badlands"] = {
			"ApocryphansRest:252:353:0:66",
			"CampBoff:274:448:407:220",
			"AgmondsEnd:342:353:230:315",
			"AngorFortress:285:223:230:68",
			"CampCagg:339:347:0:281",
			"CampKosh:236:260:504:19",
			"Uldaman:266:210:336:0",
			"HammertoesDigsite:209:196:411:116",
			"LethlorRavine:469:613:533:55",
			"DeathwingScar:328:313:175:178",
			"TheDustbowl:214:285:144:99",
		},
		["Hinterlands"] = {
			"AeriePeak:238:267:0:236",
			"TheCreepingRuin:199:199:390:252",
			"Zunwatha:226:225:152:284",
			"PlaguemistRavine:191:278:133:105",
			"Seradane:303:311:475:5",
			"JinthaAlor:287:289:487:334",
			"SkulkRock:176:235:490:195",
			"ShadraAlor:240:196:220:379",
			"Agolwatha:208:204:367:159",
			"Shaolwatha:281:261:565:208",
			"TheAltarofZul:225:196:357:343",
			"TheOverlookCliffs:244:401:677:267",
			"ValorwindLake:199:212:286:269",
			"QuelDanilLodge:241:211:220:181",
		},
		["UngoroCrater"] = {
			"TheScreamingReaches:332:332:157:0",
			"TerrorRun:316:293:162:357",
			"GolakkaHotSprings:309:277:145:226",
			"MossyPile:186:185:328:179",
			"LakkariTarPits:432:294:305:0",
			"TheMarshlands:263:412:573:256",
			"TheSlitheringScar:381:274:335:384",
			"FungalRock:224:191:557:0",
			"TheRollingGarden:337:321:565:39",
			"MarshalsStand:204:170:462:330",
			"FirePlumeRidge:321:288:356:192",
			"IronstonePlateau:197:222:706:201",
		},
		["Tanaris"] = {
			"EastmoonRuins:173:163:380:341",
			"SouthbreakShore:274:186:437:289",
			"ZulFarrak:315:190:184:0",
			"SandsorrowWatch:214:149:293:99",
			"AbyssalSands:255:194:297:148",
			"SouthmoonRuins:232:211:301:349",
			"CavernsofTime:213:173:507:238",
			"BrokenPillar:195:163:413:211",
			"DunemaulCompound:231:177:305:257",
			"ValleryoftheWatchers:269:190:255:431",
			"LostRiggerCover:178:243:615:201",
			"GadgetzanBay:254:341:479:9",
			"LandsEndBeach:224:216:431:452",
			"ThistleshrubValley:221:293:185:280",
			"TheGapingChasm:225:187:448:364",
			"TheNoxiousLair:179:190:258:211",
			"Gadgetzan:189:180:412:92",
		},
		["Dustwallow"] = {
			"AlcazIsland:206:200:656:21",
			"BrackenwllVillage:384:249:133:59",
			"BlackhoofVillage:344:183:199:0",
			"DirehornPost:279:301:358:169",
			"ShadyRestInn:317:230:137:188",
			"TheWyrmbog:436:299:359:369",
			"WitchHill:270:353:428:0",
			"TheramoreIsle:305:247:542:223",
			"Mudsprocket:433:351:109:313",
		},
		["ThousandNeedles"] = {
			"RustmaulDiveSite:234:203:527:465",
			"TheShimmeringDeep:411:411:591:257",
			"DarkcloudPinnacle:317:252:169:116",
			"FreewindPost:436:271:276:186",
			"Highperch:246:380:0:134",
			"TheTwilightWithering:374:339:347:329",
			"SplithoofHeights:431:410:571:49",
			"TwilightBulwark:358:418:125:241",
			"TheGreatLift:272:232:136:0",
			"WestreachSummit:280:325:0:0",
			"SouthseaHoldfast:246:256:756:412",
			"RazorfenDowns:361:314:298:0",
		},
		["SearingGorge"] = {
			"FirewatchRidge:365:393:0:75",
			"BlackrockMountain:304:244:243:424",
			"TannerCamp:571:308:413:360",
			"ThoriumPoint:429:301:255:38",
			"TheCauldron:481:360:232:171",
			"DustfireValley:392:355:588:0",
			"GrimsiltWorksite:441:266:531:241",
			"BlackcharCave:375:307:0:361",
		},
		["Ashenvale"] = {
			"TheRuinsofStardust:236:271:210:331",
			"RaynewoodRetreat:231:256:481:221",
			"ThistlefurVillage:314:241:255:78",
			"LakeFalathim:184:232:112:148",
			"TheZoramStrand:262:390:0:0",
			"OrendilsRetreat:244:251:143:0",
			"FallenSkyLake:287:276:529:385",
			"Satyrnaar:235:236:696:154",
			"TheShrineofAssenia:306:283:40:275",
			"WarsongLumberCamp:231:223:771:265",
			"BoughShadow:166:211:836:148",
			"SilverwindRefuge:347:308:338:335",
			"Astranaar:251:271:255:164",
			"NightRun:221:257:595:253",
			"TheHowlingVale:325:239:473:97",
			"FelfireHill:277:333:714:317",
			"ThunderPeak:203:310:377:121",
			"MaelstrasPost:246:361:188:0",
		},
		["Desolace"] = {
			"ThargadsCamp:212:186:275:376",
			"ShadowpreyVillage:222:299:142:369",
			"MannorocCoven:326:311:381:357",
			"SlitherbladeShore:338:342:208:24",
			"MagramTerritory:289:244:613:170",
			"TethrisAran:274:145:399:0",
			"ShokThokar:309:349:589:319",
			"CenarionWildlands:312:285:415:156",
			"Sargeron:317:293:655:0",
			"RanzjarIsle:161:141:210:0",
			"KodoGraveyard:250:215:360:273",
			"ShadowbreakRavine:292:266:637:402",
			"ThunderAxeFortress:220:205:440:49",
			"GelkisVillage:274:196:207:472",
			"ValleyofSpears:321:275:170:196",
			"NijelsPoint:231:257:573:0",
		},
		["BurningSteppes"] = {
			"AltarofStorms:182:360:0:0",
			"Dracodar:362:431:0:237",
			"MorgansVigil:383:413:615:255",
			"BlackrockStronghold:320:385:235:0",
			"TerrorWingPath:350:341:646:7",
			"DreadmaulRock:274:263:568:151",
			"RuinsofThaurissan:324:354:421:0",
			"BlackrockPass:298:410:419:258",
			"BlackrockMountain:281:388:79:0",
			"PillarofAsh:274:413:253:255",
		},
		["VashjirRuins"] = {
			"RuinsOfVashjir:349:361:217:268",
			"BethMoraRidge:335:223:407:445",
			"ShimmeringGrotto:339:278:400:0",
			"RuinsOfTherseral:197:223:554:175",
			"Nespirah:286:269:460:261",
			"GlimmeringdeepGorge:272:180:270:222",
			"SilverTideHollow:480:319:150:32",
		},
		["BlastedLands"] = {
			"TheRedReaches:268:354:533:268",
			"DreadmaulPost:235:188:327:182",
			"TheTaintedForest:348:357:132:311",
			"NethergardeKeep:295:205:530:6",
			"TheDarkPortal:370:298:368:179",
			"SerpentsCoil:218:183:459:97",
			"SunveilExcursion:233:266:386:374",
			"DreadmaulHold:272:206:258:0",
			"AltarofStorms:238:195:225:110",
			"NethergardeSupplyCamps:195:199:436:0",
			"Shattershore:240:270:578:91",
			"Surwich:199:191:333:474",
			"RiseoftheDefiler:168:170:375:102",
			"TheTaintedScar:308:226:144:175",
		},
		["Aszhara"] = {
			"RuinsofEldarath:218:237:228:229",
			"RavencrestMonument:295:267:476:401",
			"BearsHead:256:224:113:141",
			"LakeMennar:210:232:245:377",
			"BilgewaterHarbor:587:381:395:127",
			"OrgimmarRearGate:352:274:22:344",
			"TheShatteredStrand:206:329:316:168",
			"TowerofEldara:306:337:684:22",
			"TheSecretLab:184:213:353:396",
			"GallywixPleasurePalace:250:230:70:222",
			"RuinsofArkkoran:219:193:575:121",
			"StormCliffs:207:232:407:403",
			"DarnassianBaseCamp:243:262:343:3",
			"BitterReaches:321:247:477:0",
			"BlackmawHold:260:267:204:53",
		},
		["Felwood"] = {
			"TalonbranchGlade:209:226:531:57",
			"EmeraldSanctuary:274:212:394:382",
			"RuinsofConstellas:268:214:278:359",
			"IrontreeWoods:261:273:406:55",
			"ShatterScarVale:343:250:243:107",
			"MorlosAran:187:176:476:484",
			"BloodvenomFalls:345:192:220:231",
			"DeadwoodVillage:173:163:410:505",
			"JadefireGlen:229:210:288:458",
			"FelpawVillage:307:161:471:0",
			"JadefireRun:263:199:303:9",
			"Jaedenar:319:176:234:317",
		},
		["EasternPlaguelands"] = {
			"TheFungalVale:274:216:183:211",
			"EastwallTower:181:176:541:184",
			"LightsShieldTower:243:162:391:271",
			"Plaguewood:328:253:144:40",
			"LakeMereldar:266:241:462:427",
			"Darrowshire:248:206:211:462",
			"NorthpassTower:250:192:401:69",
			"Terrordale:258:320:0:10",
			"CrownGuardTower:202:191:258:351",
			"ZulMashar:286:176:528:0",
			"RuinsOfTheScarletEnclave:264:373:738:295",
			"Tyrshand:214:254:651:414",
			"ThondorilRiver:262:526:0:100",
			"TheUndercroft:280:211:56:457",
			"TheInfectisScar:177:266:595:263",
			"QuelLithienLodge:277:175:351:0",
			"TheMarrisStead:202:202:133:335",
			"ThePestilentScar:182:320:383:348",
			"BlackwoodLake:238:231:382:151",
			"LightsHopeChapel:196:220:687:271",
			"TheNoxiousGlade:297:299:650:55",
			"Acherus:228:273:774:102",
			"CorinsCrossing:186:213:493:289",
			"Stratholme:310:178:118:0",
			"Northdale:265:232:570:61",
		},
		["TwilightHighlands"] = {
			"HumboldtConflaguration:143:141:344:89",
			"HighlandForest:239:232:482:330",
			"CrucibleOfCarnage:203:208:387:268",
			"GlopgutsHollow:174:190:291:89",
			"ObsidianForest:342:288:436:380",
			"RuinsOfDrakgor:206:182:296:0",
			"SlitheringCove:198:201:622:169",
			"FirebeardsPatrol:215:181:499:265",
			"WyrmsBend:191:198:205:232",
			"VictoryPoint:177:159:302:306",
			"DragonmawPort:251:207:631:245",
			"TheTwilightBreach:199:212:312:192",
			"TheKrazzworks:226:232:654:0",
			"Kirthaven:308:267:482:0",
			"Highbank:220:227:697:403",
			"Crushblow:182:195:370:447",
			"Thundermar:238:229:374:93",
			"GrimBatol:230:276:83:223",
			"TheGullet:175:180:269:179",
			"Bloodgulch:215:157:416:205",
			"TwilightShore:260:202:610:345",
			"TheBlackBreach:211:210:498:121",
			"DragonmawPass:283:206:76:120",
			"DunwaldRuins:197:218:395:367",
			"TheTwilightGate:165:199:327:356",
			"VermillionRedoubt:324:264:71:16",
			"GorshakWarCamp:194:170:543:220",
			"WeepingWound:214:190:358:0",
			"TheTwilightCitadel:361:354:151:314",
		},
		["VashjirKelpForest"] = {
			"LegionsFate:278:315:210:35",
			"HonorsTomb:291:206:380:43",
			"TheAccursedReef:340:225:365:162",
			"GubogglesLedge:227:207:399:280",
			"GnawsBoneyard:311:217:451:325",
			"HoldingPens:316:267:456:401",
			"DarkwhisperGorge:220:189:528:228",
		},
		["Deepholm"] = {
			"TwilightOverlook:411:248:570:420",
			"CrimsonExpanse:462:400:540:12",
			"TwilightTerrace:237:198:297:384",
			"DeathwingsFall:454:343:549:297",
			"StoneHearth:371:354:0:314",
			"StormsFuryWreckage:292:285:458:383",
			"TheShatteredField:430:230:141:438",
			"TherazanesThrone:274:156:434:0",
			"ThePaleRoost:467:273:85:0",
			"ScouredReach:516:287:448:0",
			"NeedlerockChasm:378:359:20:0",
			"TempleOfEarth:355:345:287:177",
			"NeedlerockSlag:370:285:0:146",
		},
		["StonetalonMountains"] = {
			"ThaldarahOverlook:210:189:252:121",
			"KromgarFortress:183:196:588:341",
			"SunRockRetreat:222:222:353:285",
			"MirkfallonLake:244:247:417:143",
			"CliffwalkerPost:241:192:366:95",
			"TheCharredVale:277:274:199:368",
			"BoulderslideRavine:194:156:532:512",
			"WindshearHold:176:189:516:289",
			"WebwinderHollow:164:258:479:401",
			"BattlescarValley:290:297:220:189",
			"StonetalonPeak:305:244:265:0",
			"WindshearCrag:374:287:533:179",
			"WebwinderPath:267:352:468:263",
			"RuinsofEldrethar:221:235:367:411",
			"GreatwoodVale:322:220:602:448",
			"UnearthedGrounds:265:206:654:369",
			"Malakajin:211:131:618:537",
		},
		["WesternPlaguelands"] = {
			"DalsonsFarm:325:192:300:232",
			"CaerDarrow:194:208:601:390",
			"SorrowHill:368:220:261:448",
			"GahrronsWithering:241:252:495:213",
			"NorthridgeLumberCamp:359:182:231:123",
			"TheWrithingHaunt:169:195:472:332",
			"Hearthglen:432:271:235:0",
			"Andorhal:464:325:96:343",
			"DarrowmereLake:492:314:510:354",
			"FelstoneField:241:212:229:228",
			"TheBulwark:316:316:48:235",
			"ThondrorilRiver:311:436:533:0",
			"RedpineDell:290:133:286:211",
			"TheWeepingCave:185:230:551:151",
		},
		["Feralas"] = {
			"RuinsofFeathermoon:208:204:186:229",
			"GordunniOutpost:192:157:663:116",
			"GrimtotemCompund:159:218:607:170",
			"LowerWilds:207:209:756:191",
			"DireMaul:265:284:485:101",
			"WrithingDeep:232:206:652:298",
			"DarkmistRuins:172:198:568:287",
			"CampMojache:174:220:671:181",
			"TheForgottenCoast:194:304:375:343",
			"FeralScar:191:179:457:281",
			"FeathermoonStronghold:217:192:362:237",
			"TheTwinColossals:350:334:271:0",
			"RuinsofIsildien:206:237:467:354",
		},
		["Uldum"] = {
			"CradelOfTheAncient:202:169:341:402",
			"HallsOfOrigination:269:242:599:184",
			"TheVortexPinnacle:213:195:656:473",
			"RuinsOfAhmtul:278:173:365:0",
			"AkhenetFields:164:185:471:277",
			"TahretGrounds:150:159:545:193",
			"Orsis:249:243:264:136",
			"Marat:160:193:406:174",
			"ObeliskOfTheSun:269:203:340:282",
			"TheTrailOfDevestation:206:204:657:349",
			"TheGateofUnendingCycles:161:236:647:15",
			"TheCursedlanding:237:316:752:170",
			"ObeliskOfTheMoon:400:224:110:0",
			"KhartutsTomb:203:215:542:0",
			"Ramkahen:228:227:411:67",
			"TempleofUldum:296:209:132:127",
			"Neferset:209:254:407:384",
			"LostCityOfTheTolVir:233:321:527:291",
			"Nahom:237:194:583:162",
			"Schnottzslanding:312:289:28:221",
			"ObeliskOfTheStars:196:170:551:121",
			"RuinsOfAmmon:203:249:217:289",
			"VirnaalDam:151:144:479:215",
			"ThroneOfTheFourWinds:270:229:229:433",
		},
		["Winterspring"] = {
			"TimbermawPost:362:252:92:302",
			"WinterfallVillage:221:209:588:181",
			"LakeKeltheril:271:258:372:268",
			"OwlWingThicket:254:150:556:439",
			"FrostsaberRock:332:268:304:0",
			"FrostwhisperGorge:317:183:424:474",
			"Everlook:194:229:482:195",
			"IceThistleHills:249:217:581:314",
			"TheHiddenGrove:333:255:500:17",
			"StarfallVillage:367:340:229:33",
			"Mazthoril:257:238:399:340",
			"FrostfireHotSprings:376:289:93:118",
		},
		["Silithus"] = {
			"CenarionHold:292:260:427:143",
			"HiveAshi:405:267:345:4",
			"TheCrystalVale:329:246:126:0",
			"SouthwindVillage:309:243:550:181",
			"HiveRegal:489:358:380:310",
			"TheScarabWall:580:213:0:455",
			"ValorsRest:315:285:614:0",
			"TwilightBaseCamp:434:231:100:151",
			"HiveZora:542:367:0:206",
		},
		["DeadwindPass"] = {
			"DeadmansCrossing:617:522:83:0",
			"Karazhan:513:358:92:310",
			"TheVice:350:449:433:208",
		},
		["Moonglade"] = {
			"StormrageBarrowDens:275:346:542:210",
			"LakeEluneara:431:319:219:273",
			"ShrineofRemulos:271:296:209:91",
			"Nighthaven:346:244:370:135",
		},
		["Hellfire"] = {
			"TheLegionFront:256:512:579:128",
			"RuinsofShanaar:256:378:25:290",
			"HellfireCitadel:256:458:338:210",
			"FallenSkyRidge:256:256:34:142",
			"ExpeditionArmory:512:255:261:413",
			"Thrallmar:256:256:467:154",
			"MagharPost:256:256:206:110",
			"DenofHaalesh:256:256:182:412",
			"TempleofTelhamat:512:512:38:152",
			"PoolsofAggonar:256:512:326:45",
			"ForgeCampRage:512:512:478:25",
			"ThroneofKiljaeden:512:256:477:6",
			"ZethGor:422:238:580:430",
			"TheStairofDestiny:256:512:737:156",
			"VoidRidge:256:256:705:368",
			"WarpFields:256:260:308:408",
			"FalconWatch:512:342:183:326",
			"HonorHold:256:256:469:298",
		},
		["Zangarmarsh"] = {
			"FeralfenVillage:512:336:314:332",
			"Telredor:256:512:569:112",
			"OreborHarborage:256:512:329:25",
			"ZabraJin:256:256:175:232",
			"AngoroshStronghold:256:128:124:0",
			"TwinspireRuins:256:256:342:249",
			"TheDeadMire:286:512:716:128",
			"MarshlightLake:256:256:81:152",
			"TheHewnBog:256:512:219:51",
			"UmbrafenVillage:256:207:720:461",
			"CenarionRefuge:308:256:694:321",
			"BloodscaleEnclave:256:256:596:412",
			"AngoroshGrounds:256:256:88:50",
			"TheLagoon:256:256:512:303",
			"CoilfangReservoir:256:512:462:90",
			"Sporeggar:512:256:20:202",
			"QuaggRidge:256:343:141:325",
			"TheSpawningGlen:256:256:31:339",
		},
		["Nagrand"] = {
			"Telaar:256:256:387:390",
			"ClanWatch:256:256:532:363",
			"BurningBladeRUins:256:334:660:334",
			"KilsorrowFortress:256:241:558:427",
			"RingofTrials:256:256:533:267",
			"ForgeCampFear:512:420:36:248",
			"Halaa:256:256:335:193",
			"TwilightRidge:256:512:10:107",
			"LaughingSkullRuins:256:256:351:52",
			"ThroneoftheElements:256:256:504:53",
			"ForgeCampHate:256:256:162:154",
			"ZangarRidge:256:256:277:54",
			"WindyreedVillage:256:256:666:233",
			"WindyreedPass:256:256:598:79",
			"WarmaulHill:256:256:157:32",
			"SunspringPost:256:256:219:199",
			"SouthwindCleft:256:256:391:258",
			"Garadar:256:256:431:143",
			"OshuGun:512:334:168:334",
		},
		["TerokkarForest"] = {
			"BonechewerRuins:256:256:521:275",
			"CenarionThicket:256:256:314:0",
			"CarrionHill:256:256:377:272",
			"ShattrathCity:512:512:104:4",
			"RingofObservance:256:256:310:345",
			"FirewingPoint:385:512:617:149",
			"SmolderingCaravan:256:208:321:460",
			"SkethylMountains:512:320:449:348",
			"SethekkTomb:256:256:245:289",
			"RefugeCaravan:128:256:316:268",
			"AuchenaiGrounds:256:234:247:434",
			"VeilRhaze:256:256:222:362",
			"RazorthornShelf:256:256:478:19",
			"GrangolvarVilliage:512:256:143:171",
			"Tuurem:256:512:455:34",
			"StonebreakerHold:256:256:397:165",
			"TheBarrierHills:256:256:116:4",
			"WrithingMound:256:256:417:327",
			"RaastokGlade:256:256:505:154",
			"BleedingHollowClanRuins:256:367:103:301",
			"AllerianStronghold:256:256:480:277",
		},
		["ShadowmoonValley"] = {
			"TheWardensCage:512:410:469:258",
			"TheBlackTemple:396:512:606:126",
			"IlladarPoint:256:256:143:256",
			"CoilskarPoint:512:512:348:8",
			"AltarofShatar:256:256:520:93",
			"WildhammerStronghold:512:439:168:229",
			"ShadowmoonVilliage:512:512:116:35",
			"TheHandofGuldan:512:512:394:90",
			"NetherwingCliffs:256:256:554:308",
			"EclipsePoint:512:358:343:310",
			"TheDeathForge:256:512:290:129",
			"NetherwingLedge:492:223:510:445",
			"LegionHold:512:512:104:155",
		},
		["BladesEdgeMountains"] = {
			"VortexPinnacle:256:462:166:206",
			"RazorRidge:256:336:533:332",
			"BladedGulch:256:256:623:147",
			"BloodmaulOutpost:256:297:342:371",
			"DeathsDoor:256:419:512:249",
			"Grishnath:256:256:286:28",
			"RidgeofMadness:256:410:554:258",
			"VekhaarStand:256:256:629:406",
			"Skald:256:256:673:71",
			"GruulsLayer:256:256:527:81",
			"VeilLashh:256:240:271:428",
			"Sylvanaar:256:318:289:350",
			"VeilRuuan:256:128:563:151",
			"TheCrystalpine:256:256:585:0",
			"BrokenWilds:256:256:733:109",
			"ThunderlordStronghold:256:396:405:272",
			"RuuanWeald:256:512:479:98",
			"RavensWood:512:256:214:55",
			"MokNathalVillage:256:256:658:297",
			"JaggedRidge:256:254:446:414",
			"ForgeCampWrath:256:256:254:176",
			"ForgeCampAnger:416:256:586:147",
			"BloodmaulCamp:256:256:412:95",
			"ForgeCampTerror:512:252:144:416",
			"CircleofWrath:256:256:439:210",
			"BashirLanding:256:256:422:0",
			"BladesipreHold:256:507:314:161",
		},
		["Netherstorm"] = {
			"RuinedManaforge:256:256:513:138",
			"ManaforgeCoruu:256:179:357:489",
			"SunfuryHold:256:217:454:451",
			"TheScrapField:256:256:356:261",
			"Netherstone:256:256:411:20",
			"RuinsofFarahlon:512:256:354:49",
			"ManafrogeAra:256:256:171:155",
			"TempestKeep:409:384:593:284",
			"CelestialRidge:256:256:644:173",
			"ArklonRuins:256:256:328:397",
			"KirinVarVillage:256:145:490:523",
			"ForgeBaseOG:256:256:237:22",
			"EcoDomeFarfield:256:256:396:10",
			"ManaforgeBanar:256:387:147:281",
			"SocretharsSeat:256:256:229:38",
			"EtheriumStagingGrounds:256:256:481:208",
			"ManaforgeDuro:256:256:465:336",
			"NetherstormBridge:256:256:132:294",
			"TheStormspire:256:256:298:134",
			"Area52:256:128:241:388",
			"RuinsofEnkaat:256:256:253:301",
			"TheHeap:256:213:239:455",
		},
		["Ghostlands"] = {
			"BleedingZiggurat:256:256:184:238",
			"DawnstarSpire:427:256:575:0",
			"IsleofTribulations:256:256:585:0",
			"FarstriderEnclave:429:256:573:136",
			"SuncrownVillage:512:256:460:0",
			"Deatholme:512:293:95:375",
			"Tranquillien:256:512:365:2",
			"SanctumoftheSun:256:512:448:150",
			"AmaniPass:404:436:598:232",
			"ThalassiaPass:256:262:364:406",
			"ElrendarCrossing:512:256:326:0",
			"ZebNowa:512:431:466:237",
			"GoldenmistVillage:512:512:44:0",
			"SanctumoftheMoon:256:256:210:126",
			"WindrunnerVillage:256:512:60:117",
			"HowlingZiggurat:256:449:340:219",
			"WindrunnerSpire:256:256:40:287",
		},
		["EversongWoods"] = {
			"RunestoneShandor:256:174:464:494",
			"FarstriderRetreat:256:128:524:359",
			"RuinsofSilvermoon:256:256:307:136",
			"NorthSanctum:256:256:361:298",
			"LakeElrendar:128:197:584:471",
			"TheScortchedGrove:256:128:255:507",
			"TheGoldenStrand:128:253:183:415",
			"ThuronsLivery:256:128:539:305",
			"SatherilsHaven:256:256:324:384",
			"SunstriderIsle:512:512:195:5",
			"Zebwatha:128:193:554:475",
			"TorWatha:256:353:648:315",
			"StillwhisperPond:256:256:474:314",
			"TranquilShore:256:256:215:298",
			"EastSanctum:256:256:460:373",
			"RunestoneFalithas:256:172:378:496",
			"GoldenboughPass:256:128:243:469",
			"ElrendarFalls:128:256:580:399",
			"FairbreezeVilliage:256:256:386:386",
			"TheLivingWood:128:248:511:420",
			"AzurebreezeCoast:256:256:669:228",
			"SilvermoonCity:512:512:440:87",
			"WestSanctum:128:256:292:319",
			"SunsailAnchorage:256:128:231:404",
			"DuskwitherGrounds:256:256:605:253",
		},
		["AzuremystIsle"] = {
			"AmmenFord:256:256:515:279",
			"OdesyusLanding:256:256:352:378",
			"FairbridgeStrand:256:128:356:0",
			"StillpineHold:256:256:365:49",
			"SiltingShore:256:256:291:3",
			"PodCluster:256:256:281:305",
			"PodWreckage:128:256:462:349",
			"TheExodar:512:512:74:85",
			"AmmenVale:475:512:527:104",
			"GreezlesCamp:256:256:507:350",
			"BristlelimbVillage:256:256:174:363",
			"SilvermystIsle:256:222:23:446",
			"Emberglade:256:256:488:24",
			"MoongrazeWoods:256:256:449:183",
			"WrathscalePoint:256:247:220:421",
			"ValaarsBerth:256:256:176:303",
			"AzureWatch:256:256:383:249",
		},
		["AhnQirajTheFallenKingdom"] = {
			"AQKingdom:887:668:115:0",
		},
		["BloodmystIsle"] = {
			"WyrmscarIsland:256:256:613:82",
			"VeridianPoint:256:256:637:0",
			"BloodWatch:256:256:437:258",
			"Middenvale:256:256:414:406",
			"KesselsCrossing:485:141:517:527",
			"TalonStand:256:256:657:78",
			"TheBloodcursedReef:256:256:729:54",
			"TheLostFold:256:198:503:470",
			"TheBloodwash:256:256:302:27",
			"WrathscaleLair:256:256:598:338",
			"VindicatorsRest:256:256:232:242",
			"BristlelimbEnclave:256:256:546:410",
			"Axxarien:256:256:297:136",
			"Nazzivian:256:256:250:404",
			"RuinsofLorethAran:256:256:556:216",
			"TheWarpPiston:256:256:451:29",
			"AmberwebPass:256:512:44:62",
			"TheVectorCoil:512:430:43:238",
			"Bladewood:256:256:367:209",
			"TheCryoCore:256:256:293:285",
			"TheFoulPool:256:256:221:136",
			"TheCrimsonReach:256:256:555:87",
			"Mystwood:256:185:309:483",
			"TheHiddenReef:256:256:205:39",
			"BlacksiltShore:512:242:177:426",
			"RagefeatherRidge:256:256:481:117",
			"TelathionsCamp:128:128:180:216",
			"BloodscaleIsle:239:256:763:256",
		},
		["TheLostIsles"] = {
			"TheSlavePits:212:193:279:68",
			"SkyFalls:190:186:416:131",
			"ScorchedGully:305:288:323:185",
			"HordeBaseCamp:222:190:244:458",
			"KTCOilPlatform:156:142:433:11",
			"landingSite:142:133:377:359",
			"TheSavageGlen:231:216:213:325",
			"GallywixDocks:173:180:351:21",
			"RaptorRise:168:205:416:368",
			"OoomlotVillage:221:211:508:345",
			"BilgewaterLumberyard:248:209:462:43",
			"Lostpeak:350:517:581:21",
			"WarchiefsLookout:159:230:264:144",
			"Oostan:210:258:492:161",
			"Alliancebeachhead:177:172:129:348",
			"ShipwreckShore:172:175:189:408",
			"RuinsOfVashelan:212:216:440:452",
		},
		["IcecrownGlacier"] = {
			"ArgentTournamentGround:314:224:616:30",
			"TheFleshwerks:219:283:218:291",
			"Corprethar:308:212:342:392",
			"Valhalas:238:240:217:50",
			"Ymirheim:223:207:444:276",
			"ValleyofEchoes:269:217:715:390",
			"OnslaughtHarbor:204:268:0:167",
			"TheConflagration:227:210:327:305",
			"Aldurthar:373:375:355:37",
			"TheBrokenFront:283:231:558:329",
			"Jotunheim:393:474:22:122",
			"SindragosasFall:300:343:626:31",
			"Scourgeholme:245:239:690:267",
			"TheBombardment:248:243:538:181",
			"TheShadowVault:223:399:321:15",
			"IcecrownCitadel:308:202:392:466",
		},
		["ZulDrak"] = {
			"AltarOfSseratus:237:248:288:168",
			"Kolramas:302:231:380:437",
			"LightsBreach:321:305:181:363",
			"AmphitheaterOfAnguish:266:254:289:287",
			"Voltarus:218:291:174:191",
			"DrakSotraFields:286:265:326:358",
			"ThrymsEnd:272:268:0:247",
			"AltarOfRhunok:247:304:431:127",
			"GunDrak:336:297:629:0",
			"AltarOfHarKoa:265:257:533:345",
			"Zeramas:307:256:7:412",
			"ZimTorga:249:258:479:241",
			"AltarOfMamToth:311:317:575:88",
			"AltarOfQuetzLun:261:288:607:251",
		},
		["SholazarBasin"] = {
			"TheSavageThicket:293:229:396:51",
			"RainspeakerCanopy:207:235:427:244",
			"TheSuntouchedPillar:455:316:82:186",
			"TheMakersOverlook:233:286:705:236",
			"TheMosslightPillar:239:313:265:355",
			"TheStormwrightsShelf:268:288:138:58",
			"TheMakersPerch:249:248:172:135",
			"KartaksHold:329:293:76:375",
			"TheGlimmeringPillar:294:327:308:34",
			"TheAvalanche:322:265:596:92",
			"TheLifebloodPillar:312:369:501:134",
			"RiversHeart:468:329:359:339",
		},
		["CrystalsongForest"] = {
			"VioletStand:264:303:0:176",
			"TheDecrepitFlow:288:222:0:0",
			"TheUnboundThicket:502:477:500:105",
			"ForlornWoods:544:668:129:0",
			"TheGreatTree:252:260:0:91",
			"TheAzureFront:416:424:0:244",
			"WindrunnersOverlook:558:285:444:383",
			"SunreaversCommand:446:369:536:40",
		},
		["HowlingFjord"] = {
			"ScalawagPoint:350:258:168:410",
			"Baleheim:174:173:576:170",
			"EmberClutch:213:256:283:203",
			"Gjalerbron:242:189:225:0",
			"UtgardeKeep:248:382:477:216",
			"AncientLift:177:191:342:351",
			"SteelGate:222:168:222:100",
			"ExplorersLeagueOutpost:232:216:585:336",
			"ApothecaryCamp:263:265:99:37",
			"Nifflevar:178:208:595:240",
			"GiantsRun:298:306:572:0",
			"WestguardKeep:347:220:90:180",
			"IvaldsRuin:193:201:668:223",
			"CampWinterHoof:223:209:354:0",
			"Kamagua:333:265:99:278",
			"BaelgunsExcavationSite:244:305:621:327",
			"TheTwistedGlade:266:210:420:57",
			"Skorn:238:232:343:108",
			"VengeanceLanding:223:338:664:25",
			"NewAgamand:284:308:415:360",
			"Halgrind:187:263:397:208",
			"CauldrosIsle:181:178:490:161",
			"FortWildervar:251:192:490:0",
		},
		["GrizzlyHills"] = {
			"Voldrune:283:247:176:421",
			"DrakTheronKeep:382:285:0:46",
			"RageFangShrine:475:362:312:294",
			"ConquestHold:332:294:17:307",
			"UrsocsDen:328:260:331:32",
			"AmberpineLodge:278:290:217:244",
			"DunArgol:455:400:547:257",
			"CampOneqwah:324:265:548:137",
			"BlueSkyLoggingGrounds:249:235:232:129",
			"VentureBay:274:207:18:461",
			"GraniteSprings:356:224:7:207",
			"DrakilJinRuins:351:284:607:41",
			"ThorModan:329:246:509:0",
			"GrizzleMaw:294:227:358:187",
		},
		["SouthernBarrens"] = {
			"ForwardCommand:216:172:423:251",
			"Battlescar:384:248:274:307",
			"VendettaPoint:254:214:267:196",
			"NorthwatchHold:280:279:548:147",
			"RazorfenKraul:214:140:273:528",
			"HuntersHill:218:178:300:64",
			"HonorsStand:315:170:201:0",
			"RuinsofTaurajo:285:171:244:286",
			"TheOvergrowth:355:226:289:117",
			"FrazzlecrazMotherload:242:195:269:436",
			"BaelModan:269:211:398:457",
		},
		["Hyjal"] = {
			"SethriasRoost:277:232:139:436",
			"TheThroneOfFlame:419:290:318:378",
			"GatesOfSothann:272:334:622:320",
			"AshenLake:282:418:6:78",
			"DarkwhisperGorge:320:471:682:128",
			"Nordrassil:537:323:392:0",
			"DireforgeHill:270:173:303:197",
			"TheScorchedPlain:365:264:411:216",
			"ArchimondesVengeance:270:300:320:5",
			"TheRegrowth:441:319:52:253",
			"ShrineOfGoldrinn:291:321:116:17",
		},
		["BoreanTundra"] = {
			"DeathsStand:289:279:707:181",
			"AmberLedge:244:214:325:140",
			"GarroshsLanding:267:378:153:238",
			"RiplashStrand:382:258:293:383",
			"ValianceKeep:259:302:457:264",
			"BorGorokOutpost:396:203:314:0",
			"Kaskala:385:316:509:214",
			"TheGeyserFields:375:342:480:0",
			"TheDensOfDying:203:209:662:11",
			"WarsongStronghold:260:278:329:237",
			"SteeljawsCaravan:244:319:397:66",
			"TorpsFarm:186:276:272:237",
			"Coldarra:460:381:50:0",
			"TempleCityOfEnKilah:290:292:712:15",
		},
		["Dragonblight"] = {
			"ColdwindHeights:213:219:403:0",
			"Angrathar:306:242:210:0",
			"IcemistVillage:235:337:134:165",
			"TheCrystalVice:229:259:487:0",
			"AgmarsHammer:236:218:258:203",
			"LightsRest:299:278:703:7",
			"LakeIndule:356:300:217:313",
			"TheForgottenShore:301:286:698:332",
			"EmeraldDragonshrine:196:218:543:362",
			"RubyDragonshrine:188:211:374:208",
			"ObsidianDragonshrine:304:203:256:104",
			"ScarletPoint:235:354:569:7",
			"Naxxramas:311:272:691:160",
			"WyrmrestTemple:317:353:453:219",
			"WestwindRefugeeCamp:229:299:42:187",
			"GalakrondsRest:258:225:433:118",
			"VenomSpite:226:212:661:264",
			"NewHearthglen:214:261:614:358",
		},
		["TheStormPeaks"] = {
			"Thunderfall:306:484:627:179",
			"BrunnhildarVillage:305:298:339:370",
			"Ulduar:369:265:218:0",
			"EngineoftheMakers:210:179:316:296",
			"Frosthold:244:220:134:429",
			"GarmsBane:184:191:395:470",
			"NarvirsCradle:180:239:214:144",
			"TempleofLife:182:270:570:113",
			"TempleofStorms:169:164:239:301",
			"Nidavelir:221:200:108:206",
			"SnowdriftPlains:205:232:162:143",
			"TerraceoftheMakers:363:341:292:122",
			"BorsBreath:322:195:109:375",
			"Valkyrion:228:158:98:318",
			"DunNiffelem:309:383:481:285",
			"SparksocketMinefield:251:200:242:468",
		},
		["TheWanderingIsle"] = {
			"RidgeofLaughingWinds:313:320:182:198",
			"SkyfireCrash-Site:346:262:124:404",
			"TheSingingPools:372:474:544:12",
			"TheRows:385:372:504:294",
			"MorningBreezeVillage:261:314:202:36",
			"Pei-WuForest:651:262:350:406",
			"TheDawningValley:677:668:324:0",
			"MandoriVillage:610:374:392:294",
			"Fe-FangVillage:234:286:134:8",
			"TempleofFiveDawns:607:460:394:182",
			"TheWoodofStaves:989:466:12:202",
		},
		["TheJadeForest"] = {
			"EmperorsOmen:202:204:430:20",
			"DreamersPavillion:218:148:474:520",
			"ChunTianMonastery:227:198:300:56",
			"WindlessIsle:251:348:538:42",
			"TempleOfTheJadeSerpent:264:210:468:294",
			"HellscreamsHope:196:166:180:74",
			"GrookinMound:253:228:182:214",
			"DawnsBlossom:234:210:324:178",
			"SlingtailPits:179:180:428:416",
			"WreckOfTheSkyShark:210:158:202:0",
			"JadeMines:236:142:400:146",
			"NectarbreezeOrchard:219:256:290:330",
			"Waywardlanding:219:186:346:482",
			"GlassfinVillage:278:310:524:358",
			"RuinsOfGanShi:196:158:316:0",
			"SerpentsSpine:191:216:388:298",
			"TheArboretum:242:210:480:214",
			"NookaNooka:219:204:188:150",
		},
		["Krasarang"] = {
			"ZhusBastion:306:204:612:0",
			"RuinsOfKorja:211:394:124:88",
			"NayeliLagoon:246:240:342:372",
			"TheForbiddenJungle:257:300:0:78",
			"krasarangCove:286:268:700:18",
			"UngaIngoo:258:170:330:498",
			"CradleOfChiJi:272:250:176:376",
			"TheSouthernIsles:252:312:22:266",
			"TempleOfTheRedCrane:219:258:300:214",
			"TheDeepwild:188:412:396:58",
			"LostDynasty:217:278:588:26",
			"RedwingRefuge:212:264:316:62",
			"FallsongRiver:214:392:218:76",
			"RuinsOfDojan:204:382:444:44",
			"DojaniRiver:190:282:512:2",
			"AnglersOutpost:265:194:544:204",
		},
		["ValleyoftheFourWinds"] = {
			"KuzenVillage:199:304:224:74",
			"CliffsofDispair:510:264:214:404",
			"Theheartland:286:392:252:74",
			"ThunderfootFields:380:316:622:0",
			"DustbackGorge:209:308:0:342",
			"GrandGranery:314:212:334:324",
			"MudmugsPlace:230:216:560:160",
			"SingingMarshes:175:290:170:130",
			"ZhusDecent:303:322:698:114",
			"PoolsofPurity:213:246:512:58",
			"SilkenFields:254:258:530:252",
			"Halfhill:206:244:438:176",
			"NesingwarySafari:249:342:104:326",
			"RumblingTerrace:277:244:582:300",
			"GildedFan:208:292:438:40",
			"HarvestHome:260:250:4:238",
			"StormsoutBrewery:257:288:226:380",
			"PaoquanHollow:273:246:12:104",
		},
		["TheHiddenPass"] = {
			"TheHiddenSteps:290:190:412:476",
			"TheBlackMarket:479:492:370:174",
		},
		["KunLaiSummit"] = {
			"Mogujia:253:208:462:410",
			"Kotapeak:252:256:232:360",
			"GateoftheAugust:261:162:448:506",
			"PeakOfSerenity:287:276:332:62",
			"BinanVillage:240:198:606:470",
			"ValleyOfEmperors:224:240:452:190",
			"TEMPLEOFTHEWHITETIGER:250:260:586:170",
			"ZouchinVillage:298:218:502:64",
			"FireboughNook:224:172:322:496",
			"Iseoflostsouls:259:232:602:4",
			"ShadoPanMonastery:385:384:88:92",
			"TheBurlapTrail:310:276:398:310",
			"MuskpawRanch:229:262:602:312",
			"MountNeverset:313:208:228:264",
		},
		["TownlongWastes"] = {
			"Sikvess:261:234:306:432",
			"SriVess:294:282:92:192",
			"palewindVillage:282:306:692:362",
			"ShadoPanGarrison:213:170:412:384",
			"ShanzeDao:300:246:124:0",
			"KriVess:255:268:420:208",
			"OsulMesa:238:296:560:184",
			"TheSumprushes:271:204:544:368",
			"NiuzaoTemple:296:358:212:240",
			"MingChiCrossroads:247:220:416:446",
			"GaoRanBlockade:353:200:546:468",
		},
		["ValeofEternalBlossoms"] = {
			"MistfallVillage:310:304:200:362",
			"GuoLaiRuins:337:348:86:2",
			"WhitepetalLake:267:280:278:170",
			"WhiteMoonShrine:298:262:482:10",
			"WinterboughGlade:361:332:4:106",
			"MoguShanPalace:373:384:628:22",
			"TheGoldenStair:242:254:328:16",
			"SettingSunTraining:350:428:0:234",
			"TheTwinMonoliths:272:522:444:96",
			"TuShenBurialGround:267:308:348:316",
			"TheStairsAscent:446:358:556:266",
		},
		["DreadWastes"] = {
			"SOGGYSGAMBLE:268:240:450:406",
			"BRINYMUCK:325:270:214:310",
			"HORRIDMARCH:323:194:440:224",
			"BREWGARDEN:250:218:350:0",
			"HEARTOFFEAR:262:292:190:122",
			"DREADWATERLAKE:322:210:436:312",
			"CLUTCHESOFSHEKZEER:209:318:340:124",
			"RIKKITUNVILLAGE:218:186:236:32",
			"TERRACEOFGURTHAN:209:234:592:92",
			"KLAXXIVESS:236:206:458:110",
			"KYPARIVOR:325:190:484:0",
			"ZANVESS:290:282:162:384",
		},

}

local old_GetNumMapOverlays = GetNumMapOverlays;
local old_NUM_WORLDMAP_OVERLAYS = NUM_WORLDMAP_OVERLAYS;
local old_WorldMapFrame_Update = WorldMapFrame_Update;
------------------------------------------------------------------------------------------------

function MetaFWM_OnEvent(self, event, ...)
	local arg1 = ...;
	if(event == "ADDON_LOADED" and arg1 == "MetaMapFWM") then
		if(FWM_Options == nil) then FWM_Options = {}; end
		if(FWM_Options.red == nil) then FWM_Options.red = 1; end
		if(FWM_Options.green == nil) then FWM_Options.green = 1; end
		if(FWM_Options.blue == nil) then FWM_Options.blue = 1; end
		if(FWM_Options.alpha == nil) then FWM_Options.alpha = 1; end
		if(FWM_Options.Errata == nil) then FWM_Options.Errata = {}; end
		if(FWM_Options.FWMcolor == nil) then FWM_Options.FWMcolor = false; end
		if(FWM_Options.Discovered == nil) then FWM_Options.Discovered = {}; end
		if(FWM_ShowUnexplored == nil) then FWM_ShowUnexplored = false; end
		
		
			
		MetaMapFWM_colorCheckButton:SetChecked(FWM_Options.FWMcolor);
		FWM_WorldMapFrame_Init();
	end
end

function GetNumMapOverlays()
    if (NUM_WORLDMAP_OVERLAYS == 0) then return 0 end;
    return old_GetNumMapOverlays()
end

function WorldMapFrame_Update()
	old_NUM_WORLDMAP_OVERLAYS = NUM_WORLDMAP_OVERLAYS;
	NUM_WORLDMAP_OVERLAYS = 0;
	old_WorldMapFrame_Update();
	if(old_NUM_WORLDMAP_OVERLAYS) then
		NUM_WORLDMAP_OVERLAYS = old_NUM_WORLDMAP_OVERLAYS;
	else NUM_WORLDMAP_OVERLAYS = 1;
	end
	worldMapFrame_UpdateOverlays();
end

function FWM_WorldMapFrame_Init()
	-- Integrate the contents of the errata table into the main dataset.
	-- and while we're at it, remove anything we don't recognize from the errata table!
	local mapFileName, errataTable, i, oinfo
	for mapFileName,errataTable in next,FWM_Options.Errata do
		-- hack to keep strings short and maintainable.
		local prefix = "Interface\\WorldMap\\"..mapFileName.."\\"
		-- build a temporary index of the mainTable, from textureName to index!
		local mainIndex = {}
		
		local mainTable = getMainTable(mapFileName)
		for i,oinfo in next,mainTable do
			local tname = oinfo_uncombine(prefix,oinfo)
			if tname then mainIndex[tname] = i; end
		end
		-- build a temporary index of the errata too (removing redundant entries).
		local errataIndex = {}
		for i,oinfo in next,errataTable do
			local tname = oinfo_uncombine(prefix,oinfo)
			if not tname then
				if (FWM_DEBUG) then MetaMap_Print(mapFileName..": borked: "..oinfo, true) end
				errataTable[i] = nil
			else
				if errataIndex[tname] then
					if (FWM_DEBUG) then 
						local old = errataTable[errataIndex[tname]]
						MetaMap_Print(mapFileName..": redundant: "..old, true)
					end
					errataTable[errataIndex[tname]] = nil
				end
				errataIndex[tname] = i;
			end
		end
			-- now integrate errata into mainTable (for this session only)
		for i,oinfo in next,errataTable do
			local tname = oinfo_uncombine(prefix,oinfo)
			if mainIndex[tname] then
				if mainTable[mainIndex[tname]] ~= oinfo then
					if (FWM_DEBUG) then MetaMap_Print(mapFileName..": update "..oinfo, true) end
					mainTable[mainIndex[tname]] = oinfo
				else
					if (FWM_DEBUG) then MetaMap_Print(mapFileName..": redundant: "..oinfo, true) end
					errataTable[i] = nil
				end
			else
				if (FWM_DEBUG) then MetaMap_Print(mapFileName..": add "..oinfo, true) end
				table.insert(mainTable, oinfo)
			end
		end
	end
end

function MetaMapFWM_Initcolor()
	ColorPickerFrame.func = MetaMapFWM_Setcolor;
	ColorPickerFrame.cancelFunc = MetaMapFWM_Cancelcolor;
	ColorPickerFrame.previousValues = {FWM_Options.red, FWM_Options.green, FWM_Options.blue};
	ColorPickerFrame:SetFrameStrata("FULLSCREEN");
	ColorPickerFrame:Show();
	ColorPickerFrame:SetColorRGB(FWM_Options.red, FWM_Options.green, FWM_Options.blue);
end

function MetaMapFWM_Setcolor()
	FWM_Options.red, FWM_Options.green, FWM_Options.blue = ColorPickerFrame:GetColorRGB();
	WorldMapFrame_Update();
end

function MetaMapFWM_Cancelcolor(prevColors)
	FWM_Options.red, FWM_Options.green, FWM_Options.blue = unpack(prevColors);
	WorldMapFrame_Update();
end

function oinfo_combine(prefix,tname,tw,th,ofx,ofy,mpx,mpy)
    -- shorten strings by replacing redundant prefix paths with a marker token
    local result = ":"..tw..":"..th..":"..ofx..":"..ofy
    if (mpx~=0 or mpy~=0) then 
	 if(mpy~=nil) then
	 	   result = result..":"..mpx..":"..mpy 
      end
	end
    if string.sub(tname, 0, string.len(prefix)) == prefix then
        return string.sub(tname, string.len(prefix)+1)..result
    end
    return "|"..result
end

function oinfo_uncombine(prefix,oinfo)
    local pfxUnused,tname,tw,th,ofx,ofy,mpx,mpy;
    _,_,pfxUnused,tname,tw,th,ofx,ofy = string.find(oinfo,
        "^([|]?)([^:]+):([^:]+):([^:]+):([^:]+):([^:]+)")
    if (not tname or not ofy) then return nil; end -- safety check
    if (ofy) then
        _,_,mpx,mpy = string.find(oinfo,
            "^[|]?[^:]+:[^:]+:[^:]+:[^:]+:[^:]+:([^:]+):([^:]+)")
    end
    if (not mpy) then mpx=0; mpy=0 end
    if (pfxUnused~="|") then tname = prefix..tname; end
    return tname,tw+0,th+0,ofx+0,ofy+0,mpx+0,mpy+0
end

function oinfo_getname(prefix,oinfo)
    local junk1,junk2,pfxUnused,tname = string.find(oinfo, "^([|]?)([^:]+):")
    if (not tname) then return nil; end -- safety check
    if (pfxUnused~="|") then tname = prefix..tname; end
    return tname
end

function getMainTable(mapFileName)
    local t = FWM_OverlayInfo[mapFileName]
    if not t then t = { }; FWM_OverlayInfo[mapFileName] = t end
    return t
end

function getErrataTable(mapFileName)
    local t = FWM_Options.Errata[mapFileName]
    if not t then t = { }; FWM_Options.Errata[mapFileName] = t end
    return t
end

function getSaveDiscoveredTable(mapFileName)
    local t = FWM_Options.Discovered[mapFileName]
    if not t then t = { }; FWM_Options.Discovered[mapFileName] = t end
    return t
end



-- This code replaces the short-circuited code from WorldMapFrame_Update.
function worldMapFrame_UpdateOverlays(dtlFrame, ovrLay)
	local mapOverLay;
	if((dtlFrame) and (ovrLay)) then
		mapOverLay = ovrLay;
	else
		dtlFrame = "WorldMapDetailFrame";
		mapOverLay = "WorldMapOverlay";
	end

	local mapFileName, textureHeight, _, isMicroDungeon, microDungeonMapName = GetMapInfo();
	if (not mapFileName) then mapFileName = "World"; end
	--MetaMap_Debug_Print("MapInfo isMicroDungeon: " .. isMicroDungeon, true);

    -- hack to keep strings short and maintainable.
    local prefix = "Interface\\WorldMap\\"..mapFileName.."\\"

    -- (1) create oinfos for discovered areas in this zone.
	local i, tname, oinfo
	local discovered = {}
	local numOverlays = GetNumMapOverlays()
	
	for i=1, numOverlays do
		local tname,tw,th,ofx,ofy,mpx,mpy = GetMapOverlayInfo(i)
		local oi = oinfo_combine(prefix,tname,tw,th,ofx,ofy,mpx,mpy);
		discovered[tname] = oi;
		MetaMap_Debug_Print(mapFileName..": "..discovered[tname],true);
		if((oi ~= "|:0:0:0:0") and (MetaMapOptions["Debug"])) then
		  local savename = oinfo_getname(prefix,oi);  
		  local sd = getSaveDiscoveredTable(mapFileName);
		  sd[savename] = oi;
		end
	end
	

    -- (2) update any overlays for which our stored data is *incorrect* (should never happen!)
    local zoneTable = getMainTable(mapFileName)
    
    numOverlays = #(zoneTable)
    for i,oinfo in next,zoneTable do
        local tname = oinfo_getname(prefix,oinfo)
					if discovered[tname] then
            if discovered[tname] == 1 then
                if (FWM_DEBUG) then MetaMap_Print(mapFileName..": repeating "..tname.." ??", true) end
            elseif discovered[tname] ~= oinfo then
                if (FWM_DEBUG) then MetaMap_Print(mapFileName..": update "..discovered[tname], true) end
                zoneTable[i] = discovered[tname]
                -- record in the errata table for next time!
                table.insert(getErrataTable(mapFileName),discovered[tname])
            end
            discovered[tname] = 1
        end
    end
    -- (3) add any overlays which are *missing* from our stored data (should never happen!)
    for tname,oinfo in next,discovered do
        if oinfo ~= 1 then
            if (FWM_DEBUG) then MetaMap_Print(mapFileName..": adding "..oinfo, true) end
            table.insert(zoneTable,oinfo)
            -- record in the errata table for next time!
            table.insert(getErrataTable(mapFileName),oinfo)
        end
    end
    
	-- Modified version of original overlay stuff
	local textureName, textureWidth, textureHeight, offsetX, offsetY, mapPointX, mapPointY;
	local textureCount = 1;
	local texture;
	local texturePixelWidth, textureFileWidth, texturePixelHeight, textureFileHeight;
	local numTexturesWide, numTexturesTall;

	for i=1, 100 do
		if(_G[mapOverLay..i] == nil) then
			break;
		end
		_G[mapOverLay..i]:Hide();
	end

	if (isMicroDungeon) then return; end

	for i,oinfo in next,zoneTable do
		textureName, textureWidth, textureHeight, offsetX, offsetY, mapPointX, mapPointY =
		oinfo_uncombine(prefix,oinfo)
		if FWM_ShowUnexplored or discovered[textureName] then
			numTexturesWide = ceil(textureWidth/256);
			numTexturesTall = ceil(textureHeight/256);
			neededTextures = textureCount + (numTexturesWide * numTexturesTall);
			if ( neededTextures > NUM_WORLDMAP_OVERLAYS ) then
				for j=NUM_WORLDMAP_OVERLAYS+1, neededTextures do
					WorldMapDetailFrame:CreateTexture("WorldMapOverlay"..j, "ARTWORK");
				end
				NUM_WORLDMAP_OVERLAYS = neededTextures;
			end
    		for j=1, numTexturesTall do
    			if (j < numTexturesTall) then
    				texturePixelHeight = 256; textureFileHeight = 256;
    			else
    				texturePixelHeight = mod(textureHeight, 256);
    				if (texturePixelHeight == 0) then texturePixelHeight = 256; end
    				textureFileHeight = 16;
    				while(textureFileHeight < texturePixelHeight) do
    					textureFileHeight = textureFileHeight * 2;
    				end
    			end
    			for k=1, numTexturesWide do
    				if (textureCount > NUM_WORLDMAP_OVERLAYS) then
    				    message("Too many worldmap overlays!");	return;
    				end
    				texture = _G[mapOverLay..textureCount];
    				if (k < numTexturesWide) then
    				    texturePixelWidth = 256; textureFileWidth = 256;
    				else
    					texturePixelWidth = mod(textureWidth, 256);
    					if (texturePixelWidth == 0) then texturePixelWidth = 256; end
    					textureFileWidth = 16;
    					while(textureFileWidth < texturePixelWidth) do
    						textureFileWidth = textureFileWidth * 2;
    					end
    				end
    				texture:SetWidth(texturePixelWidth);
    				texture:SetHeight(texturePixelHeight);
    				texture:SetTexCoord(0, texturePixelWidth/textureFileWidth, 0,
    				    texturePixelHeight/textureFileHeight);
    				texture:ClearAllPoints();
    				texture:SetPoint("TOPLEFT", dtlFrame, "TOPLEFT",
							offsetX + (256 * (k-1)), -(offsetY + (256 * (j - 1))));

    				texture:SetTexture(textureName..(((j - 1) * numTexturesWide) + k));
    				
    				if discovered[textureName] then
       				texture:SetVertexColor(1.0,1.0,1.0)
   				    texture:SetAlpha(1.0)
						else
							if(FWM_Options.FWMcolor) then
								texture:SetVertexColor(FWM_Options.red,FWM_Options.green,FWM_Options.blue,FWM_Options.alpha);
							else
								texture:SetVertexColor(1.0,1.0,1.0)
							end                            
    				end
    				texture:Show();
    				textureCount = textureCount + 1;
    			end
    		end
     end
	end
	for i=textureCount+1, NUM_WORLDMAP_OVERLAYS do
		if(_G[mapOverLay..i]) then
			_G[mapOverLay..i]:Hide();
		end
	end
end
