﻿-- MetaMapTRK
-- Written by MetaHawk - aka Urshurak

TRK_NAME = "MetaMapTRK";
TRK_ICON_PATH = "Interface\\AddOns\\MetaMapTRK\\Nodes\\";
TRK_HRB_NAME = "Herb";
TRK_ORE_NAME = "Ore";
TRK_TRS_NAME = "Treasure";
TRK_MSC_NAME = "Misc";
TRK_MSC_HOLDER = "PlaceHolder";

TRK_Options = {};
TRK_Data    = {};
TRK_NodeList = {};
TRK_ZoneList = {};
TRK_Excludes = {};
TRK_MenuList = {};

TRK_Default = {
	["Herbs"]    = true,
	["Ores"]     = true,
	["Treasure"] = true,
	["Unmined"]  = true,
	["ShowAll"]  = false,
	["ShowHerb"] = true,
	["ShowOre"]  = true,
	["ShowTreasure"] = true,
	["ShowMisc"] = true,
	["FilterHerb"] = true,
	["FilterOre"]  = true,
	["FilterTreasure"] = true,
	["FilterMisc"] = true,
	["Sortby"]   = "name",
	["Padding"]  = 10,
}

TRK_FilterMenu = {
	[1] = {TRK_SORT_TITLE,  "Sortbyname"},
	[2] = {TRK_SORT_LEVEL,  "Sortbylevel"},
	[3] = {"", "", 1},
	[4] = {TRK_FILTER_ALL,  "ShowAll"},
	[5] = {TRK_FILTER_HERB, "ShowHerb"},
	[6] = {TRK_FILTER_ORE,  "ShowOre"},
	[7] = {TRK_FILTER_TREASURE, "ShowTreasure"},
	[8] = {TRK_FILTER_MISC, "ShowMisc"},
}

TRK_VarsLoaded  = false;
TRK_LastSearch	= "";
TRK_LastNode    = 0;
TRK_ButtonTotal	= 0;
TRK_HerbTotal = 0;
TRK_OreTotal = 0;
TRK_TreasureTotal = 0;
TRK_MiscTotal = 0;
TRK_ItemTotal = 0;
TRK_NodeCount = false;
TRK_HerbRank = 0;
TRK_OreRank = 0;
TRK_NodeOnMenu = false;
TRK_ZoneExpand = "";

function TRK_OnLoad(self)
	self:RegisterEvent("ADDON_LOADED");
	self:RegisterEvent("WORLD_MAP_UPDATE");
	self:RegisterEvent("UNIT_SPELLCAST_SENT");
	self:RegisterEvent("UI_ERROR_MESSAGE");
end

function TRK_OnEvent(self, event, ...)
	local arg1, arg2 = ...
	if(event == "ADDON_LOADED" and arg1 == "MetaMapTRK") then
		TRK_LoadConfig();
		if(WorldMapFrame:IsVisible()) then MetaMap_MainMapUpdate(); end
		UIDropDownMenu_Initialize(TRK_FilterSelectMenu, TRK_FilterMenuInit, "MENU");
		UIDropDownMenu_Initialize(TRK_QuickMenu, TRK_QuickMenuInit, "MENU");
		UIDropDownMenu_Initialize(TRK_ExclusionMenuMenu, TRK_ExclusionMenuInit, "MENU");
	elseif(event == "WORLD_MAP_UPDATE" and TRK_DisplayFrame:IsVisible()) then
		TRK_DisplayInit();
	elseif(event == "INSTANCE_MAP_UPDATE" and TRK_DisplayFrame:IsVisible()) then
		TRK_DisplayInit();
	elseif(event == "UNIT_SPELLCAST_SENT" and arg1 == "player") then
		TRK_ProcessNode(arg2, 1);
	elseif(event == "UI_ERROR_MESSAGE") then
		TRK_ProcessNode(arg1, 2);
	end
end

function TRK_LoadConfig()
	for option, value in pairs(TRK_Default) do
		if(TRK_Options[option] == nil) then TRK_Options[option] = value; end
	end
	TRK_Default = nil;
	if(TRK_Data == nil) then TRK_Data = {}; end
	if(TRK_Errata == nil) then TRK_Errata = {}; end
	TRK_UpDateDB();
	TRK_HerbRank = TRK_GetSkillRank(TRK_HERBALISM);
	TRK_OreRank = TRK_GetSkillRank(TRK_MINING);
	TRK_VarsLoaded = true;
end

function TRK_ToggleFrame(mode)
	if(mode == 2) then return; end
	if(TRK_DisplayFrame:IsVisible()) then
		MetaMapContainer_ShowFrame();
		if(mode == 1) then
			MetaMap_ToggleFrame(WorldMapFrame);
		end
	else
		if(not WorldMapFrame:IsVisible()) then
			MetaMap_ToggleFrame(WorldMapFrame);
		end
		MetaMapContainer_ShowFrame(TRK_DisplayFrame);
		TRK_DisplayInit();
	end
end

function TRK_ProcessNode(msg, mode)
	local x, y = GetPlayerMapPosition("player");
	local zone = MetaMap_GetRealZoneText();
	local level = GetCurrentMapDungeonLevel();
	local name = METAMAP_TT_NAME;
	if ( mode == 1 ) then
		if ( string.match(msg, TRK_DETECT_HERB) and TRK_Options.Herbs ) then
			if ( name and (strlen(name) > 0) ) then
				TRK_NodeCount = true;
				TRK_AddNode(zone, level, name, TRK_HRB_NAME, UnitName("player"), x, y);
			end
		elseif ( string.match(msg, TRK_DETECT_ORE) and TRK_Options.Ores ) then
			if ( name and (strlen(name) > 0) ) then
				TRK_NodeCount = true;
				TRK_AddNode(zone, level, name, TRK_ORE_NAME, UnitName("player"), x, y);
			end
		elseif ( string.match(msg, TRK_DETECT_TREASURE) and TRK_Options.Treasure ) then
			if ( name and (strlen(name) > 0) ) then
				TRK_NodeCount = true;
				TRK_AddNode(zone, level, name, TRK_TRS_NAME, UnitName("player"), x, y);
			end
		end
	elseif ( TRK_Options.Unmined ) then
		if ( name and (strlen(name) > 0) ) then
			if ( string.find(msg, TRK_HERBALISM) and TRK_Options.Herbs ) then
				TRK_AddNode(zone, level, name, TRK_HRB_NAME, UnitName("player"), x, y, 0, true);
			elseif ( string.find(msg, TRK_MINING) and TRK_Options.Ores ) then
				TRK_AddNode(zone, level, name, TRK_ORE_NAME, UnitName("player"), x, y, 0, true);
			end
		end
	end
	METAMAP_TT_NAME = nil;
end

function TRK_AddNode(zone, mlevel, name, type, creator, x, y, count, skipCount)
	if ( TRK_Excludes[name] or not MetaMap_GetZoneTableEntry(zone) ) then return; end
	if ( count == nil ) then count = 1; end
	if ( TRK_Data[zone] ) then
		for index, value in ipairs(TRK_Data[zone]) do
			local TRK_ref = TRK_TrackerTable[value.ref];
			local is_type = ( TRK_ref["cat"] == type );
			local is_misc = ( (TRK_ref["cat"] == TRK_MSC_NAME) and (type == TRK_TRS_NAME) );
			if ( (abs(value.xPos-x) <= 0.01) and (abs(value.yPos-y) <= 0.01) and (is_type or is_misc) and ( not value.mlevel or value.mlevel == mlevel) ) then
				if ( not skipCount and TRK_NodeCount and (name == TRK_ref[MetaMap_Locale]) ) then
					value.count = value.count + 1;
				end
				TRK_NodeCount = false;
				return;
			end
		end
	end
	TRK_NodeCount = false;
	local _, entry = TRK_GetTrackerEntry(name);
	if ( not entry ) then
		if ( type == TRK_TRS_NAME ) then type = TRK_MSC_NAME; end
		local icon;
		if     ( type == TRK_HRB_NAME ) then icon = "Herb_Generic";
		elseif ( type == TRK_ORE_NAME ) then icon = "Ore_Generic";
						else icon = "Misc_Generic"; end
		tinsert(TRK_TrackerTable, {cat = type, en = name, de = name, fr = name, es = name, ru = name, level = 0, icon = icon});
		_, entry = TRK_GetTrackerEntry(name);
		TRK_Errata[name] = {};
		TRK_Errata[name].ref = entry;
		TRK_Errata[name].type = type;
	end
	if ( not TRK_Data[zone] ) then
		TRK_Data[zone] = {};
	end
	tinsert(TRK_Data[zone], {mlevel = mlevel, ref = entry, creator = creator, xPos = x, yPos = y, count = count});
	MetaMap_Print(name.." "..TRK_NODE_ADDED, true)
	return true;
end

function TRK_DisplayNodes(mapName, mapLevel)
	for i=1, TRK_LastNode, 1 do
		_G["TRK_Node"..i]:Hide();
	end
	if(not TRK_Data[mapName]) then return; end
	local buttonID = 1;
	for index, value in ipairs(TRK_Data[mapName]) do
		if(value.xPos == 0) then return; end
		local showThis = false;
		local cat = TRK_TrackerTable[value.ref].cat;
		if ( cat == TRK_HRB_NAME and TRK_Options.FilterHerb)     then showThis = true; end
		if ( cat == TRK_ORE_NAME and TRK_Options.FilterOre)      then showThis = true; end
		if ( cat == TRK_TRS_NAME and TRK_Options.FilterTreasure) then showThis = true; end
		if ( cat == TRK_MSC_NAME and TRK_Options.FilterMisc)     then showThis = true; end
		if ( value.mlevel and not (value.mlevel == mapLevel) )   then showThis = false; end
		if ( not value.mlevel and (mapLevel ~= 0) )              then showThis = false; end
		if( showThis ) then
			local temp = TRK_CreateNodeObject(buttonID);
			local x = value.xPos * WorldMapButton:GetWidth();
			local y = -value.yPos * WorldMapButton:GetHeight();
			temp:SetParent("WorldMapButton");
			temp:SetPoint("CENTER", "WorldMapButton", "TOPLEFT", x, y);
			_G["TRK_Node"..buttonID.."Texture"]:SetTexture(TRK_ICON_PATH..TRK_TrackerTable[value.ref].icon);
			temp.ref = value.ref;
			temp.node = index;
			temp:Show();
			buttonID = buttonID +1;
		end
	end
end

function TRK_NodeOnEnter(self, ref, noteID)
	local cLevel = {r=0, g=1, b=0};
	local cTitle = {r=0.9, g=0.8, b=0};
	local mapName = MetaMap_GetCurrentMapInfo();
	local cat = TRK_TrackerTable[ref].cat;
	if (cat == TRK_HRB_NAME) then
		cTitle = {r=0, g=0.8, b=0.4};
		if (not TRK_HerbRank or TRK_TrackerTable[ref].level > TRK_HerbRank) then
			cLevel = {r=1, g=0, b=0};
		end
	elseif (cat == TRK_ORE_NAME) then
		cTitle = {r=0.9, g=0.7, b=0.4};
	 	if (not TRK_OreRank or TRK_TrackerTable[ref].level > TRK_OreRank) then
	 		cLevel = {r=1, g=0, b=0};
	 	end
	end
	local cat_lc;
	if (cat == TRK_HRB_NAME) then cat_lc = TRK_DELETE_HRB; end
	if (cat == TRK_ORE_NAME) then cat_lc = TRK_DELETE_ORE; end
	if (cat == TRK_TRS_NAME) then cat_lc = TRK_DELETE_TRS; end
	if (cat == TRK_MSC_NAME) then cat_lc = TRK_DELETE_MSC; end
	WorldMapTooltip:SetOwner(self, "ANCHOR_LEFT");
	WorldMapTooltip:AddDoubleLine(TRK_TrackerTable[ref][MetaMap_Locale], cat_lc, cTitle.r, cTitle.g, cTitle.b, 0.6, 0.6, 0.6);
	WorldMapTooltip:AddDoubleLine(TRK_HEADER_LEVEL, TRK_TrackerTable[ref].level, 0.75, 0.85, 0, cLevel.r, cLevel.g, cLevel.b, 1);
	WorldMapTooltip:AddDoubleLine(TRK_HEADER_COUNT, TRK_Data[mapName][noteID].count, 0.75, 0.85, 0, 0.75, 0.85, 0, 1);
	WorldMapTooltip:AddDoubleLine(TRK_CREATOR, TRK_Data[mapName][noteID].creator, 0, 0.75, 0.85, 0, 0.75, 0.85, 1);
	WorldMapPOIFrame.allowBlobTooltip = false;
	WorldMapTooltip:Show();
end

function TRK_DisplayInit()
	TRK_NodeList.Herbs = {}; TRK_NodeList.Ores = {}; TRK_NodeList.Treasure = {}; TRK_NodeList.Misc = {}; TRK_ZoneList = {};
	TRK_HerbTotal, TRK_OreTotal, TRK_TreasureTotal, TRK_MiscTotal, TRK_ItemTotal = 0,0,0,0,0;
	local mapName = MetaMap_GetCurrentMapInfo();
	for zoneName, iTable in pairs(TRK_Data) do
		TRK_ItemTotal = TRK_ItemTotal + #(iTable);
		if(MetaMap_CheckRelatedZone(zoneName, mapName) or TRK_Options.ShowAll) then
			for index, value in ipairs(iTable) do
				local showThis = false;
				local name = TRK_TrackerTable[value.ref][MetaMap_Locale];
				local level = TRK_TrackerTable[value.ref].level;
				local cat = TRK_TrackerTable[value.ref].cat;
				if(not TRK_ZoneList[name]) then TRK_ZoneList[name] = {}; end
				if(cat == TRK_HRB_NAME and TRK_Options.ShowHerb) then showThis = true; end
				if(cat == TRK_ORE_NAME and TRK_Options.ShowOre) then showThis = true; end
				if(cat == TRK_TRS_NAME and TRK_Options.ShowTreasure) then showThis = true; end
				if(cat == TRK_MSC_NAME and TRK_Options.ShowMisc) then showThis = true; end
				if(showThis and string.find(string.lower(name),string.lower(TRK_LastSearch),1,true)) then
					if(cat == TRK_HRB_NAME) then
						local id = TRK_FindMatch(TRK_NodeList.Herbs, name);
						if(id) then
							TRK_NodeList.Herbs[id].nodes = TRK_NodeList.Herbs[id].nodes +1;
							TRK_NodeList.Herbs[id].count = TRK_NodeList.Herbs[id].count + value.count;
						else
							tinsert(TRK_NodeList.Herbs, {name = name, nodes = 1, index = value.ref, zone = zoneName, noteID = index, level = level, count = value.count});
						end
						TRK_HerbTotal = TRK_HerbTotal +1;
					elseif(cat == TRK_ORE_NAME) then
						local id = TRK_FindMatch(TRK_NodeList.Ores, name);
						if(id) then
							TRK_NodeList.Ores[id].nodes = TRK_NodeList.Ores[id].nodes +1;
							TRK_NodeList.Ores[id].count = TRK_NodeList.Ores[id].count + value.count;
						else
							tinsert(TRK_NodeList.Ores, {name = name, nodes = 1, index = value.ref, zone = zoneName, noteID = index, level = level, count = value.count});
						end
						TRK_OreTotal = TRK_OreTotal +1;
					elseif(cat == TRK_TRS_NAME) then
						local id = TRK_FindMatch(TRK_NodeList.Treasure, name);
						if(id) then
							TRK_NodeList.Treasure[id].nodes = TRK_NodeList.Treasure[id].nodes +1;
							TRK_NodeList.Treasure[id].count = TRK_NodeList.Treasure[id].count + value.count;
						else
							tinsert(TRK_NodeList.Treasure, {name = name, nodes = 1, index = value.ref, zone = zoneName, noteID = index, level = level, count = value.count});
						end
						TRK_TreasureTotal = TRK_TreasureTotal +1;
					elseif(cat == TRK_MSC_NAME) then
						local id = TRK_FindMatch(TRK_NodeList.Misc, name);
						if(id) then
							TRK_NodeList.Misc[id].nodes = TRK_NodeList.Misc[id].nodes +1;
							TRK_NodeList.Misc[id].count = TRK_NodeList.Misc[id].count + value.count;
						else
							tinsert(TRK_NodeList.Misc, {name = name, nodes = 1, index = value.ref, zone = zoneName, noteID = index, level = level, count = value.count});
						end
						TRK_MiscTotal = TRK_MiscTotal +1;
					end
					if(TRK_ZoneList[name][zoneName]) then
						TRK_ZoneList[name][zoneName].nodes = TRK_ZoneList[name][zoneName].nodes +1;
					else
						TRK_ZoneList[name][zoneName] = {};
						TRK_ZoneList[name][zoneName].nodes = 1;
					end
				end
			end
		end
	end
	TRK_SortTrackerList(TRK_Options.Sortby);
	TRK_HeaderText:SetText(mapName);
	TRK_InfoText1:SetText("Total items: |cffffff00"..TRK_ItemTotal.."|r   Displayed: |cffffff00"..TRK_HerbTotal+TRK_OreTotal+TRK_TreasureTotal+TRK_MiscTotal);
	local text = "";
	local rank, maxrank = TRK_GetSkillRank(TRK_HERBALISM);
	if(rank) then
		text = TRK_HERBALISM..": |cffffff00"..rank.."/"..maxrank;
	else
		rank, maxrank = TRK_GetSkillRank(TRK_MINING);
		if(rank) then
			text = TRK_MINING..": |cffffff00"..rank.."/"..maxrank;
		end
	end
	TRK_InfoText2:SetText(text);
	TRK_RefreshDisplay();
end

function TRK_SortTrackerList(sort)
	local tmp = MetaMap_sortType;
	MetaMap_sortType = sort;
	table.sort(TRK_NodeList.Herbs, MetaMap_SortCriteria);
	table.sort(TRK_NodeList.Ores, MetaMap_SortCriteria);
	table.sort(TRK_NodeList.Treasure, MetaMap_SortCriteria);
	table.sort(TRK_NodeList.Misc, MetaMap_SortCriteria);
	MetaMap_sortType = tmp;
end

function TRK_RefreshDisplay()
	local buttonID = 1;
	local ScrollHeight = 0;
	local button, buttonText;
	if(#(TRK_NodeList.Herbs) > 0) then
		button = TRK_CreateButton(buttonID);
		buttontext = _G["TRKButton"..buttonID.."Header"];
		buttontext:SetText(TRK_HERBALISM.." - "..TRK_HerbTotal.." "..TRK_HEADER_NODES);
		buttontext:SetTextColor(0.75, 0.75, 1);
		if(buttonID == 1) then
			button:SetPoint("TOPLEFT", "TRK_ScrollChild", "TOPLEFT", 10, -15);
		else
			button:SetPoint("TOP", _G["TRKButton"..buttonID-1], "BOTTOM", 0, 0)
		end
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
		button:Show();
	end
	for index, mList in ipairs(TRK_NodeList.Herbs) do
		button = TRK_CreateButton(buttonID);
		buttontext = _G["TRKButton"..buttonID.."Text"];
		buttontext:SetText(mList.name);
		buttontext:SetTextColor(0, 0.8, 0.4);
		_G["TRKButton"..buttonID.."Nodes"]:SetText(mList.nodes);
		_G["TRKButton"..buttonID.."Level"]:SetText(TRK_TrackerTable[mList.index].level);
		_G["TRKButton"..buttonID.."Count"]:SetText(mList.count);
		if(not TRK_HerbRank or TRK_TrackerTable[mList.index].level > TRK_HerbRank) then
			_G["TRKButton"..buttonID.."Level"]:SetTextColor(1, 0, 0);
		else
			_G["TRKButton"..buttonID.."Level"]:SetTextColor(0, 1, 0);
		end
		button:SetPoint("TOP", _G["TRKButton"..buttonID-1], "BOTTOM", 0, 0)
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		button.ref = mList.index;
		button:Show();
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
		if(TRK_ZoneExpand == mList.name) then
			buttonID, ScrollHeight = TRK_ExpandZones(mList.name, buttonID, ScrollHeight);
		end
	end
	if(#(TRK_NodeList.Ores) > 0) then
		button = TRK_CreateButton(buttonID);
		buttontext = _G["TRKButton"..buttonID.."Header"];
		buttontext:SetText(TRK_MINING.." - "..TRK_OreTotal.." "..TRK_HEADER_NODES);
		buttontext:SetTextColor(0.75, 0.75, 1);
		if(buttonID == 1) then
			button:SetPoint("TOPLEFT", "TRK_ScrollChild", "TOPLEFT", 10, -15);
		else
			button:SetPoint("TOP", _G["TRKButton"..buttonID-1], "BOTTOM", 0, 0)
		end
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
		button:Show();
	end
	for index, mList in ipairs(TRK_NodeList.Ores) do
		button = TRK_CreateButton(buttonID);
		buttontext = _G["TRKButton"..buttonID.."Text"];
		buttontext:SetText(mList.name);
		buttontext:SetTextColor(0.9, 0.7, 0.4);
		_G["TRKButton"..buttonID.."Nodes"]:SetText(mList.nodes);
		_G["TRKButton"..buttonID.."Level"]:SetText(TRK_TrackerTable[mList.index].level);
		_G["TRKButton"..buttonID.."Count"]:SetText(mList.count);
		if(not TRK_OreRank or TRK_TrackerTable[mList.index].level > TRK_OreRank) then
			_G["TRKButton"..buttonID.."Level"]:SetTextColor(1, 0, 0);
		else
			_G["TRKButton"..buttonID.."Level"]:SetTextColor(0, 1, 0);
		end
		button:SetPoint("TOP", _G["TRKButton"..buttonID-1], "BOTTOM", 0, 0)
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		button.ref = mList.index;
		button:Show();
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
		if(TRK_ZoneExpand == mList.name) then
			buttonID, ScrollHeight = TRK_ExpandZones(mList.name, buttonID, ScrollHeight);
		end
	end
	if(#(TRK_NodeList.Treasure) > 0) then
		button = TRK_CreateButton(buttonID);
		buttontext = _G["TRKButton"..buttonID.."Header"];
		buttontext:SetText(TRK_TREASURE.." - "..TRK_TreasureTotal.." "..TRK_HEADER_NODES);
		buttontext:SetTextColor(0.75, 0.75, 1);
		if(buttonID == 1) then
			button:SetPoint("TOPLEFT", "TRK_ScrollChild", "TOPLEFT", 10, -15);
		else
			button:SetPoint("TOP", _G["TRKButton"..buttonID-1], "BOTTOM", 0, 0)
		end
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
		button:Show();
	end
	for index, mList in ipairs(TRK_NodeList.Treasure) do
		button = TRK_CreateButton(buttonID);
		buttontext = _G["TRKButton"..buttonID.."Text"];
		buttontext:SetText(mList.name);
		buttontext:SetTextColor(0.9, 0.8, 0);
		_G["TRKButton"..buttonID.."Nodes"]:SetText(mList.nodes);
		_G["TRKButton"..buttonID.."Level"]:SetText(TRK_TrackerTable[mList.index].level);
		_G["TRKButton"..buttonID.."Count"]:SetText(mList.count);
		_G["TRKButton"..buttonID.."Level"]:SetTextColor(0, 1, 0);
		button:SetPoint("TOP", _G["TRKButton"..buttonID-1], "BOTTOM", 0, 0)
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		button.ref = mList.index;
		button:Show();
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
		if(TRK_ZoneExpand == mList.name) then
			buttonID, ScrollHeight = TRK_ExpandZones(mList.name, buttonID, ScrollHeight);
		end
	end
	if(#(TRK_NodeList.Misc) > 0) then
		button = TRK_CreateButton(buttonID);
		buttontext = _G["TRKButton"..buttonID.."Header"];
		buttontext:SetText(TRK_MISC.." - "..TRK_MiscTotal.." "..TRK_HEADER_NODES);
		buttontext:SetTextColor(0.75, 0.75, 1);
		if(buttonID == 1) then
			button:SetPoint("TOPLEFT", "TRK_ScrollChild", "TOPLEFT", 10, -15);
		else
			button:SetPoint("TOP", _G["TRKButton"..buttonID-1], "BOTTOM", 0, 0)
		end
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
		button:Show();
	end
	for index, mList in ipairs(TRK_NodeList.Misc) do
		button = TRK_CreateButton(buttonID);
		buttontext = _G["TRKButton"..buttonID.."Text"];
		buttontext:SetText(mList.name);
		buttontext:SetTextColor(0.9, 0.8, 0);
		_G["TRKButton"..buttonID.."Nodes"]:SetText(mList.nodes);
		_G["TRKButton"..buttonID.."Level"]:SetText(TRK_TrackerTable[mList.index].level);
		_G["TRKButton"..buttonID.."Count"]:SetText(mList.count);
		_G["TRKButton"..buttonID.."Level"]:SetTextColor(0.8, 0.8, 0.8);
		button:SetPoint("TOP", _G["TRKButton"..buttonID-1], "BOTTOM", 0, 0)
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		button.ref = mList.index;
		button:Show();
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
		if(TRK_ZoneExpand == mList.name) then
			buttonID, ScrollHeight = TRK_ExpandZones(mList.name, buttonID, ScrollHeight);
		end
	end
	for i=buttonID, TRK_ButtonTotal, 1 do
		_G["TRKButton"..i]:Hide()
	end
	TRK_ScrollChild:SetHeight(ScrollHeight);
	TRK_ScrollFrame:UpdateScrollChildRect()
end

function TRK_ExpandZones(nodeName, buttonID, ScrollHeight)
	for zone, value in pairs(TRK_ZoneList[nodeName]) do
		button = TRK_CreateButton(buttonID);
		buttontext = _G["TRKButton"..buttonID.."Zones"];
		buttontext:SetText(zone);
		buttontext:SetTextColor(0.75, 0.75, 1);
		_G["TRKButton"..buttonID.."Nodes"]:SetText(TRK_ZoneList[nodeName][zone].nodes);
		button:SetPoint("TOP", _G["TRKButton"..buttonID-1], "BOTTOM", 0, 0)
		button.ref = zone;
		button:Show();
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
	end
	return buttonID, ScrollHeight;
end

function TRK_FilterMenuInit()
	for index, menuItem in ipairs(TRK_FilterMenu) do
		local check = nil;
		local spacer = nil;
		if(menuItem[3]) then spacer = 1; end
		if(TRK_Options.Sortby == string.gsub(menuItem[2], "Sortby", "")) then
			check = 1;
		elseif(TRK_Options[menuItem[2]]) then
			check = 1;
		end
		local info = {};
		info.isTitle = spacer;
		info.notClickable = spacer;
		info.notCheckable = spacer;
		info.checked = check;
		info.text = menuItem[1];
		info.value = menuItem[2];
		info.func = TRK_FilterMenuOnClick;
		UIDropDownMenu_AddButton(info);
	end
	UIDropDownMenu_SetText(TRK_FilterSelect, TRK_FILTER_DISP);
end

function TRK_FilterMenuOnClick(self)
	if(string.match(self.value, "Sortby")) then
		TRK_Options.Sortby = string.gsub(self.value, "Sortby", "");
		TRK_SortTrackerList(TRK_Options.Sortby);
		TRK_RefreshDisplay();
		return;
	else
		TRK_ToggleOptions(self.value);
	end
	UIDropDownMenu_SetText(TRK_FilterSelect, TRK_FILTER_DISP);
	TRK_DisplayInit();
end

function TRK_MetaMapMenuOnClick(self)
	local txt = self:GetText();
	TRK_ToggleOptions(self.value);
	TRK_DisplayInit();
	MetaMap_MainMapUpdate();
	if(string.find(txt, METAMAP_MENU_ON)) then
		txt = string.gsub(txt, METAMAP_MENU_ON, METAMAP_MENU_OFF);
	else
		txt = string.gsub(txt, METAMAP_MENU_OFF, METAMAP_MENU_ON);
	end
	self:SetText(txt);
	self.checked = not self.checked;
end

function TRK_QuickMenuInit()
	local info, zone, node, cat_lc; local item = ""; local cat = "";
	if(UIDROPDOWNMENU_MENU_VALUE and UIDROPDOWNMENU_MENU_VALUE[2]) then
		zone = UIDROPDOWNMENU_MENU_VALUE[1];
		node = UIDROPDOWNMENU_MENU_VALUE[2];
		if ( node == zone ) then return; end

		if(TRK_NodeOnMenu) then
			item = TRK_TrackerTable[TRK_Data[zone][node].ref][MetaMap_Locale];
			cat = TRK_TrackerTable[TRK_Data[zone][node].ref].cat;
		else
			item = TRK_TrackerTable[node][MetaMap_Locale];
			cat = TRK_TrackerTable[node].cat;
		end
		if (cat == TRK_HRB_NAME) then cat_lc = TRK_DELETE_HRB; end
		if (cat == TRK_ORE_NAME) then cat_lc = TRK_DELETE_ORE; end
		if (cat == TRK_TRS_NAME) then cat_lc = TRK_DELETE_TRS; end
		if (cat == TRK_MSC_NAME) then cat_lc = TRK_DELETE_MSC; end
	else
		return;
	end
	if(TRK_NodeOnMenu) then
		info = {};
		info.notCheckable = 1;
		info.checked = nil;
		info.text = TRK_DELETE_NODE;
		info.value = 1;
		info.func = TRK_DeleteConfirm;
		info.arg1 = zone;
		info.arg2 = node;
		UIDropDownMenu_AddButton(info);
	end
	info = {};
	info.notCheckable = 1;
	info.checked = nil;
	info.text = TRK_DELETE_ALL.." |cFFFFD100"..item.."|r";
	info.value = 2;
	info.func = TRK_DeleteConfirm;
	info.arg1 = zone;
	info.arg2 = item;
	UIDropDownMenu_AddButton(info);
	info = {};
	info.notCheckable = 1;
	info.checked = nil;
	info.text = TRK_DELETE_ALL.." |cFFFFD100"..cat_lc.."|r";
	info.value = 3;
	info.func = TRK_DeleteConfirm;
	info.arg1 = zone;
	info.arg2 = cat;
	UIDropDownMenu_AddButton(info);
	info = {};
	info.notCheckable = 1;
	info.checked = nil;
	info.text = TRK_OPTIONS_EXIT;
	info.value = nil;
	info.func = TRK_DeleteConfirm;
	UIDropDownMenu_AddButton(info);
end

function TRK_DeleteConfirm(self, zone, id, mode)
	if(not zone or not id) then return; end
	if(mode) then
		if(TRK_NodeOnMenu) then
			TRK_DeleteNodes(zone, id, mode)
		else
			for zoneName, iTable in pairs(TRK_Data) do
				if(MetaMap_CheckRelatedZone(zoneName, zone)) then
					TRK_DeleteNodes(zoneName, id, mode)
				end
			end
		end
	end
	local val = self.value;
	if(val == 1) then
		TRK_DeleteNodes(zone, id, val);
	else
		StaticPopupDialogs["Delete_Nodes"] = {
			text = self:GetText().." "..TRK_DELETE_FROM.." \n|cFFFFD100"..zone.."?",
			button1 = TEXT(ACCEPT),
			button2 = TEXT(DECLINE),
			OnAccept = function()
				TRK_DeleteConfirm(self, zone, id, val);
			end,
			timeout = 60,
			showAlert = 1,
		};
		StaticPopup_Show("Delete_Nodes");
	end
end

function TRK_ExclusionMenuInit(self)
	TRK_SetMenuList();
	if(UIDROPDOWNMENU_MENU_LEVEL == 2) then
		local menuVal = MetaMap_SubMenuFix(self);
		local menuItems = {};
		if(menuVal == "TRK_MenuList") then
			menuItems = _G[menuVal];
		elseif(menuVal and (TRK_MenuListSub and TRK_MenuListSub[menuVal])) then
			menuItems = TRK_MenuListSub[menuVal];
		elseif(not menuVal) then
			menuItems = TRK_MenuList;
		end
		if(menuItems) then
			for index, value in pairs(menuItems) do
				local info = {};
				info.text = menuItems[index].name;
				info.func = TRK_SetExclude;
				info.value = menuItems[index].name;
				info.checked = TRK_Excludes[menuItems[index].name];
				UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			end
		end
	else
		local info = {};
		info.text = TRK_SetMenuTitle(TRK_MenuList);
		info.hasArrow = 1;
		info.value = "TRK_MenuList";
		info.notCheckable = 1;
		UIDropDownMenu_AddButton(info);
		if(TRK_MenuListSub) then
			for index, value in ipairs(TRK_MenuListSub) do
				if(TRK_SetMenuTitle(value)) then
					local info = {};
					info.text = TRK_SetMenuTitle(value);
					info.hasArrow = 1;
					info.value = index;
					info.notCheckable = 1;
					UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
				end
			end
		end
	end
	UIDropDownMenu_SetText(TRK_ExclusionMenu, TRK_OPTIONS_EXC);
end

function TRK_SetMenuList()
	TRK_MenuList = {};
	for index, value in pairs(TRK_Errata) do
		table.insert(TRK_MenuList, {name = index});
	end
	local sort = MetaMap_sortType;
	MetaMap_sortType = METAMAP_SORTBY_NAME;
	table.sort(TRK_MenuList, MetaMap_SortCriteria);
	MetaMap_sortType = sort;
	if(#(TRK_MenuList) > 20) then
		local tmpList = {};
		TRK_MenuListSub = {};
		TRK_MenuListSub[1] = {}; TRK_MenuListSub[2] = {};
		TRK_MenuListSub[3] = {}; TRK_MenuListSub[4] = {};
		TRK_MenuListSub[5] = {}; TRK_MenuListSub[6] = {};
		TRK_MenuListSub[7] = {}; TRK_MenuListSub[8] = {};
		local listCount = 0;
		for index, value in ipairs(TRK_MenuList) do
			listCount = listCount + 1;
			if(listCount < 21) then
				tinsert(tmpList, value)
			elseif(listCount < 42) then 
				tinsert(TRK_MenuListSub[1], value);
			elseif(listCount < 63) then 
				tinsert(TRK_MenuListSub[2], value);
			elseif(listCount < 84) then 
				tinsert(TRK_MenuListSub[3], value);
			elseif(listCount < 105) then 
				tinsert(TRK_MenuListSub[4], value);
			elseif(listCount < 126) then 
				tinsert(TRK_MenuListSub[5], value);
			elseif(listCount < 147) then 
				tinsert(TRK_MenuListSub[6], value);
			elseif(listCount < 168) then 
				tinsert(TRK_MenuListSub[7], value);
			elseif(listCount < 189) then 
				tinsert(TRK_MenuListSub[8], value);
			end
		end
		TRK_MenuList = tmpList;
	end
end

function TRK_SetMenuTitle(MList)
	local firstword, lastword, tempstring;
	for index, value in pairs(MList) do
		if(not tempstring) then
			if(value.name) then 
				tempstring = value.name;
			end
			firstword = tempstring;
		else
			if(value.name) then 
				tempstring = value.name;
			end
		end
	end
	if(tempstring and firstword) then
		lastword = strsub(tempstring, 1, string.find(tempstring, " "));
		firstword = strsub(firstword, 1, string.find(firstword, " "));
		return firstword.."- "..lastword;
	else return nil end
end

function TRK_SetExclude(self)
	if(TRK_Excludes[self.value]) then
		TRK_Excludes[self.value] = nil;
	else
		TRK_Excludes[self.value] = true;
	end
end

function TRK_NodeOnClick(self,node)
	if(not node) then return; end
	local nodeInfo = {MetaMap_GetCurrentMapInfo(), node};
	TRK_NodeOnMenu = true;
	ToggleDropDownMenu(nil, nodeInfo, TRK_QuickMenu, self, 0, 0);
end

function TRK_DisplayButtonOnClick(self, button, ref)
	if (not ref) then return; end

	if (button == "LeftButton") then
		if (ref == _G[self:GetName().."Zones"]:GetText()) then
			MetaMap_ShowLocation(self, ref);
			return;
		end
		if (TRK_ZoneExpand == _G[self:GetName().."Text"]:GetText()) then
			TRK_ZoneExpand = "";
		else
			TRK_ZoneExpand = _G[self:GetName().."Text"]:GetText();
		end
		TRK_RefreshDisplay();
	else
		local nodeInfo = {MetaMap_GetCurrentMapInfo(), ref};
		TRK_NodeOnMenu = false;
		ToggleDropDownMenu(nil, nodeInfo, TRK_QuickMenu, self, 0, 0);
	end
end

function TRK_DeleteNodes(zone, id, mode)
	if(not TRK_Data[zone]) then return; end
	local TempData = {};
	TempData[zone] = TRK_Data[zone];
	TRK_Data[zone] = {};
	for index, value in ipairs(TempData[zone]) do
		local size = #(TRK_Data[zone]) +1;
		if(mode == 1 and id ~= index) then
			TRK_Data[zone][size] = value;
		elseif(mode == 2 and id ~= TRK_TrackerTable[value.ref][MetaMap_Locale]) then
			TRK_Data[zone][size] = value;
		elseif(mode == 3 and id ~= TRK_TrackerTable[value.ref].cat) then
			TRK_Data[zone][size] = value;
		end
	end
	TempData = nil;
	if(TRK_DisplayFrame:IsVisible()) then
		TRK_DisplayInit();
	end
	if(WorldMapFrame:IsVisible()) then
		MetaMap_MainMapUpdate();
	end
end

function TRK_CreateNodeObject(id)
	local button;
	if(_G["TRK_Node"..id]) then
		button = _G["TRK_Node"..id];
		button.index = nil;
	else
		button = CreateFrame("Button" ,"TRK_Node"..id, WorldMapButton, "TRK_NodeTemplate");
		TRK_LastNode = TRK_LastNode +1;
	end
	return button;
end

function TRK_CreateButton(id)
	local button;
	if(_G["TRKButton"..id]) then
		button = _G["TRKButton"..id];
		_G["TRKButton"..id.."Header"]:SetText("");
		_G["TRKButton"..id.."Text"]:SetText("");
		_G["TRKButton"..id.."Nodes"]:SetText("");
		_G["TRKButton"..id.."Level"]:SetText("");
		_G["TRKButton"..id.."Count"]:SetText("");
		_G["TRKButton"..id.."Zones"]:SetText("");
		button.ref = nil;
	else
		button = CreateFrame("Button" ,"TRKButton"..id, TRK_ScrollChild, "TRK_ButtonTemplate");
		button:SetWidth(TRK_ScrollChild:GetWidth());
		TRK_ButtonTotal = TRK_ButtonTotal +1;
	end
	button:SetID(id);
	return button;
end

function TRK_GetTrackerEntry(mName)
	for index, mTable in pairs(TRK_TrackerTable) do
		if(string.lower(mName) == string.lower(mTable.en) or
		   string.lower(mName) == string.lower(mTable.de) or
		   string.lower(mName) == string.lower(mTable.fr) or
		   string.lower(mName) == string.lower(mTable.es) or
		   string.lower(mName) == string.lower(mTable.ru)) then
			return mTable[MetaMap_Locale], index, mTable.cat;
		end
	end
end

function TRK_FindMatch(table, name)
	for index, value in pairs(table) do
		if(value.name == name) then
			return index;
		end
	end
end

function TRK_GetSkillRank(skill)
	--for skillIndex = 1, GetNumSkillLines() do
	--	skillName, isHeader, _, skillRank, _, _, skillMaxRank = GetSkillLineInfo(skillIndex);
	--	if(not isHeader and skillName == skill) then
	--		return skillRank, skillMaxRank;
	--	end
	--end
	
	local prof_1, prof_2, archaeology, fishing, cooking, firstaid = GetProfessions();
	
	if ( not prof_1 ) then return; end
	local name, icon, rank, maxrank, numspells, spelloffset, skillline = GetProfessionInfo(prof_1);
	if(skill == TRK_HERBALISM) then
	 if(name == "Herbalism") then
	  return rank,maxrank;
	 end
	elseif (skill == TRK_MINING) then
	 if(name == "Mining") then
	  return rank,maxrank;
	  end
	end

	if ( not prof_2 ) then return; end
	local name, icon, rank, maxrank, numspells, spelloffset, skillline = GetProfessionInfo(prof_2);
	if(skill == TRK_HERBALISM) then
	 if(name == "Herbalism") then
	  return rank,maxrank;
	 end
	elseif (skill == TRK_MINING) then
	 if(name == "Mining") then
	  return rank,maxrank;
	 end
	end
	
	
end

function TRK_UpDateDB()
	for zone, indexTable in pairs(TRK_Data) do
		for index, value in ipairs(indexTable) do
			if(not value.count or type(value.count) == "boolean") then
				value.count = 0;
			end
		end
	end
	local skiped = false;
	local maxref = 0;
	for mName, value in pairs(TRK_Errata) do
		if (value.ref > maxref) then maxref = value.ref; end
		if (TRK_TrackerTable[value.ref]) then skiped = true; end
	end
	if (skiped) then
		for mName, item in pairs(TRK_Errata) do
			if (TRK_TrackerTable[item.ref]) then
				local n_en = TRK_TrackerTable[item.ref].en;
				local n_de = TRK_TrackerTable[item.ref].de;
				local n_fr = TRK_TrackerTable[item.ref].fr;
				local n_es = TRK_TrackerTable[item.ref].es;
				local n_ru = TRK_TrackerTable[item.ref].ru;
				if (mName ~= n_en and mName ~= n_de and mName ~= n_fr and mName ~= n_es and mName ~= n_ru) then
					maxref = maxref + 1;
					for zone, indexTable in pairs(TRK_Data) do
						for index, value in ipairs(indexTable) do
							if (value.ref == item.ref) then
								value.ref = maxref;
							end
						end
					end
					item.ref = maxref;
				else
					TRK_Errata[mName] = nil;
				end
			end
		end
	end
	for mName, item in pairs(TRK_Errata) do
		local name, entry = TRK_GetTrackerEntry(mName);
		if(entry) then
			for zone, indexTable in pairs(TRK_Data) do
				for index, value in ipairs(indexTable) do
					if(value.ref == item.ref) then
						value.ref = entry;
					end
				end
			end
			TRK_Errata[mName] = nil;
		end
	end
	local icon, type;
	for mName, value in pairs(TRK_Errata) do
		if     ( value.type == TRK_HRB_NAME ) then type = TRK_HRB_NAME; icon = "Herb_Generic";
		elseif ( value.type == TRK_ORE_NAME ) then type = TRK_ORE_NAME; icon = "Ore_Generic";
		else                                       type = TRK_MSC_NAME; icon = "Misc_Generic"; end

		TRK_TrackerTable[value.ref] = {};
		TRK_TrackerTable[value.ref].cat = type;
		TRK_TrackerTable[value.ref].en = mName;
		TRK_TrackerTable[value.ref].de = mName;
		TRK_TrackerTable[value.ref].fr = mName;
		TRK_TrackerTable[value.ref].es = mName;
		TRK_TrackerTable[value.ref].ru = mName;
		TRK_TrackerTable[value.ref].level = 0;
		TRK_TrackerTable[value.ref].icon = icon;
	end
end

function TRK_HintTooltip(self)
	WorldMapTooltip:SetOwner(self, "ANCHOR_TOPLEFT");
	WorldMapTooltip:SetText(TRK_TTHINT_H0, 0.2, 0.5, 1, 1);
	WorldMapTooltip:AddDoubleLine(TRK_TTKEY_T1, TRK_TTHINT_T1, 1, 1, 1, 1);
	WorldMapTooltip:AddDoubleLine(TRK_TTKEY_T2, TRK_TTHINT_T2, 1, 1, 1, 1);
	WorldMapPOIFrame.allowBlobTooltip = false;
	WorldMapTooltip:Show();
end

function TRK_ToggleOptions(key, value)
	if(value) then
		TRK_Options[key] = value;
	else
		TRK_Options[key] = not TRK_Options[key];
	end
	return TRK_Options[key];
end

-- Attention: do not change the order!
TRK_TrackerTable = {
	--- Herbs
	[1]  = {cat = TRK_HRB_NAME, en = "Silverleaf",          de = "Silberblatt",          fr = "Feuillargent",               es = "Hojaplata",               ru="Сребролист",               level =   1, icon = "Herb_Silverleaf"},
	[2]  = {cat = TRK_HRB_NAME, en = "Peacebloom",          de = "Friedensblume",        fr = "Pacifique",                  es = "Flor de paz",             ru="Мироцвет",                 level =   1, icon = "Herb_Peacebloom"},
	[3]  = {cat = TRK_HRB_NAME, en = "Earthroot",           de = "Erdwurzel",            fr = "Terrestrine",                es = "Raíz de tierra",          ru="Земляной корень",          level =  15, icon = "Herb_Earthroot"},
	[4]  = {cat = TRK_HRB_NAME, en = "Mageroyal",           de = "Maguskönigskraut",     fr = "Mage Royal",                 es = "Marregal",                ru="Магороза",                 level =  50, icon = "Herb_Mageroyal"},
	[6]  = {cat = TRK_HRB_NAME, en = "Briarthorn",          de = "Wilddornrose",         fr = "Eglantine",                  es = "Brezospina",              ru="Остротерн",                level =  70, icon = "Herb_Briarthorn"},
	[7]  = {cat = TRK_HRB_NAME, en = "Stranglekelp",        de = "Würgetang",            fr = "Etouffante",                 es = "Alga estranguladora",     ru="Удавник",                  level =  85, icon = "Herb_Stranglekelp"},
	[8]  = {cat = TRK_HRB_NAME, en = "Bruiseweed",          de = "Beulengras",           fr = "Doulourante",                es = "Hierba cardenal",         ru="Синячник",                 level =  85, icon = "Herb_Bruiseweed"},
	[9]  = {cat = TRK_HRB_NAME, en = "Wild Steelbloom",     de = "Wildstahlblume",       fr = "Aciérite Sauvage",           es = "Acérita salvaje",         ru="Дикий сталецвет",          level = 115, icon = "Herb_WildSteelbloom"},
	[10] = {cat = TRK_HRB_NAME, en = "Grave Moss",          de = "Grabmoos",             fr = "Tombeline",                  es = "Musgo de tumba",          ru="Могильный мох",            level = 105, icon = "Herb_GraveMoss"},
	[11] = {cat = TRK_HRB_NAME, en = "Kingsblood",          de = "Königsblut",           fr = "Sang-Royal",                 es = "Sangrerregia",            ru="Королевская кровь",        level = 125, icon = "Herb_Kingsblood"},
	[12] = {cat = TRK_HRB_NAME, en = "Liferoot",            de = "Lebenswurz",           fr = "Vietérule",                  es = "Vidarraíz",               ru="Корень жизни",             level = 150, icon = "Herb_Liferoot"},
	[13] = {cat = TRK_HRB_NAME, en = "Fadeleaf",            de = "Blassblatt",           fr = "Pâlerette",                  es = "Pálida",                  ru="Бледнолист",               level = 150, icon = "Herb_Fadeleaf"},
	[14] = {cat = TRK_HRB_NAME, en = "Goldthorn",           de = "Golddorn",             fr = "Dorépine",                   es = "Espina de oro",           ru="Златошип",                 level = 150, icon = "Herb_Goldthorn"},
	[15] = {cat = TRK_HRB_NAME, en = "Khadgar's Whisker",   de = "Khadgars Schnurrbart", fr = "Moustache de Khadgar",       es = "Mostacho de Khadgar",     ru="Кадгаров ус",              level = 160, icon = "Herb_KhadgarsWhisker"},
	[16] = {cat = TRK_HRB_NAME, en = "Dragon's Teeth",      de = "Drachenzahn",          fr = "Dents de dragon",            es = "Dientes de dragón",       ru="Драконьи зубы",            level = 195, icon = "Herb_DragonsTeeth"},
	[17] = {cat = TRK_HRB_NAME, en = "Firebloom",           de = "Feuerblüte",           fr = "Fleur de Feu",               es = "Flor de fuego",           ru="Огнецвет",                 level = 205, icon = "Herb_Firebloom"},
	[18] = {cat = TRK_HRB_NAME, en = "Purple Lotus",        de = "Lila Lotus",           fr = "Lotus Pourpre",              es = "Loto cárdeno",            ru="Лиловый лотос",            level = 210, icon = "Herb_PurpleLotus"},
	[20] = {cat = TRK_HRB_NAME, en = "Arthas' Tears",       de = "Arthas' Tränen",       fr = "Larmes d'Arthas",            es = "Lágrimas de Arthas",      ru="Слезы Артаса",             level = 220, icon = "Herb_ArthasTears"},
	[21] = {cat = TRK_HRB_NAME, en = "Sungrass",            de = "Sonnengras",           fr = "Soleillette",                es = "Solea",                   ru="Солнечник",                level = 230, icon = "Herb_Sungrass"},
	[22] = {cat = TRK_HRB_NAME, en = "Blindweed",           de = "Blindkraut",           fr = "Aveuglette",                 es = "Carolina",                ru="Пастушья сумка",           level = 235, icon = "Herb_Blindweed"},
	[23] = {cat = TRK_HRB_NAME, en = "Ghost Mushroom",      de = "Geisterpilz",          fr = "Champignon Fantôme",         es = "Champiñón fantasma",      ru="Призрачная поганка",       level = 245, icon = "Herb_GhostMushroom"},
	[24] = {cat = TRK_HRB_NAME, en = "Gromsblood",          de = "Gromsblut",            fr = "Gromsang",                   es = "Gromsanguina",            ru="Кровь Грома",              level = 250, icon = "Herb_Gromsblood"},
	[25] = {cat = TRK_HRB_NAME, en = "Golden Sansam",       de = "Goldener Sansam",      fr = "Sansam Doré",                es = "Sansam dorado",           ru="Золотой сансам",           level = 260, icon = "Herb_GoldenSansam"},
	[26] = {cat = TRK_HRB_NAME, en = "Dreamfoil",           de = "Traumblatt",           fr = "Feuillerêve",                es = "Hojasueño",               ru="Снолист",                  level = 270, icon = "Herb_Dreamfoil"},
	[27] = {cat = TRK_HRB_NAME, en = "Mountain Silversage", de = "Bergsilbersalbei",     fr = "Sauge-Argent des Montagnes", es = "Salviargenta de montaña", ru="Горный серебряный шалфей", level = 280, icon = "Herb_MountainSilversage"},
	[28] = {cat = TRK_HRB_NAME, en = "Sorrowmoss",          de = "Trauermoos",           fr = "Chagrinelle",                es = "Musgopena",               ru="Печаль-трава",             level = 285, icon = "Herb_Sorrowmoss"},
	[29] = {cat = TRK_HRB_NAME, en = "Icecap",              de = "Eiskappe",             fr = "Chapeglace",                 es = "Setelo",                  ru="Ледяной зев",              level = 270, icon = "Herb_Icecap"},
	[30] = {cat = TRK_HRB_NAME, en = "Black Lotus",         de = "Schwarzer Lotus",      fr = "Lotus Noir",                 es = "Loto negro",              ru="Черный лотос",             level = 300, icon = "Herb_BlackLotus"},
	--- Herbs BC
	[31] = {cat = TRK_HRB_NAME, en = "Felweed",        de = "Teufelsgras",   fr = "Gangrelette",     es = "Hierba vil",        ru="Сквернопля",         level = 300, icon = "Herb_Felweed"},
	[32] = {cat = TRK_HRB_NAME, en = "Dreaming Glory", de = "Traumwinde",    fr = "Glaurier",        es = "Gloria de ensueño", ru="Сияние грез",        level = 315, icon = "Herb_DreamingGlory"},
	[33] = {cat = TRK_HRB_NAME, en = "Terocone",       de = "Terozapfen",    fr = "Terocône",        es = "Teropiña",          ru="Терошишка",          level = 325, icon = "Herb_Terocone"},
	[34] = {cat = TRK_HRB_NAME, en = "Ragveil",        de = "Zottelkappe",   fr = "Voile-misère",    es = "Velada",            ru="Кисейница",          level = 325, icon = "Herb_Ragveil"},
	[35] = {cat = TRK_HRB_NAME, en = "Netherbloom",    de = "Netherblüte",   fr = "Néantine",        es = "Flor abisal",       ru="Пустоцвет",          level = 350, icon = "Herb_Netherbloom"},
	[36] = {cat = TRK_HRB_NAME, en = "Flame Cap",      de = "Flammenkappe",  fr = "Chapeflamme",     es = "Copo de llamas",    ru="Огненный зев",       level = 335, icon = "Herb_FlameCap"},
	[38] = {cat = TRK_HRB_NAME, en = "Mana Thistle",   de = "Manadistel",    fr = "Chardon de mana", es = "Cardo de maná",     ru="Манаполох",          level = 375, icon = "Herb_ManaThistle"},
	[39] = {cat = TRK_HRB_NAME, en = "Nightmare Vine", de = "Alptraumranke", fr = "Cauchemardelle",  es = "Vid pesadilla",     ru="Ползучий кошмарник", level = 365, icon = "Herb_NightmareVine"},
	[40] = {cat = TRK_HRB_NAME, en = "Ancient Lichen", de = "Urflechte",     fr = "Lichen ancien",   es = "Liquen antiguo",    ru="Древний лишайник",   level = 340, icon = "Herb_AncientLichen"},
	--- Ores
	[50] = {cat = TRK_ORE_NAME, en = "Copper Vein",        de = "Kupferader",           fr = "Filon de cuivre",         es = "Filón de cobre",             ru="Медная жила",              level =   1, icon = "Ore_Copper"},
	[51] = {cat = TRK_ORE_NAME, en = "Tin Vein",           de = "Zinnader",             fr = "Filon d'étain",           es = "Filón de estaño",            ru="Оловянная жила",           level =  65, icon = "Ore_Tin"},
	[52] = {cat = TRK_ORE_NAME, en = "Silver Vein",        de = "Silberader",           fr = "Filon d'Argent",          es = "Filón de plata",             ru="Серебряная жила",          level =  75, icon = "Ore_Silver"},
	[53] = {cat = TRK_ORE_NAME, en = "Iron Deposit",       de = "Eisenvorkommen",       fr = "Gisement de fer",         es = "Depósito de hierro",         ru="Залежи железа",            level = 125, icon = "Ore_Iron"},
	[54] = {cat = TRK_ORE_NAME, en = "Gold Vein",          de = "Goldader",             fr = "Filon d'or",              es = "Filón de oro",               ru="Золотая жила",             level = 155, icon = "Ore_Gold"},
	[55] = {cat = TRK_ORE_NAME, en = "Mithril Deposit",    de = "Mithrilvorkommen",     fr = "Gisement de mithril",     es = "Depósito de mitril",         ru="Мифриловые залежи",        level = 175, icon = "Ore_Mithril"},
	[56] = {cat = TRK_ORE_NAME, en = "Truesilver Deposit", de = "Echtsilbervorkommen",  fr = "Gisement de vrai-argent", es = "Depósito de veraplata",      ru="Залежи истинного серебра", level = 205, icon = "Ore_Truesilver"},
	[57] = {cat = TRK_ORE_NAME, en = "Dark Iron Deposit",  de = "Dunkeleisenvorkommen", fr = "Gisement de sombrefer",   es = "Depósito de hierro negro",   ru="Залежи черного железа",    level = 230, icon = "Ore_DarkIron"},
	[58] = {cat = TRK_ORE_NAME, en = "Small Thorium Vein", de = "Kleine Thoriumader",   fr = "Petit filon de thorium",  es = "Filón pequeño de torio",     ru="Малая ториевая жила",      level = 230, icon = "Ore_Thorium"},
	[59] = {cat = TRK_ORE_NAME, en = "Rich Thorium Vein",  de = "Reiche Thoriumader",   fr = "Riche filon de thorium",  es = "Filón de torio enriquecido", ru="Богатая ториевая жила",    level = 255, icon = "Ore_Thorium"},
	-- Ores BC
	[60] = {cat = TRK_ORE_NAME, en = "Fel Iron Deposit",          de = "Teufelseisenvorkommen",       fr = "Gisement de gangrefer",                 es = "Depósito de hierro vil",        ru="Месторождение оскверненного железа",  level = 275, icon = "Ore_FelIron"},
	[62] = {cat = TRK_ORE_NAME, en = "Rich Adamantite Deposit",   de = "Reiches Adamantitvorkommen",  fr = "Riche gisement d'adamantite",           es = "Depósito rico en adamantita",   ru="Богатые залежи адамантита",           level = 350, icon = "Ore_Adamantite"},
	[63] = {cat = TRK_ORE_NAME, en = "Khorium Vein",              de = "Khoriumader",                 fr = "Filon de khorium",                      es = "Filón de korio",                ru="Кориевая жила",                       level = 375, icon = "Ore_Khorium"},
	[64] = {cat = TRK_ORE_NAME, en = "Adamantite Deposit",        de = "Adamantitvorkommen",          fr = "Gisement d'adamantite",                 es = "Depósito de adamantita",        ru="Залежи адамантита",                   level = 325, icon = "Ore_Adamantite"},
	[65] = {cat = TRK_ORE_NAME, en = "Lesser Bloodstone Deposit", de = "Geringes Blutsteinvorkommen", fr = "Gisement de pierre de sang inférieure", es = "Depósito de sangrita inferior", ru="Малое месторождение кровавого камня", level =  75, icon = "Ore_LesserBloodstone"},
	[66] = {cat = TRK_ORE_NAME, en = "Ancient Gem Vein",          de = "Uralte Edelsteinader",        fr = "Ancien filon de gemmes",                es = "Filón de gemas antiguo",        ru="Древняя самоцветная жила",            level = 375, icon = "Ore_AncientGem"},
	--- Treasure
	[81]  = {cat = TRK_TRS_NAME, en = "Tattered Chest",        de = "Ramponierte Truhe",                     fr = "Coffre en morceaux",                   es = "Cofre ajado",                      ru="Побитый сундук",              level = 0, icon = "Treasure_Chest"},
	[82]  = {cat = TRK_TRS_NAME, en = "Battered Chest",        de = "Ramponierte Truhe",                     fr = "Coffre endommagé",                     es = "Cofre maltrecho",                  ru="Побитый сундук",              level = 0, icon = "Treasure_Chest"},
	[84]  = {cat = TRK_TRS_NAME, en = "Rusty Chest",           de = "Rostige Truhe",                         fr = "Coffre rouillé",                       es = "Cofre oxidado",                    ru="Ржавый сундук",               level = 0, icon = "Treasure_Chest"},
	[85]  = {cat = TRK_TRS_NAME, en = "Solid Chest",           de = "Robuste Truhe",                         fr = "Coffre solide",                        es = "Cofre macizo",                     ru="Добротный сундук",            level = 0, icon = "Treasure_Chest"},
	[86]  = {cat = TRK_TRS_NAME, en = "Armor Crate",           de = "Rüstungskiste",                         fr = "Caisse d'armures",                     es = "Cajón de armaduras",               ru="Оружейный ящик",              level = 0, icon = "Treasure_Crate"},
	[87]  = {cat = TRK_TRS_NAME, en = "Food Crate",            de = "Nahrungsmittelkiste",                   fr = "Caisse de nourriture",                 es = "Cajón de comida",                  ru="Ящик со съестными припасами", level = 0, icon = "Treasure_Crate"},
	[88]  = {cat = TRK_TRS_NAME, en = "Horde Supply Crate",    de = "Vorratskiste der Horde",                fr = "Caisse de ravitaillement de la Horde", es = "Cajón de suministros de la Horda", ru="Ящик Орды с припасами",       level = 0, icon = "Treasure_Crate"},
	[89]  = {cat = TRK_TRS_NAME, en = "Box of Assorted Parts", de = "Kasten mit verschiedenen Ersatzteilen", fr = "Boîte de pièces assorties",            es = "Caja de colección de piezas",      ru="Ящик с различными деталями",  level = 0, icon = "Treasure_Crate"},
	[91]  = {cat = TRK_TRS_NAME, en = "Weapon Crate",          de = "Waffenkiste",                           fr = "Caisse d'armes",                       es = "Cajón de armas",                   ru="Ящик с оружием",              level = 0, icon = "Treasure_Crate"},
	--- Misc (Quest) additions
	[93]  = {cat = TRK_MSC_NAME, en = "Blood of Heroes",       de = "Blut von Helden",                       fr = "Sang des héros",                       es = "Sangre de héroes",                 ru="Кровь героев",                level = 0, icon = "Misc_BloodHero"},
	[94]  = {cat = TRK_MSC_NAME, en = "Shellfish Trap",        de = "Schalentierfalle",                      fr = "Casier à crustacés",                   es = "Trampa para marisco",              ru="Ловушка на моллюска",         level = 0, icon = "Misc_ShellfishTrap"},
	[95]  = {cat = TRK_MSC_NAME, en = "Giant Clam",            de = "Riesenmuschel",                         fr = "Palourde géante",                      es = "Almeja gigante",                   ru="Гигантский моллюск",          level = 0, icon = "Treasure_Clam"},
	[96]  = {cat = TRK_MSC_NAME, en = "Red Power Crystal",     de = "Roter Machtkristall",                   fr = "Cristal de puissance rouge",           es = "Cristal de poder rojo",            ru="Красный кристалл силы",       level = 0, icon = "Misc_PowerCrystalR"},
	[97]  = {cat = TRK_MSC_NAME, en = "Blue Power Crystal",    de = "Blauer Machtkristall",                  fr = "Cristal de puissance bleu",            es = "Cristal de poder azul",            ru="Синий кристалл силы",         level = 0, icon = "Misc_PowerCrystalB"},
	[98]  = {cat = TRK_MSC_NAME, en = "Green Power Crystal",   de = "Grüner Machtkristall",                  fr = "Cristal de puissance vert",            es = "Cristal de poder verde",           ru="Зеленый кристалл силы",       level = 0, icon = "Misc_PowerCrystalG"},
	[99]  = {cat = TRK_MSC_NAME, en = "Yellow Power Crystal",  de = "Gelber Machtkristall",                  fr = "Cristal de puissance jaune",           es = "Cristal de poder amarillo",        ru="Желтый кристалл силы",        level = 0, icon = "Misc_PowerCrystalY"},
	[101] = {cat = TRK_MSC_NAME, en = "Bloodpetal Sprout",     de = "Blutblütensprössling",                  fr = "Pousse de Pétale-de-sang",             es = "Brote Sangrepétalo",               ru="Росток кровоцвета",           level = 0, icon = "Misc_Sprout"},
	--- North Herbs
	[102] = {cat = TRK_HRB_NAME, en = "Bloodthistle",    de = "Blutdistel",       fr = "Chardon sanglant",      es = "Cardo de sangre",         ru="Кровопийка",      level =   1, icon = "Herb_Bloodthistle"},
	[104] = {cat = TRK_HRB_NAME, en = "Netherdust Bush", de = "Netherstaubbusch", fr = "Buisson de pruinéante", es = "Arbusto de polvo abisal", ru="Куст пустопраха", level = 350, icon = "Herb_NetherdustBush"},
	[105] = {cat = TRK_HRB_NAME, en = "Goldclover",      de = "Goldklee",         fr = "Trèfle doré",           es = "Trébol de oro",           ru="Золотой клевер",  level = 350, icon = "Herb_GoldClover"},
	[107] = {cat = TRK_HRB_NAME, en = "Firethorn",       de = "Feuerdorn",        fr = "Epine de feu",          es = "Espino de fuego",         ru="Огница",          level = 360, icon = "Herb_Firethorn"},
	[108] = {cat = TRK_HRB_NAME, en = "Tiger Lily",      de = "Tigerlilie",       fr = "Lys tigré",             es = "Lirio atigrado",          ru="Тигровая лилия",  level = 375, icon = "Herb_TigerLily"},
	[109] = {cat = TRK_HRB_NAME, en = "Talandra's Rose", de = "Talandras Rose",   fr = "Rose de Talandra",      es = "Rosa de Talandra",        ru="Роза Таландры",   level = 385, icon = "Herb_TalandrasRose"},
	[110] = {cat = TRK_HRB_NAME, en = "Frozen Herb",     de = "Gefrorenes Kraut", fr = "Herbe gelée",           es = "Hierba congelada",        ru="Мерзлая трава",   level = 400, icon = "Herb_FrozenHerb"},
	[111] = {cat = TRK_HRB_NAME, en = "Adder's Tongue",  de = "Schlangenzunge",   fr = "Langue de serpent",     es = "Lengua de víboris",       ru="Язык аспида",     level = 400, icon = "Herb_AddersTongue"},
	[112] = {cat = TRK_HRB_NAME, en = "Lichbloom",       de = "Lichblüte",        fr = "Fleur-de-liche",        es = "Flor exánime",            ru="Личецвет",        level = 425, icon = "Herb_Lichbloom"},
	[113] = {cat = TRK_HRB_NAME, en = "Icethorn",        de = "Eisdorn",          fr = "Glacépine",             es = "Espina de hielo",         ru="Ледошип",         level = 435, icon = "Herb_IceThorn"},
	[114] = {cat = TRK_HRB_NAME, en = "Frost Lotus",     de = "Frostlotus",       fr = "Lotus givré",           es = "Loto de escarcha",        ru="Северный лотос",  level = 450, icon = "Herb_FrostLotus"},
	--- Ores additions
	[115] = {cat = TRK_ORE_NAME, en = "Incendicite Mineral Vein",        de = "Pyrophormineralvorkommen",                  fr = "Filon d'incendicite",                     es = "Filón de incendicita",                        ru="Ароматитовая жила",                        level =  65, icon = "Ore_Incendicite"},
	[119] = {cat = TRK_ORE_NAME, en = "Ooze Covered Silver Vein",        de = "Schlammbedecktes Silbervorkommen",          fr = "Filon d'argent couvert de limon",         es = "Filón de plata cubierto de moco",             ru="Покрытая слизью серебряная жила",          level =  75, icon = "Ore_Silver"},
	[120] = {cat = TRK_ORE_NAME, en = "Ooze Covered Gold Vein",          de = "Schlammbedecktes Goldvorkommen",            fr = "Filon d'or couvert de limon",             es = "Filón de oro cubierto de moco",               ru="Покрытая слизью золотая жила",             level = 155, icon = "Ore_Gold"},
	[121] = {cat = TRK_ORE_NAME, en = "Ooze Covered Truesilver Deposit", de = "Schlammbedeckte Echtsilberablagerung",      fr = "Gisement de vrai-argent couvert de vase", es = "Depósito de veraplata cubierta de moco",      ru="Покрытые слизью залежи истинного серебра", level = 205, icon = "Ore_TrueSilver"},
	[122] = {cat = TRK_ORE_NAME, en = "Ooze Covered Mithril Deposit",    de = "Schlammbedeckte Mithrilablagerung",         fr = "Gisement de mithril couvert de vase",     es = "Depósito de mitril cubierto de moco",         ru="Покрытые слизью мифриловые залежи",        level = 175, icon = "Ore_Mithril"},
	[123] = {cat = TRK_ORE_NAME, en = "Ooze Covered Thorium Vein",       de = "Schlammbedeckte Thoriumader",               fr = "Filon de thorium couvert de limon",       es = "Filón de torio cubierto de moco",             ru="Покрытая слизью ториевая жила",            level = 230, icon = "Ore_Thorium"},
	[124] = {cat = TRK_ORE_NAME, en = "Ooze Covered Rich Thorium Vein",  de = "Schlammbedecktes reiches Thoriumvorkommen", fr = "Riche filon de thorium couvert de limon", es = "Filón de torio enriquecido cubierto de moco", ru="Покрытая слизью богатая ториевая жила",    level = 255, icon = "Ore_Thorium"},
	[126] = {cat = TRK_ORE_NAME, en = "Nethercite Deposit",              de = "Netheritvorkommen",                         fr = "Gisement de néanticite",                  es = "Depósito de abisalita",                       ru="Месторождение хаотита",                    level = 275, icon = "Ore_Nethercite"},
	--- North Ores
	[128] = {cat = TRK_ORE_NAME, en = "Cobalt Deposit",        de = "Kobaltvorkommen",          fr = "Gisement de cobalt",         es = "Depósito de cobalto",       ru="Залежи кобальта",                level = 350, icon = "Ore_Cobalt"},
	[129] = {cat = TRK_ORE_NAME, en = "Rich Cobalt Deposit",   de = "Reiches Kobaltvorkommen",  fr = "Riche gisement de cobalt",   es = "Depósito de cobalto rico",  ru="Богатые залежи кобальта",        level = 375, icon = "Ore_Cobalt"},
	[130] = {cat = TRK_ORE_NAME, en = "Saronite Deposit",      de = "Saronitvorkommen",         fr = "Gisement de saronite",       es = "Depósito de saronita",      ru="Месторождение саронита",         level = 400, icon = "Ore_Saronite"},
	[131] = {cat = TRK_ORE_NAME, en = "Rich Saronite Deposit", de = "Reiches Saronitvorkommen", fr = "Riche gisement de saronite", es = "Depósito de saronita rico", ru="Богатое месторождение саронита", level = 425, icon = "Ore_Saronite"},
	[132] = {cat = TRK_ORE_NAME, en = "Pure Saronite Deposit", de = "Reine Saronitablagerung",  fr = "Gisement de saronite pure",  es = "Depósito de saronita pura", ru="Месторождение чистого саронита", level = 450, icon = "Ore_Saronite"},
	[133] = {cat = TRK_ORE_NAME, en = "Titanium Vein",         de = "Titanader",                fr = "Veine de titane",            es = "Filón de titanio",          ru="Залежи титана",                  level = 450, icon = "Ore_Titanium"},
	--- Treasure additions
	[137] = {cat = TRK_TRS_NAME, en = "Large Battered Chest",   de = "Große ramponierte Truhe",    fr = "Grand coffre endommagé",     es = "Cofre grande abollado",          ru="Большой побитый сундук",                 level = 0, icon = "Treasure_Chest"},
	[138] = {cat = TRK_TRS_NAME, en = "Large Solid Chest",      de = "Große robuste Truhe",        fr = "Grand coffre solide",        es = "Cofre macizo grande",            ru="Большой добротный сундук",               level = 0, icon = "Treasure_Chest"},
	[139] = {cat = TRK_TRS_NAME, en = "Adamantite Bound Chest", de = "Adamantitbeschlagene Truhe", fr = "Coffre cerclé d'adamantite", es = "Cofre reforzado con adamantita", ru="Окованный адамантитом сундук",           level = 0, icon = "Treasure_Chest"},
	[140] = {cat = TRK_TRS_NAME, en = "Fel Iron Chest",         de = "Teufelseisentruhe",          fr = "Coffre en gangrefer",        es = "Cofre de hierro vil",            ru="Сундук из оскверненного железа",         level = 0, icon = "Treasure_Chest"},
	[141] = {cat = TRK_TRS_NAME, en = "Heavy Fel Iron Chest",   de = "Schwere Teufelseisentruhe",  fr = "Coffre lourd en gangrefer",  es = "Cofre pesado de hierro vil",     ru="Тяжелый сундук из оскверненного железа", level = 0, icon = "Treasure_Chest"},
	[142] = {cat = TRK_TRS_NAME, en = "Felsteel Chest",         de = "Teufelsstahltruhe",          fr = "Coffre en gangracier",       es = "Cofre de acero vil",             ru = "Сундук из оскверненной стали",         level = 0, icon = "Treasure_Chest"},
	[143] = {cat = TRK_TRS_NAME, en = "Water Barrel",           de = "Wasserfass",                 fr = "Baril d'eau",                es = "Barrica de agua",                ru="Бочка с водой",                          level = 0, icon = "Treasure_Barrel"},
	[144] = {cat = TRK_TRS_NAME, en = "Barrel of Milk",         de = "Fass mit Milch",             fr = "Tonneau de lait",            es = "Barrica de leche",               ru="Бочка молока",                           level = 0, icon = "Treasure_Barrel"},
	[145] = {cat = TRK_TRS_NAME, en = "Barrel of Melon Juice",  de = "Fass Melonensaft",           fr = "Tonneau de jus de melon",    es = "Barrica de zumo de melón",       ru="Бочка дынного сока",                     level = 0, icon = "Treasure_Barrel"},
	[146] = {cat = TRK_TRS_NAME, en = "Barrel of Sweet Nectar", de = "Fass mit süßem Nektar",      fr = "Tonneau de nectar sucré",    es = "Barrica de néctar dulce",        ru="Бочка сладкого нектара",                 level = 0, icon = "Treasure_Barrel"},
	[147] = {cat = TRK_TRS_NAME, en = "Giant Softshell Clam",   de = "Riesenweichpanzermuschel",   fr = "Praire géante",              es = "Almeja blanda gigante",          ru="Гигантский моллюск в мягком панцире",    level = 0, icon = "Treasure_Clam"},
	--- Misc (Quest) additions
	[148] = {cat = TRK_MSC_NAME, en = "Bloodberry Bush",        de = "Blutbeerenbusch",         fr = "Buisson de sangrelle",            es = "Arbusto de bayas de sangre",     ru="Куст Кровяники",                       level = 0, icon = "Misc_Bloodberry"},
	[149] = {cat = TRK_MSC_NAME, en = "Fel Cone",               de = "Teufelszapfen",           fr = "Gangrenoix",                      es = "Bellota vil",                    ru="Шишка Скверны",                        level = 0, icon = "Misc_FelCone"},
	[150] = {cat = TRK_MSC_NAME, en = "Wyrmtail",               de = "Drachenwinde",            fr = "Queue de wyrm",                   es = "Cola de vermis",                 ru="Змейкин хвост",                        level = 0, icon = "Misc_Wyrmtail"},
	[151] = {cat = TRK_MSC_NAME, en = "Wildkin Feather",        de = "Wildekinfeder",           fr = "Plume d'Indomptable",             es = "Pluma de lechúcico salvaje",     ru="Перо дикого совуха",                   level = 0, icon = "Misc_WildkinFeather"},
	[152] = {cat = TRK_MSC_NAME, en = "Moontouched Feather",    de = "Mondbestrahlte Feder",    fr = "Plume de chouettard lunaire",     es = "Pluma Lunadón",                  ru="Осененное луной перо",                 level = 0, icon = "Misc_MoontouchedFeather"},
	[153] = {cat = TRK_MSC_NAME, en = "Glowcap",                de = "Glühkappe",               fr = "Chapeluisant",                    es = "Fluochampiñón",                  ru="Огнешляпка",                           level = 0, icon = "Misc_Glowcap"},
	[154] = {cat = TRK_MSC_NAME, en = "Bogblossom",             de = "Sumpfblüte",              fr = "Fleur des tourbières",            es = "Cardo de Mantar",                ru="Топлянник",                            level = 0, icon = "Misc_Bogblossom"},
	[155] = {cat = TRK_MSC_NAME, en = "Olemba Cone",            de = "Olembazapfen",            fr = "Cône d'olemba",                   es = "Cono de olemba",                 ru="Шишка олембы",                         level = 0, icon = "Misc_OlembaCone"},
	[156] = {cat = TRK_MSC_NAME, en = "Olemba Root",            de = "Olembawurzel",            fr = "Racine d'olemba",                 es = "Raíz de olemba",                 ru="Корень олембы",                        level = 0, icon = "Herb_Earthroot"},
	[157] = {cat = TRK_MSC_NAME, en = "Apexis Shard Formation", de = "Apexissplitterformation", fr = "Formation de cristaux d'apogide", es = "Formación de cristal de ápices", ru="Пласт апекситовых осколков",           level = 0, icon = "Misc_ApexisShard"},
	[158] = {cat = TRK_MSC_NAME, en = "Netherwing Egg",         de = "Ei der Netherschwingen",  fr = "Œuf de l'Aile-du-Néant",          es = "Huevo de Ala Abisal",            ru="Яйцо дракона из стаи Крыльев Пустоты", level = 0, icon = "Misc_NetherwingEgg"},
	[159] = {cat = TRK_MSC_NAME, en = "Frostberry Bush",        de = "Frostbeerenbusch",        fr = "Buisson de givrelles",            es = "Arbusto de gelifructus",         ru="Куст снежевики",                       level = 0, icon = "Misc_Frostberry"},
	[160] = {cat = TRK_MSC_NAME, en = "Infused Mushroom",       de = "Energieerfüllter Pilz",   fr = "Champignon infusé",               es = "Champiñón imbuido",              ru="Странный гриб",                        level = 0, icon = "Misc_InfusedMushroom"},
	[161] = {cat = TRK_MSC_NAME, en = "Wild Mustard",           de = "Wilder Senf",             fr = "Moutarde sauvage",                es = "Mostaza silvestre",              ru="Полевая горчица",                      level = 0, icon = "Misc_WildMustard"},
	--- Cata Herbs
	[162] = {cat = TRK_HRB_NAME, en = "Cinderbloom",      de = "Aschenblüte",       fr = "Cendrelle",            es = "Flor de ceniza",     ru="Пепельник",         level = 425, icon = "Herb_Cinderbloom"},
	[163] = {cat = TRK_HRB_NAME, en = "Azshara's Veil",   de = "Azsharas Schleier", fr = "Voile d'Azshara",      es = "Velo de Azshara",    ru="Вуаль Азшары",      level = 425, icon = "Herb_AzsharasVeil"},
	[164] = {cat = TRK_HRB_NAME, en = "Stormvine",        de = "Sturmwinde",        fr = "Vignétincelle",        es = "Viñaviento",         ru="Ливневая лоза",     level = 425, icon = "Herb_Stormvine"},
	[165] = {cat = TRK_HRB_NAME, en = "Heartblossom",     de = "Herzblüte",         fr = "Pétale de cœur",       es = "Flor de corazón",    ru="Цветущее сердце",   level = 475, icon = "Herb_Heartblossom"},
	[166] = {cat = TRK_HRB_NAME, en = "Whiptail",         de = "Gertenrohr",        fr = "Fouettine",            es = "Colátigo",           ru="Хлыстохвост",       level = 500, icon = "Herb_Whiptail"},
	[167] = {cat = TRK_HRB_NAME, en = "Twilight Jasmine", de = "Schattenjasmin",    fr = "Jasmin crépusculaire", es = "Jazmín Crepuscular", ru="Сумеречный жасмин", level = 525, icon = "Herb_TwilightJasmine"},
	--- Cata Ores
	[168] = {cat = TRK_ORE_NAME, en = "Obsidium Deposit",      de = "Obsidiumvorkommen",         fr = "Gisement d'obsidium",       es = "Depósito de obsidium",      ru="Залежи обсидиана",          level = 425, icon = "Ore_Obsidium"},
	[169] = {cat = TRK_ORE_NAME, en = "Rich Obsidium Deposit", de = "Reiches Obsidiumvorkommen", fr = "Riche gisement d'obsidium", es = "Depósito de obsidium rico", ru="Громадный кусок обсидиана", level = 450, icon = "Ore_Obsidium"},
	[170] = {cat = TRK_ORE_NAME, en = "Elementium Vein",       de = "Elementiumader",            fr = "Filon d'élémentium",        es = "Filón de elementium",       ru="Элементиевая жила",         level = 475, icon = "Ore_Elementium"},
	[171] = {cat = TRK_ORE_NAME, en = "Rich Elementium Vein",  de = "Reiche Elementiumader",     fr = "Riche filon d'élémentium",  es = "Filón de elementium rico",  ru="Богатая элементиевая жила", level = 500, icon = "Ore_Elementium"},
	[172] = {cat = TRK_ORE_NAME, en = "Pyrite Deposit",        de = "Pyritvorkommen",            fr = "Gisement de pyrite",        es = "Depósito de pirita",        ru="Залежи колчедана",          level = 525, icon = "Ore_Pyrite"},
	[173] = {cat = TRK_ORE_NAME, en = "Rich Pyrite Deposit",   de = "Reiches Pyritvorkommen",    fr = "Riche gisement de pyrite",  es = "Depósito de pirita rico",   ru="Богатые залежи колчедана",  level = 525, icon = "Ore_Pyrite"},
	--- MoP Herbs
	[200] = {cat = TRK_HRB_NAME, en = "Rain Poppy",       de = "Regenmohn",           fr = "Pavot de pluie",             es = "Amapola de lluvia",              ru="Дождевой мак",        level = 500, icon = "Herb_RainPoppy"},
	[201] = {cat = TRK_HRB_NAME, en = "Green Tea Leaf",   de = "Teepflanze",          fr = "Feuille de thé vert",        es = "Hoja de té verde",               ru="Лист зеленого чая",   level = 500, icon = "Herb_JadeTeaLeaf"},
	[202] = {cat = TRK_HRB_NAME, en = "Silkweed",         de = "Seidenkraut",         fr = "Herbe à soie",               es = "Hierbaseda",                     ru="Ваточник",            level = 545, icon = "Herb_Silkweed"},
	[203] = {cat = TRK_HRB_NAME, en = "Snow Lily",        de = "Schneelilie",         fr = "Lys des neiges",             es = "Lirio de las nieves",            ru="Снежная лилия",       level = 575, icon = "Herb_SnowLily"},
	[204] = {cat = TRK_HRB_NAME, en = "Fool's Cap",       de = "Narrenkappe",         fr = "Berluette",                  es = "Seta del inocente",              ru="Дурногриб",           level = 600, icon = "Herb_FoolsCap"},
	[205] = {cat = TRK_HRB_NAME, en = "Golden Lotus",     de = "Goldlotus",           fr = "Lotus doré",                 es = "Loto dorado",                    ru="Золотой лотос",       level = 550, icon = "Herb_GoldenLotus"},
	[206] = {cat = TRK_HRB_NAME, en = "Sha-Touched Herb", de = "Sha-berührtes Kraut", fr = "Plante touchée par les sha", es = "Hierba influenciada por el sha", ru="Пораженная ша трава", level = 575, icon = "Herb_ShaHerb"},
	--- MoP Ores
	[210] = {cat = TRK_ORE_NAME, en = "Ghost Iron Deposit",      de = "Geistereisenvorkommen",         fr = "Gisement d’ectofer",         es = "Depósito de hierro fantasma",      ru="Залежи призрачного железа",         level = 500, icon = "Ore_Ghostiron"},
	[211] = {cat = TRK_ORE_NAME, en = "Rich Ghost Iron Deposit", de = "Reiches Geistereisenvorkommen", fr = "Riche gisement d’ectofer",   es = "Depósito de hierro fantasma rico", ru="Богатые залежи призрачного железа", level = 500, icon = "Ore_Ghostiron"},
	[212] = {cat = TRK_ORE_NAME, en = "Kyparite Deposit",        de = "Kyparitvorkommen",              fr = "Gisement de kyparite",       es = "Depósito de kyparita",             ru="Залежи кипарита",                   level = 550, icon = "Ore_Manticyte"},
	[213] = {cat = TRK_ORE_NAME, en = "Rich Kyparite Deposit",   de = "Reiches Kyparitvorkommen",      fr = "Riche gisement de kyparite", es = "Depósito de kyparita rico",        ru="Богатые залежи кипарита",           level = 550, icon = "Ore_Manticyte"},
	[214] = {cat = TRK_ORE_NAME, en = "Trillium Vein",           de = "Trilliumader",                  fr = "Filon de trillium",          es = "Filón de trillium",                ru="Триллиевая жила",                   level = 600, icon = "Ore_TrilliumBlack"},
	[215] = {cat = TRK_ORE_NAME, en = "Rich Trillium Vein",      de = "Reiche Trilliumader",           fr = "Riche filon de trillium",    es = "Filón de trillium enriquecido",    ru="Богатая триллиевая жила",           level = 600, icon = "Ore_TrilliumBlack"},
	--- MoP Misc (Quest) additions
	[220] = {cat = TRK_MSC_NAME, en = "Tidemist Cap",              de = "Gezeitennebelkappe",            fr = "Amanite de Raz-de-Brume",         es = "Hongo de Niebla Eterna",          ru="Гриб Приливных Туманов",             level = 0, icon = "Misc_Mushroom_03"},
	[221] = {cat = TRK_MSC_NAME, en = "Rattan Switch",             de = "Rattanrute",                    fr = "Canne en rotin",                  es = "Tallo de rota",                   ru="Побег ротанга",                      level = 0, icon = "Misc_Bloodberry"},
	[222] = {cat = TRK_MSC_NAME, en = "Silk Patch",                de = "Seidenstück",                   fr = "Carré de soie",                   es = "Zona de seda",                    ru="Шелковые коконы",                    level = 0, icon = "Misc_Web_02"},
	[223] = {cat = TRK_MSC_NAME, en = "Firework Launcher",         de = "Zünder für Feuerwerk",          fr = "Lanceur de feux d'artifice",      es = "Lanzador de fuegos artificiales", ru="Пусковая установка для фейерверков", level = 0, icon = "Misc_Musket_04"},
	[224] = {cat = TRK_MSC_NAME, en = "Imperial Lotus",            de = "Kaiserlicher Lotus",            fr = "Lotus impérial",                  es = "Loto imperial",                   ru="Императорский лотос",                level = 0, icon = "Misc_Ability_Druid_TreeofLife"},
	[225] = {cat = TRK_MSC_NAME, en = "Mogu Artifact",             de = "Moguartefakt",                  fr = "Artéfact mogu",                   es = "Artefacto mogu",                  ru="Реликвия могу",                      level = 0, icon = "Misc_Archaeology_Vrykul_Artifactfragment"},
	[226] = {cat = TRK_MSC_NAME, en = "Rain-Slick Honeycomb",      de = "Regennasse Honigwaben",         fr = "Rayon de miel luisant de pluie",  es = "Panal escurrelluvias",            ru="Намоченные дождем медовые соты",     level = 0, icon = "Misc_Food_121_ButterMeat"},
	[227] = {cat = TRK_MSC_NAME, en = "Ancient Dynastic Tablet",   de = "Uralte dynastische Tafel",      fr = "Antique tablette dynastique",     es = "Tablilla dinástica antigua",      ru="Древняя динайстийная табличка",      level = 0, icon = "Misc_StoneTablet_04"},
	[228] = {cat = TRK_MSC_NAME, en = "Stolen Barley Sack",        de = "Gestohlener Gerstesack",        fr = "Sac d’orge volé",                 es = "Saco de cebada robado",           ru="Украденный мешок с зерном",          level = 0, icon = "Herb_GraveMoss"},
	[229] = {cat = TRK_MSC_NAME, en = "Jademoon",                  de = "Jademond",                      fr = "Jadelune",                        es = "Luna de jade",                    ru="Нефритовая Луна",                    level = 0, icon = "Misc_Spell_Nature_Healingtouch"},
	[230] = {cat = TRK_MSC_NAME, en = "Explosives Barrel",         de = "Explosives Fass",               fr = "Baril d’explosifs",               es = "Barril de explosivos",            ru="Бочка со взрывчаткой",               level = 0, icon = "Misc_Ability_Vehicle_LiquidPyrite"},
	[231] = {cat = TRK_MSC_NAME, en = "Stolen Supplies",           de = "Gestohlene Versorgungsgüter",   fr = "Fournitures volées",              es = "Suministros robados",             ru="Украденные припасы",                 level = 0, icon = "Misc_Bag_29"},
	[232] = {cat = TRK_MSC_NAME, en = "Kafa'kota Berries",         de = "Kafa'kota-Beeren",              fr = "Baies de kafa’kota",              es = "Bayas de Kafa'kota",              ru="Ягоды кафа'коту",                    level = 0, icon = "Misc_Food_104_TundraBerries"},
	[233] = {cat = TRK_MSC_NAME, en = "Kafa'kota Bush",            de = "kafa'kota-Strauch",             fr = "Buisson de kafa’kota",            es = "Matorral de Kafa'kota",           ru="Куст кафа'коту",                     level = 0, icon = "Misc_Food_104_TundraBerries"},
	[234] = {cat = TRK_MSC_NAME, en = "Arrow for Commander Hsieh", de = "Pfeil für Kommandantin Hsieh",  fr = "Flèche pour le commandant Hsieh", es = "Flecha para la comandante Hsieh", ru="Стрела для командира Се",            level = 0, icon = "Misc_Ammo_Arrow_06"},
	[235] = {cat = TRK_MSC_NAME, en = "Mogu Relic",                de = "Relikt der Mogu",               fr = "Relique mogu",                    es = "Reliquia mogu",                   ru="Реликвия могу",                      level = 0, icon = "Misc_Archaeology_Stoneshield"},
	[236] = {cat = TRK_MSC_NAME, en = "Untainted Supplies",        de = "Unverdorbene Versorgungsgüter", fr = "Fournitures non corrompues",      es = "Suministros intactos",            ru="Нетронутые припасы",                 level = 0, icon = "Misc_Bag_29"},
	[237] = {cat = TRK_MSC_NAME, en = "Volatile Blooms",           de = "Zunderblüte",                   fr = "Fleurs volatiles",                es = "Flores volátiles",                ru="Взрывоцвет",                         level = 0, icon = "Herb_Heartblossom"},
	[238] = {cat = TRK_MSC_NAME, en = "Palewind Totem",            de = "Bleichwindtotem",               fr = "Totem de Vent-Blême",             es = "Tótem de Viento Albar",           ru="Тотем Слабого Ветра",                level = 0, icon = "Misc_Spell_Shaman_TotemRecall"},
	[239] = {cat = TRK_MSC_NAME, en = "Shado-Pan Fire Arrows",     de = "Feuerpfeile der Shado-Pan",     fr = "Flèches enflammées pandashan",    es = "Flechas de fuego del Shadopan",   ru="Огненные стрелы Шадо-Пан",           level = 0, icon = "Misc_Ammo_Arrow_06"},
	[240] = {cat = TRK_MSC_NAME, en = "Krik'thik Limb",            de = "Krik'thik-Bein",                fr = "Membre de kri'thik",              es = "Extremidad Krik'thik",            ru="Конечность крик'тика",               level = 0, icon = "Misc_MonsterClaw_06"},
	[241] = {cat = TRK_MSC_NAME, en = "Mao-Willow",                de = "Mao-Weide",                     fr = "Saule mao",                       es = "Sauce Mao",                       ru="Ива Мао",                            level = 0, icon = "Herb_Whiptail"},
	[242] = {cat = TRK_MSC_NAME, en = "Dread Orb",                 de = "Schreckenskugel",               fr = "Orbe funeste",                    es = "Orbe aterrador",                  ru="Сфера ужаса",                        level = 0, icon = "Misc_Orb_05"},
	[243] = {cat = TRK_MSC_NAME, en = "Pitch Pot",                 de = "Topf mit Pech",                 fr = "Pot de poix",                     es = "Escudilla",                       ru="Котелок с варевом",                  level = 0, icon = "Misc_Ability_Vehicle_OilJets"},
	[244] = {cat = TRK_MSC_NAME, en = "Violet Citron",             de = "Zitronenfeilchen",              fr = "Cédrat pourpre",                  es = "Cidra violeta",                   ru="Лиловый лимон",                      level = 0, icon = "Herb_ArthasTears"},
	[245] = {cat = TRK_MSC_NAME, en = "Amber Fragment",            de = "Bernfragment",                  fr = "Fragment d’ambre",                es = "Fragmento de ámbar",              ru="Янтарный фрагмент",                  level = 0, icon = "Misc_Archaeology_Insect_in_Amber"},
	[246] = {cat = TRK_MSC_NAME, en = "Amber Collector",           de = "Bernsammler",                   fr = "Collecteur d’ambre",              es = "Recolector de ámbar",             ru="Накопитель янтаря",                  level = 0, icon = "Misc_Alchemy_PotionE6"},
	[247] = {cat = TRK_MSC_NAME, en = "Amber Pot",                 de = "Berntopf",                      fr = "Pot d’ambre",                     es = "Olla de ámbar",                   ru="Янтарный сосуд",                     level = 0, icon = "Misc_Holiday_ToW_SpicePotion03"},
	[248] = {cat = TRK_MSC_NAME, en = "Dreadspore Bulb",           de = "Furchtsporenknolle",            fr = "Bulbe sporeffroi",                es = "Bulbo Temespora",                 ru="Почка споры ужаса",                  level = 0, icon = "Misc_Sprout"},
	[249] = {cat = TRK_MSC_NAME, en = "Gurthani Tablet",           de = "Gurthanitafel",                 fr = "Tablette gurthanie",              es = "Tablilla de Gurthani",            ru="Гуртанская табличка",                level = 0, icon = "Misc_StoneTablet_07"},
	[250] = {cat = TRK_MSC_NAME, en = "Mantid Relic",              de = "Mantisrelikt",                  fr = "Relique mantide",                 es = "Reliquia mántide",                ru="Реликвия богомолов",                 level = 0, icon = "Misc_StoneTablet_05"},
	[251] = {cat = TRK_MSC_NAME, en = "Spiny Starfish",            de = "Stacheliger Seestern",          fr = "Minuscule étoile de mer",         es = "Estrella marina espinosa",        ru="Игольчатая морская звезда",          level = 0, icon = "Misc_Creatureportrait_Saltwater_Star"},
}
